from typing import List, Literal, Optional

from betfair_parser.spec.common import BaseMessage


class MatchedOrder(BaseMessage, array_like=True):
    price: float
    size: float


class UnmatchedOrder(BaseMessage):
    """
    https://docs.developer.betfair.com/display/1smk3cen4v3lu3yomq5qye0ni/Exchange+Stream+API
    """

    id: str
    p: float
    s: float
    side: Literal["B", "L"]
    status: Literal["E", "EC"]
    pt: str
    ot: str
    pd: int
    rac: str
    rc: str
    rfo: str
    rfs: str
    md: Optional[int] = None
    cd: Optional[int] = None
    ld: Optional[int] = None
    avp: Optional[float] = None
    sm: Optional[float] = None
    sr: Optional[float] = None
    sl: Optional[float] = None
    sc: Optional[float] = None
    sv: Optional[float] = None


class StrategyMatched(BaseMessage):
    mb: Optional[List[MatchedOrder]] = []
    ml: Optional[List[MatchedOrder]] = []


class OrderChanges(BaseMessage):
    """
    https://docs.developer.betfair.com/display/1smk3cen4v3lu3yomq5qye0ni/Exchange+Stream+API
    """

    id: int
    fullImage: Optional[bool] = False
    hc: Optional[float] = None
    uo: Optional[List[UnmatchedOrder]] = []
    mb: Optional[List[MatchedOrder]] = []
    ml: Optional[List[MatchedOrder]] = []
    smc: dict[str, StrategyMatched] | None = None


class OrderAccountChange(BaseMessage):
    """
    https://docs.developer.betfair.com/display/1smk3cen4v3lu3yomq5qye0ni/Exchange+Stream+API
    """

    id: str
    accountId: int | None = None
    fullImage: Optional[bool] = False
    orc: List[OrderChanges] = []
    closed: Optional[bool] = None


class OCM(BaseMessage, tag_field="op", tag=str.lower):
    """
    https://docs.developer.betfair.com/display/1smk3cen4v3lu3yomq5qye0ni/Exchange+Stream+API
    """

    id: int
    clk: str
    pt: int
    oc: List[OrderAccountChange] = []
    initialClk: str | None = None
    status: int | None = None
    conflateMs: int | None = None
    heartbeatMs: int | None = None
    ct: Literal["HEARTBEAT", "SUB_IMAGE"] | None = None
    con: bool | None = None
