# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class Access(str, Enum):
    """Indicates whether the traffic is allowed or denied.
    """

    allow = "Allow"
    deny = "Deny"

class ApplicationGatewayBackendHealthServerHealth(str, Enum):
    """Health of backend server. Possible values are: 'Unknown', 'Up', 'Down', and 'Partial'.
    """

    unknown = "Unknown"
    up = "Up"
    down = "Down"
    partial = "Partial"

class ApplicationGatewayCookieBasedAffinity(str, Enum):
    """Cookie based affinity. Possible values are: 'Enabled' and 'Disabled'.
    """

    enabled = "Enabled"
    disabled = "Disabled"

class ApplicationGatewayFirewallMode(str, Enum):
    """Web application firewall mode. Possible values are: 'Detection' and 'Prevention'.
    """

    detection = "Detection"
    prevention = "Prevention"

class ApplicationGatewayOperationalState(str, Enum):
    """Operational state of the application gateway resource. Possible values are: 'Stopped',
    'Started', 'Running', and 'Stopping'.
    """

    stopped = "Stopped"
    starting = "Starting"
    running = "Running"
    stopping = "Stopping"

class ApplicationGatewayProtocol(str, Enum):
    """Protocol. Possible values are: 'Http' and 'Https'.
    """

    http = "Http"
    https = "Https"

class ApplicationGatewayRequestRoutingRuleType(str, Enum):
    """Rule type. Possible values are: 'Basic' and 'PathBasedRouting'.
    """

    basic = "Basic"
    path_based_routing = "PathBasedRouting"

class ApplicationGatewaySkuName(str, Enum):
    """Name of an application gateway SKU. Possible values are: 'Standard_Small', 'Standard_Medium',
    'Standard_Large', 'WAF_Medium', and 'WAF_Large'.
    """

    standard_small = "Standard_Small"
    standard_medium = "Standard_Medium"
    standard_large = "Standard_Large"
    waf_medium = "WAF_Medium"
    waf_large = "WAF_Large"

class ApplicationGatewaySslProtocol(str, Enum):

    tl_sv1_0 = "TLSv1_0"
    tl_sv1_1 = "TLSv1_1"
    tl_sv1_2 = "TLSv1_2"

class ApplicationGatewayTier(str, Enum):
    """Tier of an application gateway. Possible values are: 'Standard' and 'WAF'.
    """

    standard = "Standard"
    waf = "WAF"

class AssociationType(str, Enum):
    """The association type of the child resource to the parent resource.
    """

    associated = "Associated"
    contains = "Contains"

class AuthorizationUseStatus(str, Enum):
    """AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'.
    """

    available = "Available"
    in_use = "InUse"

class BgpPeerState(str, Enum):
    """The BGP peer state
    """

    unknown = "Unknown"
    stopped = "Stopped"
    idle = "Idle"
    connecting = "Connecting"
    connected = "Connected"

class Direction(str, Enum):
    """The direction of the packet represented as a 5-tuple.
    """

    inbound = "Inbound"
    outbound = "Outbound"

class EffectiveRouteSource(str, Enum):
    """Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and
    'Default'.
    """

    unknown = "Unknown"
    user = "User"
    virtual_network_gateway = "VirtualNetworkGateway"
    default = "Default"

class EffectiveRouteState(str, Enum):
    """The value of effective route. Possible values are: 'Active' and 'Invalid'.
    """

    active = "Active"
    invalid = "Invalid"

class ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(str, Enum):
    """AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured',
    'Configuring', 'Configured', and 'ValidationNeeded'.
    """

    not_configured = "NotConfigured"
    configuring = "Configuring"
    configured = "Configured"
    validation_needed = "ValidationNeeded"

class ExpressRouteCircuitPeeringState(str, Enum):
    """The state of peering. Possible values are: 'Disabled' and 'Enabled'
    """

    disabled = "Disabled"
    enabled = "Enabled"

class ExpressRouteCircuitPeeringType(str, Enum):
    """The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and
    'MicrosoftPeering'.
    """

    azure_public_peering = "AzurePublicPeering"
    azure_private_peering = "AzurePrivatePeering"
    microsoft_peering = "MicrosoftPeering"

class ExpressRouteCircuitSkuFamily(str, Enum):
    """The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
    """

    unlimited_data = "UnlimitedData"
    metered_data = "MeteredData"

class ExpressRouteCircuitSkuTier(str, Enum):
    """The tier of the SKU. Possible values are 'Standard' and 'Premium'.
    """

    standard = "Standard"
    premium = "Premium"

class IPAllocationMethod(str, Enum):
    """PrivateIP allocation method. Possible values are: 'Static' and 'Dynamic'.
    """

    static = "Static"
    dynamic = "Dynamic"

class IPVersion(str, Enum):
    """Available from Api-Version 2016-03-30 onwards, it represents whether the specific
    ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and
    'IPv6'.
    """

    i_pv4 = "IPv4"
    i_pv6 = "IPv6"

class LoadDistribution(str, Enum):
    """The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and
    'SourceIPProtocol'.
    """

    default = "Default"
    source_ip = "SourceIP"
    source_ip_protocol = "SourceIPProtocol"

class NetworkOperationStatus(str, Enum):
    """Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and
    'Failed'.
    """

    in_progress = "InProgress"
    succeeded = "Succeeded"
    failed = "Failed"

class NextHopType(str, Enum):
    """Next hop type.
    """

    internet = "Internet"
    virtual_appliance = "VirtualAppliance"
    virtual_network_gateway = "VirtualNetworkGateway"
    vnet_local = "VnetLocal"
    hyper_net_gateway = "HyperNetGateway"
    none = "None"

class PcError(str, Enum):

    internal_error = "InternalError"
    agent_stopped = "AgentStopped"
    capture_failed = "CaptureFailed"
    local_file_failed = "LocalFileFailed"
    storage_failed = "StorageFailed"

class PcProtocol(str, Enum):
    """Protocol to be filtered on.
    """

    tcp = "TCP"
    udp = "UDP"
    any = "Any"

class PcStatus(str, Enum):
    """The status of the packet capture session.
    """

    not_started = "NotStarted"
    running = "Running"
    stopped = "Stopped"
    error = "Error"
    unknown = "Unknown"

class ProbeProtocol(str, Enum):
    """The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp' is specified, a
    received ACK is required for the probe to be successful. If 'Http' is specified, a 200 OK
    response from the specifies URI is required for the probe to be successful.
    """

    http = "Http"
    tcp = "Tcp"

class ProcessorArchitecture(str, Enum):
    """VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'.
    """

    amd64 = "Amd64"
    x86 = "X86"

class Protocol(str, Enum):
    """Protocol to be verified on.
    """

    tcp = "TCP"
    udp = "UDP"

class ProvisioningState(str, Enum):
    """The provisioning state of the resource.
    """

    succeeded = "Succeeded"
    updating = "Updating"
    deleting = "Deleting"
    failed = "Failed"

class RouteNextHopType(str, Enum):
    """The type of Azure hop the packet should be sent to. Possible values are:
    'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'.
    """

    virtual_network_gateway = "VirtualNetworkGateway"
    vnet_local = "VnetLocal"
    internet = "Internet"
    virtual_appliance = "VirtualAppliance"
    none = "None"

class SecurityRuleAccess(str, Enum):
    """Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
    """

    allow = "Allow"
    deny = "Deny"

class SecurityRuleDirection(str, Enum):
    """The direction of the rule. Possible values are: 'Inbound and Outbound'.
    """

    inbound = "Inbound"
    outbound = "Outbound"

class SecurityRuleProtocol(str, Enum):
    """The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and '*'.
    """

    tcp = "Tcp"
    udp = "Udp"
    asterisk = "*"

class ServiceProviderProvisioningState(str, Enum):
    """The ServiceProviderProvisioningState state of the resource. Possible values are
    'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'.
    """

    not_provisioned = "NotProvisioned"
    provisioning = "Provisioning"
    provisioned = "Provisioned"
    deprovisioning = "Deprovisioning"

class TransportProtocol(str, Enum):
    """The transport protocol for the external endpoint. Possible values are 'Udp' or 'Tcp'
    """

    udp = "Udp"
    tcp = "Tcp"

class VirtualNetworkGatewayConnectionStatus(str, Enum):
    """Virtual network Gateway connection status
    """

    unknown = "Unknown"
    connecting = "Connecting"
    connected = "Connected"
    not_connected = "NotConnected"

class VirtualNetworkGatewayConnectionType(str, Enum):
    """Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and
    'VPNClient.
    """

    i_psec = "IPsec"
    vnet2_vnet = "Vnet2Vnet"
    express_route = "ExpressRoute"
    vpn_client = "VPNClient"

class VirtualNetworkGatewaySkuName(str, Enum):
    """Gateway SKU name. Possible values are: 'Basic', 'HighPerformance','Standard', and
    'UltraPerformance'.
    """

    basic = "Basic"
    high_performance = "HighPerformance"
    standard = "Standard"
    ultra_performance = "UltraPerformance"

class VirtualNetworkGatewaySkuTier(str, Enum):
    """Gateway SKU tier. Possible values are: 'Basic', 'HighPerformance','Standard', and
    'UltraPerformance'.
    """

    basic = "Basic"
    high_performance = "HighPerformance"
    standard = "Standard"
    ultra_performance = "UltraPerformance"

class VirtualNetworkGatewayType(str, Enum):
    """The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
    """

    vpn = "Vpn"
    express_route = "ExpressRoute"

class VirtualNetworkPeeringState(str, Enum):
    """The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and
    'Disconnected'.
    """

    initiated = "Initiated"
    connected = "Connected"
    disconnected = "Disconnected"

class VpnType(str, Enum):
    """The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
    """

    policy_based = "PolicyBased"
    route_based = "RouteBased"
