# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

import msrest.serialization

from ._network_management_client_enums import *


class AddressSpace(msrest.serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        address_prefixes: Optional[List[str]] = None,
        **kwargs
    ):
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(msrest.serialization.Model):
    """Azure resource manager resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySku
    :ivar operational_state: Operational state of the application gateway resource. Possible values
     are: 'Stopped', 'Started', 'Running', and 'Stopping'. Possible values include: "Stopped",
     "Starting", "Running", "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Gets or sets subnets of application gateway resource.
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayIPConfiguration]
    :param ssl_certificates: SSL certificates of the application gateway resource.
    :type ssl_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
    :type frontend_ports:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application gateway resource.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the application gateway
     resource.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
    :type http_listeners:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
    :type url_path_maps: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRule]
    :param resource_guid: Resource GUID property of the application gateway resource.
    :type resource_guid: str
    :param provisioning_state: Provisioning state of the application gateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        sku: Optional["ApplicationGatewaySku"] = None,
        gateway_ip_configurations: Optional[List["ApplicationGatewayIPConfiguration"]] = None,
        ssl_certificates: Optional[List["ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["ApplicationGatewayBackendHttpSettings"]] = None,
        http_listeners: Optional[List["ApplicationGatewayHttpListener"]] = None,
        url_path_maps: Optional[List["ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["ApplicationGatewayRequestRoutingRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendAddress(msrest.serialization.Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address.
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        ip_address: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class SubResource(msrest.serialization.Model):
    """Azure resource manager sub resource properties.

    :param id: Resource Identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Resource that is unique within a resource group. This name can be used to access
     the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param backend_ip_configurations: Collection of references to IPs defined in network
     interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses.
    :type backend_addresses:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddress]
    :param provisioning_state: Provisioning state of the backend address pool resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        backend_ip_configurations: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        backend_addresses: Optional[List["ApplicationGatewayBackendAddress"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddressPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param port: Port.
    :type port: int
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values are: 'Enabled' and
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway will fail the request
     if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Gets or sets Provisioning state of the backend http settings
     resource Updating/Deleting/Failed.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: PrivateIP allocation method. Possible values are: 'Static'
     and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the public IP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["SubResource"] = None,
        public_ip_address: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param port: Frontend port.
    :type port: int
    :param provisioning_state: Provisioning state of the frontend port resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayFrontendPort, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.port = port
        self.provisioning_state = provisioning_state


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :type require_server_name_indication: bool
    :param provisioning_state: Provisioning state of the HTTP listener resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        frontend_port: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayHttpListener, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = provisioning_state


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the application gateway subnet resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        subnet: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.subnet = subnet
        self.provisioning_state = provisioning_state


class ApplicationGatewayListResult(msrest.serialization.Model):
    """Response for ListApplicationGateways API service call.

    :param value: List of an application gateways in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGateway]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path map.
    :type backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        backend_http_settings: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayPathRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :type path: str
    :param interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :type interval: int
    :param timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :type unhealthy_threshold: int
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        protocol: Optional[Union[str, "ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayProbe, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.provisioning_state = provisioning_state


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param rule_type: Rule type. Possible values are: 'Basic' and 'PathBasedRouting'. Possible
     values include: "Basic", "PathBasedRouting".
    :type rule_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRuleType
    :param backend_address_pool: Backend address pool resource of the application gateway.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_http_settings: Frontend port resource of the application gateway.
    :type backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the request routing rule resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        rule_type: Optional[Union[str, "ApplicationGatewayRequestRoutingRuleType"]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        backend_http_settings: Optional["SubResource"] = None,
        http_listener: Optional["SubResource"] = None,
        url_path_map: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.rule_type = rule_type
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.provisioning_state = provisioning_state


class ApplicationGatewaySku(msrest.serialization.Model):
    """SKU of application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of an application gateway SKU. Possible values are: 'Standard_Small',
     'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'. Possible values include:
     "Standard_Small", "Standard_Medium", "Standard_Large".
    :type name: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Default value: "Standard".
    :vartype tier: str
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _validation = {
        'tier': {'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    tier = "Standard"

    def __init__(
        self,
        *,
        name: Optional[Union[str, "ApplicationGatewaySkuName"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only applicable in PUT request.
    :type password: str
    :param public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :type public_cert_data: str
    :param provisioning_state: Provisioning state of the SSL certificate resource Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewaySslCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.data = data
        self.password = password
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param default_backend_address_pool: Default backend address pool resource of URL path map.
    :type default_backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param default_backend_http_settings: Default backend http settings resource of URL path map.
    :type default_backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayPathRule]
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        default_backend_address_pool: Optional["SubResource"] = None,
        default_backend_http_settings: Optional["SubResource"] = None,
        path_rules: Optional[List["ApplicationGatewayPathRule"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGatewayUrlPathMap, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.path_rules = path_rules
        self.provisioning_state = provisioning_state


class AuthorizationListResult(msrest.serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :param value: The authorizations in an ExpressRoute Circuit.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitAuthorization]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AuthorizationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureAsyncOperationResult(msrest.serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Possible values include: "InProgress", "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.network.v2015_06_15.models.NetworkOperationStatus
    :param error: Error object properties.
    :type error: ~azure.mgmt.network.v2015_06_15.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "NetworkOperationStatus"]] = None,
        error: Optional["Error"] = None,
        **kwargs
    ):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = status
        self.error = error


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param backend_ip_configurations: Gets collection of references to IP addresses defined in
     network interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param outbound_nat_rule: Gets outbound rules that use this backend address pool.
    :type outbound_nat_rule: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Get provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'load_balancing_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        backend_ip_configurations: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        outbound_nat_rule: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(BackendAddressPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = backend_ip_configurations
        self.load_balancing_rules = None
        self.outbound_nat_rule = outbound_nat_rule
        self.provisioning_state = provisioning_state


class BgpSettings(msrest.serialization.Model):
    """BgpSettings.

    :param asn: Gets or sets this BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: Gets or sets the BGP peering address and BGP identifier of this BGP
     speaker.
    :type bgp_peering_address: str
    :param peer_weight: Gets or sets the weight added to routes learned from this BGP speaker.
    :type peer_weight: int
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        **kwargs
    ):
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class ConnectionResetSharedKey(msrest.serialization.Model):
    """ConnectionResetSharedKey.

    :param key_length: The virtual network connection reset shared key length.
    :type key_length: long
    """

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        key_length: Optional[int] = None,
        **kwargs
    ):
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(msrest.serialization.Model):
    """Response for GetConnectionSharedKey API service call.

    :param value: The virtual network connection shared key value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionSharedKey, self).__init__(**kwargs)
        self.value = value


class ConnectionSharedKeyResult(msrest.serialization.Model):
    """Response for CheckConnectionSharedKey API service call.

    :param value: The virtual network connection shared key value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionSharedKeyResult, self).__init__(**kwargs)
        self.value = value


class DhcpOptions(msrest.serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class DnsNameAvailabilityResult(msrest.serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        available: Optional[bool] = None,
        **kwargs
    ):
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = available


class Error(msrest.serialization.Model):
    """Error object properties.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.network.v2015_06_15.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(msrest.serialization.Model):
    """Error details properties.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSku
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :type circuit_provisioning_state: str
    :param service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
     'Deprovisioning'. Possible values include: "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioning".
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :param service_key: The ServiceKey.
    :type service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitServiceProviderProperties
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ExpressRouteCircuitSku"] = None,
        etag: Optional[str] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["ExpressRouteCircuitServiceProviderProperties"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuit, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitArpTable(msrest.serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
     'InUse'. Possible values include: "Available", "InUse".
    :type authorization_use_status: str or
     ~azure.mgmt.network.v2015_06_15.models.AuthorizationUseStatus
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "AuthorizationUseStatus"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitAuthorization, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitListResult(msrest.serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :param value: A list of ExpressRouteCircuits in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuit]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuit"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
     'AzurePrivatePeering', and 'MicrosoftPeering'. Possible values include: "AzurePublicPeering",
     "AzurePrivatePeering", "MicrosoftPeering".
    :type peering_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringType
    :param state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible
     values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringState
    :param azure_asn: The Azure ASN.
    :type azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: int
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param primary_azure_port: The primary port.
    :type primary_azure_port: str
    :param secondary_azure_port: The secondary port.
    :type secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringConfig
    :param stats: Gets peering stats.
    :type stats: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'int'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        peering_type: Optional[Union[str, "ExpressRouteCircuitPeeringType"]] = None,
        state: Optional[Union[str, "ExpressRouteCircuitPeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["ExpressRouteCircuitStats"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeering, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Specifies the peering configuration.

    :param advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
     Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
     Possible values include: "NotConfigured", "Configuring", "Configured", "ValidationNeeded".
    :type advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the configuration.
    :type routing_registry_name: str
    """

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_public_prefixes_state: Optional[Union[str, "ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_public_prefixes_state = advertised_public_prefixes_state
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringListResult(msrest.serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :param value: The peerings in an express route circuit.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitRoutesTable(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    All required parameters must be populated in order to send to Azure.

    :param address_prefix: Gets AddressPrefix.
    :type address_prefix: str
    :param next_hop_type: Required. Gets NextHopType. Possible values include:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :param next_hop_ip: Gets NextHopIP.
    :type next_hop_ip: str
    :param as_path: Gets AsPath.
    :type as_path: str
    """

    _validation = {
        'next_hop_type': {'required': True},
    }

    _attribute_map = {
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip': {'key': 'nextHopIP', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_hop_type: Union[str, "RouteNextHopType"],
        address_prefix: Optional[str] = None,
        next_hop_ip: Optional[str] = None,
        as_path: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip = next_hop_ip
        self.as_path = as_path


class ExpressRouteCircuitsArpTableListResult(msrest.serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: Gets list of the ARP table.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(msrest.serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(msrest.serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Possible values
     include: "Standard", "Premium".
    :type tier: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
     Possible values include: "UnlimitedData", "MeteredData".
    :type family: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: The list of routes table.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsStatsListResult(msrest.serialization.Model):
    """Response for ListStats from Express Route Circuits Api service call.

    :param value: Gets List of Stats.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats]
    :param next_link: Gets the URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitStats]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteCircuitStats"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitsStatsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(msrest.serialization.Model):
    """Contains stats associated with the peering.

    :param bytes_in: Gets BytesIn of the peering.
    :type bytes_in: int
    :param bytes_out: Gets BytesOut of the peering.
    :type bytes_out: int
    """

    _attribute_map = {
        'bytes_in': {'key': 'bytesIn', 'type': 'int'},
        'bytes_out': {'key': 'bytesOut', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        bytes_in: Optional[int] = None,
        bytes_out: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.bytes_in = bytes_in
        self.bytes_out = bytes_out


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: Get a list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: Gets bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProviderBandwidthsOffered]
    :param provisioning_state: Gets the provisioning state of the resource.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProvider, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = provisioning_state


class ExpressRouteServiceProviderBandwidthsOffered(msrest.serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        offer_name: Optional[str] = None,
        value_in_mbps: Optional[int] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(msrest.serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :param value: A list of ExpressRouteResourceProvider resources.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProvider]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteServiceProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExpressRouteServiceProviderListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
    :type outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param public_ip_address: The reference of the Public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        inbound_nat_rules: Optional[List["SubResource"]] = None,
        inbound_nat_pools: Optional[List["SubResource"]] = None,
        outbound_nat_rules: Optional[List["SubResource"]] = None,
        load_balancing_rules: Optional[List["SubResource"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["Subnet"] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(FrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.load_balancing_rules = load_balancing_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param frontend_port_range_start: The first port number in the range of external ports that
     will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
     range between 1 and 65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: The last port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :type frontend_port_range_end: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(InboundNatPool, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.provisioning_state = provisioning_state


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backed IP.
    :type backend_ip_configuration:
     ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration
    :param protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        backend_ip_configuration: Optional["NetworkInterfaceIPConfiguration"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(InboundNatRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = backend_ip_configuration
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class IPConfiguration(SubResource):
    """IPConfiguration.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["Subnet"] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(IPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by a load balancer.
    :type backend_address_pools: list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer.
    :type probes: list[~azure.mgmt.network.v2015_06_15.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.InboundNatPool]
    :param outbound_nat_rules: The outbound NAT rules.
    :type outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.OutboundNatRule]
    :param resource_guid: The resource GUID property of the load balancer resource.
    :type resource_guid: str
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        frontend_ip_configurations: Optional[List["FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["LoadBalancingRule"]] = None,
        probes: Optional[List["Probe"]] = None,
        inbound_nat_rules: Optional[List["InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["InboundNatPool"]] = None,
        outbound_nat_rules: Optional[List["OutboundNatRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancer, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LoadBalancerListResult(msrest.serialization.Model):
    """Response for ListLoadBalancers API service call.

    :param value: A list of load balancers in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancer]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LoadBalancer"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param probe: The reference of the load balancer probe used by the load balancing rule.
    :type probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: The transport protocol for the external endpoint. Possible values are 'Udp' or
     'Tcp'. Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule. Possible values are
     'Default', 'SourceIP', and 'SourceIPProtocol'. Possible values include: "Default", "SourceIP",
     "SourceIPProtocol".
    :type load_distribution: str or ~azure.mgmt.network.v2015_06_15.models.LoadDistribution
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["SubResource"] = None,
        backend_address_pool: Optional["SubResource"] = None,
        probe: Optional["SubResource"] = None,
        protocol: Optional[Union[str, "TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancingRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :param resource_guid: The resource GUID property of the LocalNetworkGateway resource.
    :type resource_guid: str
    :param provisioning_state: Gets or sets Provisioning state of the LocalNetworkGateway resource
     Updating/Deleting/Failed.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        local_network_address_space: Optional["AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        bgp_settings: Optional["BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(LocalNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LocalNetworkGatewayListResult(msrest.serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    :param value: A list of local network gateways that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LocalNetworkGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LocalNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param virtual_machine: The reference of a virtual machine.
    :type virtual_machine: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :param ip_configurations: A list of IPConfigurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings: ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceDnsSettings
    :param mac_address: The MAC address of the network interface.
    :type mac_address: str
    :param primary: Gets whether this is a primary network interface on a virtual machine.
    :type primary: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :type enable_ip_forwarding: bool
    :param resource_guid: The resource GUID property of the network interface resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        virtual_machine: Optional["SubResource"] = None,
        network_security_group: Optional["NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["NetworkInterfaceIPConfiguration"]] = None,
        dns_settings: Optional["NetworkInterfaceDnsSettings"] = None,
        mac_address: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.virtual_machine = virtual_machine
        self.network_security_group = network_security_group
        self.ip_configurations = ip_configurations
        self.dns_settings = dns_settings
        self.mac_address = mac_address
        self.primary = primary
        self.enable_ip_forwarding = enable_ip_forwarding
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkInterfaceDnsSettings(msrest.serialization.Model):
    """DNS settings of a network interface.

    :param dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :type dns_servers: list[str]
    :param applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :type applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :param internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
     in the same virtual network.
    :type internal_fqdn: str
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        applied_dns_servers: Optional[List[str]] = None,
        internal_dns_name_label: Optional[str] = None,
        internal_fqdn: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :param private_ip_address:
    :type private_ip_address: str
    :param private_ip_allocation_method: Defines how a private IP address is assigned. Possible
     values are: 'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: Subnet in a virtual network resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param primary: Gets whether this is a primary customer address on the network interface.
    :type primary: bool
    :param public_ip_address: Public IP address resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state:
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        load_balancer_backend_address_pools: Optional[List["BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterfaceIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class NetworkInterfaceListResult(msrest.serialization.Model):
    """Response for the ListNetworkInterface API service call.

    :param value: A list of network interfaces in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterface]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkInterface"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkInterfaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param security_rules: A collection of security rules of the network security group.
    :type security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param default_security_rules: The default security rules of network security group.
    :type default_security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param network_interfaces: A collection of references to network interfaces.
    :type network_interfaces: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :param subnets: A collection of references to subnets.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param resource_guid: The resource GUID property of the network security group resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        security_rules: Optional[List["SecurityRule"]] = None,
        default_security_rules: Optional[List["SecurityRule"]] = None,
        network_interfaces: Optional[List["NetworkInterface"]] = None,
        subnets: Optional[List["Subnet"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = network_interfaces
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :param value: A list of NetworkSecurityGroup resources.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkSecurityGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :type frontend_ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["SubResource"]] = None,
        backend_address_pool: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(OutboundNatRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = provisioning_state


class Probe(SubResource):
    """A load balancer probe.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param load_balancing_rules: The load balancer rules that use this probe.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp'
     is specified, a received ACK is required for the probe to be successful. If 'Http' is
     specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     Possible values include: "Http", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ProbeProtocol
    :param port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :type request_path: str
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        load_balancing_rules: Optional[List["SubResource"]] = None,
        protocol: Optional[Union[str, "ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        number_of_probes: Optional[int] = None,
        request_path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Probe, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancing_rules = load_balancing_rules
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = provisioning_state


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param public_ip_allocation_method: The public IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param ip_configuration: IPConfiguration.
    :type ip_configuration: ~azure.mgmt.network.v2015_06_15.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public IP address.
    :type dns_settings: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddressDnsSettings
    :param ip_address:
    :type ip_address: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param resource_guid: The resource GUID property of the public IP resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        public_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        ip_configuration: Optional["IPConfiguration"] = None,
        dns_settings: Optional["PublicIPAddressDnsSettings"] = None,
        ip_address: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddress, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.public_ip_allocation_method = public_ip_allocation_method
        self.ip_configuration = ip_configuration
        self.dns_settings = dns_settings
        self.ip_address = ip_address
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class PublicIPAddressDnsSettings(msrest.serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
     name label and the regionalized DNS zone make up the fully qualified domain name associated
     with the public IP address. If a domain name label is specified, an A DNS record is created for
     the public IP in the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the
     public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name
     that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record
     is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressListResult(msrest.serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :param value: A list of public IP addresses that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.PublicIPAddress]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicIPAddress]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PublicIPAddress"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddressListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Route(SubResource):
    """Route resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible
     values include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :type next_hop_ip_address: str
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Route, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = provisioning_state


class RouteListResult(msrest.serialization.Model):
    """Response for the ListRoute API service call.

    :param value: Gets a list of routes in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Route"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :param subnets: A collection of references to subnets.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        routes: Optional[List["Route"]] = None,
        subnets: Optional[List["Subnet"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(RouteTable, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.routes = routes
        self.subnets = subnets
        self.provisioning_state = provisioning_state


class RouteTableListResult(msrest.serialization.Model):
    """Response for the ListRouteTable API service call.

    :param value: Gets a list of route tables in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.RouteTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RouteTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityRule(SubResource):
    """Network security rule.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
     '*'. Possible values include: "Tcp", "Udp", "*".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix. CIDR or source IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :type destination_address_prefix: str
    :param access: The network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Possible values
     include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleDirection
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        access: Optional[Union[str, "SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "SecurityRuleDirection"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(SecurityRule, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = provisioning_state


class SecurityRuleListResult(msrest.serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :param value: The security rules in a network security group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SecurityRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecurityRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :param route_table: The reference of the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2015_06_15.models.RouteTable
    :param ip_configurations: Gets an array of references to the network interface IP
     configurations using subnet.
    :type ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.IPConfiguration]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        network_security_group: Optional["NetworkSecurityGroup"] = None,
        route_table: Optional["RouteTable"] = None,
        ip_configurations: Optional[List["IPConfiguration"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(Subnet, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.ip_configurations = ip_configurations
        self.provisioning_state = provisioning_state


class SubnetListResult(msrest.serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :param value: The subnets in a virtual network.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Subnet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Subnet"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SubnetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Usage(msrest.serialization.Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of measurement. Default value: "Count".
    :vartype unit: str
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2015_06_15.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        *,
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :param value: The list network resource usages.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Usage]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :type address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2015_06_15.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param resource_guid: The resourceGuid property of the Virtual Network resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        address_space: Optional["AddressSpace"] = None,
        dhcp_options: Optional["DhcpOptions"] = None,
        subnets: Optional[List["Subnet"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
     'ExpressRoute'. Possible values include: "Vpn", "ExpressRoute".
    :type gateway_type: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
     and 'RouteBased'. Possible values include: "PolicyBased", "RouteBased".
    :type vpn_type: str or ~azure.mgmt.network.v2015_06_15.models.VpnType
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :type enable_bgp: bool
    :param gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :type gateway_default_site: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :type vpn_client_configuration: ~azure.mgmt.network.v2015_06_15.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :param resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "VpnType"]] = None,
        enable_bgp: Optional[bool] = None,
        gateway_default_site: Optional["SubResource"] = None,
        sku: Optional["VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["VpnClientConfiguration"] = None,
        bgp_settings: Optional["BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.enable_bgp = enable_bgp
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: A common class for general resource information.
    :type virtual_network_gateway1: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param virtual_network_gateway2: A common class for general resource information.
    :type virtual_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param local_network_gateway2: A common class for general resource information.
    :type local_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway
    :param connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :param connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :type connection_status: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionStatus
    :param egress_bytes_transferred: The egress bytes transferred in this connection.
    :type egress_bytes_transferred: long
    :param ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :type ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway1: Optional["VirtualNetworkGateway"] = None,
        virtual_network_gateway2: Optional["VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["LocalNetworkGateway"] = None,
        connection_type: Optional[Union[str, "VirtualNetworkGatewayConnectionType"]] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        connection_status: Optional[Union[str, "VirtualNetworkGatewayConnectionStatus"]] = None,
        egress_bytes_transferred: Optional[int] = None,
        ingress_bytes_transferred: Optional[int] = None,
        peer: Optional["SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnection, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = connection_status
        self.egress_bytes_transferred = egress_bytes_transferred
        self.ingress_bytes_transferred = ingress_bytes_transferred
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayConnectionListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    :param value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
     resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnection]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkGatewayConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: Gets or sets the privateIPAddress of the IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IPAllocationMethod"]] = None,
        subnet: Optional["SubResource"] = None,
        public_ip_address: Optional["SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    :param value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkGatewaySku(msrest.serialization.Model):
    """VirtualNetworkGatewaySku details.

    :param name: Gateway sku name -Basic/HighPerformance/Standard. Possible values include:
     "Basic", "HighPerformance", "Standard".
    :type name: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway sku tier -Basic/HighPerformance/Standard. Possible values include:
     "Basic", "HighPerformance", "Standard".
    :type tier: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuTier
    :param capacity: The capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "VirtualNetworkGatewaySkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class VirtualNetworkListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :param value: Gets a list of VirtualNetwork resources in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetwork]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetwork"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VpnClientConfiguration(msrest.serialization.Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: Gets or sets the reference of the Address space resource which
     represents Address space for P2S VpnClient.
    :type vpn_client_address_pool: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for Virtual network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
     gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRevokedCertificate]
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["VpnClientRevokedCertificate"]] = None,
        **kwargs
    ):
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates


class VpnClientParameters(msrest.serialization.Model):
    """VpnClientParameters.

    :param processor_architecture: VPN client Processor Architecture. Possible values are: 'AMD64'
     and 'X86'. Possible values include: "Amd64", "X86".
    :type processor_architecture: str or
     ~azure.mgmt.network.v2015_06_15.models.ProcessorArchitecture
    """

    _attribute_map = {
        'processor_architecture': {'key': 'ProcessorArchitecture', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        processor_architecture: Optional[Union[str, "ProcessorArchitecture"]] = None,
        **kwargs
    ):
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = processor_architecture


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :param provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VpnClientRevokedCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = provisioning_state


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param public_cert_data: Gets or sets the certificate public data.
    :type public_cert_data: str
    :param provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        etag: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(VpnClientRootCertificate, self).__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state
