# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AddressSpace(msrest.serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = kwargs.get('address_prefixes', None)


class Resource(msrest.serialization.Model):
    """Azure resource manager resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySku
    :ivar operational_state: Operational state of the application gateway resource. Possible values
     are: 'Stopped', 'Started', 'Running', and 'Stopping'. Possible values include: "Stopped",
     "Starting", "Running", "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Gets or sets subnets of application gateway resource.
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayIPConfiguration]
    :param ssl_certificates: SSL certificates of the application gateway resource.
    :type ssl_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
    :type frontend_ports:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application gateway resource.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the application gateway
     resource.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
    :type http_listeners:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
    :type url_path_maps: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRule]
    :param resource_guid: Resource GUID property of the application gateway resource.
    :type resource_guid: str
    :param provisioning_state: Provisioning state of the application gateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGateway, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.sku = kwargs.get('sku', None)
        self.operational_state = None
        self.gateway_ip_configurations = kwargs.get('gateway_ip_configurations', None)
        self.ssl_certificates = kwargs.get('ssl_certificates', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.frontend_ports = kwargs.get('frontend_ports', None)
        self.probes = kwargs.get('probes', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.backend_http_settings_collection = kwargs.get('backend_http_settings_collection', None)
        self.http_listeners = kwargs.get('http_listeners', None)
        self.url_path_maps = kwargs.get('url_path_maps', None)
        self.request_routing_rules = kwargs.get('request_routing_rules', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayBackendAddress(msrest.serialization.Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address.
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.ip_address = kwargs.get('ip_address', None)


class SubResource(msrest.serialization.Model):
    """Azure resource manager sub resource properties.

    :param id: Resource Identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Resource that is unique within a resource group. This name can be used to access
     the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param backend_ip_configurations: Collection of references to IPs defined in network
     interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses.
    :type backend_addresses:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddress]
    :param provisioning_state: Provisioning state of the backend address pool resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendAddressPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.backend_ip_configurations = kwargs.get('backend_ip_configurations', None)
        self.backend_addresses = kwargs.get('backend_addresses', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param port: Port.
    :type port: int
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values are: 'Enabled' and
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway will fail the request
     if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Gets or sets Provisioning state of the backend http settings
     resource Updating/Deleting/Failed.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.port = kwargs.get('port', None)
        self.protocol = kwargs.get('protocol', None)
        self.cookie_based_affinity = kwargs.get('cookie_based_affinity', None)
        self.request_timeout = kwargs.get('request_timeout', None)
        self.probe = kwargs.get('probe', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: PrivateIP allocation method. Possible values are: 'Static'
     and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the public IP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param port: Frontend port.
    :type port: int
    :param provisioning_state: Provisioning state of the frontend port resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayFrontendPort, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.port = kwargs.get('port', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :type require_server_name_indication: bool
    :param provisioning_state: Provisioning state of the HTTP listener resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayHttpListener, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.protocol = kwargs.get('protocol', None)
        self.host_name = kwargs.get('host_name', None)
        self.ssl_certificate = kwargs.get('ssl_certificate', None)
        self.require_server_name_indication = kwargs.get('require_server_name_indication', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the application gateway subnet resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.subnet = kwargs.get('subnet', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayListResult(msrest.serialization.Model):
    """Response for ListApplicationGateways API service call.

    :param value: List of an application gateways in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGateway]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path map.
    :type backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayPathRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.paths = kwargs.get('paths', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param protocol: Protocol. Possible values are: 'Http' and 'Https'. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :type path: str
    :param interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :type interval: int
    :param timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :type unhealthy_threshold: int
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayProbe, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.protocol = kwargs.get('protocol', None)
        self.host = kwargs.get('host', None)
        self.path = kwargs.get('path', None)
        self.interval = kwargs.get('interval', None)
        self.timeout = kwargs.get('timeout', None)
        self.unhealthy_threshold = kwargs.get('unhealthy_threshold', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param rule_type: Rule type. Possible values are: 'Basic' and 'PathBasedRouting'. Possible
     values include: "Basic", "PathBasedRouting".
    :type rule_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRuleType
    :param backend_address_pool: Backend address pool resource of the application gateway.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_http_settings: Frontend port resource of the application gateway.
    :type backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Provisioning state of the request routing rule resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayRequestRoutingRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.rule_type = kwargs.get('rule_type', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.backend_http_settings = kwargs.get('backend_http_settings', None)
        self.http_listener = kwargs.get('http_listener', None)
        self.url_path_map = kwargs.get('url_path_map', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewaySku(msrest.serialization.Model):
    """SKU of application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of an application gateway SKU. Possible values are: 'Standard_Small',
     'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'. Possible values include:
     "Standard_Small", "Standard_Medium", "Standard_Large".
    :type name: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Default value: "Standard".
    :vartype tier: str
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _validation = {
        'tier': {'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    tier = "Standard"

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.capacity = kwargs.get('capacity', None)


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only applicable in PUT request.
    :type password: str
    :param public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :type public_cert_data: str
    :param provisioning_state: Provisioning state of the SSL certificate resource Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewaySslCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.data = kwargs.get('data', None)
        self.password = kwargs.get('password', None)
        self.public_cert_data = kwargs.get('public_cert_data', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    :param id: Resource Identifier.
    :type id: str
    :param name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param default_backend_address_pool: Default backend address pool resource of URL path map.
    :type default_backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param default_backend_http_settings: Default backend http settings resource of URL path map.
    :type default_backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayPathRule]
    :param provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGatewayUrlPathMap, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.default_backend_address_pool = kwargs.get('default_backend_address_pool', None)
        self.default_backend_http_settings = kwargs.get('default_backend_http_settings', None)
        self.path_rules = kwargs.get('path_rules', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class AuthorizationListResult(msrest.serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :param value: The authorizations in an ExpressRoute Circuit.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitAuthorization]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AzureAsyncOperationResult(msrest.serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Possible values include: "InProgress", "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.network.v2015_06_15.models.NetworkOperationStatus
    :param error: Error object properties.
    :type error: ~azure.mgmt.network.v2015_06_15.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param backend_ip_configurations: Gets collection of references to IP addresses defined in
     network interfaces.
    :type backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param outbound_nat_rule: Gets outbound rules that use this backend address pool.
    :type outbound_nat_rule: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Get provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'load_balancing_rules': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendAddressPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.backend_ip_configurations = kwargs.get('backend_ip_configurations', None)
        self.load_balancing_rules = None
        self.outbound_nat_rule = kwargs.get('outbound_nat_rule', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class BgpSettings(msrest.serialization.Model):
    """BgpSettings.

    :param asn: Gets or sets this BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: Gets or sets the BGP peering address and BGP identifier of this BGP
     speaker.
    :type bgp_peering_address: str
    :param peer_weight: Gets or sets the weight added to routes learned from this BGP speaker.
    :type peer_weight: int
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = kwargs.get('asn', None)
        self.bgp_peering_address = kwargs.get('bgp_peering_address', None)
        self.peer_weight = kwargs.get('peer_weight', None)


class ConnectionResetSharedKey(msrest.serialization.Model):
    """ConnectionResetSharedKey.

    :param key_length: The virtual network connection reset shared key length.
    :type key_length: long
    """

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = kwargs.get('key_length', None)


class ConnectionSharedKey(msrest.serialization.Model):
    """Response for GetConnectionSharedKey API service call.

    :param value: The virtual network connection shared key value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionSharedKey, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ConnectionSharedKeyResult(msrest.serialization.Model):
    """Response for CheckConnectionSharedKey API service call.

    :param value: The virtual network connection shared key value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionSharedKeyResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DhcpOptions(msrest.serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)


class DnsNameAvailabilityResult(msrest.serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = kwargs.get('available', None)


class Error(msrest.serialization.Model):
    """Error object properties.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.network.v2015_06_15.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)


class ErrorDetails(msrest.serialization.Model):
    """Error details properties.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSku
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :type circuit_provisioning_state: str
    :param service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
     'Deprovisioning'. Possible values include: "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioning".
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :param service_key: The ServiceKey.
    :type service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitServiceProviderProperties
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuit, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.etag = kwargs.get('etag', None)
        self.circuit_provisioning_state = kwargs.get('circuit_provisioning_state', None)
        self.service_provider_provisioning_state = kwargs.get('service_provider_provisioning_state', None)
        self.authorizations = kwargs.get('authorizations', None)
        self.peerings = kwargs.get('peerings', None)
        self.service_key = kwargs.get('service_key', None)
        self.service_provider_notes = kwargs.get('service_provider_notes', None)
        self.service_provider_properties = kwargs.get('service_provider_properties', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ExpressRouteCircuitArpTable(msrest.serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.mac_address = kwargs.get('mac_address', None)


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :param authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
     'InUse'. Possible values include: "Available", "InUse".
    :type authorization_use_status: str or
     ~azure.mgmt.network.v2015_06_15.models.AuthorizationUseStatus
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitAuthorization, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.authorization_use_status = kwargs.get('authorization_use_status', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ExpressRouteCircuitListResult(msrest.serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :param value: A list of ExpressRouteCircuits in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuit]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
     'AzurePrivatePeering', and 'MicrosoftPeering'. Possible values include: "AzurePublicPeering",
     "AzurePrivatePeering", "MicrosoftPeering".
    :type peering_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringType
    :param state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible
     values include: "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringState
    :param azure_asn: The Azure ASN.
    :type azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: int
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param primary_azure_port: The primary port.
    :type primary_azure_port: str
    :param secondary_azure_port: The secondary port.
    :type secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringConfig
    :param stats: Gets peering stats.
    :type stats: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'int'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeering, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.peering_type = kwargs.get('peering_type', None)
        self.state = kwargs.get('state', None)
        self.azure_asn = kwargs.get('azure_asn', None)
        self.peer_asn = kwargs.get('peer_asn', None)
        self.primary_peer_address_prefix = kwargs.get('primary_peer_address_prefix', None)
        self.secondary_peer_address_prefix = kwargs.get('secondary_peer_address_prefix', None)
        self.primary_azure_port = kwargs.get('primary_azure_port', None)
        self.secondary_azure_port = kwargs.get('secondary_azure_port', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.vlan_id = kwargs.get('vlan_id', None)
        self.microsoft_peering_config = kwargs.get('microsoft_peering_config', None)
        self.stats = kwargs.get('stats', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ExpressRouteCircuitPeeringConfig(msrest.serialization.Model):
    """Specifies the peering configuration.

    :param advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
     Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
     Possible values include: "NotConfigured", "Configuring", "Configured", "ValidationNeeded".
    :type advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the configuration.
    :type routing_registry_name: str
    """

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = kwargs.get('advertised_public_prefixes', None)
        self.advertised_public_prefixes_state = kwargs.get('advertised_public_prefixes_state', None)
        self.customer_asn = kwargs.get('customer_asn', None)
        self.routing_registry_name = kwargs.get('routing_registry_name', None)


class ExpressRouteCircuitPeeringListResult(msrest.serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :param value: The peerings in an express route circuit.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitPeering]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitPeeringListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitRoutesTable(msrest.serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    All required parameters must be populated in order to send to Azure.

    :param address_prefix: Gets AddressPrefix.
    :type address_prefix: str
    :param next_hop_type: Required. Gets NextHopType. Possible values include:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :param next_hop_ip: Gets NextHopIP.
    :type next_hop_ip: str
    :param as_path: Gets AsPath.
    :type as_path: str
    """

    _validation = {
        'next_hop_type': {'required': True},
    }

    _attribute_map = {
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip': {'key': 'nextHopIP', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_type = kwargs['next_hop_type']
        self.next_hop_ip = kwargs.get('next_hop_ip', None)
        self.as_path = kwargs.get('as_path', None)


class ExpressRouteCircuitsArpTableListResult(msrest.serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: Gets list of the ARP table.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitServiceProviderProperties(msrest.serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = kwargs.get('service_provider_name', None)
        self.peering_location = kwargs.get('peering_location', None)
        self.bandwidth_in_mbps = kwargs.get('bandwidth_in_mbps', None)


class ExpressRouteCircuitSku(msrest.serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Possible values
     include: "Standard", "Premium".
    :type tier: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
     Possible values include: "UnlimitedData", "MeteredData".
    :type family: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.family = kwargs.get('family', None)


class ExpressRouteCircuitsRoutesTableListResult(msrest.serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :param value: The list of routes table.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitsStatsListResult(msrest.serialization.Model):
    """Response for ListStats from Express Route Circuits Api service call.

    :param value: Gets List of Stats.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats]
    :param next_link: Gets the URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitStats]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitsStatsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ExpressRouteCircuitStats(msrest.serialization.Model):
    """Contains stats associated with the peering.

    :param bytes_in: Gets BytesIn of the peering.
    :type bytes_in: int
    :param bytes_out: Gets BytesOut of the peering.
    :type bytes_out: int
    """

    _attribute_map = {
        'bytes_in': {'key': 'bytesIn', 'type': 'int'},
        'bytes_out': {'key': 'bytesOut', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.bytes_in = kwargs.get('bytes_in', None)
        self.bytes_out = kwargs.get('bytes_out', None)


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: Get a list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: Gets bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProviderBandwidthsOffered]
    :param provisioning_state: Gets the provisioning state of the resource.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProvider, self).__init__(**kwargs)
        self.peering_locations = kwargs.get('peering_locations', None)
        self.bandwidths_offered = kwargs.get('bandwidths_offered', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class ExpressRouteServiceProviderBandwidthsOffered(msrest.serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = kwargs.get('offer_name', None)
        self.value_in_mbps = kwargs.get('value_in_mbps', None)


class ExpressRouteServiceProviderListResult(msrest.serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :param value: A list of ExpressRouteResourceProvider resources.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProvider]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteServiceProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpressRouteServiceProviderListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
    :type outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param public_ip_address: The reference of the Public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)
        self.outbound_nat_rules = kwargs.get('outbound_nat_rules', None)
        self.load_balancing_rules = kwargs.get('load_balancing_rules', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param frontend_port_range_start: The first port number in the range of external ports that
     will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
     range between 1 and 65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: The last port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :type frontend_port_range_end: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundNatPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port_range_start = kwargs.get('frontend_port_range_start', None)
        self.frontend_port_range_end = kwargs.get('frontend_port_range_end', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backed IP.
    :type backend_ip_configuration:
     ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration
    :param protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundNatRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_ip_configuration = kwargs.get('backend_ip_configuration', None)
        self.protocol = kwargs.get('protocol', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class IPConfiguration(SubResource):
    """IPConfiguration.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by a load balancer.
    :type backend_address_pools: list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer.
    :type probes: list[~azure.mgmt.network.v2015_06_15.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :type inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.InboundNatPool]
    :param outbound_nat_rules: The outbound NAT rules.
    :type outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.OutboundNatRule]
    :param resource_guid: The resource GUID property of the load balancer resource.
    :type resource_guid: str
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancer, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pools = kwargs.get('backend_address_pools', None)
        self.load_balancing_rules = kwargs.get('load_balancing_rules', None)
        self.probes = kwargs.get('probes', None)
        self.inbound_nat_rules = kwargs.get('inbound_nat_rules', None)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)
        self.outbound_nat_rules = kwargs.get('outbound_nat_rules', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class LoadBalancerListResult(msrest.serialization.Model):
    """Response for ListLoadBalancers API service call.

    :param value: A list of load balancers in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancer]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param probe: The reference of the load balancer probe used by the load balancing rule.
    :type probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param protocol: The transport protocol for the external endpoint. Possible values are 'Udp' or
     'Tcp'. Possible values include: "Udp", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule. Possible values are
     'Default', 'SourceIP', and 'SourceIPProtocol'. Possible values include: "Default", "SourceIP",
     "SourceIPProtocol".
    :type load_distribution: str or ~azure.mgmt.network.v2015_06_15.models.LoadDistribution
    :param frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :type enable_floating_ip: bool
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.frontend_ip_configuration = kwargs.get('frontend_ip_configuration', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.probe = kwargs.get('probe', None)
        self.protocol = kwargs.get('protocol', None)
        self.load_distribution = kwargs.get('load_distribution', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.enable_floating_ip = kwargs.get('enable_floating_ip', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :param resource_guid: The resource GUID property of the LocalNetworkGateway resource.
    :type resource_guid: str
    :param provisioning_state: Gets or sets Provisioning state of the LocalNetworkGateway resource
     Updating/Deleting/Failed.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalNetworkGateway, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.local_network_address_space = kwargs.get('local_network_address_space', None)
        self.gateway_ip_address = kwargs.get('gateway_ip_address', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class LocalNetworkGatewayListResult(msrest.serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    :param value: A list of local network gateways that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param virtual_machine: The reference of a virtual machine.
    :type virtual_machine: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :param ip_configurations: A list of IPConfigurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings: ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceDnsSettings
    :param mac_address: The MAC address of the network interface.
    :type mac_address: str
    :param primary: Gets whether this is a primary network interface on a virtual machine.
    :type primary: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :type enable_ip_forwarding: bool
    :param resource_guid: The resource GUID property of the network interface resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.virtual_machine = kwargs.get('virtual_machine', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.mac_address = kwargs.get('mac_address', None)
        self.primary = kwargs.get('primary', None)
        self.enable_ip_forwarding = kwargs.get('enable_ip_forwarding', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class NetworkInterfaceDnsSettings(msrest.serialization.Model):
    """DNS settings of a network interface.

    :param dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :type dns_servers: list[str]
    :param applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :type applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :param internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
     in the same virtual network.
    :type internal_fqdn: str
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = kwargs.get('dns_servers', None)
        self.applied_dns_servers = kwargs.get('applied_dns_servers', None)
        self.internal_dns_name_label = kwargs.get('internal_dns_name_label', None)
        self.internal_fqdn = kwargs.get('internal_fqdn', None)


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :param private_ip_address:
    :type private_ip_address: str
    :param private_ip_allocation_method: Defines how a private IP address is assigned. Possible
     values are: 'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: Subnet in a virtual network resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :param primary: Gets whether this is a primary customer address on the network interface.
    :type primary: bool
    :param public_ip_address: Public IP address resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :param provisioning_state:
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools', None)
        self.load_balancer_inbound_nat_rules = kwargs.get('load_balancer_inbound_nat_rules', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.primary = kwargs.get('primary', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class NetworkInterfaceListResult(msrest.serialization.Model):
    """Response for the ListNetworkInterface API service call.

    :param value: A list of network interfaces in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkInterface]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param security_rules: A collection of security rules of the network security group.
    :type security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param default_security_rules: The default security rules of network security group.
    :type default_security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param network_interfaces: A collection of references to network interfaces.
    :type network_interfaces: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :param subnets: A collection of references to subnets.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param resource_guid: The resource GUID property of the network security group resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityGroup, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.security_rules = kwargs.get('security_rules', None)
        self.default_security_rules = kwargs.get('default_security_rules', None)
        self.network_interfaces = kwargs.get('network_interfaces', None)
        self.subnets = kwargs.get('subnets', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class NetworkSecurityGroupListResult(msrest.serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :param value: A list of NetworkSecurityGroup resources.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :type frontend_ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :type backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundNatRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.allocated_outbound_ports = kwargs.get('allocated_outbound_ports', None)
        self.frontend_ip_configurations = kwargs.get('frontend_ip_configurations', None)
        self.backend_address_pool = kwargs.get('backend_address_pool', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class Probe(SubResource):
    """A load balancer probe.

    :param id: Resource Identifier.
    :type id: str
    :param name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param load_balancing_rules: The load balancer rules that use this probe.
    :type load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :param protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp'
     is specified, a received ACK is required for the probe to be successful. If 'Http' is
     specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     Possible values include: "Http", "Tcp".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.ProbeProtocol
    :param port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :type request_path: str
    :param provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Probe, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.load_balancing_rules = kwargs.get('load_balancing_rules', None)
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.number_of_probes = kwargs.get('number_of_probes', None)
        self.request_path = kwargs.get('request_path', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param public_ip_allocation_method: The public IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param ip_configuration: IPConfiguration.
    :type ip_configuration: ~azure.mgmt.network.v2015_06_15.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public IP address.
    :type dns_settings: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddressDnsSettings
    :param ip_address:
    :type ip_address: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param resource_guid: The resource GUID property of the public IP resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddress, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.public_ip_allocation_method = kwargs.get('public_ip_allocation_method', None)
        self.ip_configuration = kwargs.get('ip_configuration', None)
        self.dns_settings = kwargs.get('dns_settings', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PublicIPAddressDnsSettings(msrest.serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
     name label and the regionalized DNS zone make up the fully qualified domain name associated
     with the public IP address. If a domain name label is specified, an A DNS record is created for
     the public IP in the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the
     public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name
     that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record
     is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = kwargs.get('domain_name_label', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.reverse_fqdn = kwargs.get('reverse_fqdn', None)


class PublicIPAddressListResult(msrest.serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :param value: A list of public IP addresses that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.PublicIPAddress]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicIPAddress]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicIPAddressListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Route(SubResource):
    """Route resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible
     values include: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", "None".
    :type next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :type next_hop_ip_address: str
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Route, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.next_hop_type = kwargs.get('next_hop_type', None)
        self.next_hop_ip_address = kwargs.get('next_hop_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class RouteListResult(msrest.serialization.Model):
    """Response for the ListRoute API service call.

    :param value: Gets a list of routes in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :param subnets: A collection of references to subnets.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteTable, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.routes = kwargs.get('routes', None)
        self.subnets = kwargs.get('subnets', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class RouteTableListResult(msrest.serialization.Model):
    """Response for the ListRouteTable API service call.

    :param value: Gets a list of route tables in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.RouteTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RouteTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteTableListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SecurityRule(SubResource):
    """Network security rule.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
     '*'. Possible values include: "Tcp", "Udp", "*".
    :type protocol: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix. CIDR or source IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :type destination_address_prefix: str
    :param access: The network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Possible values
     include: "Inbound", "Outbound".
    :type direction: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleDirection
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.description = kwargs.get('description', None)
        self.protocol = kwargs.get('protocol', None)
        self.source_port_range = kwargs.get('source_port_range', None)
        self.destination_port_range = kwargs.get('destination_port_range', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.destination_address_prefix = kwargs.get('destination_address_prefix', None)
        self.access = kwargs.get('access', None)
        self.priority = kwargs.get('priority', None)
        self.direction = kwargs.get('direction', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class SecurityRuleListResult(msrest.serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :param value: The security rules in a network security group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param network_security_group: The reference of the NetworkSecurityGroup resource.
    :type network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :param route_table: The reference of the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2015_06_15.models.RouteTable
    :param ip_configurations: Gets an array of references to the network interface IP
     configurations using subnet.
    :type ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.IPConfiguration]
    :param provisioning_state: The provisioning state of the resource.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.address_prefix = kwargs.get('address_prefix', None)
        self.network_security_group = kwargs.get('network_security_group', None)
        self.route_table = kwargs.get('route_table', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class SubnetListResult(msrest.serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :param value: The subnets in a virtual network.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Subnet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubnetListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Usage(msrest.serialization.Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of measurement. Default value: "Count".
    :vartype unit: str
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2015_06_15.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.current_value = kwargs['current_value']
        self.limit = kwargs['limit']
        self.name = kwargs['name']


class UsageName(msrest.serialization.Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :param value: The list network resource usages.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.Usage]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :type address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2015_06_15.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :param resource_guid: The resourceGuid property of the Virtual Network resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.address_space = kwargs.get('address_space', None)
        self.dhcp_options = kwargs.get('dhcp_options', None)
        self.subnets = kwargs.get('subnets', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
     'ExpressRoute'. Possible values include: "Vpn", "ExpressRoute".
    :type gateway_type: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
     and 'RouteBased'. Possible values include: "PolicyBased", "RouteBased".
    :type vpn_type: str or ~azure.mgmt.network.v2015_06_15.models.VpnType
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :type enable_bgp: bool
    :param gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :type gateway_default_site: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :type vpn_client_configuration: ~azure.mgmt.network.v2015_06_15.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :param resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGateway, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.ip_configurations = kwargs.get('ip_configurations', None)
        self.gateway_type = kwargs.get('gateway_type', None)
        self.vpn_type = kwargs.get('vpn_type', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.gateway_default_site = kwargs.get('gateway_default_site', None)
        self.sku = kwargs.get('sku', None)
        self.vpn_client_configuration = kwargs.get('vpn_client_configuration', None)
        self.bgp_settings = kwargs.get('bgp_settings', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: A common class for general resource information.
    :type virtual_network_gateway1: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param virtual_network_gateway2: A common class for general resource information.
    :type virtual_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param local_network_gateway2: A common class for general resource information.
    :type local_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway
    :param connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: "IPsec",
     "Vnet2Vnet", "ExpressRoute", "VPNClient".
    :type connection_type: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :param connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: "Unknown",
     "Connecting", "Connected", "NotConnected".
    :type connection_status: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionStatus
    :param egress_bytes_transferred: The egress bytes transferred in this connection.
    :type egress_bytes_transferred: long
    :param ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :type ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnection, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs.get('virtual_network_gateway1', None)
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs.get('connection_type', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = kwargs.get('connection_status', None)
        self.egress_bytes_transferred = kwargs.get('egress_bytes_transferred', None)
        self.ingress_bytes_transferred = kwargs.get('ingress_bytes_transferred', None)
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class VirtualNetworkGatewayConnectionListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    :param value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
     resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnection]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGatewayConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param private_ip_address: Gets or sets the privateIPAddress of the IP Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Possible values include: "Static", "Dynamic".
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.private_ip_address = kwargs.get('private_ip_address', None)
        self.private_ip_allocation_method = kwargs.get('private_ip_allocation_method', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class VirtualNetworkGatewayListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    :param value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkGateway]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewayListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VirtualNetworkGatewaySku(msrest.serialization.Model):
    """VirtualNetworkGatewaySku details.

    :param name: Gateway sku name -Basic/HighPerformance/Standard. Possible values include:
     "Basic", "HighPerformance", "Standard".
    :type name: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway sku tier -Basic/HighPerformance/Standard. Possible values include:
     "Basic", "HighPerformance", "Standard".
    :type tier: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuTier
    :param capacity: The capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class VirtualNetworkListResult(msrest.serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :param value: Gets a list of VirtualNetwork resources in a resource group.
    :type value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetwork]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VpnClientConfiguration(msrest.serialization.Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: Gets or sets the reference of the Address space resource which
     represents Address space for P2S VpnClient.
    :type vpn_client_address_pool: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for Virtual network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
     gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRevokedCertificate]
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = kwargs.get('vpn_client_address_pool', None)
        self.vpn_client_root_certificates = kwargs.get('vpn_client_root_certificates', None)
        self.vpn_client_revoked_certificates = kwargs.get('vpn_client_revoked_certificates', None)


class VpnClientParameters(msrest.serialization.Model):
    """VpnClientParameters.

    :param processor_architecture: VPN client Processor Architecture. Possible values are: 'AMD64'
     and 'X86'. Possible values include: "Amd64", "X86".
    :type processor_architecture: str or
     ~azure.mgmt.network.v2015_06_15.models.ProcessorArchitecture
    """

    _attribute_map = {
        'processor_architecture': {'key': 'ProcessorArchitecture', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = kwargs.get('processor_architecture', None)


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :param provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientRevokedCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    :param id: Resource Identifier.
    :type id: str
    :param name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param public_cert_data: Gets or sets the certificate public data.
    :type public_cert_data: str
    :param provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :type provisioning_state: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VpnClientRootCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.etag = kwargs.get('etag', None)
        self.public_cert_data = kwargs.get('public_cert_data', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
