"""
Patches :class:`~intents.model.entity.Sys.Color`

Sources:

* https://simple.wikipedia.org/wiki/List_of_colors
* https://it.wikipedia.org/wiki/Lista_dei_colori
* https://fr.wikipedia.org/wiki/Liste_de_noms_de_couleur
* https://de.wikipedia.org/wiki/Liste_der_Farben_im_Farbkreis
* https://www.lingomastery.com/full-list-colors-spanish/

Some uncommons colors have been removed
"""
from typing import List, Union

from intents import Entity, LanguageCode
from intents.language.entity_language import make_language_data

# TODO: Dutch, German and Spanish have less than other languages

class I_IntentsColor(Entity):
    __intents_internal__ = True
    __entity_language_data__ = {
        LanguageCode.ENGLISH: make_language_data(["Amaranth", "Amber", "Amethyst", "Apricot", "Aquamarine", "Azure", "Baby blue", "Beige", "Brick red", "Black", "Blue", "Blue-green", "Blue-violet", "Blush", "Bronze", "Brown", "Burgundy", "Byzantium", "Carmine", "Cerise", "Cerulean", "Champagne", "Chartreuse green", "Chocolate", "Cobalt blue", "Coffee", "Copper", "Coral", "Crimson", "Cyan", "Desert sand", "Electric blue", "Emerald", "Erin", "Gold", "Gray", "Green", "Harlequin", "Indigo", "Ivory", "Jade", "Jungle green", "Lavender", "Lemon", "Lilac", "Lime", "Magenta", "Magenta rose", "Maroon", "Mauve", "Navy blue", "Ochre", "Olive", "Orange", "Orange-red", "Orchid", "Peach", "Pear", "Periwinkle", "Persian blue", "Pink", "Plum", "Prussian blue", "Puce", "Purple", "Raspberry", "Red", "Red-violet", "Rose", "Ruby", "Salmon", "Sangria", "Sapphire", "Scarlet", "Silver", "Slate gray", "Spring bud", "Spring green", "Tan", "Taupe", "Teal", "Turquoise", "Ultramarine", "Violet", "Viridian", "White", "Yellow"]),
        LanguageCode.ITALIAN: make_language_data(["Acquamarina", "Albicocca", "Amaranto", "Ambra", "Ametista", "Anguria", "Antracite", "Aragosta", "Arancione", "Ardesia", "Argento", "Asparago", "Avio", "Avorio", "Azalea", "Azzurro", "Beige", "Beige-oliva", "Beige verdastro", "Bianco", "Bianco fantasma", "Bianco fumo", "Bianco Navajo", "Biscotto", "Bistro", "Blu", "Blu acciaio", "Blu alice", "Blu Bondi", "Blu cadetto", "Blu ceruleo", "Blu di Persia", "Blu di Prussia", "Blu elettrico", "Blu marino", "Blu notte", "Blu oltremare", "Blu polvere", "Blu reale", "Blu scuro", "Bordeaux", "Borgogna", "Bronzo", "Bronzo antico", "Camoscio", "Carbone", "Cardo", "Carminio", "Carta da zucchero", "Castagno", "Catrame", "Celadon", "Celeste", "Ceruleo", "Chartreuse", "Ciano", "Ciliegia", "Cioccolato", "Cobalto", "Conchiglia", "Corallo", "Crema", "Cremisi", "Denim", "Eliotropo", "Écru", "Fiore di granturco", "Foglia di tè", "Fucsia", "Fulvo", "Gainsboro", "Giada", "Giallo", "Giallo miele", "Giallo pastello", "Giallo sabbia", "Glicine", "Granata", "Grano", "Grigio ardesia", "Grigio cenere", "Grigio topo", "Indaco", "Indaco elettrico", "Indaco scuro", "Isabella", "Kaki", "Lampone", "Lavanda", "Lavanda pallido", "Lavanda rosata", "Limone", "Limone crema", "Lilla", "Lime", "Lino", "Magenta", "Magnolia", "Malva", "Malva chiaro", "Mandarino", "Marrone", "Marrone chiaro", "Marrone pastello", "Marrone-rosso", "Marrone scuro", "Melanzana", "Mogano", "Nero", "Ocra", "Olivina", "Orchidea", "Oro", "Oro vecchio", "Ottone antico", "Ottanio", "Papaia", "Pera", "Pervinca", "Pesca", "Pesca scuro", "Pesca-arancio", "Pesca-giallo", "Pistacchio", "Platino", "Porpora", "Prugna", "Rame", "Rosa", "Rosa arancio", "Rosa medio", "Rosa pallido", "Rosa pastello", "Rosa scuro", "Rosa shocking", "Rosa vivo", "Rosso", "Rosso aragosta", "Rosso cardinale", "Rosso corsa", "Rosso Falun", "Rosso fragola", "Rosso fuoco", "Rosso mattone", "Rosso pomodoro", "Rosso pompeiano", "Rosso rosa", "Rosso sangue", "Rosso segnale", "Rosso Tiziano", "Rosso veneziano", "Rubino", "Sabbia", "Salmone", "Scarlatto", "Senape", "Seppia", "Solidago", "Tanno", "Tenné", "Tronco", "Turchese", "Turchese chiaro", "Turchese pallido", "Turchese scuro", "Verde", "Verde foresta", "Verde chiaro", "Verde-giallo", "Verde marino", "Verde menta", "Verde muschio", "Verde oliva", "Verde olivastro", "Verde pastello", "Verde pino", "Verde primavera", "Verde ufficio", "Verde smeraldo", "Verde Veronese", "Vermiglio", "Viola", "Viola chiaro", "Viola melanzana", "Violetto", "Vinaccia", "Zafferano", "Zaffiro"]),
        LanguageCode.DUTCH: make_language_data(["zwart", "wit", "rood", "geel", "blauw", "groen", "bruin", ["rose", "roze"], "oranje", "grijs", ["paars", "purper"], "lila", "turquoise", "khaki", "gebroken wit", ["okergeel", "oker"], "aubergine", "bordeauxrood"]),
        LanguageCode.FRENCH: make_language_data(["Abricot", "Acajou", "Aigue-marine", "Amande", "Amarante", "Ambre", "Améthyste", "Anthracite", "Argent", "Aubergine", "Auburn", "Aurore", "Avocat", "Azur", "Baillet", "Beurre", "Bis", "Bisque", "Bistre", "Bitume", "Blanc", "Blé", "Bleu", "Bleuet", "Bleu acier", "Bleu barbeau", "Bleu céleste", "Bleu ciel", "Bleu de cobalt", "Bleu électrique", "Bleu givré", "Bleu marine", "Bleu nuit", "Bleu pétrole", "Bleu turquin", "Blond vénitien", "Blond", "Brique", "Bronze", "Brou de noix", "Caca d'oie", "Cacao", "Cachou", "Cæruleum", "Café", "Cannelle", "Capucine", "Caramel", "Carmin", "Carotte", "Chamois", "Chartreuse", "Châtain", "Chaudron", "Chocolat", "Cinabre", "Citrouille", "Corail", "Cramoisi", "Cuisse de nymphe", "Cuivre", "Cyan", "Écarlate", "Écru", "Émeraude", "Fauve", "Flave", "Fraise", "Framboise", "Fuchsia", "Fumée", "Garance", "Glauque", "Glycine", "Grège", "Grenadine", "Grenat", "Gris", "Gris fer", "Gris perle", "Gris souris", "Groseille", "Gueules", "Incarnat", "Indigo", "Isabelle", "Jaune", "Jaune canari", "Jaune citron", "Jaune d'or", "Jaune mimosa", "Lapis-lazuli", "Lavande", "Lilas", "Lime", "Lin", "Magenta", "Mandarine", "Marron", "Mastic", "Mauve", "Menthe", "Moutarde", "Nacarat", "Nankin", "Noisette", "Noir", "Ocre jaune", "Ocre rouge", "Olive", "Or", "Orange", "Orchidée", "Orpiment", "Paille", "Parme", "Pelure d'oignon", "Pervenche", "Pistache", "Poil de chameau", "Ponceau ou Coquelicot", "Pourpre", "Prasin", "Prune", "Puce", "Rose", "Rouge", "Rouge d'Andrinople", "Rouge de Falun", "Rouge feu", "Rouille", "Roux", "Rubis", "Sable", "Safre", "Sanguine", "Saphir", "Sarcelle", "Saumon", "Sépia", "Smalt", "Soufre", "Tabac", "Taupe", "Terre d'ombre", "Tomate", "Topaze", "Tourterelle", "Turquoise", "Vanille", "Vermeil", "Vermillon", "Vert", "Vert bouteille", "Vert céladon", "Vert d'eau", "Vert de Hooker", "Vert olive", "Violet", "Viride", "Zinzolin"]),
        LanguageCode.GERMAN: make_language_data(["Rot", "Gelb", "Grün", "Blau", "Braun", "Mittelrot", "Zinnoberrot", "Rotorange", "Ocker", "Gelborange", "Indischgelb", "Umbra", "Goldgelb", "Cadmiumgelb", "Mittelgelb", "Zitronengelb", "Sepia", "Maigrün", "Gelbgrün", "Grasgrün", "Olivgrün", "Blattgrün", "Mittelgrün", "Blaugrün", "Smaragdgrün", "Phthalogrün", "Seegrün", "Türkis", "Türkisblau", "Cyanblau", "Coelinblau", "Bremerblau", "Indigo", "Preußischblau", "Mittelblau", "Pariserblau", "Ultramarinblau", "Paynesgrau", "Kobaltblau", "Violettblau", "Blauviolett", "Violett", "Purpurviolett", "Purpurrot", "Krapplack", "Karminrot", "Venezianischrot", "Scharlachrot"]),
        LanguageCode.SPANISH: make_language_data(["Negro", "Blanco", "Amarillo", "Azul", "Rojo", "Verde", "Naranja", "Violeta/Morado", "Púrpura", "Rosa", "Gris", "Marrón", "Plateado/Plata", "Dorado/Oro", "Limón", "Lima", "Mostaza", "Lavanda", "Lila", "Salmón", "Fucsia", "Magenta", "Escarlata", "Borgoña", "Marfil", "Champaña", "Beige", "Ocre", "Cobre", "Ámbar", "Aguamarina", "Turquesa", "Cian", "Azul Claro", "Azul de Prusia", "Azul Marino", "Jade", "Verde Oliva"]),
        LanguageCode.CHINESE: make_language_data(["黑色", "灰色", "銀色", "白煙色", "白色", "雪色", "鐵灰色", "沙棕", "印度紅", "褐色", "磚紅色", "栗色", "紅色", "柿子橙", "鮭紅", "腥紅", "蕃茄紅", "珊瑚紅", "橙紅", "朱紅", "赭黃", "駝色", "杏黃", "海貝色", "鞍褐", "巧克力色", "粉撲桃色", "沙褐", "銅色", "亞麻色", "烏賊墨色", "赭色", "陶坯黃", "橘色", "古董白", "日曬色", "硬木色", "杏仁白", "那瓦霍白", "萬壽菊黃", "灰土色", "卡其色", "鹿皮鞋色", "舊蕾絲色", "小麥色", "桃色", "橙色", "金菊色", "咖啡色", "茉莉黃", "琥珀色", "鉻黃", "金色", "灰金菊色", "含羞草黃", "奶油色", "象牙色", "米色", "香檳黃", "芥末黃", "月黃", "橄欖色", "鮮黃", "黃色", "苔蘚綠", "亮檸檬绿", "橄欖軍服綠", "黃綠", "暗橄欖綠", "蘋果綠", "綠黃", "草綠", "草坪綠", "葉綠", "嫩綠", "明綠", "鈷綠", "蜜瓜綠", "暗海綠", "亮綠", "灰綠", "常春藤綠", "森林綠", "檸檬綠", "暗綠", "綠色", "鮮绿色", "薄荷綠", "青瓷綠", "綠松石綠", "鉻綠", "海綠", "中海綠", "薄荷奶油色", "孔雀綠", "碧藍色", "青藍", "水藍", "土耳其藍", "綠松石色", "中綠松石色", "亮青", "淺藍", "鳧綠", "青色", "水色", "孔雀藍", "薩克斯藍", "深天藍", "水手藍", "道奇藍", "礦藍", "湛藍", "韋奇伍德瓷藍", "鈷藍", "灰丁寧藍", "鼠尾草藍", "藍寶石色", "蔚藍", "暗礦藍", "極濃海藍", "天青石藍", "薰衣草紫", "長春花色", "長春花色", "午夜藍", "藏青", "藍色", "淺灰紫紅", "靛色", "鋼青色", "碧綠", "紫色", "岩藍", "紫羅蘭色", "岩灰", "藍紫", "梅紅色", "天空藍", "淺天藍", "勃艮第酒紅", "宗主教", "紫水晶色", "薰衣草紫", "三色堇紫", "錦葵紫", "優品紫紅", "淡紫丁香色", "礦紫", "紫藤色", "紫丁香色", "纈草紫", "木槿紫", "薊紫", "鐵線蓮紫", "洋紅", "品紅", "蘭紫", "淺珍珠紅", "陳玫紅", "淺玫瑰紅", "洋玫瑰紅", "玫瑰紅", "紅寶石色", "山茶紅", "火鶴紅", "淺珊瑚紅", "尖晶石紅", "胭脂紅", "淺粉紅", "樞機紅", "薰衣草紫紅", "櫻桃紅", "淺鮭紅", "緋紅", "粉紅", "殼黃紅"]),
    }
