"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestDistro = void 0;
const core_1 = require("@aws-solutions-constructs/core");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
function CreateTestDistro(stack, id) {
    const newDistro = new cloudfront.Distribution(stack, id, {
        defaultBehavior: {
            origin: new origins.OriginGroup({
                primaryOrigin: new origins.HttpOrigin("www.example.com"),
                fallbackOrigin: new origins.HttpOrigin("admin.example.com"),
                // optional, defaults to: 500, 502, 503 and 504
                fallbackStatusCodes: [404],
            }),
        },
    });
    (0, core_1.addCfnSuppressRules)(newDistro, [{ id: "W10", reason: "Test Resource" }]);
    (0, core_1.addCfnSuppressRules)(newDistro, [{ id: "W70", reason: "Test Resource" }]);
    return newDistro;
}
exports.CreateTestDistro = CreateTestDistro;
//# sourceMappingURL=data:application/json;base64,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