"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const test_helper_1 = require("./test-helper");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
const newDistroOne = (0, test_helper_1.CreateTestDistro)(stack, "distroOne");
const newDistroTwo = (0, test_helper_1.CreateTestDistro)(stack, "distroTwo");
const ownsWaf = new lib_1.WafwebaclToCloudFront(stack, 'first-construct', {
    existingCloudFrontWebDistribution: newDistroOne,
});
new lib_1.WafwebaclToCloudFront(stack, 'second-construct', {
    existingCloudFrontWebDistribution: newDistroTwo,
    existingWebaclObj: ownsWaf.webacl
});
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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