"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToCloudFront = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The WafwebaclToCloudFront class.
 */
class WafwebaclToCloudFront extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToCloudFront class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToCloudFrontProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckWafWebAclProps(props);
        // All our tests are based upon this behavior being on, so we're setting
        // context here rather than assuming the client will set it
        this.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'CLOUDFRONT', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        // Property override of CloudFront Cfn Template
        const cfnExistingCloudFrontWebDistribution = props.existingCloudFrontWebDistribution.node.defaultChild;
        cfnExistingCloudFrontWebDistribution.addPropertyOverride('DistributionConfig.WebACLId', this.webacl.attrArn);
        this.cloudFrontWebDistribution = props.existingCloudFrontWebDistribution;
    }
}
exports.WafwebaclToCloudFront = WafwebaclToCloudFront;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToCloudFront[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-cloudfront.WafwebaclToCloudFront", version: "2.76.0" };
//# sourceMappingURL=data:application/json;base64,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