/**
 * Fields of CloudWatch Events that change references.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 * @stability stable
 */
export declare class ReferenceEvent {
    /**
     * The type of reference event.
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     *
     * @stability stable
     */
    static get eventType(): string;
    /**
     * Name of the CodeCommit repository.
     *
     * @stability stable
     */
    static get repositoryName(): string;
    /**
     * Id of the CodeCommit repository.
     *
     * @stability stable
     */
    static get repositoryId(): string;
    /**
     * Type of reference changed.
     *
     * 'branch' or 'tag'
     *
     * @stability stable
     */
    static get referenceType(): string;
    /**
     * Name of reference changed (branch or tag name).
     *
     * @stability stable
     */
    static get referenceName(): string;
    /**
     * Full reference name.
     *
     * For example, 'refs/tags/myTag'
     *
     * @stability stable
     */
    static get referenceFullName(): string;
    /**
     * Commit id this reference now points to.
     *
     * @stability stable
     */
    static get commitId(): string;
    private constructor();
}
