"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateJsonPath = exports.transformAttributeValueMap = exports.getDynamoResourceArn = exports.DynamoMethod = void 0;
const sfn = require("../../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const task_utils_1 = require("../../private/task-utils");
var DynamoMethod;
(function (DynamoMethod) {
    DynamoMethod["GET"] = "Get";
    DynamoMethod["PUT"] = "Put";
    DynamoMethod["DELETE"] = "Delete";
    DynamoMethod["UPDATE"] = "Update";
})(DynamoMethod = exports.DynamoMethod || (exports.DynamoMethod = {}));
function getDynamoResourceArn(method) {
    return task_utils_1.integrationResourceArn('dynamodb', `${method.toLowerCase()}Item`, sfn.IntegrationPattern.REQUEST_RESPONSE);
}
exports.getDynamoResourceArn = getDynamoResourceArn;
function transformAttributeValueMap(attrMap) {
    const transformedValue = {};
    for (const key in attrMap) {
        if (key) {
            transformedValue[key] = attrMap[key].toObject();
        }
    }
    return attrMap ? transformedValue : undefined;
}
exports.transformAttributeValueMap = transformAttributeValueMap;
function validateJsonPath(value) {
    if (!value.startsWith('$')) {
        throw new Error("Data JSON path values must either be exactly equal to '$' or start with '$.'");
    }
}
exports.validateJsonPath = validateJsonPath;
//# sourceMappingURL=data:application/json;base64,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