"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServer = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-07-31T23:11:32.054Z","fingerprint":"m9EXm1KDcECvxLpRuBRA8mj17JZdfUn7mChm9NOzmdY="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnServerProps`
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the result of the validation.
 */
function CfnServerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('associatePublicIpAddress', cdk.validateBoolean)(properties.associatePublicIpAddress));
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('backupRetentionCount', cdk.validateNumber)(properties.backupRetentionCount));
    errors.collect(cdk.propertyValidator('customCertificate', cdk.validateString)(properties.customCertificate));
    errors.collect(cdk.propertyValidator('customDomain', cdk.validateString)(properties.customDomain));
    errors.collect(cdk.propertyValidator('customPrivateKey', cdk.validateString)(properties.customPrivateKey));
    errors.collect(cdk.propertyValidator('disableAutomatedBackup', cdk.validateBoolean)(properties.disableAutomatedBackup));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineAttributes', cdk.listValidator(CfnServer_EngineAttributePropertyValidator))(properties.engineAttributes));
    errors.collect(cdk.propertyValidator('engineModel', cdk.validateString)(properties.engineModel));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.requiredValidator)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.validateString)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('keyPair', cdk.validateString)(properties.keyPair));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.requiredValidator)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnServerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource.
 */
// @ts-ignore TS6133
function cfnServerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServerPropsValidator(properties).assertSuccess();
    return {
        InstanceProfileArn: cdk.stringToCloudFormation(properties.instanceProfileArn),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        AssociatePublicIpAddress: cdk.booleanToCloudFormation(properties.associatePublicIpAddress),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        BackupRetentionCount: cdk.numberToCloudFormation(properties.backupRetentionCount),
        CustomCertificate: cdk.stringToCloudFormation(properties.customCertificate),
        CustomDomain: cdk.stringToCloudFormation(properties.customDomain),
        CustomPrivateKey: cdk.stringToCloudFormation(properties.customPrivateKey),
        DisableAutomatedBackup: cdk.booleanToCloudFormation(properties.disableAutomatedBackup),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineAttributes: cdk.listMapper(cfnServerEngineAttributePropertyToCloudFormation)(properties.engineAttributes),
        EngineModel: cdk.stringToCloudFormation(properties.engineModel),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        KeyPair: cdk.stringToCloudFormation(properties.keyPair),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnServerPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        instanceProfileArn: cfn_parse.FromCloudFormation.getString(properties.InstanceProfileArn),
        instanceType: cfn_parse.FromCloudFormation.getString(properties.InstanceType),
        serviceRoleArn: cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn),
        associatePublicIpAddress: properties.AssociatePublicIpAddress == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.AssociatePublicIpAddress),
        backupId: properties.BackupId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.BackupId),
        backupRetentionCount: properties.BackupRetentionCount == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionCount),
        customCertificate: properties.CustomCertificate == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CustomCertificate),
        customDomain: properties.CustomDomain == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CustomDomain),
        customPrivateKey: properties.CustomPrivateKey == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CustomPrivateKey),
        disableAutomatedBackup: properties.DisableAutomatedBackup == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.DisableAutomatedBackup),
        engine: properties.Engine == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Engine),
        engineAttributes: cfn_parse.FromCloudFormation.getArray(properties.EngineAttributes, (prop1) => CfnServerEngineAttributePropertyFromCloudFormation(prop1)),
        engineModel: properties.EngineModel == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EngineModel),
        engineVersion: properties.EngineVersion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.EngineVersion),
        keyPair: properties.KeyPair == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.KeyPair),
        preferredBackupWindow: properties.PreferredBackupWindow == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow),
        preferredMaintenanceWindow: properties.PreferredMaintenanceWindow == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow),
        securityGroupIds: cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds),
        serverName: properties.ServerName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ServerName),
        subnetIds: cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds),
        tags: cfn_parse.FromCloudFormation.getArray(properties.Tags, (prop1) => cfn_parse.FromCloudFormation.getCfnTag(prop1)),
    };
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`
 *
 * @cloudformationResource AWS::OpsWorksCM::Server
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 */
class CfnServer extends cdk.CfnResource {
    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServer.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'instanceProfileArn', this);
        cdk.requireProperty(props, 'instanceType', this);
        cdk.requireProperty(props, 'serviceRoleArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.instanceProfileArn = props.instanceProfileArn;
        this.instanceType = props.instanceType;
        this.serviceRoleArn = props.serviceRoleArn;
        this.associatePublicIpAddress = props.associatePublicIpAddress;
        this.backupId = props.backupId;
        this.backupRetentionCount = props.backupRetentionCount;
        this.customCertificate = props.customCertificate;
        this.customDomain = props.customDomain;
        this.customPrivateKey = props.customPrivateKey;
        this.disableAutomatedBackup = props.disableAutomatedBackup;
        this.engine = props.engine;
        this.engineAttributes = props.engineAttributes;
        this.engineModel = props.engineModel;
        this.engineVersion = props.engineVersion;
        this.keyPair = props.keyPair;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.securityGroupIds = props.securityGroupIds;
        this.serverName = props.serverName;
        this.subnetIds = props.subnetIds;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::OpsWorksCM::Server", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnServerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnServer(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnServer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            instanceProfileArn: this.instanceProfileArn,
            instanceType: this.instanceType,
            serviceRoleArn: this.serviceRoleArn,
            associatePublicIpAddress: this.associatePublicIpAddress,
            backupId: this.backupId,
            backupRetentionCount: this.backupRetentionCount,
            customCertificate: this.customCertificate,
            customDomain: this.customDomain,
            customPrivateKey: this.customPrivateKey,
            disableAutomatedBackup: this.disableAutomatedBackup,
            engine: this.engine,
            engineAttributes: this.engineAttributes,
            engineModel: this.engineModel,
            engineVersion: this.engineVersion,
            keyPair: this.keyPair,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            securityGroupIds: this.securityGroupIds,
            serverName: this.serverName,
            subnetIds: this.subnetIds,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnServerPropsToCloudFormation(props);
    }
}
exports.CfnServer = CfnServer;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnServer.CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorksCM::Server";
/**
 * Determine whether the given properties match those of a `EngineAttributeProperty`
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the result of the validation.
 */
function CfnServer_EngineAttributePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "EngineAttributeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource.
 */
// @ts-ignore TS6133
function cfnServerEngineAttributePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServer_EngineAttributePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnServerEngineAttributePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        name: properties.Name == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Name),
        value: properties.Value == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Value),
    };
}
//# sourceMappingURL=data:application/json;base64,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