"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployAction = void 0;
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
class ServiceCatalogDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        this.templatePath = props.templatePath.location;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployAction = ServiceCatalogDeployAction;
//# sourceMappingURL=data:application/json;base64,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