"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsAction = exports.JenkinsActionType = void 0;
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const action_1 = require("../action");
const jenkins_provider_1 = require("./jenkins-provider");
/**
 * The type of the Jenkins Action that determines its CodePipeline Category -
 * Build, or Test.
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 */
var JenkinsActionType;
(function (JenkinsActionType) {
    /**
     * The Action will have the Build Category.
     */
    JenkinsActionType[JenkinsActionType["BUILD"] = 0] = "BUILD";
    /**
     * The Action will have the Test Category.
     */
    JenkinsActionType[JenkinsActionType["TEST"] = 1] = "TEST";
})(JenkinsActionType = exports.JenkinsActionType || (exports.JenkinsActionType = {}));
/**
 * Jenkins build CodePipeline Action.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-four-stage-pipeline.html
 */
class JenkinsAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: props.type === JenkinsActionType.BUILD
                ? codepipeline.ActionCategory.BUILD
                : codepipeline.ActionCategory.TEST,
            provider: props.jenkinsProvider.providerName,
            owner: 'Custom',
            artifactBounds: jenkins_provider_1.jenkinsArtifactsBounds,
            version: props.jenkinsProvider.version,
        });
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        if (this.actionProperties.category === codepipeline.ActionCategory.BUILD) {
            this.props.jenkinsProvider._registerBuildProvider();
        }
        else {
            this.props.jenkinsProvider._registerTestProvider();
        }
        return {
            configuration: {
                ProjectName: this.props.projectName,
            },
        };
    }
}
exports.JenkinsAction = JenkinsAction;
//# sourceMappingURL=data:application/json;base64,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