"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(originId, props) {
        this.props = props;
        this.originId = originId;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.originId,
            allowedMethods: (_b = (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods) !== null && _b !== void 0 ? _b : undefined,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            viewerProtocolPolicy: distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
            lambdaFunctionAssociations: this.props.edgeLambdas
                ? this.props.edgeLambdas.map(edgeLambda => {
                    if (edgeLambda.functionVersion.version === '$LATEST') {
                        throw new Error('$LATEST function version cannot be used for Lambda@Edge');
                    }
                    return {
                        lambdaFunctionArn: edgeLambda.functionVersion.functionArn,
                        eventType: edgeLambda.eventType.toString(),
                    };
                })
                : undefined,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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