# AUTOGENERATED! DO NOT EDIT! File to edit: 07_Muse.ipynb (unless otherwise specified).

__all__ = ['get_recordings', 'get_eeg', 'get_eeg_timestamps', 'get_eeg_info', 'get_unique_timestamps', 'parse_channel',
           'eeg_to_df', 'get_ppg', 'parse_ppg', 'get_ppg_timestamp', 'ppg_to_df', 'get_xyz', 'get_motion_timetamp',
           'motion_to_df', 'get_telemetry', 'get_task', 'get_events', 'nback_info', 'sync_nback_task', 'get_events',
           'get_streams', 'eeg_to_mne']

# Cell
import matplotlib
import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
import time
import mne
import psycopg2

# Cell

def get_recordings():
    host = "35.195.94.118"    # Production database
    #host = "34.76.231.74"    # Devolpment database
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')
    #def get_ppg(eeg_id):
    sql = f"""
    select "metricId","type", "userId","createdAt" , "startTime","stopTime"
    from "Recording"
    ORDER by "createdAt" ASC
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()

    df_recordings = pd.DataFrame(data, columns=['metricId','type','userId','createdAt','startTime','stopTime'])
    return df_recordings


# For EEG Data
def get_eeg(metricId):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')
    #def get_ppg(eeg_id):
    sql = f"""
    SELECT "index","data","startTime","samplingRate"
    FROM "EEGSample"
    JOIN "EEGEpoch" on "EEGEpoch".id = "EEGSample"."epochId"
    Where "EEGEpoch"."metricId" = '{metricId}'
    Order by "startTime","index"
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()

    df = pd.DataFrame(data, columns=['index','data','startTime','samplingRate'])
    return df

def get_eeg_timestamps(ch):
    "Gets timestamps of all the samples and returns in ms"

    duration = int(len(ch.data.iloc[0])/ch.samplingRate.iloc[0]) #in seconds
    starts = pd.to_datetime(ch.startTime.astype('float'), unit='ms').values
    periods = np.array(ch.samplingRate.values, dtype=np.int)*duration
    ends = starts + np.timedelta64(duration, 's') -  np.timedelta64(3906250, 'ns')
    ranges =  np.array([pd.date_range(start=s, end=e, periods=p) for s,e,p in zip(starts, ends, periods)]).flatten()

    #starts_unix = ch.startTime.astype('float64')
    #ends_unix = starts_unix + 1000 -  3.90625
    #ranges_unix = np.array([pd.interval_range(start=s, end=e, periods=p) for s,e,p in zip(starts_unix, ends_unix, periods)]).flatten()

    return ranges#,ranges_unix

def get_eeg_info(ch):
    duration = int(len(ch.data.iloc[0])/ ch.samplingRate.iloc[0]) #in seconds
    print("Each buffer is", duration, "seconds long")

    startTimesDiff = 1e-9*np.diff(pd.to_datetime(ch.startTime.astype('float'), unit='ms').values, axis=0).astype(float)
    values,counts = np.unique(startTimesDiff,return_counts=True)
    interval = values[np.argmax(counts)]
    print ("Each buffer is sampled every", interval,"seconds")  # prints the most frequent element

    missed_samples = np.array(np.where((duration-startTimesDiff) < 0 )).flatten()
    print("The number of buffers skipped",len(missed_samples))

def get_unique_timestamps(ch):
    data = ch.data.explode().values
    timestamps = get_eeg_timestamps(ch)
    assert len(data) == len(timestamps)
    print("Number of timestamps: ",len(timestamps))
    data_time = np.stack((data,timestamps))
    df = pd.DataFrame(data=data_time.T,columns=['data','time'])

    #Drop duplicates with same data and time
    df_duplicatedatatime = df.drop_duplicates(subset=['data', 'time'], keep='first').sort_values(by=['time'])

    #Drop duplicates with same time, keep last entry
    #**There may have different data values for the same timestamp
    df_duplicatetime = df_duplicatedatatime.drop_duplicates(subset=['time'], keep='last').sort_values(by=['time'])

    unique_timestamps = np.array(df_duplicatetime.index)
    print("Number of unique timestamps: ",len(timestamps))


    erroneous_timestamps = len(df_duplicatedatatime)-len(df_duplicatetime)

    print("Some timestamps had different data values, this affected approximately",'%.2f' %(100*erroneous_timestamps/ len(df_duplicatedatatime)),"% of the data")



    #To do: Check if you have continous timestamps throughout
    #assert = not np.any(np.diff(timestamps[uniqueTimestamps], axis=0).astype(float)-3906250)


    return timestamps,unique_timestamps

def parse_channel(ch):
    data = ch.data.explode().values
    return pd.DataFrame(data=data)

def eeg_to_df(eeg):
    ch_names = ['TP9', 'AF7', 'AF8', 'TP10']
    channels = [eeg.loc[eeg['index'] == i] for i, ch in enumerate(ch_names)]
    assert len(channels[0]) == len(channels[1]) == len(channels[2]) == len(channels[3]), "all channels should have the same length"

    get_eeg_info(channels[0])
    timestamps,uniqueTimestamps = get_unique_timestamps(channels[0])
    df_cat = pd.concat([parse_channel(ch) for ch in channels], axis=1)
    df_cat.columns = ch_names
    df_cat['time'] = timestamps
    #pd_cat['time_unixepoch'] =pd_cat['time'].astype('int64') * 0.000001
    df_unique = df_cat.iloc[uniqueTimestamps]
    df_eeg = df_unique.set_index('time')
    return df_eeg


# For PPG Data
def get_ppg(metricId):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')
    sql = f"""
    SELECT channel,samples,index,timestamp
    from "PPG"
    where "metricId" = '{metricId}'
    ORDER BY timestamp,channel Asc
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()

    df = pd.DataFrame(data, columns=['channel','samples','index','timestamps'])
    return df

def parse_ppg(ch):
    data = ch.sort_values(by=['timestamps']).samples.explode().values
    return pd.DataFrame(data=data)

def get_ppg_timestamp(ch):
    starts = pd.to_datetime(ch.timestamps.astype('float'), unit='ms').values
    periods = np.repeat(len(ch.iloc[0].samples), len(ch), axis=None)
    ends = starts + np.timedelta64(78125, 'us')

    return np.array([pd.date_range(start=s, end=e, periods=p) for s,e,p in zip(starts, ends, periods)]).flatten()

def ppg_to_df(ppg):

    ppg_names = ['Ambient','Infrared','Red']
    channels = [ppg.loc[ppg['channel'] == i] for i, ch in enumerate(ppg_names)]
    assert len(channels[0]) == len(channels[1]) == len(channels[2]), "all channels should have the same length"
    timestamps = get_ppg_timestamp(channels[0])
    timestampsppg = get_ppg_timestamp(channels[0])
    #assert not np.count_nonzero(np.diff(timestampsppg)-15625000)
    df_cat = pd.concat([parse_ppg(ch) for ch in channels], axis=1)
    df_cat.columns = ppg_names
    df_cat['time'] = timestamps
    df_ppg = df_cat.set_index('time')
    return  df_ppg


# For Accelerometer and Gyroscope Data
def get_xyz(metricId,datatype):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')


    datatypeId = datatype.lower()+'Id'
    sql = f"""
    SELECT
    x,y,z,timestamp
    FROM "XYZ"
    LEFT JOIN "{datatype}" ON "{datatype}".id = "XYZ"."{datatypeId}"
    Where "XYZ"."{datatypeId}" IS NOT NULL AND "{datatype}"."metricId" = '{metricId}'
    ORDER BY timestamp,"XYZ".id ASC
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()

    df = pd.DataFrame(data, columns=['x','y','z','timestamp'])
    return df

def get_motion_timetamp(motion):
    starts = pd.to_datetime(motion['timestamp'].iloc[::3].astype('float'), unit='ms').values
    periods = np.repeat(3, len(starts), axis=None)
    ends = starts + np.timedelta64(38461538, 'ns')
    ranges_ = [pd.date_range(start=s, end=e, periods=p) for s,e,p in zip(starts, ends, periods)]
    return np.array([pd.date_range(start=s, end=e, periods=p) for s,e,p in zip(starts, ends, periods)]).flatten()

def motion_to_df(df_motion):
    timestamps = get_motion_timetamp(df_motion)
    df_motion['time'] = timestamps
    df_motion_sorted = df_motion.set_index('time')
    return df_motion_sorted

# For Telemetry

def get_telemetry(metricId):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')
    sql = f"""
    SELECT  "batteryLevel", "fuelGaugeVoltage", "temperature",timestamp
    FROM "Telemetry"
    WHERE "metricId" = '{metricId}'
    ORDER BY timestamp Asc
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()

    df = pd.DataFrame(data, columns=['batteryLevel','fuelGaugeVoltage','temperature','timestamp'])
    df['time']= pd.to_datetime(df.timestamp.astype('float'), unit='ms').values
    df_tele = df.set_index('time')
    return df_tele


# For tasks and events

def get_task(metricId):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')

    sql = f"""
    SELECT
    TRIAL.index,
    U.email,
    TASK.name, TASK.completed,  TRIAL.critical, TRIAL.stimulus, TRIAL.expected,
    RESP.result,RESP."presentedAt", RESP."respondedAt", RESP.response,
    TASK.comment

    FROM "User" as U
    JOIN "Task" as TASK on TASK."userId" = U.id
    JOIN "Trial" as TRIAL on TRIAL."taskId" = Task.id
    JOIN "TrialResponse" as RESP on RESP."trialId" = TRIAL.id
    WHERE TASK."metricId"='{metricId}'
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()
    return pd.DataFrame(data, columns=['trial_index','email','name','completed','critical', 'stimulus', 'expected',
                                       'result', 'presented_at', 'responded_at', 'response','comment'
                                      ])

def get_events(eeg_id):
    host="35.195.94.118"    # Prod
    #host="34.76.231.74"    # Dev
    conn = psycopg2.connect(user='prisma',
                          password='cognition365*',
                          host=host ,
                          port='5432',
                          database='mydb')
    sql = f"""
        SELECT
        U.id as "user_id", U.email,
        EEG.id as "eeg_id",
        EVENT.id as "event_id", EVENT.timestamp, EVENT.value

    FROM "User" as U
    JOIN "EEG" as EEG on EEG."userId" = U.id
    JOIN "EEGEvent" as EVENT on EVENT."eegId" = EEG.id
    WHERE EVENT."eegId"='{eeg_id}'
    ORDER BY timestamp, event_id
    """
    cursor = conn.cursor()
    cursor.execute(sql)
    data = cursor.fetchall()
    return pd.DataFrame(data, columns=['user_id', 'email', 'eeg_id', 'event_id', 'timestamp', 'value'])



def nback_info(task):
    task_name,task_level,task_trials = task.head(1)['name'][0].split("-")
    print("Task:", task_name,"\nLevel:", task_level,"\nTrials:", task_trials)
    Behave_result = (sum(task['result'])/len(task['result']))*100
    print("Behavioral Accuracy: " , Behave_result,"%")
    response = task['responded_at'].astype('int64')-task['presented_at'].astype('int64')
    responseMean,responseStd = np.mean(response),np.std(response)
    print("Response time: ", responseMean,"+/-",responseStd, "ms")


def sync_nback_task(data, task, event_dir):
    presented_at = pd.to_datetime(task.presented_at.astype('int64'), unit='ms').values
    responded_at = pd.to_datetime(task.responded_at.astype('int64'), unit='ms').values

    p_events = [[data.index.get_loc(t, method='nearest'), 0, event_dir['presented_at']] for t in presented_at]
    r_events = [[data.index.get_loc(t, method='nearest'), event_dir['presented_at'], event_dir['responded_at']] for t in responded_at]

    events = np.concatenate([p_events, r_events])
    events_df = pd.DataFrame(events, columns=['time_index','prior_event', 'event']).set_index('time_index')

    return events_df.sort_index()

def get_events(df_task,df_datastream):
    event_dir={'presented_at': 1, 'responded_at': 2}
    events = sync_nback_task(df_datastream,df_task,event_dir)
    events_df = np.concatenate((np.expand_dims(events.index.to_numpy(),axis=1),events.to_numpy()),axis=1)
    return events_df

def get_streams(metricId):

    #EEG
    eeg = get_eeg(metricId)
    df_eeg = eeg_to_df(eeg)

    #PPG
    ppg = get_ppg(metricId)
    df_ppg = ppg_to_df(ppg)

    #Accelerometer
    accel = get_xyz(metricId,'Accelerometer')
    df_accel = motion_to_df(accel)


    #EEG
    gyro = get_xyz(metricId,'Gyroscope')
    df_gyro = motion_to_df(gyro)

    return df_eeg,df_ppg,df_accel,df_gyro




# Cell
def eeg_to_mne(metricId,fmin=1,fmax=40):
    eeg = get_eeg(metricId)
    df_eeg = eeg_to_df(eeg)
    df_task = get_task(metricId)
    events_eeg = []
    if len(df_task) > 0 :
        events_eeg = get_events(df_task,df_eeg)
    sfreq = 256
    ch_names = ['TP9', 'AF7', 'AF8', 'TP10']

    #Create MNE Object
    info = mne.create_info(ch_names=ch_names, sfreq=sfreq, ch_types='eeg')
    raw = mne.io.RawArray(df_eeg[ch_names].T, info)
    montage = mne.channels.make_standard_montage('standard_1005')
    raw.set_montage(montage,match_case=False)


    #Plotting
    #print("Raw EEG data")
    #scalings = dict(eeg=400)
    #raw.plot(scalings = scalings)
    #raw.plot_psd()

    #Rereference
    #raw.set_eeg_reference()
    #raw.plot(scalings = scalings)

    #Filtering
    fmin,fmax = fmin, fmax
    raw_filter = raw.copy().filter(fmin, fmax, n_jobs=1, method='iir',verbose=False)
    raw_filter.notch_filter(np.arange(50, 101, 50), n_jobs=1, fir_design='firwin',verbose=False)
    #print("EEG data after basic filtering")
    #raw_filter.plot(scalings = scalings)
    return raw_filter,events_eeg,df_eeg
    #Plot sensor locations
    #raw.plot_sensors(show_names=True)
