# -----------------------------------------------------------------------------
#  pytermor [ANSI formatted terminal output toolset]
#  (c) 2022. A. Shavykin <0.delameter@gmail.com>
# -----------------------------------------------------------------------------
# AUTOGENERATED MODULE
# 2023-01-07T00:08:42.481249
"""
Color preset list.
"""
from .color import Color16, Color256, ColorRGB
from .ansi import IntCode


class CVAL:
    """

    """
    # fmt: off
    BLACK       = Color16(0x000000, IntCode.BLACK,       IntCode.BG_BLACK,       "black",        register=True, index=True)
    RED         = Color16(0x800000, IntCode.RED,         IntCode.BG_RED,         "red",          register=True, index=True)
    GREEN       = Color16(0x008000, IntCode.GREEN,       IntCode.BG_GREEN,       "green",        register=True, index=True)
    YELLOW      = Color16(0x808000, IntCode.YELLOW,      IntCode.BG_YELLOW,      "yellow",       register=True, index=True)
    BLUE        = Color16(0x000080, IntCode.BLUE,        IntCode.BG_BLUE,        "blue",         register=True, index=True)
    MAGENTA     = Color16(0x800080, IntCode.MAGENTA,     IntCode.BG_MAGENTA,     "magenta",      register=True, index=True)
    CYAN        = Color16(0x008080, IntCode.CYAN,        IntCode.BG_CYAN,        "cyan",         register=True, index=True)
    WHITE       = Color16(0xc0c0c0, IntCode.WHITE,       IntCode.BG_WHITE,       "white",        register=True, index=True)
    GRAY        = Color16(0x808080, IntCode.GRAY,        IntCode.BG_GRAY,        "gray",         register=True, index=True)
    HI_RED      = Color16(0xff0000, IntCode.HI_RED,      IntCode.BG_HI_RED,      "hi-red",       register=True, index=True, aliases=['bright-red'])
    HI_GREEN    = Color16(0x00ff00, IntCode.HI_GREEN,    IntCode.BG_HI_GREEN,    "hi-green",     register=True, index=True, aliases=['bright-green'])
    HI_YELLOW   = Color16(0xffff00, IntCode.HI_YELLOW,   IntCode.BG_HI_YELLOW,   "hi-yellow",    register=True, index=True, aliases=['bright-yellow'])
    HI_BLUE     = Color16(0x0000ff, IntCode.HI_BLUE,     IntCode.BG_HI_BLUE,     "hi-blue",      register=True, index=True, aliases=['bright-blue'])
    HI_MAGENTA  = Color16(0xff00ff, IntCode.HI_MAGENTA,  IntCode.BG_HI_MAGENTA,  "hi-magenta",   register=True, index=True, aliases=['bright-magenta'])
    HI_CYAN     = Color16(0x00ffff, IntCode.HI_CYAN,     IntCode.BG_HI_CYAN,     "hi-cyan",      register=True, index=True, aliases=['bright-cyan'])
    HI_WHITE    = Color16(0xffffff, IntCode.HI_WHITE,    IntCode.BG_HI_WHITE,    "hi-white",     register=True, index=True, aliases=['bright-white'])

    __256A_16_BLACK      = Color256(0x000000, 0,   "black",                 register=True, index=True, aliases=['color0', 'colour0'], color16_equiv=BLACK)
    __256A_16_RED        = Color256(0x800000, 1,   "maroon",                register=True, index=True, aliases=['color1', 'colour1'], color16_equiv=RED)
    __256A_16_GREEN      = Color256(0x008000, 2,   "green",                 register=True, index=True, aliases=['color2', 'colour2'], color16_equiv=GREEN)
    __256A_16_YELLOW     = Color256(0x808000, 3,   "olive",                 register=True, index=True, aliases=['color3', 'colour3'], color16_equiv=YELLOW)
    __256A_16_BLUE       = Color256(0x000080, 4,   "navy",                  register=True, index=True, aliases=['color4', 'colour4'], color16_equiv=BLUE)
    __256A_16_MAGENTA    = Color256(0x800080, 5,   "purple-5",              register=True, index=True, aliases=['color5', 'colour5'], color16_equiv=MAGENTA)
    __256A_16_CYAN       = Color256(0x008080, 6,   "teal",                  register=True, index=True, aliases=['color6', 'colour6'], color16_equiv=CYAN)
    __256A_16_WHITE      = Color256(0xc0c0c0, 7,   "silver",                register=True, index=True, aliases=['color7', 'colour7'], color16_equiv=WHITE)
    __256A_16_GRAY       = Color256(0x808080, 8,   "gray",                  register=True, index=True, aliases=['color8', 'colour8'], color16_equiv=GRAY)
    __256A_16_HI_RED     = Color256(0xff0000, 9,   "red",                   register=True, index=True, aliases=['color9', 'colour9'], color16_equiv=HI_RED)
    __256A_16_HI_GREEN   = Color256(0x00ff00, 10,  "lime",                  register=True, index=True, aliases=['color10', 'colour10'], color16_equiv=HI_GREEN)
    __256A_16_HI_YELLOW  = Color256(0xffff00, 11,  "yellow",                register=True, index=True, aliases=['color11', 'colour11'], color16_equiv=HI_YELLOW)
    __256A_16_HI_BLUE    = Color256(0x0000ff, 12,  "blue",                  register=True, index=True, aliases=['color12', 'colour12'], color16_equiv=HI_BLUE)
    __256A_16_HI_MAGENTA = Color256(0xff00ff, 13,  "fuchsia",               register=True, index=True, aliases=['color13', 'colour13'], color16_equiv=HI_MAGENTA)
    __256A_16_HI_CYAN    = Color256(0x00ffff, 14,  "aqua",                  register=True, index=True, aliases=['color14', 'colour14'], color16_equiv=HI_CYAN)
    __256A_16_HI_WHITE   = Color256(0xffffff, 15,  "white",                 register=True, index=True, aliases=['color15', 'colour15'], color16_equiv=HI_WHITE)
    AQUAMARINE_1         = Color256(0x87ffd7, 122, "aquamarine-1",          register=True, index=True, aliases=['color122', 'colour122'])
    AQUAMARINE_2         = Color256(0x5fffd7, 86,  "aquamarine-2",          register=True, index=True, aliases=['color86', 'colour86'])
    AQUAMARINE_3         = Color256(0x5fd7af, 79,  "aquamarine-3",          register=True, index=True, aliases=['color79', 'colour79'])
    BLUE_1               = Color256(0x0000ff, 21,  "blue-1",                register=True, index=True, aliases=['color21', 'colour21'])
    BLUE_2               = Color256(0x0000d7, 20,  "blue-2",                register=True, index=True, aliases=['color20', 'colour20'])
    BLUE_3               = Color256(0x0000af, 19,  "blue-3",                register=True, index=True, aliases=['color19', 'colour19'])
    BLUE_VIOLET          = Color256(0x5f00ff, 57,  "blue-violet",           register=True, index=True, aliases=['color57', 'colour57'])
    CADET_BLUE           = Color256(0x5fafaf, 73,  "cadet-blue",            register=True, index=True, aliases=['color73', 'colour73'])
    CADET_BLUE_2         = Color256(0x5faf87, 72,  "cadet-blue-2",          register=True, index=True, aliases=['color72', 'colour72'])
    CHARTREUSE_1         = Color256(0x87ff00, 118, "chartreuse-1",          register=True, index=True, aliases=['color118', 'colour118'])
    CHARTREUSE_2         = Color256(0x5fff00, 82,  "chartreuse-2",          register=True, index=True, aliases=['color82', 'colour82'])
    CHARTREUSE_3         = Color256(0x87d700, 112, "chartreuse-3",          register=True, index=True, aliases=['color112', 'colour112'])
    CHARTREUSE_4         = Color256(0x5fd700, 76,  "chartreuse-4",          register=True, index=True, aliases=['color76', 'colour76'])
    CHARTREUSE_5         = Color256(0x5faf00, 70,  "chartreuse-5",          register=True, index=True, aliases=['color70', 'colour70'])
    CHARTREUSE_6         = Color256(0x5f8700, 64,  "chartreuse-6",          register=True, index=True, aliases=['color64', 'colour64'])
    CORNFLOWER_BLUE      = Color256(0x5f87ff, 69,  "cornflower-blue",       register=True, index=True, aliases=['color69', 'colour69'])
    CORNSILK_1           = Color256(0xffffd7, 230, "cornsilk-1",            register=True, index=True, aliases=['color230', 'colour230'])
    CYAN_1               = Color256(0x00ffff, 51,  "cyan-1",                register=True, index=True, aliases=['color51', 'colour51'])
    CYAN_2               = Color256(0x00ffd7, 50,  "cyan-2",                register=True, index=True, aliases=['color50', 'colour50'])
    CYAN_3               = Color256(0x00d7af, 43,  "cyan-3",                register=True, index=True, aliases=['color43', 'colour43'])
    DARK_BLUE            = Color256(0x000087, 18,  "dark-blue",             register=True, index=True, aliases=['color18', 'colour18'])
    DARK_CYAN            = Color256(0x00af87, 36,  "dark-cyan",             register=True, index=True, aliases=['color36', 'colour36'])
    DARK_GOLDENROD       = Color256(0xaf8700, 136, "dark-goldenrod",        register=True, index=True, aliases=['color136', 'colour136'])
    DARK_GREEN           = Color256(0x005f00, 22,  "dark-green",            register=True, index=True, aliases=['color22', 'colour22'])
    DARK_KHAKI           = Color256(0xafaf5f, 143, "dark-khaki",            register=True, index=True, aliases=['color143', 'colour143'])
    DARK_MAGENTA         = Color256(0x8700af, 91,  "dark-magenta",          register=True, index=True, aliases=['color91', 'colour91'])
    DARK_MAGENTA_2       = Color256(0x870087, 90,  "dark-magenta-2",        register=True, index=True, aliases=['color90', 'colour90'])
    DARK_OLIVE_GREEN_1   = Color256(0xd7ff87, 192, "dark-olive-green-1",    register=True, index=True, aliases=['color192', 'colour192'])
    DARK_OLIVE_GREEN_2   = Color256(0xd7ff5f, 191, "dark-olive-green-2",    register=True, index=True, aliases=['color191', 'colour191'])
    DARK_OLIVE_GREEN_3   = Color256(0xafff5f, 155, "dark-olive-green-3",    register=True, index=True, aliases=['color155', 'colour155'])
    DARK_OLIVE_GREEN_4   = Color256(0x87d75f, 113, "dark-olive-green-4",    register=True, index=True, aliases=['color113', 'colour113'])
    DARK_OLIVE_GREEN_5   = Color256(0xafd75f, 149, "dark-olive-green-5",    register=True, index=True, aliases=['color149', 'colour149'])
    DARK_OLIVE_GREEN_6   = Color256(0x87af5f, 107, "dark-olive-green-6",    register=True, index=True, aliases=['color107', 'colour107'])
    DARK_ORANGE          = Color256(0xff8700, 208, "dark-orange",           register=True, index=True, aliases=['color208', 'colour208'])
    DARK_ORANGE_2        = Color256(0xd75f00, 166, "dark-orange-2",         register=True, index=True, aliases=['color166', 'colour166'])
    DARK_ORANGE_3        = Color256(0xaf5f00, 130, "dark-orange-3",         register=True, index=True, aliases=['color130', 'colour130'])
    DARK_RED             = Color256(0x870000, 88,  "dark-red",              register=True, index=True, aliases=['color88', 'colour88'])
    DARK_RED_2           = Color256(0x5f0000, 52,  "dark-red-2",            register=True, index=True, aliases=['color52', 'colour52'])
    DARK_SEA_GREEN_1     = Color256(0xafffd7, 158, "dark-sea-green-1",      register=True, index=True, aliases=['color158', 'colour158'])
    DARK_SEA_GREEN_2     = Color256(0xd7ffaf, 193, "dark-sea-green-2",      register=True, index=True, aliases=['color193', 'colour193'])
    DARK_SEA_GREEN_3     = Color256(0xafffaf, 157, "dark-sea-green-3",      register=True, index=True, aliases=['color157', 'colour157'])
    DARK_SEA_GREEN_4     = Color256(0xafd7af, 151, "dark-sea-green-4",      register=True, index=True, aliases=['color151', 'colour151'])
    DARK_SEA_GREEN_5     = Color256(0x87d7af, 115, "dark-sea-green-5",      register=True, index=True, aliases=['color115', 'colour115'])
    DARK_SEA_GREEN_6     = Color256(0xafd787, 150, "dark-sea-green-6",      register=True, index=True, aliases=['color150', 'colour150'])
    DARK_SEA_GREEN_7     = Color256(0x87af87, 108, "dark-sea-green-7",      register=True, index=True, aliases=['color108', 'colour108'])
    DARK_SEA_GREEN_8     = Color256(0x5faf5f, 71,  "dark-sea-green-8",      register=True, index=True, aliases=['color71', 'colour71'])
    DARK_SEA_GREEN_9     = Color256(0x5f875f, 65,  "dark-sea-green-9",      register=True, index=True, aliases=['color65', 'colour65'])
    DARK_SLATE_GRAY_1    = Color256(0x87ffff, 123, "dark-slate-gray-1",     register=True, index=True, aliases=['color123', 'colour123'])
    DARK_SLATE_GRAY_2    = Color256(0x5fffff, 87,  "dark-slate-gray-2",     register=True, index=True, aliases=['color87', 'colour87'])
    DARK_SLATE_GRAY_3    = Color256(0x87d7d7, 116, "dark-slate-gray-3",     register=True, index=True, aliases=['color116', 'colour116'])
    DARK_TURQUOISE       = Color256(0x00d7d7, 44,  "dark-turquoise",        register=True, index=True, aliases=['color44', 'colour44'])
    DARK_VIOLET          = Color256(0xaf00d7, 128, "dark-violet",           register=True, index=True, aliases=['color128', 'colour128'])
    DARK_VIOLET_2        = Color256(0x8700d7, 92,  "dark-violet-2",         register=True, index=True, aliases=['color92', 'colour92'])
    DEEP_PINK_1          = Color256(0xff00af, 199, "deep-pink-1",           register=True, index=True, aliases=['color199', 'colour199'])
    DEEP_PINK_2          = Color256(0xff0087, 198, "deep-pink-2",           register=True, index=True, aliases=['color198', 'colour198'])
    DEEP_PINK_3          = Color256(0xd70087, 162, "deep-pink-3",           register=True, index=True, aliases=['color162', 'colour162'])
    DEEP_PINK_4          = Color256(0xff005f, 197, "deep-pink-4",           register=True, index=True, aliases=['color197', 'colour197'])
    DEEP_PINK_5          = Color256(0xd7005f, 161, "deep-pink-5",           register=True, index=True, aliases=['color161', 'colour161'])
    DEEP_PINK_6          = Color256(0xaf005f, 125, "deep-pink-6",           register=True, index=True, aliases=['color125', 'colour125'])
    DEEP_PINK_7          = Color256(0x87005f, 89,  "deep-pink-7",           register=True, index=True, aliases=['color89', 'colour89'])
    DEEP_PINK_8          = Color256(0x5f005f, 53,  "deep-pink-8",           register=True, index=True, aliases=['color53', 'colour53'])
    DEEP_SKY_BLUE_1      = Color256(0x00afff, 39,  "deep-sky-blue-1",       register=True, index=True, aliases=['color39', 'colour39'])
    DEEP_SKY_BLUE_2      = Color256(0x00afd7, 38,  "deep-sky-blue-2",       register=True, index=True, aliases=['color38', 'colour38'])
    DEEP_SKY_BLUE_3      = Color256(0x0087d7, 32,  "deep-sky-blue-3",       register=True, index=True, aliases=['color32', 'colour32'])
    DEEP_SKY_BLUE_4      = Color256(0x0087af, 31,  "deep-sky-blue-4",       register=True, index=True, aliases=['color31', 'colour31'])
    DEEP_SKY_BLUE_5      = Color256(0x005faf, 25,  "deep-sky-blue-5",       register=True, index=True, aliases=['color25', 'colour25'])
    DEEP_SKY_BLUE_6      = Color256(0x005f87, 24,  "deep-sky-blue-6",       register=True, index=True, aliases=['color24', 'colour24'])
    DEEP_SKY_BLUE_7      = Color256(0x005f5f, 23,  "deep-sky-blue-7",       register=True, index=True, aliases=['color23', 'colour23'])
    DODGER_BLUE_1        = Color256(0x0087ff, 33,  "dodger-blue-1",         register=True, index=True, aliases=['color33', 'colour33'])
    DODGER_BLUE_2        = Color256(0x005fff, 27,  "dodger-blue-2",         register=True, index=True, aliases=['color27', 'colour27'])
    DODGER_BLUE_3        = Color256(0x005fd7, 26,  "dodger-blue-3",         register=True, index=True, aliases=['color26', 'colour26'])
    GOLD_1               = Color256(0xffd700, 220, "gold-1",                register=True, index=True, aliases=['color220', 'colour220'])
    GOLD_2               = Color256(0xd7af00, 178, "gold-2",                register=True, index=True, aliases=['color178', 'colour178'])
    GOLD_3               = Color256(0xafaf00, 142, "gold-3",                register=True, index=True, aliases=['color142', 'colour142'])
    GRAY_0               = Color256(0x000000, 16,  "gray-0",                register=True, index=True, aliases=['color16', 'colour16'])
    GRAY_100             = Color256(0xffffff, 231, "gray-100",              register=True, index=True, aliases=['color231', 'colour231'])
    GRAY_11              = Color256(0x1c1c1c, 234, "gray-11",               register=True, index=True, aliases=['color234', 'colour234'])
    GRAY_15              = Color256(0x262626, 235, "gray-15",               register=True, index=True, aliases=['color235', 'colour235'])
    GRAY_19              = Color256(0x303030, 236, "gray-19",               register=True, index=True, aliases=['color236', 'colour236'])
    GRAY_23              = Color256(0x3a3a3a, 237, "gray-23",               register=True, index=True, aliases=['color237', 'colour237'])
    GRAY_27              = Color256(0x444444, 238, "gray-27",               register=True, index=True, aliases=['color238', 'colour238'])
    GRAY_3               = Color256(0x080808, 232, "gray-3",                register=True, index=True, aliases=['color232', 'colour232'])
    GRAY_30              = Color256(0x4e4e4e, 239, "gray-30",               register=True, index=True, aliases=['color239', 'colour239'])
    GRAY_35              = Color256(0x585858, 240, "gray-35",               register=True, index=True, aliases=['color240', 'colour240'])
    GRAY_37              = Color256(0x5f5f5f, 59,  "gray-37",               register=True, index=True, aliases=['color59', 'colour59'])
    GRAY_39              = Color256(0x626262, 241, "gray-39",               register=True, index=True, aliases=['color241', 'colour241'])
    GRAY_42              = Color256(0x6c6c6c, 242, "gray-42",               register=True, index=True, aliases=['color242', 'colour242'])
    GRAY_46              = Color256(0x767676, 243, "gray-46",               register=True, index=True, aliases=['color243', 'colour243'])
    GRAY_50              = Color256(0x808080, 244, "gray-50",               register=True, index=True, aliases=['color244', 'colour244'])
    GRAY_53              = Color256(0x878787, 102, "gray-53",               register=True, index=True, aliases=['color102', 'colour102'])
    GRAY_54              = Color256(0x8a8a8a, 245, "gray-54",               register=True, index=True, aliases=['color245', 'colour245'])
    GRAY_58              = Color256(0x949494, 246, "gray-58",               register=True, index=True, aliases=['color246', 'colour246'])
    GRAY_62              = Color256(0x9e9e9e, 247, "gray-62",               register=True, index=True, aliases=['color247', 'colour247'])
    GRAY_63              = Color256(0xaf87af, 139, "gray-63",               register=True, index=True, aliases=['color139', 'colour139'])
    GRAY_66              = Color256(0xa8a8a8, 248, "gray-66",               register=True, index=True, aliases=['color248', 'colour248'])
    GRAY_69              = Color256(0xafafaf, 145, "gray-69",               register=True, index=True, aliases=['color145', 'colour145'])
    GRAY_7               = Color256(0x121212, 233, "gray-7",                register=True, index=True, aliases=['color233', 'colour233'])
    GRAY_70              = Color256(0xb2b2b2, 249, "gray-70",               register=True, index=True, aliases=['color249', 'colour249'])
    GRAY_74              = Color256(0xbcbcbc, 250, "gray-74",               register=True, index=True, aliases=['color250', 'colour250'])
    GRAY_78              = Color256(0xc6c6c6, 251, "gray-78",               register=True, index=True, aliases=['color251', 'colour251'])
    GRAY_82              = Color256(0xd0d0d0, 252, "gray-82",               register=True, index=True, aliases=['color252', 'colour252'])
    GRAY_84              = Color256(0xd7d7d7, 188, "gray-84",               register=True, index=True, aliases=['color188', 'colour188'])
    GRAY_85              = Color256(0xdadada, 253, "gray-85",               register=True, index=True, aliases=['color253', 'colour253'])
    GRAY_89              = Color256(0xe4e4e4, 254, "gray-89",               register=True, index=True, aliases=['color254', 'colour254'])
    GRAY_93              = Color256(0xeeeeee, 255, "gray-93",               register=True, index=True, aliases=['color255', 'colour255'])
    GREEN_2              = Color256(0x00ff00, 46,  "green-2",               register=True, index=True, aliases=['color46', 'colour46'])
    GREEN_3              = Color256(0x00d700, 40,  "green-3",               register=True, index=True, aliases=['color40', 'colour40'])
    GREEN_4              = Color256(0x00af00, 34,  "green-4",               register=True, index=True, aliases=['color34', 'colour34'])
    GREEN_5              = Color256(0x008700, 28,  "green-5",               register=True, index=True, aliases=['color28', 'colour28'])
    GREEN_YELLOW         = Color256(0xafff00, 154, "green-yellow",          register=True, index=True, aliases=['color154', 'colour154'])
    HONEYDEW_2           = Color256(0xd7ffd7, 194, "honeydew-2",            register=True, index=True, aliases=['color194', 'colour194'])
    HOT_PINK             = Color256(0xff5fd7, 206, "hot-pink",              register=True, index=True, aliases=['color206', 'colour206'])
    HOT_PINK_2           = Color256(0xff5faf, 205, "hot-pink-2",            register=True, index=True, aliases=['color205', 'colour205'])
    HOT_PINK_3           = Color256(0xd75faf, 169, "hot-pink-3",            register=True, index=True, aliases=['color169', 'colour169'])
    HOT_PINK_4           = Color256(0xd75f87, 168, "hot-pink-4",            register=True, index=True, aliases=['color168', 'colour168'])
    HOT_PINK_5           = Color256(0xaf5f87, 132, "hot-pink-5",            register=True, index=True, aliases=['color132', 'colour132'])
    INDIAN_RED_1         = Color256(0xff5f5f, 203, "indian-red-1",          register=True, index=True, aliases=['color203', 'colour203'])
    INDIAN_RED_2         = Color256(0xff5f87, 204, "indian-red-2",          register=True, index=True, aliases=['color204', 'colour204'])
    INDIAN_RED_3         = Color256(0xd75f5f, 167, "indian-red-3",          register=True, index=True, aliases=['color167', 'colour167'])
    INDIAN_RED_4         = Color256(0xaf5f5f, 131, "indian-red-4",          register=True, index=True, aliases=['color131', 'colour131'])
    KHAKI_1              = Color256(0xffff87, 228, "khaki-1",               register=True, index=True, aliases=['color228', 'colour228'])
    KHAKI_3              = Color256(0xd7d75f, 185, "khaki-3",               register=True, index=True, aliases=['color185', 'colour185'])
    LIGHT_CORAL          = Color256(0xff8787, 210, "light-coral",           register=True, index=True, aliases=['color210', 'colour210'])
    LIGHT_CYAN_1         = Color256(0xd7ffff, 195, "light-cyan-1",          register=True, index=True, aliases=['color195', 'colour195'])
    LIGHT_CYAN_3         = Color256(0xafd7d7, 152, "light-cyan-3",          register=True, index=True, aliases=['color152', 'colour152'])
    LIGHT_GOLDENROD_1    = Color256(0xffff5f, 227, "light-goldenrod-1",     register=True, index=True, aliases=['color227', 'colour227'])
    LIGHT_GOLDENROD_2    = Color256(0xffd787, 222, "light-goldenrod-2",     register=True, index=True, aliases=['color222', 'colour222'])
    LIGHT_GOLDENROD_3    = Color256(0xd7d787, 186, "light-goldenrod-3",     register=True, index=True, aliases=['color186', 'colour186'])
    LIGHT_GOLDENROD_4    = Color256(0xffd75f, 221, "light-goldenrod-4",     register=True, index=True, aliases=['color221', 'colour221'])
    LIGHT_GOLDENROD_5    = Color256(0xd7af5f, 179, "light-goldenrod-5",     register=True, index=True, aliases=['color179', 'colour179'])
    LIGHT_GREEN          = Color256(0x87ff87, 120, "light-green",           register=True, index=True, aliases=['color120', 'colour120'])
    LIGHT_GREEN_2        = Color256(0x87ff5f, 119, "light-green-2",         register=True, index=True, aliases=['color119', 'colour119'])
    LIGHT_PINK_1         = Color256(0xffafaf, 217, "light-pink-1",          register=True, index=True, aliases=['color217', 'colour217'])
    LIGHT_PINK_2         = Color256(0xd78787, 174, "light-pink-2",          register=True, index=True, aliases=['color174', 'colour174'])
    LIGHT_PINK_3         = Color256(0x875f5f, 95,  "light-pink-3",          register=True, index=True, aliases=['color95', 'colour95'])
    LIGHT_SALMON_1       = Color256(0xffaf87, 216, "light-salmon-1",        register=True, index=True, aliases=['color216', 'colour216'])
    LIGHT_SALMON_2       = Color256(0xd7875f, 173, "light-salmon-2",        register=True, index=True, aliases=['color173', 'colour173'])
    LIGHT_SALMON_3       = Color256(0xaf875f, 137, "light-salmon-3",        register=True, index=True, aliases=['color137', 'colour137'])
    LIGHT_SEA_GREEN      = Color256(0x00afaf, 37,  "light-sea-green",       register=True, index=True, aliases=['color37', 'colour37'])
    LIGHT_SKY_BLUE_1     = Color256(0xafd7ff, 153, "light-sky-blue-1",      register=True, index=True, aliases=['color153', 'colour153'])
    LIGHT_SKY_BLUE_2     = Color256(0x87afd7, 110, "light-sky-blue-2",      register=True, index=True, aliases=['color110', 'colour110'])
    LIGHT_SKY_BLUE_3     = Color256(0x87afaf, 109, "light-sky-blue-3",      register=True, index=True, aliases=['color109', 'colour109'])
    LIGHT_SLATE_BLUE     = Color256(0x8787ff, 105, "light-slate-blue",      register=True, index=True, aliases=['color105', 'colour105'])
    LIGHT_SLATE_GRAY     = Color256(0x8787af, 103, "light-slate-gray",      register=True, index=True, aliases=['color103', 'colour103'])
    LIGHT_STEEL_BLUE_1   = Color256(0xd7d7ff, 189, "light-steel-blue-1",    register=True, index=True, aliases=['color189', 'colour189'])
    LIGHT_STEEL_BLUE_2   = Color256(0xafafff, 147, "light-steel-blue-2",    register=True, index=True, aliases=['color147', 'colour147'])
    LIGHT_STEEL_BLUE_3   = Color256(0xafafd7, 146, "light-steel-blue-3",    register=True, index=True, aliases=['color146', 'colour146'])
    LIGHT_YELLOW_3       = Color256(0xd7d7af, 187, "light-yellow-3",        register=True, index=True, aliases=['color187', 'colour187'])
    MAGENTA_1            = Color256(0xff00ff, 201, "magenta-1",             register=True, index=True, aliases=['color201', 'colour201'])
    MAGENTA_2            = Color256(0xff00d7, 200, "magenta-2",             register=True, index=True, aliases=['color200', 'colour200'])
    MAGENTA_3            = Color256(0xd700af, 163, "magenta-3",             register=True, index=True, aliases=['color163', 'colour163'])
    MAGENTA_4            = Color256(0xd700ff, 165, "magenta-4",             register=True, index=True, aliases=['color165', 'colour165'])
    MAGENTA_5            = Color256(0xd700d7, 164, "magenta-5",             register=True, index=True, aliases=['color164', 'colour164'])
    MAGENTA_6            = Color256(0xaf00af, 127, "magenta-6",             register=True, index=True, aliases=['color127', 'colour127'])
    MEDIUM_ORCHID_1      = Color256(0xff5fff, 207, "medium-orchid-1",       register=True, index=True, aliases=['color207', 'colour207'])
    MEDIUM_ORCHID_2      = Color256(0xd75fff, 171, "medium-orchid-2",       register=True, index=True, aliases=['color171', 'colour171'])
    MEDIUM_ORCHID_3      = Color256(0xaf5fd7, 134, "medium-orchid-3",       register=True, index=True, aliases=['color134', 'colour134'])
    MEDIUM_ORCHID_4      = Color256(0xaf5faf, 133, "medium-orchid-4",       register=True, index=True, aliases=['color133', 'colour133'])
    MEDIUM_PURPLE_1      = Color256(0xaf87ff, 141, "medium-purple-1",       register=True, index=True, aliases=['color141', 'colour141'])
    MEDIUM_PURPLE_2      = Color256(0xaf5fff, 135, "medium-purple-2",       register=True, index=True, aliases=['color135', 'colour135'])
    MEDIUM_PURPLE_3      = Color256(0xaf87d7, 140, "medium-purple-3",       register=True, index=True, aliases=['color140', 'colour140'])
    MEDIUM_PURPLE_4      = Color256(0x8787d7, 104, "medium-purple-4",       register=True, index=True, aliases=['color104', 'colour104'])
    MEDIUM_PURPLE_5      = Color256(0x875fd7, 98,  "medium-purple-5",       register=True, index=True, aliases=['color98', 'colour98'])
    MEDIUM_PURPLE_6      = Color256(0x875faf, 97,  "medium-purple-6",       register=True, index=True, aliases=['color97', 'colour97'])
    MEDIUM_PURPLE_7      = Color256(0x5f5f87, 60,  "medium-purple-7",       register=True, index=True, aliases=['color60', 'colour60'])
    MEDIUM_SPRING_GREEN  = Color256(0x00ffaf, 49,  "medium-spring-green",   register=True, index=True, aliases=['color49', 'colour49'])
    MEDIUM_TURQUOISE     = Color256(0x5fd7d7, 80,  "medium-turquoise",      register=True, index=True, aliases=['color80', 'colour80'])
    MEDIUM_VIOLET_RED    = Color256(0xaf0087, 126, "medium-violet-red",     register=True, index=True, aliases=['color126', 'colour126'])
    MISTY_ROSE_1         = Color256(0xffd7d7, 224, "misty-rose-1",          register=True, index=True, aliases=['color224', 'colour224'])
    MISTY_ROSE_3         = Color256(0xd7afaf, 181, "misty-rose-3",          register=True, index=True, aliases=['color181', 'colour181'])
    NAVAJO_WHITE_1       = Color256(0xffd7af, 223, "navajo-white-1",        register=True, index=True, aliases=['color223', 'colour223'])
    NAVAJO_WHITE_3       = Color256(0xafaf87, 144, "navajo-white-3",        register=True, index=True, aliases=['color144', 'colour144'])
    NAVY_BLUE            = Color256(0x00005f, 17,  "navy-blue",             register=True, index=True, aliases=['color17', 'colour17'])
    ORANGE_1             = Color256(0xffaf00, 214, "orange-1",              register=True, index=True, aliases=['color214', 'colour214'])
    ORANGE_2             = Color256(0xd78700, 172, "orange-2",              register=True, index=True, aliases=['color172', 'colour172'])
    ORANGE_3             = Color256(0x875f00, 94,  "orange-3",              register=True, index=True, aliases=['color94', 'colour94'])
    ORANGE_4             = Color256(0x5f5f00, 58,  "orange-4",              register=True, index=True, aliases=['color58', 'colour58'])
    ORANGE_RED_1         = Color256(0xff5f00, 202, "orange-red-1",          register=True, index=True, aliases=['color202', 'colour202'])
    ORCHID_1             = Color256(0xff87ff, 213, "orchid-1",              register=True, index=True, aliases=['color213', 'colour213'])
    ORCHID_2             = Color256(0xff87d7, 212, "orchid-2",              register=True, index=True, aliases=['color212', 'colour212'])
    ORCHID_3             = Color256(0xd75fd7, 170, "orchid-3",              register=True, index=True, aliases=['color170', 'colour170'])
    PALE_GREEN_1         = Color256(0x87ffaf, 121, "pale-green-1",          register=True, index=True, aliases=['color121', 'colour121'])
    PALE_GREEN_2         = Color256(0xafff87, 156, "pale-green-2",          register=True, index=True, aliases=['color156', 'colour156'])
    PALE_GREEN_3         = Color256(0x87d787, 114, "pale-green-3",          register=True, index=True, aliases=['color114', 'colour114'])
    PALE_GREEN_4         = Color256(0x5fd75f, 77,  "pale-green-4",          register=True, index=True, aliases=['color77', 'colour77'])
    PALE_TURQUOISE_1     = Color256(0xafffff, 159, "pale-turquoise-1",      register=True, index=True, aliases=['color159', 'colour159'])
    PALE_TURQUOISE_4     = Color256(0x5f8787, 66,  "pale-turquoise-4",      register=True, index=True, aliases=['color66', 'colour66'])
    PALE_VIOLET_RED_1    = Color256(0xff87af, 211, "pale-violet-red-1",     register=True, index=True, aliases=['color211', 'colour211'])
    PINK_1               = Color256(0xffafd7, 218, "pink-1",                register=True, index=True, aliases=['color218', 'colour218'])
    PINK_3               = Color256(0xd787af, 175, "pink-3",                register=True, index=True, aliases=['color175', 'colour175'])
    PLUM_1               = Color256(0xffafff, 219, "plum-1",                register=True, index=True, aliases=['color219', 'colour219'])
    PLUM_2               = Color256(0xd7afff, 183, "plum-2",                register=True, index=True, aliases=['color183', 'colour183'])
    PLUM_3               = Color256(0xd787d7, 176, "plum-3",                register=True, index=True, aliases=['color176', 'colour176'])
    PLUM_4               = Color256(0x875f87, 96,  "plum-4",                register=True, index=True, aliases=['color96', 'colour96'])
    PURPLE               = Color256(0xaf00ff, 129, "purple",                register=True, index=True, aliases=['color129', 'colour129'])
    PURPLE_2             = Color256(0x8700ff, 93,  "purple-2",              register=True, index=True, aliases=['color93', 'colour93'])
    PURPLE_3             = Color256(0x5f00d7, 56,  "purple-3",              register=True, index=True, aliases=['color56', 'colour56'])
    PURPLE_4             = Color256(0x5f00af, 55,  "purple-4",              register=True, index=True, aliases=['color55', 'colour55'])
    PURPLE_6             = Color256(0x5f0087, 54,  "purple-6",              register=True, index=True, aliases=['color54', 'colour54'])
    RED_1                = Color256(0xff0000, 196, "red-1",                 register=True, index=True, aliases=['color196', 'colour196'])
    RED_3                = Color256(0xd70000, 160, "red-3",                 register=True, index=True, aliases=['color160', 'colour160'])
    RED_4                = Color256(0xaf0000, 124, "red-4",                 register=True, index=True, aliases=['color124', 'colour124'])
    ROSY_BROWN           = Color256(0xaf8787, 138, "rosy-brown",            register=True, index=True, aliases=['color138', 'colour138'])
    ROYAL_BLUE_1         = Color256(0x5f5fff, 63,  "royal-blue-1",          register=True, index=True, aliases=['color63', 'colour63'])
    SALMON_1             = Color256(0xff875f, 209, "salmon-1",              register=True, index=True, aliases=['color209', 'colour209'])
    SANDY_BROWN          = Color256(0xffaf5f, 215, "sandy-brown",           register=True, index=True, aliases=['color215', 'colour215'])
    SEA_GREEN_1          = Color256(0x5fffaf, 85,  "sea-green-1",           register=True, index=True, aliases=['color85', 'colour85'])
    SEA_GREEN_2          = Color256(0x5fff87, 84,  "sea-green-2",           register=True, index=True, aliases=['color84', 'colour84'])
    SEA_GREEN_3          = Color256(0x5fd787, 78,  "sea-green-3",           register=True, index=True, aliases=['color78', 'colour78'])
    SEA_GREEN_4          = Color256(0x5fff5f, 83,  "sea-green-4",           register=True, index=True, aliases=['color83', 'colour83'])
    SKY_BLUE_1           = Color256(0x87d7ff, 117, "sky-blue-1",            register=True, index=True, aliases=['color117', 'colour117'])
    SKY_BLUE_2           = Color256(0x87afff, 111, "sky-blue-2",            register=True, index=True, aliases=['color111', 'colour111'])
    SKY_BLUE_3           = Color256(0x5fafd7, 74,  "sky-blue-3",            register=True, index=True, aliases=['color74', 'colour74'])
    SLATE_BLUE_1         = Color256(0x875fff, 99,  "slate-blue-1",          register=True, index=True, aliases=['color99', 'colour99'])
    SLATE_BLUE_2         = Color256(0x5f5fd7, 62,  "slate-blue-2",          register=True, index=True, aliases=['color62', 'colour62'])
    SLATE_BLUE_3         = Color256(0x5f5faf, 61,  "slate-blue-3",          register=True, index=True, aliases=['color61', 'colour61'])
    SPRING_GREEN_1       = Color256(0x00ff87, 48,  "spring-green-1",        register=True, index=True, aliases=['color48', 'colour48'])
    SPRING_GREEN_2       = Color256(0x00ff5f, 47,  "spring-green-2",        register=True, index=True, aliases=['color47', 'colour47'])
    SPRING_GREEN_3       = Color256(0x00d75f, 41,  "spring-green-3",        register=True, index=True, aliases=['color41', 'colour41'])
    SPRING_GREEN_4       = Color256(0x00875f, 29,  "spring-green-4",        register=True, index=True, aliases=['color29', 'colour29'])
    SPRING_GREEN_5       = Color256(0x00af5f, 35,  "spring-green-5",        register=True, index=True, aliases=['color35', 'colour35'])
    SPRING_GREEN_6       = Color256(0x00d787, 42,  "spring-green-6",        register=True, index=True, aliases=['color42', 'colour42'])
    STEEL_BLUE           = Color256(0x5f87af, 67,  "steel-blue",            register=True, index=True, aliases=['color67', 'colour67'])
    STEEL_BLUE_1         = Color256(0x5fd7ff, 81,  "steel-blue-1",          register=True, index=True, aliases=['color81', 'colour81'])
    STEEL_BLUE_2         = Color256(0x5fafff, 75,  "steel-blue-2",          register=True, index=True, aliases=['color75', 'colour75'])
    STEEL_BLUE_3         = Color256(0x5f87d7, 68,  "steel-blue-3",          register=True, index=True, aliases=['color68', 'colour68'])
    TAN                  = Color256(0xd7af87, 180, "tan",                   register=True, index=True, aliases=['color180', 'colour180'])
    THISTLE_1            = Color256(0xffd7ff, 225, "thistle-1",             register=True, index=True, aliases=['color225', 'colour225'])
    THISTLE_3            = Color256(0xd7afd7, 182, "thistle-3",             register=True, index=True, aliases=['color182', 'colour182'])
    TURQUOISE_2          = Color256(0x00d7ff, 45,  "turquoise-2",           register=True, index=True, aliases=['color45', 'colour45'])
    TURQUOISE_4          = Color256(0x008787, 30,  "turquoise-4",           register=True, index=True, aliases=['color30', 'colour30'])
    VIOLET               = Color256(0xd787ff, 177, "violet",                register=True, index=True, aliases=['color177', 'colour177'])
    WHEAT_1              = Color256(0xffffaf, 229, "wheat-1",               register=True, index=True, aliases=['color229', 'colour229'])
    WHEAT_4              = Color256(0x87875f, 101, "wheat-4",               register=True, index=True, aliases=['color101', 'colour101'])
    YELLOW_1             = Color256(0xffff00, 226, "yellow-1",              register=True, index=True, aliases=['color226', 'colour226'])
    YELLOW_2             = Color256(0xd7ff00, 190, "yellow-2",              register=True, index=True, aliases=['color190', 'colour190'])
    YELLOW_3             = Color256(0xd7d700, 184, "yellow-3",              register=True, index=True, aliases=['color184', 'colour184'])
    YELLOW_4             = Color256(0x87af00, 106, "yellow-4",              register=True, index=True, aliases=['color106', 'colour106'])
    YELLOW_5             = Color256(0xafd700, 148, "yellow-5",              register=True, index=True, aliases=['color148', 'colour148'])
    YELLOW_6             = Color256(0x878700, 100, "yellow-6",              register=True, index=True, aliases=['color100', 'colour100'])

    ColorRGB(0x0048ba, "absolute-zero",                         register=True, index=True)
    ColorRGB(0x4c2f27, "acajou",                                register=True, index=True)
    ColorRGB(0xb0bf1a, "acid-green",                            register=True, index=True)
    ColorRGB(0x7cb9e8, "aero",                                  register=True, index=True)
    ColorRGB(0xc9ffe5, "aero-blue",                             register=True, index=True)
    ColorRGB(0xb284be, "african-violet",                        register=True, index=True)
    ColorRGB(0x5d8aa8, "air-force-blue",                        register=True, index=True, variation_map={
             0x00308f:   "usaf" })
    ColorRGB(0x72a0c1, "air-superiority-blue",                  register=True, index=True)
    ColorRGB(0xaf002a, "alabama-crimson",                       register=True, index=True)
    ColorRGB(0xf2f0e6, "alabaster",                             register=True, index=True)
    ColorRGB(0xf0f8ff, "alice-blue",                            register=True, index=True)
    ColorRGB(0xe32636, "alizarin-crimson",                      register=True, index=True)
    ColorRGB(0xc46210, "alloy-orange",                          register=True, index=True)
    ColorRGB(0xefdecd, "almond",                                register=True, index=True)
    ColorRGB(0x5a6457, "aloeswood-brown",                       register=True, index=True)
    ColorRGB(0x6a432d, "aloewood",                              register=True, index=True)
    ColorRGB(0xd6d6d6, "aluminum",                              register=True, index=True)
    ColorRGB(0xd2d9db, "aluminum-foil",                         register=True, index=True)
    ColorRGB(0xe52b50, "amaranth",                              register=True, index=True)
    ColorRGB(0x9f2b68, "amaranth-deep-purple",                  register=True, index=True)
    ColorRGB(0xf19cbb, "amaranth-pink",                         register=True, index=True)
    ColorRGB(0xab274f, "amaranth-purple",                       register=True, index=True)
    ColorRGB(0xd3212d, "amaranth-red",                          register=True, index=True)
    ColorRGB(0x3b7a57, "amazon",                                register=True, index=True)
    ColorRGB(0xffbf00, "amber",                                 register=True, index=True, variation_map={
             0xca6924:   "kohaku-iro", 
             0xff7e00:   "sae-ece" })
    ColorRGB(0x3b3b6d, "american-blue",                         register=True, index=True)
    ColorRGB(0x391802, "american-bronze",                       register=True, index=True)
    ColorRGB(0x804040, "american-brown",                        register=True, index=True)
    ColorRGB(0xd3af37, "american-gold",                         register=True, index=True)
    ColorRGB(0x34b334, "american-green",                        register=True, index=True)
    ColorRGB(0xff8b00, "american-orange",                       register=True, index=True)
    ColorRGB(0xff9899, "american-pink",                         register=True, index=True)
    ColorRGB(0x431c53, "american-purple",                       register=True, index=True)
    ColorRGB(0xb32134, "american-red",                          register=True, index=True)
    ColorRGB(0xff033e, "american-rose",                         register=True, index=True)
    ColorRGB(0xcfcfcf, "american-silver",                       register=True, index=True)
    ColorRGB(0x551b8c, "american-violet",                       register=True, index=True)
    ColorRGB(0xf2b400, "american-yellow",                       register=True, index=True)
    ColorRGB(0x9966cc, "amethyst",                              register=True, index=True)
    ColorRGB(0xf3c13a, "amur-cork-tree",                        register=True, index=True)
    ColorRGB(0xf2f3f4, "anti-flash-white",                      register=True, index=True)
    ColorRGB(0xcd9575, "antique-brass",                         register=True, index=True)
    ColorRGB(0x665d1e, "antique-bronze",                        register=True, index=True)
    ColorRGB(0x915c83, "antique-fuchsia",                       register=True, index=True)
    ColorRGB(0x841b2d, "antique-ruby",                          register=True, index=True)
    ColorRGB(0xfaebd7, "antique-white",                         register=True, index=True)
    ColorRGB(0x66b447, "apple",                                 register=True, index=True)
    ColorRGB(0x8db600, "apple-green",                           register=True, index=True)
    ColorRGB(0xfbceb1, "apricot",                               register=True, index=True)
    ColorRGB(0x00ffff, "aqua",                                  register=True, index=True)
    ColorRGB(0x86aba5, "aqua-blue",                             register=True, index=True)
    ColorRGB(0x7fffd4, "aquamarine",                            register=True, index=True)
    ColorRGB(0xd0ff14, "arctic-lime",                           register=True, index=True)
    ColorRGB(0xc0c0c0, "argent",                                register=True, index=True)
    ColorRGB(0x4b5320, "army-green",                            register=True, index=True)
    ColorRGB(0x8f9779, "artichoke",                             register=True, index=True)
    ColorRGB(0xe9d66b, "arylide-yellow",                        register=True, index=True)
    ColorRGB(0x7dc242, "asda-green",                            register=True, index=True, variation_map={
             0x00dea4:   "1985", 
             0x80c197:   "1994", 
             0x66c992:   "1999", 
             0x32ad61:   "2002" })
    ColorRGB(0xc86500, "asda-orange",                           register=True, index=True, variation_map={
             0xca7309:   "1968" })
    ColorRGB(0xb2beb5, "ash-gray",                              register=True, index=True)
    ColorRGB(0x87a96b, "asparagus",                             register=True, index=True)
    ColorRGB(0x687652, "aspen-green",                           register=True, index=True)
    ColorRGB(0x003a6c, "ateneo-blue",                           register=True, index=True)
    ColorRGB(0xff9966, "atomic-tangerine",                      register=True, index=True)
    ColorRGB(0xa52a2a, "auburn",                                register=True, index=True)
    ColorRGB(0xfdee00, "aureolin",                              register=True, index=True)
    ColorRGB(0x6e7f80, "auro-metal-saurus",                     register=True, index=True)
    ColorRGB(0x568203, "avocado",                               register=True, index=True)
    ColorRGB(0xff2052, "awesome",                               register=True, index=True)
    ColorRGB(0x63775b, "axolotl",                               register=True, index=True)
    ColorRGB(0x007fff, "azure",                                 register=True, index=True)
    ColorRGB(0xf0ffff, "azure-mist",                            register=True, index=True)
    ColorRGB(0xdbe9f4, "azureish-white",                        register=True, index=True)
    ColorRGB(0x89cff0, "baby-blue",                             register=True, index=True)
    ColorRGB(0xa1caf1, "baby-blue-eyes",                        register=True, index=True)
    ColorRGB(0xf4c2c2, "baby-pink",                             register=True, index=True)
    ColorRGB(0xfefefa, "baby-powder",                           register=True, index=True)
    ColorRGB(0x857c55, "baiko-brown",                           register=True, index=True)
    ColorRGB(0xff91af, "baker-miller-pink",                     register=True, index=True)
    ColorRGB(0x21abcd, "ball-blue",                             register=True, index=True)
    ColorRGB(0xf2e096, "bamboo-cream",                          register=True, index=True)
    ColorRGB(0xfae7b5, "banana-mania",                          register=True, index=True)
    ColorRGB(0xffe135, "banana-yellow",                         register=True, index=True)
    ColorRGB(0x83a9c1, "banff-blue",                            register=True, index=True)
    ColorRGB(0x006a4e, "bangladesh-green",                      register=True, index=True)
    ColorRGB(0xe94196, "barbie-pink",                           register=True, index=True, variation_map={
             0xe85395:   "1959-1975", 
             0xd3419d:   "1975-1990", 
             0xf364a2:   "1990-1999", 
             0xf7238a:   "1999-2004", 
             0xff3988:   "2004-2005", 
             0xfc419a:   "2005-2009", 
             0xe0218a:   "pantone" })
    ColorRGB(0x7c0a02, "barn-red",                              register=True, index=True)
    ColorRGB(0x1dacd6, "battery-charged-blue",                  register=True, index=True)
    ColorRGB(0x848482, "battleship-gray",                       register=True, index=True)
    ColorRGB(0x5fc9bf, "bayside",                               register=True, index=True)
    ColorRGB(0x98777b, "bazaar",                                register=True, index=True)
    ColorRGB(0x2e5894, "bdazzled-blue",                         register=True, index=True)
    ColorRGB(0xbcd4e6, "beau-blue",                             register=True, index=True)
    ColorRGB(0x9f8170, "beaver",                                register=True, index=True)
    ColorRGB(0xf28e1c, "beer",                                  register=True, index=True)
    ColorRGB(0xfa6e79, "begonia",                               register=True, index=True)
    ColorRGB(0xf5f5dc, "beige",                                 register=True, index=True)
    ColorRGB(0x5d3f6a, "bellflower",                            register=True, index=True)
    ColorRGB(0x352925, "betel-nut-dye",                         register=True, index=True)
    ColorRGB(0x9c2542, "big-dip-o-ruby",                        register=True, index=True)
    ColorRGB(0xe88e5a, "big-foot-feet",                         register=True, index=True)
    ColorRGB(0xb14a30, "birch-brown",                           register=True, index=True)
    ColorRGB(0xffe4c4, "bisque",                                register=True, index=True)
    ColorRGB(0x3d2b1f, "bistre",                                register=True, index=True)
    ColorRGB(0x967117, "bistre-brown",                          register=True, index=True)
    ColorRGB(0xcae00d, "bitter-lemon",                          register=True, index=True)
    ColorRGB(0xbfff00, "bitter-lime",                           register=True, index=True)
    ColorRGB(0xfe6f5e, "bittersweet",                           register=True, index=True)
    ColorRGB(0xbf4f51, "bittersweet-shimmer",                   register=True, index=True)
    ColorRGB(0x171412, "black",                                 register=True, index=True)
    ColorRGB(0x3d0c02, "black-bean",                            register=True, index=True)
    ColorRGB(0x252321, "black-chestnut-oak",                    register=True, index=True)
    ColorRGB(0x1b1811, "black-chocolate",                       register=True, index=True)
    ColorRGB(0x3b2f2f, "black-coffee",                          register=True, index=True)
    ColorRGB(0x54626f, "black-coral",                           register=True, index=True)
    ColorRGB(0x351e1c, "black-kite",                            register=True, index=True)
    ColorRGB(0x253529, "black-leather-jacket",                  register=True, index=True)
    ColorRGB(0x3b3c36, "black-olive",                           register=True, index=True)
    ColorRGB(0xbfafb2, "black-shadows",                         register=True, index=True)
    ColorRGB(0xffebcd, "blanched-almond",                       register=True, index=True)
    ColorRGB(0xa57164, "blast-off-bronze",                      register=True, index=True)
    ColorRGB(0x318ce7, "bleu-de-france",                        register=True, index=True)
    ColorRGB(0xace5ee, "blizzard-blue",                         register=True, index=True)
    ColorRGB(0xfaf0be, "blond",                                 register=True, index=True)
    ColorRGB(0x8a0303, "blood",                                 register=True, index=True, variation_map={
             0xa41313:   "animal", 
             0x630f0f:   "organ" })
    ColorRGB(0xd1001c, "blood-orange",                          register=True, index=True)
    ColorRGB(0x660000, "blood-red",                             register=True, index=True, variation_map={
             0xf35336:   "benihi" })
    ColorRGB(0x1f75fe, "blue",                                  register=True, index=True, variation_map={
             0x0093af:   "munsell", 
             0x0087bd:   "ncs", 
             0x0018a8:   "pantone", 
             0x333399:   "pigment", 
             0x0247fe:   "ryb", 
             0x000080:   "xterm" })
    ColorRGB(0xa2a2d0, "blue-bell",                             register=True, index=True)
    ColorRGB(0x52593b, "blue-black-crayfish",                   register=True, index=True)
    ColorRGB(0x00b9fb, "blue-bolt",                             register=True, index=True)
    ColorRGB(0x0088dc, "blue-cola",                             register=True, index=True)
    ColorRGB(0x6699cc, "blue-gray",                             register=True, index=True)
    ColorRGB(0x0d98ba, "blue-green",                            register=True, index=True, variation_map={
             0x064e40:   "color-wheel", 
             0x3a6960:   "seiheki" })
    ColorRGB(0x5dadec, "blue-jeans",                            register=True, index=True)
    ColorRGB(0x4cb7a5, "blue-lagoon",                           register=True, index=True)
    ColorRGB(0x553592, "blue-magenta-violet",                   register=True, index=True)
    ColorRGB(0x0cbfe9, "blue-raspberry",                        register=True, index=True)
    ColorRGB(0x126180, "blue-sapphire",                         register=True, index=True)
    ColorRGB(0x8a2be2, "blue-violet",                           register=True, index=True, variation_map={
             0x4d1a7f:   "color-wheel", 
             0x7366bd:   "crayola", 
             0x2b2028:   "shikon" })
    ColorRGB(0x5072a7, "blue-yonder",                           register=True, index=True)
    ColorRGB(0x4f86f7, "blueberry",                             register=True, index=True)
    ColorRGB(0x1c1cf0, "bluebonnet",                            register=True, index=True)
    ColorRGB(0xde5d83, "blush",                                 register=True, index=True)
    ColorRGB(0x542d24, "boiled-red-bean-brown",                 register=True, index=True)
    ColorRGB(0x79443b, "bole",                                  register=True, index=True)
    ColorRGB(0x0095b6, "bondi-blue",                            register=True, index=True)
    ColorRGB(0xe3dac9, "bone",                                  register=True, index=True)
    ColorRGB(0xdde26a, "bored-accent-green",                    register=True, index=True)
    ColorRGB(0x0e9ca5, "boy-red",                               register=True, index=True)
    ColorRGB(0x873260, "boysenberry",                           register=True, index=True)
    ColorRGB(0x0070ff, "brandeis-blue",                         register=True, index=True)
    ColorRGB(0x87413f, "brandy",                                register=True, index=True)
    ColorRGB(0xb5a642, "brass",                                 register=True, index=True)
    ColorRGB(0xff631c, "brave-orange",                          register=True, index=True)
    ColorRGB(0xe68364, "brewed-mustard-brown",                  register=True, index=True)
    ColorRGB(0xcb4154, "brick-red",                             register=True, index=True)
    ColorRGB(0xebecf0, "bright-gray",                           register=True, index=True)
    ColorRGB(0x66ff00, "bright-green",                          register=True, index=True)
    ColorRGB(0xbf94e4, "bright-lavender",                       register=True, index=True)
    ColorRGB(0xd891ef, "bright-lilac",                          register=True, index=True)
    ColorRGB(0xc32148, "bright-maroon",                         register=True, index=True)
    ColorRGB(0x1974d2, "bright-navy-blue",                      register=True, index=True)
    ColorRGB(0xff007f, "bright-pink",                           register=True, index=True)
    ColorRGB(0x08e8de, "bright-turquoise",                      register=True, index=True)
    ColorRGB(0xd19fe8, "bright-ube",                            register=True, index=True)
    ColorRGB(0xffaa1d, "bright-yellow",                         register=True, index=True)
    ColorRGB(0x3399ff, "brilliant-azure",                       register=True, index=True)
    ColorRGB(0xf4bbff, "brilliant-lavender",                    register=True, index=True)
    ColorRGB(0xff55a3, "brilliant-rose",                        register=True, index=True)
    ColorRGB(0xfb607f, "brink-pink",                            register=True, index=True)
    ColorRGB(0x004225, "british-racing-green",                  register=True, index=True)
    ColorRGB(0xcd7f32, "bronze",                                register=True, index=True, variation_map={
             0x88540b:   "2", 
             0xb08d57:   "metallic" })
    ColorRGB(0x737000, "bronze-yellow",                         register=True, index=True)
    ColorRGB(0x3d504b, "brookmere-green",                       register=True, index=True)
    ColorRGB(0x993300, "brown",                                 register=True, index=True, variation_map={
             0xaf593e:   "crayola", 
             0x964b00:   "traditional" })
    ColorRGB(0x5f1933, "brown-chocolate",                       register=True, index=True)
    ColorRGB(0x4a2c2a, "brown-coffee",                          register=True, index=True)
    ColorRGB(0x6b4423, "brown-nose",                            register=True, index=True)
    ColorRGB(0x4b3c39, "brown-rat-gray",                        register=True, index=True)
    ColorRGB(0xaf6e4d, "brown-sugar",                           register=True, index=True)
    ColorRGB(0xcc9966, "brown-yellow",                          register=True, index=True)
    ColorRGB(0x1b4d3e, "brunswick-green",                       register=True, index=True)
    ColorRGB(0x8c5939, "brushwood-dyed",                        register=True, index=True)
    ColorRGB(0xffc1cc, "bubble-gum",                            register=True, index=True)
    ColorRGB(0xe7feff, "bubbles",                               register=True, index=True)
    ColorRGB(0x7bb661, "bud-green",                             register=True, index=True)
    ColorRGB(0xf0dc82, "buff",                                  register=True, index=True)
    ColorRGB(0x480607, "bulgarian-rose",                        register=True, index=True)
    ColorRGB(0x800020, "burgundy",                              register=True, index=True)
    ColorRGB(0xdeb887, "burlywood",                             register=True, index=True)
    ColorRGB(0xa17a74, "burnished-brown",                       register=True, index=True)
    ColorRGB(0xcc5500, "burnt-orange",                          register=True, index=True)
    ColorRGB(0xe97451, "burnt-sienna",                          register=True, index=True)
    ColorRGB(0x8a3324, "burnt-umber",                           register=True, index=True)
    ColorRGB(0x24a0ed, "button-blue",                           register=True, index=True)
    ColorRGB(0xbd33a4, "byzantine",                             register=True, index=True)
    ColorRGB(0x702963, "byzantium",                             register=True, index=True)
    ColorRGB(0x536872, "cadet",                                 register=True, index=True)
    ColorRGB(0x5f9ea0, "cadet-blue",                            register=True, index=True, variation_map={
             0xa9b2c3:   "crayola" })
    ColorRGB(0x91a3b0, "cadet-gray",                            register=True, index=True)
    ColorRGB(0x0a1195, "cadmium-blue",                          register=True, index=True)
    ColorRGB(0x006b3c, "cadmium-green",                         register=True, index=True)
    ColorRGB(0xed872d, "cadmium-orange",                        register=True, index=True)
    ColorRGB(0xb60c26, "cadmium-purple",                        register=True, index=True)
    ColorRGB(0xe30022, "cadmium-red",                           register=True, index=True)
    ColorRGB(0x7f3e98, "cadmium-violet",                        register=True, index=True)
    ColorRGB(0xfff600, "cadmium-yellow",                        register=True, index=True)
    ColorRGB(0xa67b5b, "cafe-au-lait",                          register=True, index=True)
    ColorRGB(0x4b3621, "cafe-noir",                             register=True, index=True)
    ColorRGB(0x1e4d2b, "cal-poly-pomona-green",                 register=True, index=True)
    ColorRGB(0xfcffa4, "calamansi",                             register=True, index=True)
    ColorRGB(0xa3c1ad, "cambridge-blue",                        register=True, index=True)
    ColorRGB(0xc19a6b, "camel",                                 register=True, index=True)
    ColorRGB(0xefbbcc, "cameo-pink",                            register=True, index=True)
    ColorRGB(0x78866b, "camouflage-green",                      register=True, index=True)
    ColorRGB(0xffff99, "canary",                                register=True, index=True)
    ColorRGB(0xffef00, "canary-yellow",                         register=True, index=True)
    ColorRGB(0xff0800, "candy-apple-red",                       register=True, index=True)
    ColorRGB(0xe4717a, "candy-pink",                            register=True, index=True)
    ColorRGB(0xffb95a, "cape-jasmine-or-gardenia",              register=True, index=True)
    ColorRGB(0x00bfff, "capri",                                 register=True, index=True)
    ColorRGB(0x592720, "caput-mortuum",                         register=True, index=True)
    ColorRGB(0xffd59a, "caramel",                               register=True, index=True)
    ColorRGB(0xc41e3a, "cardinal",                              register=True, index=True)
    ColorRGB(0x1ac1dd, "caribbean-blue",                        register=True, index=True)
    ColorRGB(0x00cc99, "caribbean-green",                       register=True, index=True)
    ColorRGB(0x960018, "carmine",                               register=True, index=True, variation_map={
             0xd70040:   "m-p" })
    ColorRGB(0xeb4c42, "carmine-pink",                          register=True, index=True)
    ColorRGB(0xff0038, "carmine-red",                           register=True, index=True)
    ColorRGB(0xffa6c9, "carnation-pink",                        register=True, index=True)
    ColorRGB(0xb31b1b, "carnelian",                             register=True, index=True)
    ColorRGB(0x56a0d3, "carolina-blue",                         register=True, index=True)
    ColorRGB(0xed9121, "carrot-orange",                         register=True, index=True)
    ColorRGB(0x00563f, "castleton-green",                       register=True, index=True)
    ColorRGB(0x062a78, "catalina-blue",                         register=True, index=True)
    ColorRGB(0x703642, "catawba",                               register=True, index=True)
    ColorRGB(0xb64925, "cattail",                               register=True, index=True)
    ColorRGB(0xc95a49, "cedar-chest",                           register=True, index=True)
    ColorRGB(0x92a1cf, "ceil",                                  register=True, index=True)
    ColorRGB(0xace1af, "celadon",                               register=True, index=True, variation_map={
             0x819c8b:   "seiji-iro" })
    ColorRGB(0x007ba7, "celadon-blue",                          register=True, index=True)
    ColorRGB(0x2f847c, "celadon-green",                         register=True, index=True)
    ColorRGB(0xb2ffff, "celeste",                               register=True, index=True)
    ColorRGB(0x4997d0, "celestial-blue",                        register=True, index=True)
    ColorRGB(0x246bce, "celtic-blue",                           register=True, index=True)
    ColorRGB(0xde3163, "cerise",                                register=True, index=True)
    ColorRGB(0xec3b83, "cerise-pink",                           register=True, index=True)
    ColorRGB(0x2a52be, "cerulean-blue",                         register=True, index=True)
    ColorRGB(0x6d9bc3, "cerulean-frost",                        register=True, index=True)
    ColorRGB(0x001440, "cetacean-blue",                         register=True, index=True)
    ColorRGB(0x007aa5, "cg-blue",                               register=True, index=True)
    ColorRGB(0xe03c31, "cg-red",                                register=True, index=True)
    ColorRGB(0xa0785a, "chamoisee",                             register=True, index=True)
    ColorRGB(0xf7e7ce, "champagne",                             register=True, index=True)
    ColorRGB(0xf1ddcf, "champagne-pink",                        register=True, index=True)
    ColorRGB(0x36454f, "charcoal",                              register=True, index=True)
    ColorRGB(0x232b2b, "charleston-green",                      register=True, index=True)
    ColorRGB(0xd0748b, "charm",                                 register=True, index=True)
    ColorRGB(0xe68fac, "charm-pink",                            register=True, index=True)
    ColorRGB(0xdfff00, "chartreuse",                            register=True, index=True)
    ColorRGB(0xffa600, "cheese",                                register=True, index=True)
    ColorRGB(0xfcc9b9, "cherry-blossom",                        register=True, index=True)
    ColorRGB(0xac8181, "cherry-blossom-mouse",                  register=True, index=True)
    ColorRGB(0xffb7c5, "cherry-blossom-pink",                   register=True, index=True)
    ColorRGB(0x954535, "chestnut",                              register=True, index=True)
    ColorRGB(0x60281e, "chestnut-leather-brown",                register=True, index=True)
    ColorRGB(0xffc34d, "chickadee",                             register=True, index=True)
    ColorRGB(0xde6fa1, "china-pink",                            register=True, index=True)
    ColorRGB(0xa8516e, "china-rose",                            register=True, index=True)
    ColorRGB(0x141414, "chinese-black",                         register=True, index=True)
    ColorRGB(0x365194, "chinese-blue",                          register=True, index=True)
    ColorRGB(0xcd8032, "chinese-bronze",                        register=True, index=True)
    ColorRGB(0xab381f, "chinese-brown",                         register=True, index=True)
    ColorRGB(0xcc9900, "chinese-gold",                          register=True, index=True)
    ColorRGB(0xd0db61, "chinese-green",                         register=True, index=True)
    ColorRGB(0xf37042, "chinese-orange",                        register=True, index=True)
    ColorRGB(0xde70a1, "chinese-pink",                          register=True, index=True)
    ColorRGB(0x720b98, "chinese-purple",                        register=True, index=True)
    ColorRGB(0xaa381e, "chinese-red",                           register=True, index=True, variation_map={
             0xcd071e:   "2" })
    ColorRGB(0xcccccc, "chinese-silver",                        register=True, index=True)
    ColorRGB(0x856088, "chinese-violet",                        register=True, index=True)
    ColorRGB(0xe2e5de, "chinese-white",                         register=True, index=True)
    ColorRGB(0xffb200, "chinese-yellow",                        register=True, index=True)
    ColorRGB(0xb7702d, "chinese-yellow-tea",                    register=True, index=True)
    ColorRGB(0x4aff00, "chlorophyll-green",                     register=True, index=True)
    ColorRGB(0x7b3f00, "chocolate",                             register=True, index=True)
    ColorRGB(0x3f000f, "chocolate-brown",                       register=True, index=True)
    ColorRGB(0x58111a, "chocolate-cosmos",                      register=True, index=True)
    ColorRGB(0x3c1421, "chocolate-kisses",                      register=True, index=True)
    ColorRGB(0xa8a9ad, "chrome-aluminum",                       register=True, index=True)
    ColorRGB(0xffa700, "chrome-yellow",                         register=True, index=True)
    ColorRGB(0x98817b, "cinereous",                             register=True, index=True)
    ColorRGB(0xe34234, "cinnabar",                              register=True, index=True)
    ColorRGB(0xd2691e, "cinnamon",                              register=True, index=True)
    ColorRGB(0xcd607e, "cinnamon-satin",                        register=True, index=True)
    ColorRGB(0xe4d00a, "citrine",                               register=True, index=True)
    ColorRGB(0x933709, "citrine-brown",                         register=True, index=True)
    ColorRGB(0x9fa91f, "citron",                                register=True, index=True)
    ColorRGB(0x7f1734, "claret",                                register=True, index=True)
    ColorRGB(0xfbcce7, "classic-rose",                          register=True, index=True)
    ColorRGB(0x8f583c, "clove-brown",                           register=True, index=True)
    ColorRGB(0xa96232, "clove-dyed",                            register=True, index=True)
    ColorRGB(0x181b26, "coarse-wool",                           register=True, index=True)
    ColorRGB(0x0047ab, "cobalt-blue",                           register=True, index=True)
    ColorRGB(0x965a3e, "coconut",                               register=True, index=True)
    ColorRGB(0xe9edf6, "coconut-white",                         register=True, index=True)
    ColorRGB(0x524b2a, "codium-fragile-seaweed",                register=True, index=True)
    ColorRGB(0x6f4e37, "coffee",                                register=True, index=True)
    ColorRGB(0x3c3024, "cola",                                  register=True, index=True)
    ColorRGB(0xc4d8e2, "columbia-blue",                         register=True, index=True)
    ColorRGB(0xffffcc, "conditioner",                           register=True, index=True)
    ColorRGB(0xf88379, "congo-pink",                            register=True, index=True)
    ColorRGB(0x665343, "contemplation-in-a-tea-garden",         register=True, index=True)
    ColorRGB(0xeee0b1, "cookies-and-cream",                     register=True, index=True)
    ColorRGB(0x002e63, "cool-black",                            register=True, index=True)
    ColorRGB(0x8c92ac, "cool-gray",                             register=True, index=True)
    ColorRGB(0xb87333, "copper",                                register=True, index=True, variation_map={
             0xda8a67:   "crayola" })
    ColorRGB(0xad6f69, "copper-penny",                          register=True, index=True)
    ColorRGB(0xcb6d51, "copper-red",                            register=True, index=True)
    ColorRGB(0x996666, "copper-rose",                           register=True, index=True)
    ColorRGB(0xff3800, "coquelicot",                            register=True, index=True)
    ColorRGB(0xff7f50, "coral",                                 register=True, index=True, variation_map={
             0xf8674f:   "sango-iro" })
    ColorRGB(0xff4040, "coral-red",                             register=True, index=True)
    ColorRGB(0xfd7c6e, "coral-reef",                            register=True, index=True, variation_map={
             0xf6a494:   "valspar-paint" })
    ColorRGB(0x893f45, "cordovan",                              register=True, index=True)
    ColorRGB(0xfbec5d, "corn",                                  register=True, index=True, variation_map={
             0xfaa945:   "tomorokoshi-iro" })
    ColorRGB(0x93ccea, "cornflower",                            register=True, index=True)
    ColorRGB(0x6495ed, "cornflower-blue",                       register=True, index=True)
    ColorRGB(0xfff8dc, "cornsilk",                              register=True, index=True)
    ColorRGB(0x2e2d88, "cosmic-cobalt",                         register=True, index=True)
    ColorRGB(0xfff8e7, "cosmic-latte",                          register=True, index=True)
    ColorRGB(0xffbcd9, "cotton-candy",                          register=True, index=True)
    ColorRGB(0x81613c, "coyote-brown",                          register=True, index=True)
    ColorRGB(0xfffdd0, "cream",                                 register=True, index=True)
    ColorRGB(0xdc143c, "crimson",                               register=True, index=True)
    ColorRGB(0xbe0032, "crimson-glory",                         register=True, index=True)
    ColorRGB(0x990000, "crimson-red",                           register=True, index=True)
    ColorRGB(0xa7d8de, "crystal",                               register=True, index=True)
    ColorRGB(0x68a0b0, "crystal-blue",                          register=True, index=True)
    ColorRGB(0xf5f5f5, "cultured",                              register=True, index=True)
    ColorRGB(0x00b7eb, "cyan",                                  register=True, index=True, variation_map={
             0x008080:   "xterm" })
    ColorRGB(0x4e82b4, "cyan-azure",                            register=True, index=True)
    ColorRGB(0x4682bf, "cyan-blue-azure",                       register=True, index=True)
    ColorRGB(0x28589c, "cyan-cobalt-blue",                      register=True, index=True)
    ColorRGB(0x188bc2, "cyan-cornflower-blue",                  register=True, index=True)
    ColorRGB(0x58427c, "cyber-grape",                           register=True, index=True)
    ColorRGB(0xffd300, "cyber-yellow",                          register=True, index=True)
    ColorRGB(0xf56fa1, "cyclamen",                              register=True, index=True)
    ColorRGB(0x752e23, "cypress-bark",                          register=True, index=True)
    ColorRGB(0x6f3028, "cypress-bark-red",                      register=True, index=True)
    ColorRGB(0xffff31, "daffodil",                              register=True, index=True)
    ColorRGB(0xf0e130, "dandelion",                             register=True, index=True, variation_map={
             0xfddb6d:   "crayola" })
    ColorRGB(0x00008b, "dark-blue",                             register=True, index=True, variation_map={
             0x192236:   "kon" })
    ColorRGB(0x666699, "dark-blue-gray",                        register=True, index=True)
    ColorRGB(0x1b294b, "dark-blue-lapis-lazuli",                register=True, index=True)
    ColorRGB(0x804a00, "dark-bronze",                           register=True, index=True, variation_map={
             0x514100:   "coin" })
    ColorRGB(0x654321, "dark-brown",                            register=True, index=True)
    ColorRGB(0x88654e, "dark-brown-tangelo",                    register=True, index=True)
    ColorRGB(0x5d3954, "dark-byzantium",                        register=True, index=True)
    ColorRGB(0xa40000, "dark-candy-apple-red",                  register=True, index=True)
    ColorRGB(0x08457e, "dark-cerulean",                         register=True, index=True)
    ColorRGB(0x333333, "dark-charcoal",                         register=True, index=True)
    ColorRGB(0x986960, "dark-chestnut",                         register=True, index=True)
    ColorRGB(0x490206, "dark-chocolate",                        register=True, index=True, variation_map={
             0x3c1321:   "hersheys" })
    ColorRGB(0xcd5b45, "dark-coral",                            register=True, index=True)
    ColorRGB(0x26428b, "dark-cornflower-blue",                  register=True, index=True)
    ColorRGB(0x008b8b, "dark-cyan",                             register=True, index=True)
    ColorRGB(0x536878, "dark-electric-blue",                    register=True, index=True)
    ColorRGB(0xaa6c39, "dark-gold",                             register=True, index=True)
    ColorRGB(0xb8860b, "dark-goldenrod",                        register=True, index=True)
    ColorRGB(0xa9a9a9, "dark-gray",                             register=True, index=True)
    ColorRGB(0x013220, "dark-green",                            register=True, index=True, variation_map={
             0x006400:   "x11" })
    ColorRGB(0x1f262a, "dark-gunmetal",                         register=True, index=True)
    ColorRGB(0x00147e, "dark-imperial-blue",                    register=True, index=True, variation_map={
             0x00416a:   "2" })
    ColorRGB(0x614e6e, "dark-indigo",                           register=True, index=True)
    ColorRGB(0x1a2421, "dark-jungle-green",                     register=True, index=True)
    ColorRGB(0xbdb76b, "dark-khaki",                            register=True, index=True)
    ColorRGB(0x483c32, "dark-lava",                             register=True, index=True)
    ColorRGB(0x734f96, "dark-lavender",                         register=True, index=True)
    ColorRGB(0x8bbe1b, "dark-lemon-lime",                       register=True, index=True)
    ColorRGB(0x534b4f, "dark-liver",                            register=True, index=True, variation_map={
             0x543d37:   "horses" })
    ColorRGB(0x8b008b, "dark-magenta",                          register=True, index=True)
    ColorRGB(0x003366, "dark-midnight-blue",                    register=True, index=True)
    ColorRGB(0x4a5d23, "dark-moss-green",                       register=True, index=True)
    ColorRGB(0x02075d, "dark-navy",                             register=True, index=True)
    ColorRGB(0x556b2f, "dark-olive-green",                      register=True, index=True)
    ColorRGB(0xff8c00, "dark-orange",                           register=True, index=True)
    ColorRGB(0x9932cc, "dark-orchid",                           register=True, index=True)
    ColorRGB(0x779ecb, "dark-pastel-blue",                      register=True, index=True)
    ColorRGB(0x03c03c, "dark-pastel-green",                     register=True, index=True)
    ColorRGB(0x966fd6, "dark-pastel-purple",                    register=True, index=True)
    ColorRGB(0xc23b22, "dark-pastel-red",                       register=True, index=True)
    ColorRGB(0xe75480, "dark-pink",                             register=True, index=True)
    ColorRGB(0x003399, "dark-powder-blue",                      register=True, index=True)
    ColorRGB(0x4f3a3c, "dark-puce",                             register=True, index=True)
    ColorRGB(0x301934, "dark-purple",                           register=True, index=True)
    ColorRGB(0x872657, "dark-raspberry",                        register=True, index=True)
    ColorRGB(0x8b0000, "dark-red",                              register=True, index=True, variation_map={
             0x23191e:   "kurobeni" })
    ColorRGB(0xe9967a, "dark-salmon",                           register=True, index=True)
    ColorRGB(0x560319, "dark-scarlet",                          register=True, index=True)
    ColorRGB(0x8fbc8f, "dark-sea-green",                        register=True, index=True)
    ColorRGB(0x3c1414, "dark-sienna",                           register=True, index=True)
    ColorRGB(0x71706e, "dark-silver",                           register=True, index=True)
    ColorRGB(0x8cbed6, "dark-sky-blue",                         register=True, index=True)
    ColorRGB(0x483d8b, "dark-slate-blue",                       register=True, index=True)
    ColorRGB(0x2f4f4f, "dark-slate-gray",                       register=True, index=True)
    ColorRGB(0x177245, "dark-spring-green",                     register=True, index=True)
    ColorRGB(0x918151, "dark-tan",                              register=True, index=True)
    ColorRGB(0xffa812, "dark-tangerine",                        register=True, index=True)
    ColorRGB(0xcc4e5c, "dark-terra-cotta",                      register=True, index=True)
    ColorRGB(0x00ced1, "dark-turquoise",                        register=True, index=True)
    ColorRGB(0xd1bea8, "dark-vanilla",                          register=True, index=True)
    ColorRGB(0x9400d3, "dark-violet",                           register=True, index=True)
    ColorRGB(0x9b870c, "dark-yellow",                           register=True, index=True)
    ColorRGB(0x00703c, "dartmouth-green",                       register=True, index=True)
    ColorRGB(0x555555, "davys-gray",                            register=True, index=True)
    ColorRGB(0xfa7b62, "dawn",                                  register=True, index=True)
    ColorRGB(0x616359, "dawn-gray",                             register=True, index=True)
    ColorRGB(0xff8936, "daylily",                               register=True, index=True)
    ColorRGB(0xd70a53, "debian-red",                            register=True, index=True)
    ColorRGB(0xd57835, "decaying-leaves",                       register=True, index=True)
    ColorRGB(0x9c8aa4, "deep-amethyst",                         register=True, index=True)
    ColorRGB(0x40826d, "deep-aquamarine",                       register=True, index=True)
    ColorRGB(0xa9203e, "deep-carmine",                          register=True, index=True)
    ColorRGB(0xef3038, "deep-carmine-pink",                     register=True, index=True)
    ColorRGB(0xe9692c, "deep-carrot-orange",                    register=True, index=True)
    ColorRGB(0xda3287, "deep-cerise",                           register=True, index=True)
    ColorRGB(0xfad6a5, "deep-champagne",                        register=True, index=True)
    ColorRGB(0xb94e48, "deep-chestnut",                         register=True, index=True)
    ColorRGB(0x704241, "deep-coffee",                           register=True, index=True)
    ColorRGB(0x9b351b, "deep-dumpling",                         register=True, index=True)
    ColorRGB(0xc154c1, "deep-fuchsia",                          register=True, index=True)
    ColorRGB(0x056608, "deep-green",                            register=True, index=True)
    ColorRGB(0x0e7c61, "deep-green-cyan-turquoise",             register=True, index=True)
    ColorRGB(0x004b49, "deep-jungle-green",                     register=True, index=True)
    ColorRGB(0x333366, "deep-koamaru",                          register=True, index=True)
    ColorRGB(0xf5c71a, "deep-lemon",                            register=True, index=True)
    ColorRGB(0x9955bb, "deep-lilac",                            register=True, index=True)
    ColorRGB(0xcc00cc, "deep-magenta",                          register=True, index=True)
    ColorRGB(0x820000, "deep-maroon",                           register=True, index=True)
    ColorRGB(0xd473d4, "deep-mauve",                            register=True, index=True)
    ColorRGB(0x355e3b, "deep-moss-green",                       register=True, index=True)
    ColorRGB(0xffcba4, "deep-peach",                            register=True, index=True)
    ColorRGB(0xff1493, "deep-pink",                             register=True, index=True)
    ColorRGB(0xa95c68, "deep-puce",                             register=True, index=True)
    ColorRGB(0x3a243b, "deep-purple",                           register=True, index=True)
    ColorRGB(0x850101, "deep-red",                              register=True, index=True)
    ColorRGB(0x843f5b, "deep-ruby",                             register=True, index=True)
    ColorRGB(0xff9933, "deep-saffron",                          register=True, index=True)
    ColorRGB(0x7b3b3a, "deep-scarlet",                          register=True, index=True)
    ColorRGB(0x4a646c, "deep-space-sparkle",                    register=True, index=True)
    ColorRGB(0x7e5e60, "deep-taupe",                            register=True, index=True)
    ColorRGB(0x66424d, "deep-tuscan-red",                       register=True, index=True)
    ColorRGB(0x330066, "deep-violet",                           register=True, index=True)
    ColorRGB(0xba8759, "deer",                                  register=True, index=True)
    ColorRGB(0x6ab2ca, "delicate-girl-blue",                    register=True, index=True)
    ColorRGB(0x1560bd, "denim",                                 register=True, index=True)
    ColorRGB(0x2243b6, "denim-blue",                            register=True, index=True)
    ColorRGB(0x669999, "desaturated-cyan",                      register=True, index=True)
    ColorRGB(0xedc9af, "desert-sand",                           register=True, index=True)
    ColorRGB(0xea3c53, "desire",                                register=True, index=True)
    ColorRGB(0xb9f2ff, "diamond",                               register=True, index=True)
    ColorRGB(0x696969, "dim-gray",                              register=True, index=True)
    ColorRGB(0xc53151, "dingy-dungeon",                         register=True, index=True)
    ColorRGB(0x9b7653, "dirt",                                  register=True, index=True)
    ColorRGB(0xb5651e, "dirty-brown",                           register=True, index=True)
    ColorRGB(0xe8e4c9, "dirty-white",                           register=True, index=True)
    ColorRGB(0x3f313a, "disappearing-purple",                   register=True, index=True)
    ColorRGB(0x1e90ff, "dodger-blue",                           register=True, index=True)
    ColorRGB(0xfef65b, "dodie-yellow",                          register=True, index=True)
    ColorRGB(0xd71868, "dogwood-rose",                          register=True, index=True)
    ColorRGB(0x85bb65, "dollar-bill",                           register=True, index=True)
    ColorRGB(0x828e84, "dolphin-gray",                          register=True, index=True)
    ColorRGB(0x2496cd, "douban-blue",                           register=True, index=True)
    ColorRGB(0x2e963d, "douban-green",                          register=True, index=True)
    ColorRGB(0xf7c58e, "douban-light-yellow",                   register=True, index=True)
    ColorRGB(0x755d5b, "dove-feather-gray",                     register=True, index=True)
    ColorRGB(0x00009c, "duke-blue",                             register=True, index=True)
    ColorRGB(0x4f4944, "dull-blue",                             register=True, index=True)
    ColorRGB(0xb07939, "durian",                                register=True, index=True)
    ColorRGB(0xe6d0ab, "durian-white",                          register=True, index=True)
    ColorRGB(0xe1bd27, "durian-yellow",                         register=True, index=True)
    ColorRGB(0xe5ccc9, "dust-storm",                            register=True, index=True)
    ColorRGB(0xefdfbb, "dutch-white",                           register=True, index=True)
    ColorRGB(0x913225, "dyestalk-red",                          register=True, index=True)
    ColorRGB(0xe1a95f, "earth-yellow",                          register=True, index=True)
    ColorRGB(0x5d3a1a, "earthtone",                             register=True, index=True)
    ColorRGB(0x555d50, "ebony",                                 register=True, index=True)
    ColorRGB(0xc2b280, "ecru",                                  register=True, index=True)
    ColorRGB(0x1b1b1b, "eerie-black",                           register=True, index=True)
    ColorRGB(0xffa631, "egg",                                   register=True, index=True)
    ColorRGB(0x614051, "eggplant",                              register=True, index=True)
    ColorRGB(0xf0ead6, "eggshell",                              register=True, index=True)
    ColorRGB(0xe2be9f, "eggshell-paper",                        register=True, index=True)
    ColorRGB(0x1034a6, "egyptian-blue",                         register=True, index=True)
    ColorRGB(0x17182b, "elderberry",                            register=True, index=True)
    ColorRGB(0x7df9ff, "electric-blue",                         register=True, index=True)
    ColorRGB(0xb56257, "electric-brown",                        register=True, index=True)
    ColorRGB(0xff003f, "electric-crimson",                      register=True, index=True)
    ColorRGB(0x6f00ff, "electric-indigo",                       register=True, index=True)
    ColorRGB(0xccff00, "electric-lime",                         register=True, index=True)
    ColorRGB(0xff3503, "electric-orange",                       register=True, index=True)
    ColorRGB(0xf62681, "electric-pink",                         register=True, index=True)
    ColorRGB(0xbf00ff, "electric-purple",                       register=True, index=True)
    ColorRGB(0xe60000, "electric-red",                          register=True, index=True)
    ColorRGB(0x3f00ff, "electric-ultramarine",                  register=True, index=True)
    ColorRGB(0x8f00ff, "electric-violet",                       register=True, index=True)
    ColorRGB(0xffff33, "electric-yellow",                       register=True, index=True)
    ColorRGB(0x50c878, "emerald",                               register=True, index=True)
    ColorRGB(0x046307, "emerald-green",                         register=True, index=True)
    ColorRGB(0x6c3082, "eminence",                              register=True, index=True)
    ColorRGB(0xb48395, "english-lavender",                      register=True, index=True)
    ColorRGB(0xab4b52, "english-red",                           register=True, index=True)
    ColorRGB(0xcc474b, "english-vermillion",                    register=True, index=True)
    ColorRGB(0x563c5c, "english-violet",                        register=True, index=True)
    ColorRGB(0x96c8a2, "eton-blue",                             register=True, index=True)
    ColorRGB(0x44d7a8, "eucalyptus",                            register=True, index=True)
    ColorRGB(0x39569c, "facebook-blue",                         register=True, index=True)
    ColorRGB(0xb0927a, "faded-sen-no-rikyus-tea",               register=True, index=True)
    ColorRGB(0x9b533f, "faded-spicy-red-brown",                 register=True, index=True)
    ColorRGB(0x43242a, "fake-purple",                           register=True, index=True)
    ColorRGB(0x801818, "falu-red",                              register=True, index=True)
    ColorRGB(0xb53389, "fandango",                              register=True, index=True)
    ColorRGB(0xde5285, "fandango-pink",                         register=True, index=True)
    ColorRGB(0xf400a1, "fashion-fuchsia",                       register=True, index=True)
    ColorRGB(0xe5aa70, "fawn",                                  register=True, index=True)
    ColorRGB(0x4d5d53, "feldgrau",                              register=True, index=True)
    ColorRGB(0xfdd5b1, "feldspar",                              register=True, index=True)
    ColorRGB(0x4f7942, "fern-green",                            register=True, index=True)
    ColorRGB(0xff2800, "ferrari-red",                           register=True, index=True)
    ColorRGB(0x6c541e, "field-drab",                            register=True, index=True)
    ColorRGB(0xff5470, "fiery-rose",                            register=True, index=True)
    ColorRGB(0x957b38, "finch-brown",                           register=True, index=True)
    ColorRGB(0xce2029, "fire-engine-red",                       register=True, index=True)
    ColorRGB(0xe95c4b, "fire-opal",                             register=True, index=True)
    ColorRGB(0xb22222, "firebrick",                             register=True, index=True)
    ColorRGB(0xe25822, "flame",                                 register=True, index=True)
    ColorRGB(0xfc8eac, "flamingo-pink",                         register=True, index=True)
    ColorRGB(0xf7e98e, "flavescent",                            register=True, index=True)
    ColorRGB(0xeedc82, "flax",                                  register=True, index=True)
    ColorRGB(0xffe9d1, "flesh",                                 register=True, index=True)
    ColorRGB(0x216bd6, "flickr-blue",                           register=True, index=True)
    ColorRGB(0xfb0081, "flickr-pink",                           register=True, index=True)
    ColorRGB(0xa2006d, "flirt",                                 register=True, index=True)
    ColorRGB(0x473f2d, "flirtatious-indigo-tea",                register=True, index=True)
    ColorRGB(0xffb94e, "floral-leaf",                           register=True, index=True)
    ColorRGB(0xfffaf0, "floral-white",                          register=True, index=True)
    ColorRGB(0xf498ad, "flower-girl",                           register=True, index=True)
    ColorRGB(0x15f4ee, "fluorescent-blue",                      register=True, index=True)
    ColorRGB(0xff004f, "folly",                                 register=True, index=True)
    ColorRGB(0xc91f37, "foreign-crimson",                       register=True, index=True)
    ColorRGB(0x228b22, "forest-green",                          register=True, index=True, variation_map={
             0x5fa777:   "crayola", 
             0x014421:   "traditional" })
    ColorRGB(0x985629, "fox",                                   register=True, index=True)
    ColorRGB(0x856d4d, "french-bistre",                         register=True, index=True)
    ColorRGB(0x0072bb, "french-blue",                           register=True, index=True)
    ColorRGB(0xfd3f92, "french-fuchsia",                        register=True, index=True)
    ColorRGB(0x86608e, "french-lilac",                          register=True, index=True)
    ColorRGB(0x9efd38, "french-lime",                           register=True, index=True)
    ColorRGB(0xfd6c9e, "french-pink",                           register=True, index=True)
    ColorRGB(0x811453, "french-plum",                           register=True, index=True)
    ColorRGB(0x4e1609, "french-puce",                           register=True, index=True)
    ColorRGB(0xc72c48, "french-raspberry",                      register=True, index=True)
    ColorRGB(0xf64a8a, "french-rose",                           register=True, index=True)
    ColorRGB(0x77b5fe, "french-sky-blue",                       register=True, index=True)
    ColorRGB(0x8806ce, "french-violet",                         register=True, index=True)
    ColorRGB(0xac1e44, "french-wine",                           register=True, index=True)
    ColorRGB(0xa6e7ff, "fresh-air",                             register=True, index=True)
    ColorRGB(0x5b8930, "fresh-onion",                           register=True, index=True)
    ColorRGB(0xe936a7, "frostbite",                             register=True, index=True)
    ColorRGB(0xff00ff, "fuchsia",                               register=True, index=True)
    ColorRGB(0xff77ff, "fuchsia-pink",                          register=True, index=True)
    ColorRGB(0xcc397b, "fuchsia-purple",                        register=True, index=True)
    ColorRGB(0xc74375, "fuchsia-rose",                          register=True, index=True)
    ColorRGB(0x000000, "full-black",                            register=True, index=True, aliases=['true-black', 'pure-black'])
    ColorRGB(0x0000ff, "full-blue",                             register=True, index=True)
    ColorRGB(0x00ffff, "full-cyan",                             register=True, index=True)
    ColorRGB(0x00ff00, "full-green",                            register=True, index=True)
    ColorRGB(0xff00ff, "full-magenta",                          register=True, index=True)
    ColorRGB(0xff0000, "full-red",                              register=True, index=True)
    ColorRGB(0xffffff, "full-white",                            register=True, index=True, aliases=['true-white', 'pure-white'])
    ColorRGB(0xffff00, "full-yellow",                           register=True, index=True)
    ColorRGB(0xe48400, "fulvous",                               register=True, index=True)
    ColorRGB(0xcc6666, "fuzzy-wuzzy",                           register=True, index=True)
    ColorRGB(0xdcdcdc, "gainsboro",                             register=True, index=True)
    ColorRGB(0xe49b0f, "gamboge",                               register=True, index=True, variation_map={
             0xffb61e:   "too" })
    ColorRGB(0x996600, "gamboge-orange",                        register=True, index=True)
    ColorRGB(0xffdf46, "gargoyle-gas",                          register=True, index=True)
    ColorRGB(0x733635, "garnet",                                register=True, index=True)
    ColorRGB(0x007f66, "generic-viridian",                      register=True, index=True)
    ColorRGB(0xf8f8ff, "ghost-white",                           register=True, index=True)
    ColorRGB(0xb05c52, "giants-club",                           register=True, index=True)
    ColorRGB(0xfe5a1d, "giants-orange",                         register=True, index=True)
    ColorRGB(0xd8e4bc, "gin",                                   register=True, index=True)
    ColorRGB(0x6082b6, "glaucous",                              register=True, index=True)
    ColorRGB(0xd34e36, "glazed-persimmon",                      register=True, index=True)
    ColorRGB(0xab92b3, "glossy-grape",                          register=True, index=True)
    ColorRGB(0x00ab66, "go-green",                              register=True, index=True)
    ColorRGB(0xa57c00, "gold",                                  register=True, index=True, variation_map={
             0xe6be8a:   "crayola", 
             0xd4af37:   "metallic" })
    ColorRGB(0xcb7e1f, "gold-brown",                            register=True, index=True)
    ColorRGB(0xbd9b16, "gold-foil",                             register=True, index=True)
    ColorRGB(0x85754e, "gold-fusion",                           register=True, index=True)
    ColorRGB(0xffd700, "golden",                                register=True, index=True)
    ColorRGB(0x996515, "golden-brown",                          register=True, index=True, variation_map={
             0xc66b27:   "kincha" })
    ColorRGB(0xe29c45, "golden-fallen-leaves",                  register=True, index=True)
    ColorRGB(0x7d4e2d, "golden-gray-bamboo",                    register=True, index=True)
    ColorRGB(0xbb8141, "golden-oak",                            register=True, index=True)
    ColorRGB(0xfcc200, "golden-poppy",                          register=True, index=True)
    ColorRGB(0xffdf00, "golden-yellow",                         register=True, index=True, variation_map={
             0xffa400:   "and-a-particular-rose-varietal" })
    ColorRGB(0xdaa520, "goldenrod",                             register=True, index=True)
    ColorRGB(0x4c8bf5, "google-chrome-blue",                    register=True, index=True)
    ColorRGB(0x1aa260, "google-chrome-green",                   register=True, index=True)
    ColorRGB(0xde5246, "google-chrome-red",                     register=True, index=True)
    ColorRGB(0xffce44, "google-chrome-yellow",                  register=True, index=True)
    ColorRGB(0x203838, "goryeo-storeroom",                      register=True, index=True)
    ColorRGB(0x676767, "granite-gray",                          register=True, index=True)
    ColorRGB(0xa8e4a0, "granny-smith-apple",                    register=True, index=True)
    ColorRGB(0x6f2da8, "grape",                                 register=True, index=True)
    ColorRGB(0x63424b, "grape-mouse",                           register=True, index=True)
    ColorRGB(0xbebebe, "gray",                                  register=True, index=True)
    ColorRGB(0x465945, "gray-asparagus",                        register=True, index=True)
    ColorRGB(0xbc2d29, "grayed-red",                            register=True, index=True)
    ColorRGB(0x656255, "grayish-dark-green",                    register=True, index=True)
    ColorRGB(0x923916, "grecian-bronze",                        register=True, index=True)
    ColorRGB(0x1cac78, "green",                                 register=True, index=True, variation_map={
             0x2a603b:   "midori", 
             0x00a877:   "munsell", 
             0x009f6b:   "ncs", 
             0x00ad43:   "pantone", 
             0x00a550:   "pigment", 
             0x66b032:   "ryb", 
             0x008000:   "xterm" })
    ColorRGB(0x006442, "green-bamboo",                          register=True, index=True)
    ColorRGB(0x1164b4, "green-blue",                            register=True, index=True, variation_map={
             0x2887c8:   "crayola" })
    ColorRGB(0x4c721d, "green-cola",                            register=True, index=True)
    ColorRGB(0x009966, "green-cyan",                            register=True, index=True)
    ColorRGB(0xa7f432, "green-lizard",                          register=True, index=True)
    ColorRGB(0x6eaea1, "green-sheen",                           register=True, index=True)
    ColorRGB(0x65ff00, "green-slime",                           register=True, index=True)
    ColorRGB(0x824b35, "green-tea",                             register=True, index=True)
    ColorRGB(0xadff2f, "green-yellow",                          register=True, index=True, variation_map={
             0xf0e891:   "crayola" })
    ColorRGB(0xbda928, "greenfinch",                            register=True, index=True)
    ColorRGB(0xa99a86, "grullo",                                register=True, index=True)
    ColorRGB(0x2a3439, "gunmetal",                              register=True, index=True)
    ColorRGB(0x00ff7f, "guppie-green",                          register=True, index=True)
    ColorRGB(0xf8f8f8, "guyabano",                              register=True, index=True)
    ColorRGB(0x663854, "halaya-ube",                            register=True, index=True)
    ColorRGB(0x8d608c, "half",                                  register=True, index=True)
    ColorRGB(0xeb6123, "halloween-orange",                      register=True, index=True)
    ColorRGB(0x446ccf, "han-blue",                              register=True, index=True)
    ColorRGB(0x5218fa, "han-purple",                            register=True, index=True)
    ColorRGB(0x757d75, "harbor-rat",                            register=True, index=True)
    ColorRGB(0x3fff00, "harlequin",                             register=True, index=True)
    ColorRGB(0x46cb18, "harlequin-green",                       register=True, index=True)
    ColorRGB(0xf29cb7, "harmonious-rose",                       register=True, index=True)
    ColorRGB(0xda9100, "harvest-gold",                          register=True, index=True)
    ColorRGB(0x00c3e3, "hawaii-blue",                           register=True, index=True)
    ColorRGB(0x808000, "heart-gold",                            register=True, index=True)
    ColorRGB(0xff7a00, "heat-wave",                             register=True, index=True)
    ColorRGB(0xdf73ff, "heliotrope",                            register=True, index=True)
    ColorRGB(0xaa98a9, "heliotrope-gray",                       register=True, index=True)
    ColorRGB(0xaa00bb, "heliotrope-magenta",                    register=True, index=True)
    ColorRGB(0xf0fff0, "honeydew",                              register=True, index=True)
    ColorRGB(0x006db0, "honolulu-blue",                         register=True, index=True)
    ColorRGB(0x49796b, "hookers-green",                         register=True, index=True)
    ColorRGB(0x3d5d42, "horsetail",                             register=True, index=True)
    ColorRGB(0xff1dce, "hot-magenta",                           register=True, index=True)
    ColorRGB(0xff69b4, "hot-pink",                              register=True, index=True)
    ColorRGB(0xcf0a2c, "huawei-red",                            register=True, index=True, variation_map={
             0xed1c24:   "1987-2018" })
    ColorRGB(0xf58f84, "ibis-wing",                             register=True, index=True)
    ColorRGB(0x71a6d2, "iceberg",                               register=True, index=True)
    ColorRGB(0x923c01, "iced-tea",                              register=True, index=True)
    ColorRGB(0xfcf75e, "icterine",                              register=True, index=True)
    ColorRGB(0x71bc78, "iguana-green",                          register=True, index=True)
    ColorRGB(0x319177, "illuminating-emerald",                  register=True, index=True)
    ColorRGB(0x602f6b, "imperial",                              register=True, index=True)
    ColorRGB(0x002395, "imperial-blue",                         register=True, index=True)
    ColorRGB(0x66023c, "imperial-purple",                       register=True, index=True)
    ColorRGB(0xed2939, "imperial-red",                          register=True, index=True)
    ColorRGB(0xb2ec5d, "inchworm",                              register=True, index=True)
    ColorRGB(0x4c516d, "independence",                          register=True, index=True)
    ColorRGB(0x138808, "india-green",                           register=True, index=True)
    ColorRGB(0xcd5c5c, "indian-red",                            register=True, index=True)
    ColorRGB(0xe3a857, "indian-yellow",                         register=True, index=True)
    ColorRGB(0x4b0082, "indigo",                                register=True, index=True, variation_map={
             0x233067:   "rainbow" })
    ColorRGB(0x2e372e, "indigo-codium-fragile-seaweed-brown",   register=True, index=True)
    ColorRGB(0x091f92, "indigo-dye",                            register=True, index=True)
    ColorRGB(0x393432, "indigo-ink-brown",                      register=True, index=True)
    ColorRGB(0xebf6f7, "indigo-white",                          register=True, index=True)
    ColorRGB(0xff496c, "infra-red",                             register=True, index=True)
    ColorRGB(0x27221f, "ink",                                   register=True, index=True)
    ColorRGB(0x2d4436, "insect-screen",                         register=True, index=True)
    ColorRGB(0xc6c2b6, "inside-of-a-bottle",                    register=True, index=True)
    ColorRGB(0x360ccc, "interdimensional-blue",                 register=True, index=True)
    ColorRGB(0xff4f00, "international-orange",                  register=True, index=True, variation_map={
             0xba160c:   "engineering", 
             0xc0362c:   "golden-gate-bridge" })
    ColorRGB(0x5a4fcf, "iris",                                  register=True, index=True, variation_map={
             0x763568:   "ayame-iro" })
    ColorRGB(0xa19d94, "iron",                                  register=True, index=True, variation_map={
             0x2b3733:   "tetsu-iro" })
    ColorRGB(0x344d56, "iron-head-flower",                      register=True, index=True)
    ColorRGB(0x2b3736, "iron-storage",                          register=True, index=True)
    ColorRGB(0xb3446c, "irresistible",                          register=True, index=True)
    ColorRGB(0xf4f0ec, "isabelline",                            register=True, index=True)
    ColorRGB(0x009000, "islamic-green",                         register=True, index=True)
    ColorRGB(0x303940, "ispahan-blue",                          register=True, index=True)
    ColorRGB(0xe9f6ef, "italian-ice",                           register=True, index=True)
    ColorRGB(0x635a52, "italian-leather",                       register=True, index=True)
    ColorRGB(0x906652, "italian-roast",                         register=True, index=True)
    ColorRGB(0xfffff0, "ivory",                                 register=True, index=True)
    ColorRGB(0x5e5545, "iwai-brown",                            register=True, index=True)
    ColorRGB(0x3d325d, "jacarta",                               register=True, index=True)
    ColorRGB(0x413628, "jacko-bean",                            register=True, index=True)
    ColorRGB(0x00a86b, "jade",                                  register=True, index=True)
    ColorRGB(0x9d2933, "japanese-carmine",                      register=True, index=True)
    ColorRGB(0x264348, "japanese-indigo",                       register=True, index=True)
    ColorRGB(0x7f5d3b, "japanese-iris-and-sooty-bamboo",        register=True, index=True)
    ColorRGB(0x2f7532, "japanese-laurel",                       register=True, index=True)
    ColorRGB(0xe2b13c, "japanese-triandra-grass",               register=True, index=True)
    ColorRGB(0x5b3256, "japanese-violet",                       register=True, index=True)
    ColorRGB(0xf8de7e, "jasmine",                               register=True, index=True)
    ColorRGB(0xd73b3e, "jasper",                                register=True, index=True)
    ColorRGB(0xde8f4e, "jasper-orange",                         register=True, index=True)
    ColorRGB(0xa50b5e, "jazzberry-jam",                         register=True, index=True)
    ColorRGB(0xda614e, "jelly-bean",                            register=True, index=True)
    ColorRGB(0x44798e, "jelly-bean-blue",                       register=True, index=True)
    ColorRGB(0x343434, "jet",                                   register=True, index=True)
    ColorRGB(0xbbd0c9, "jet-stream",                            register=True, index=True)
    ColorRGB(0xf4ca16, "jonquil",                               register=True, index=True)
    ColorRGB(0x8ab9f1, "jordy-blue",                            register=True, index=True)
    ColorRGB(0xbdda57, "june-bud",                              register=True, index=True)
    ColorRGB(0x29ab87, "jungle-green",                          register=True, index=True)
    ColorRGB(0x4cbb17, "kelly-green",                           register=True, index=True)
    ColorRGB(0x7c1c05, "kenyan-copper",                         register=True, index=True)
    ColorRGB(0x3ab09e, "keppel",                                register=True, index=True)
    ColorRGB(0xe8f48c, "key-lime",                              register=True, index=True)
    ColorRGB(0x3d4c51, "kimono-storage",                        register=True, index=True)
    ColorRGB(0x8ee53f, "kiwi",                                  register=True, index=True)
    ColorRGB(0x882d17, "kobe",                                  register=True, index=True)
    ColorRGB(0xe79fc4, "kobi",                                  register=True, index=True)
    ColorRGB(0x354230, "kombu-green",                           register=True, index=True)
    ColorRGB(0x512888, "ksu-purple",                            register=True, index=True)
    ColorRGB(0xe8000d, "ku-crimson",                            register=True, index=True)
    ColorRGB(0xfb9912, "kumquat",                               register=True, index=True)
    ColorRGB(0xd6cadd, "languid-lavender",                      register=True, index=True)
    ColorRGB(0xe0bc5b, "lanzones",                              register=True, index=True)
    ColorRGB(0x26619c, "lapis-lazuli",                          register=True, index=True, variation_map={
             0x1f4788:   "ruri-iro" })
    ColorRGB(0xffff66, "laser-lemon",                           register=True, index=True)
    ColorRGB(0xa9ba9d, "laurel-green",                          register=True, index=True)
    ColorRGB(0xcf1020, "lava",                                  register=True, index=True)
    ColorRGB(0xb57edc, "lavender",                              register=True, index=True)
    ColorRGB(0xccccff, "lavender-blue",                         register=True, index=True)
    ColorRGB(0xfff0f5, "lavender-blush",                        register=True, index=True)
    ColorRGB(0xc4c3d0, "lavender-gray",                         register=True, index=True)
    ColorRGB(0x9457eb, "lavender-indigo",                       register=True, index=True)
    ColorRGB(0xee82ee, "lavender-magenta",                      register=True, index=True)
    ColorRGB(0xe6e6fa, "lavender-mist",                         register=True, index=True)
    ColorRGB(0xfbaed2, "lavender-pink",                         register=True, index=True)
    ColorRGB(0x967bb6, "lavender-purple",                       register=True, index=True)
    ColorRGB(0xfba0e3, "lavender-rose",                         register=True, index=True)
    ColorRGB(0x7cfc00, "lawn-green",                            register=True, index=True)
    ColorRGB(0x2e211b, "legal-dye",                             register=True, index=True)
    ColorRGB(0xfff700, "lemon",                                 register=True, index=True)
    ColorRGB(0xfffacd, "lemon-chiffon",                         register=True, index=True)
    ColorRGB(0xcca01d, "lemon-curry",                           register=True, index=True)
    ColorRGB(0xfdff00, "lemon-glacier",                         register=True, index=True)
    ColorRGB(0xbd3000, "lemon-iced-tea",                        register=True, index=True)
    ColorRGB(0xe3ff00, "lemon-lime",                            register=True, index=True, variation_map={
             0x5cff67:   "2" })
    ColorRGB(0xf6eabe, "lemon-meringue",                        register=True, index=True)
    ColorRGB(0xfff44f, "lemon-yellow",                          register=True, index=True, variation_map={
             0xffff9f:   "crayola" })
    ColorRGB(0xba93d8, "lenurple",                              register=True, index=True)
    ColorRGB(0x545aa7, "liberty",                               register=True, index=True)
    ColorRGB(0x1a1110, "licorice",                              register=True, index=True)
    ColorRGB(0xadd8e6, "light-blue",                            register=True, index=True, variation_map={
             0x48929b:   "asagi-iro" })
    ColorRGB(0x1d697c, "light-blue-flower",                     register=True, index=True)
    ColorRGB(0x044f67, "light-blue-silk",                       register=True, index=True)
    ColorRGB(0xb5651d, "light-brown",                           register=True, index=True)
    ColorRGB(0xe66771, "light-carmine-pink",                    register=True, index=True)
    ColorRGB(0x551f2f, "light-chocolate-cosmos",                register=True, index=True)
    ColorRGB(0x88ace0, "light-cobalt-blue",                     register=True, index=True)
    ColorRGB(0xf08080, "light-coral",                           register=True, index=True)
    ColorRGB(0xf56991, "light-crimson",                         register=True, index=True)
    ColorRGB(0xe0ffff, "light-cyan",                            register=True, index=True)
    ColorRGB(0xff5ccd, "light-deep-pink",                       register=True, index=True)
    ColorRGB(0xc8ad7f, "light-french-beige",                    register=True, index=True)
    ColorRGB(0xf984ef, "light-fuchsia-pink",                    register=True, index=True)
    ColorRGB(0xb29700, "light-gold",                            register=True, index=True)
    ColorRGB(0xfafad2, "light-goldenrod-yellow",                register=True, index=True)
    ColorRGB(0xd3d3d3, "light-gray",                            register=True, index=True)
    ColorRGB(0xcc99cc, "light-grayish-magenta",                 register=True, index=True)
    ColorRGB(0x90ee90, "light-green",                           register=True, index=True)
    ColorRGB(0xffb3de, "light-hot-pink",                        register=True, index=True)
    ColorRGB(0xf0e68c, "light-khaki",                           register=True, index=True)
    ColorRGB(0xff80ff, "light-magenta",                         register=True, index=True)
    ColorRGB(0xd39bcb, "light-medium-orchid",                   register=True, index=True)
    ColorRGB(0xaddfad, "light-moss-green",                      register=True, index=True)
    ColorRGB(0xfed8b1, "light-orange",                          register=True, index=True)
    ColorRGB(0xe6a8d7, "light-orchid",                          register=True, index=True)
    ColorRGB(0xb19cd9, "light-pastel-purple",                   register=True, index=True)
    ColorRGB(0xc5cbe1, "light-periwinkle",                      register=True, index=True)
    ColorRGB(0xffb6c1, "light-pink",                            register=True, index=True)
    ColorRGB(0xffcccb, "light-red",                             register=True, index=True)
    ColorRGB(0xffa07a, "light-salmon",                          register=True, index=True)
    ColorRGB(0xff9999, "light-salmon-pink",                     register=True, index=True)
    ColorRGB(0x20b2aa, "light-sea-green",                       register=True, index=True)
    ColorRGB(0xd8d8d8, "light-silver",                          register=True, index=True)
    ColorRGB(0x87cefa, "light-sky-blue",                        register=True, index=True)
    ColorRGB(0x778899, "light-slate-gray",                      register=True, index=True)
    ColorRGB(0xb0c4de, "light-steel-blue",                      register=True, index=True)
    ColorRGB(0xb38b6d, "light-taupe",                           register=True, index=True)
    ColorRGB(0xffffe0, "light-yellow",                          register=True, index=True, variation_map={
             0xf7bb7d:   "asagi" })
    ColorRGB(0xc8a2c8, "lilac",                                 register=True, index=True)
    ColorRGB(0xae98aa, "lilac-luster",                          register=True, index=True)
    ColorRGB(0x32cd32, "lime-green",                            register=True, index=True)
    ColorRGB(0xd1e189, "lime-pulp",                             register=True, index=True)
    ColorRGB(0x9dc209, "limerick",                              register=True, index=True)
    ColorRGB(0x195905, "lincoln-green",                         register=True, index=True)
    ColorRGB(0xfaf0e6, "linen",                                 register=True, index=True)
    ColorRGB(0x0072b1, "linkedin-blue",                         register=True, index=True)
    ColorRGB(0x6ca0dc, "little-boy-blue",                       register=True, index=True)
    ColorRGB(0xf8b9d4, "little-girl-pink",                      register=True, index=True)
    ColorRGB(0x674c47, "liver",                                 register=True, index=True, variation_map={
             0xb86d29:   "dogs", 
             0x6c2e1f:   "organ" })
    ColorRGB(0x987456, "liver-chestnut",                        register=True, index=True)
    ColorRGB(0xb95754, "long-spring",                           register=True, index=True)
    ColorRGB(0xab6134, "loquat",                                register=True, index=True)
    ColorRGB(0xfefdfa, "lotion",                                register=True, index=True)
    ColorRGB(0x15f2fd, "lotion-blue",                           register=True, index=True)
    ColorRGB(0xeccfcf, "lotion-pink",                           register=True, index=True)
    ColorRGB(0xffe4cd, "lumber",                                register=True, index=True)
    ColorRGB(0xe62020, "lust",                                  register=True, index=True)
    ColorRGB(0xdc5349, "lychee",                                register=True, index=True)
    ColorRGB(0x7f6b5d, "lye",                                   register=True, index=True)
    ColorRGB(0xffbd88, "macaroni-and-cheese",                   register=True, index=True)
    ColorRGB(0xcc3336, "madder-lake",                           register=True, index=True)
    ColorRGB(0xca1f7b, "magenta",                               register=True, index=True, variation_map={
             0xd0417e:   "pantone", 
             0xff0090:   "process", 
             0x800080:   "xterm" })
    ColorRGB(0x9f4576, "magenta-haze",                          register=True, index=True)
    ColorRGB(0xcc338b, "magenta-pink",                          register=True, index=True)
    ColorRGB(0xaaf0d1, "magic-mint",                            register=True, index=True)
    ColorRGB(0xff4466, "magic-potion",                          register=True, index=True)
    ColorRGB(0xf8f4ff, "magnolia",                              register=True, index=True)
    ColorRGB(0xc04000, "mahogany",                              register=True, index=True)
    ColorRGB(0xf2c649, "maize",                                 register=True, index=True)
    ColorRGB(0x6050dc, "majorelle-blue",                        register=True, index=True)
    ColorRGB(0x0bda51, "malachite",                             register=True, index=True)
    ColorRGB(0x979aaa, "manatee",                               register=True, index=True)
    ColorRGB(0xf37a48, "mandarin",                              register=True, index=True)
    ColorRGB(0xfdbe02, "mango",                                 register=True, index=True)
    ColorRGB(0x96ff00, "mango-green",                           register=True, index=True)
    ColorRGB(0xff8243, "mango-tango",                           register=True, index=True)
    ColorRGB(0xe7c9a9, "manila",                                register=True, index=True)
    ColorRGB(0x74c365, "mantis",                                register=True, index=True)
    ColorRGB(0xbb9351, "maple-syrup",                           register=True, index=True)
    ColorRGB(0x880085, "mardi-gras",                            register=True, index=True)
    ColorRGB(0xf2d930, "margarine",                             register=True, index=True)
    ColorRGB(0xb0c24a, "margarita",                             register=True, index=True)
    ColorRGB(0xeaa221, "marigold",                              register=True, index=True)
    ColorRGB(0x5e2824, "maroon",                                register=True, index=True, variation_map={
             0xb03060:   "x11" })
    ColorRGB(0xe0b0ff, "mauve",                                 register=True, index=True)
    ColorRGB(0x915f6d, "mauve-taupe",                           register=True, index=True)
    ColorRGB(0xef98aa, "mauvelous",                             register=True, index=True)
    ColorRGB(0x47abcc, "maximum-blue",                          register=True, index=True)
    ColorRGB(0x30bfbf, "maximum-blue-green",                    register=True, index=True)
    ColorRGB(0xacace6, "maximum-blue-purple",                   register=True, index=True)
    ColorRGB(0x5e8c31, "maximum-green",                         register=True, index=True)
    ColorRGB(0xd9e650, "maximum-green-yellow",                  register=True, index=True)
    ColorRGB(0xff5b00, "maximum-orange",                        register=True, index=True)
    ColorRGB(0x733380, "maximum-purple",                        register=True, index=True)
    ColorRGB(0xd92121, "maximum-red",                           register=True, index=True)
    ColorRGB(0xa63a79, "maximum-red-purple",                    register=True, index=True)
    ColorRGB(0xfafa37, "maximum-yellow",                        register=True, index=True)
    ColorRGB(0xf2ba49, "maximum-yellow-red",                    register=True, index=True)
    ColorRGB(0x4c9141, "may-green",                             register=True, index=True)
    ColorRGB(0x73c2fb, "maya-blue",                             register=True, index=True)
    ColorRGB(0xf9906f, "meat",                                  register=True, index=True)
    ColorRGB(0xe5b73b, "meat-brown",                            register=True, index=True)
    ColorRGB(0x66ddaa, "medium-aquamarine",                     register=True, index=True)
    ColorRGB(0x0000cd, "medium-blue",                           register=True, index=True)
    ColorRGB(0xe2062c, "medium-candy-apple-red",                register=True, index=True)
    ColorRGB(0xaf4035, "medium-carmine",                        register=True, index=True)
    ColorRGB(0xf3e5ab, "medium-champagne",                      register=True, index=True)
    ColorRGB(0xc93756, "medium-crimson",                        register=True, index=True)
    ColorRGB(0x035096, "medium-electric-blue",                  register=True, index=True)
    ColorRGB(0x1c352d, "medium-jungle-green",                   register=True, index=True)
    ColorRGB(0xdda0dd, "medium-lavender-magenta",               register=True, index=True)
    ColorRGB(0xba55d3, "medium-orchid",                         register=True, index=True)
    ColorRGB(0x0067a5, "medium-persian-blue",                   register=True, index=True)
    ColorRGB(0x9370db, "medium-purple",                         register=True, index=True)
    ColorRGB(0xbb3385, "medium-red-violet",                     register=True, index=True)
    ColorRGB(0xaa4069, "medium-ruby",                           register=True, index=True)
    ColorRGB(0x3cb371, "medium-sea-green",                      register=True, index=True)
    ColorRGB(0x80daeb, "medium-sky-blue",                       register=True, index=True)
    ColorRGB(0x7b68ee, "medium-slate-blue",                     register=True, index=True)
    ColorRGB(0xc9dc87, "medium-spring-bud",                     register=True, index=True)
    ColorRGB(0x00fa9a, "medium-spring-green",                   register=True, index=True)
    ColorRGB(0x48d1cc, "medium-turquoise",                      register=True, index=True)
    ColorRGB(0xd9603b, "medium-vermilion",                      register=True, index=True)
    ColorRGB(0xc71585, "medium-violet-red",                     register=True, index=True)
    ColorRGB(0xfdbcb4, "melancholy",                            register=True, index=True)
    ColorRGB(0xf8b878, "mellow-apricot",                        register=True, index=True)
    ColorRGB(0xfebaad, "melon",                                 register=True, index=True)
    ColorRGB(0xc1f9a2, "menthol",                               register=True, index=True)
    ColorRGB(0x32527b, "metallic-blue",                         register=True, index=True)
    ColorRGB(0xa97142, "metallic-bronze",                       register=True, index=True)
    ColorRGB(0xac4313, "metallic-brown",                        register=True, index=True)
    ColorRGB(0x296e01, "metallic-green",                        register=True, index=True)
    ColorRGB(0xda680f, "metallic-orange",                       register=True, index=True)
    ColorRGB(0xeda6c4, "metallic-pink",                         register=True, index=True)
    ColorRGB(0xa62c2b, "metallic-red",                          register=True, index=True)
    ColorRGB(0x0a7e8c, "metallic-seaweed",                      register=True, index=True)
    ColorRGB(0x9c7c38, "metallic-sunburst",                     register=True, index=True)
    ColorRGB(0x5b0a91, "metallic-violet",                       register=True, index=True)
    ColorRGB(0xfdcc0d, "metallic-yellow",                       register=True, index=True)
    ColorRGB(0xe4007c, "mexican-pink",                          register=True, index=True)
    ColorRGB(0x00a2ed, "microsoft-blue",                        register=True, index=True)
    ColorRGB(0x0078d7, "microsoft-edge-blue",                   register=True, index=True)
    ColorRGB(0x7db700, "microsoft-green",                       register=True, index=True)
    ColorRGB(0xf04e1f, "microsoft-red",                         register=True, index=True)
    ColorRGB(0xfdb900, "microsoft-yellow",                      register=True, index=True)
    ColorRGB(0x7ed4e6, "middle-blue",                           register=True, index=True)
    ColorRGB(0x8dd9cc, "middle-blue-green",                     register=True, index=True)
    ColorRGB(0x8b72be, "middle-blue-purple",                    register=True, index=True)
    ColorRGB(0x8b8680, "middle-gray",                           register=True, index=True)
    ColorRGB(0x4d8c57, "middle-green",                          register=True, index=True)
    ColorRGB(0xacbf60, "middle-green-yellow",                   register=True, index=True)
    ColorRGB(0xd982b5, "middle-purple",                         register=True, index=True)
    ColorRGB(0xe58e73, "middle-red",                            register=True, index=True)
    ColorRGB(0xa55353, "middle-red-purple",                     register=True, index=True)
    ColorRGB(0xffeb00, "middle-yellow",                         register=True, index=True)
    ColorRGB(0xecb176, "middle-yellow-red",                     register=True, index=True)
    ColorRGB(0x702670, "midnight",                              register=True, index=True)
    ColorRGB(0x191970, "midnight-blue",                         register=True, index=True, variation_map={
             0x00468c:   "2" })
    ColorRGB(0x004953, "midnight-green",                        register=True, index=True)
    ColorRGB(0xffc40c, "mikado-yellow",                         register=True, index=True)
    ColorRGB(0xfdfff5, "milk",                                  register=True, index=True)
    ColorRGB(0x84563c, "milk-chocolate",                        register=True, index=True)
    ColorRGB(0xffdae9, "mimi-pink",                             register=True, index=True)
    ColorRGB(0xe3f988, "mindaro",                               register=True, index=True)
    ColorRGB(0x36747d, "ming",                                  register=True, index=True)
    ColorRGB(0xf5e050, "minion-yellow",                         register=True, index=True)
    ColorRGB(0x3eb489, "mint",                                  register=True, index=True)
    ColorRGB(0xf5fffa, "mint-cream",                            register=True, index=True)
    ColorRGB(0x98ff98, "mint-green",                            register=True, index=True)
    ColorRGB(0xbbb477, "misty-moss",                            register=True, index=True)
    ColorRGB(0xffe4e1, "misty-rose",                            register=True, index=True)
    ColorRGB(0xbea493, "mocha",                                 register=True, index=True)
    ColorRGB(0x3aa8c1, "moonstone",                             register=True, index=True)
    ColorRGB(0x73a9c2, "moonstone-blue",                        register=True, index=True)
    ColorRGB(0xae0c00, "mordant-red-19",                        register=True, index=True)
    ColorRGB(0x8da399, "morning-blue",                          register=True, index=True)
    ColorRGB(0x8b7d3a, "moss",                                  register=True, index=True)
    ColorRGB(0x8a9a5b, "moss-green",                            register=True, index=True)
    ColorRGB(0x30ba8f, "mountain-meadow",                       register=True, index=True)
    ColorRGB(0x997a8d, "mountbatten-pink",                      register=True, index=True)
    ColorRGB(0x5c544e, "mousy-indigo",                          register=True, index=True)
    ColorRGB(0x766980, "mousy-wisteria",                        register=True, index=True)
    ColorRGB(0x18453b, "msu-green",                             register=True, index=True)
    ColorRGB(0x70543e, "mud",                                   register=True, index=True)
    ColorRGB(0xcb6649, "muddy-brown",                           register=True, index=True)
    ColorRGB(0x306030, "mughal-green",                          register=True, index=True)
    ColorRGB(0xc54b8c, "mulberry",                              register=True, index=True, variation_map={
             0xc8509b:   "crayola" })
    ColorRGB(0x59292c, "mulberry-dye",                          register=True, index=True)
    ColorRGB(0xc57f2e, "mulberry-dyed",                         register=True, index=True)
    ColorRGB(0xffdb58, "mustard",                               register=True, index=True)
    ColorRGB(0xcd7a00, "mustard-brown",                         register=True, index=True)
    ColorRGB(0x6e6e30, "mustard-green",                         register=True, index=True)
    ColorRGB(0xe1ad01, "mustard-yellow",                        register=True, index=True)
    ColorRGB(0x317873, "myrtle-green",                          register=True, index=True)
    ColorRGB(0xd65282, "mystic",                                register=True, index=True)
    ColorRGB(0xad4379, "mystic-maroon",                         register=True, index=True)
    ColorRGB(0xff5500, "mystic-red",                            register=True, index=True)
    ColorRGB(0xf6adc6, "nadeshiko-pink",                        register=True, index=True)
    ColorRGB(0x2a8000, "napier-green",                          register=True, index=True)
    ColorRGB(0xfada5e, "naples-yellow",                         register=True, index=True)
    ColorRGB(0xffdead, "navajo-white",                          register=True, index=True)
    ColorRGB(0x000080, "navy-blue",                             register=True, index=True)
    ColorRGB(0x191f45, "navy-blue-bellflower",                  register=True, index=True)
    ColorRGB(0x1b03a3, "neon-blue",                             register=True, index=True)
    ColorRGB(0xffa343, "neon-carrot",                           register=True, index=True)
    ColorRGB(0xfe4164, "neon-fuchsia",                          register=True, index=True)
    ColorRGB(0x39ff14, "neon-green",                            register=True, index=True)
    ColorRGB(0x006c7f, "new-bridge",                            register=True, index=True)
    ColorRGB(0x214fc6, "new-car",                               register=True, index=True)
    ColorRGB(0xd7837f, "new-york-pink",                         register=True, index=True)
    ColorRGB(0x727472, "nickel",                                register=True, index=True)
    ColorRGB(0x5c4827, "nightingale-brown",                     register=True, index=True)
    ColorRGB(0xe4000f, "nintendo-red",                          register=True, index=True)
    ColorRGB(0xa4dded, "non-photo-blue",                        register=True, index=True)
    ColorRGB(0x059033, "north-texas-green",                     register=True, index=True)
    ColorRGB(0xe9ffdb, "nyanza",                                register=True, index=True)
    ColorRGB(0x4f42b5, "ocean-blue",                            register=True, index=True)
    ColorRGB(0x0077be, "ocean-boat-blue",                       register=True, index=True)
    ColorRGB(0x48bf91, "ocean-green",                           register=True, index=True)
    ColorRGB(0xcc7722, "ochre",                                 register=True, index=True, variation_map={
             0xff4e20:   "earthen-yellow-red-brown", 
             0xbe7f51:   "lit-earthen-yellow" })
    ColorRGB(0xfd5240, "ogre-odor",                             register=True, index=True)
    ColorRGB(0x5e644f, "old-bamboo",                            register=True, index=True)
    ColorRGB(0x43302e, "old-burgundy",                          register=True, index=True)
    ColorRGB(0xcfb53b, "old-gold",                              register=True, index=True)
    ColorRGB(0xfdf5e6, "old-lace",                              register=True, index=True)
    ColorRGB(0x796878, "old-lavender",                          register=True, index=True)
    ColorRGB(0x673147, "old-mauve",                             register=True, index=True)
    ColorRGB(0x867e36, "old-moss-green",                        register=True, index=True)
    ColorRGB(0xc08081, "old-rose",                              register=True, index=True)
    ColorRGB(0x6b8e23, "olive-drab",                            register=True, index=True, variation_map={
             0x3c341f:   "7" })
    ColorRGB(0xb5b35c, "olive-green",                           register=True, index=True)
    ColorRGB(0x9ab973, "olivine",                               register=True, index=True)
    ColorRGB(0x4e3e37, "olympic-bronze",                        register=True, index=True)
    ColorRGB(0x364141, "onando",                                register=True, index=True)
    ColorRGB(0xf08f90, "one-kin",                               register=True, index=True)
    ColorRGB(0x353839, "onyx",                                  register=True, index=True)
    ColorRGB(0xa8c3bc, "opal",                                  register=True, index=True)
    ColorRGB(0xb784a7, "opera-mauve",                           register=True, index=True)
    ColorRGB(0xff1b2d, "opera-red",                             register=True, index=True)
    ColorRGB(0x4d646c, "opposite-flower",                       register=True, index=True)
    ColorRGB(0xff6600, "orange",                                register=True, index=True, variation_map={
             0xff7f00:   "color-wheel", 
             0xff7538:   "crayola", 
             0xff5800:   "pantone", 
             0xfb9902:   "ryb" })
    ColorRGB(0xff9f00, "orange-peel",                           register=True, index=True)
    ColorRGB(0xff681f, "orange-red",                            register=True, index=True, variation_map={
             0xff5349:   "crayola" })
    ColorRGB(0xfa5b3d, "orange-soda",                           register=True, index=True, variation_map={
             0xeb593d:   "2" })
    ColorRGB(0xf5bd1f, "orange-yellow",                         register=True, index=True, variation_map={
             0xf8d568:   "crayola" })
    ColorRGB(0xda70d6, "orchid",                                register=True, index=True, variation_map={
             0xe29cd2:   "crayola" })
    ColorRGB(0xf2bdcd, "orchid-pink",                           register=True, index=True)
    ColorRGB(0xfb4f14, "orioles-orange",                        register=True, index=True)
    ColorRGB(0x841617, "ou-crimson-red",                        register=True, index=True)
    ColorRGB(0x414a4c, "outer-space",                           register=True, index=True, variation_map={
             0x2d383a:   "crayola" })
    ColorRGB(0xff6e4a, "outrageous-orange",                     register=True, index=True)
    ColorRGB(0xe35c38, "overdyed-refreshed-red-brown",          register=True, index=True)
    ColorRGB(0x002147, "oxford-blue",                           register=True, index=True)
    ColorRGB(0x6d9a79, "oxley",                                 register=True, index=True)
    ColorRGB(0x1ca9c9, "pacific-blue",                          register=True, index=True)
    ColorRGB(0x6b4947, "painite",                               register=True, index=True)
    ColorRGB(0x006600, "pakistan-green",                        register=True, index=True)
    ColorRGB(0x273be2, "palatinate-blue",                       register=True, index=True)
    ColorRGB(0x682860, "palatinate-purple",                     register=True, index=True)
    ColorRGB(0x8c9c76, "pale-blue",                             register=True, index=True)
    ColorRGB(0xafeeee, "pale-blue-pale-turquoise",              register=True, index=True)
    ColorRGB(0x987654, "pale-brown",                            register=True, index=True)
    ColorRGB(0x9bc4e2, "pale-cerulean",                         register=True, index=True)
    ColorRGB(0xddadaf, "pale-chestnut",                         register=True, index=True)
    ColorRGB(0xabcdef, "pale-cornflower-blue",                  register=True, index=True)
    ColorRGB(0x87d3f8, "pale-cyan",                             register=True, index=True)
    ColorRGB(0xaa8736, "pale-fallen-leaves",                    register=True, index=True)
    ColorRGB(0xeee8aa, "pale-goldenrod",                        register=True, index=True)
    ColorRGB(0x98fb98, "pale-green",                            register=True, index=True)
    ColorRGB(0x749f8d, "pale-green-onion",                      register=True, index=True)
    ColorRGB(0xffa565, "pale-incense",                          register=True, index=True)
    ColorRGB(0xdcd0ff, "pale-lavender",                         register=True, index=True)
    ColorRGB(0xf984e5, "pale-magenta",                          register=True, index=True)
    ColorRGB(0xff99cc, "pale-magenta-pink",                     register=True, index=True)
    ColorRGB(0xbba46d, "pale-oak",                              register=True, index=True)
    ColorRGB(0xfca474, "pale-persimmon",                        register=True, index=True)
    ColorRGB(0xfadadd, "pale-pink",                             register=True, index=True)
    ColorRGB(0xfae6fa, "pale-purple",                           register=True, index=True)
    ColorRGB(0xdb7093, "pale-red-violet",                       register=True, index=True)
    ColorRGB(0x96ded1, "pale-robin-egg-blue",                   register=True, index=True)
    ColorRGB(0xc9c0bb, "pale-silver",                           register=True, index=True)
    ColorRGB(0xecebbd, "pale-spring-bud",                       register=True, index=True)
    ColorRGB(0xbc987e, "pale-taupe",                            register=True, index=True)
    ColorRGB(0xcc99ff, "pale-violet",                           register=True, index=True)
    ColorRGB(0x8db255, "pale-young-green-onion",                register=True, index=True)
    ColorRGB(0x6f9940, "palm-leaf",                             register=True, index=True)
    ColorRGB(0x0040be, "panasonic-blue",                        register=True, index=True)
    ColorRGB(0x78184a, "pansy-purple",                          register=True, index=True)
    ColorRGB(0x009b7d, "paolo-veronese-green",                  register=True, index=True)
    ColorRGB(0xffefd5, "papaya-whip",                           register=True, index=True)
    ColorRGB(0xe63e62, "paradise-pink",                         register=True, index=True)
    ColorRGB(0x7eb6ff, "parakeet-blue",                         register=True, index=True)
    ColorRGB(0xd998a0, "parrot-pink",                           register=True, index=True)
    ColorRGB(0xaec6cf, "pastel-blue",                           register=True, index=True)
    ColorRGB(0x836953, "pastel-brown",                          register=True, index=True)
    ColorRGB(0xcfcfc4, "pastel-gray",                           register=True, index=True)
    ColorRGB(0x77dd77, "pastel-green",                          register=True, index=True)
    ColorRGB(0xf49ac2, "pastel-magenta",                        register=True, index=True)
    ColorRGB(0xffb347, "pastel-orange",                         register=True, index=True)
    ColorRGB(0xdea5a4, "pastel-pink",                           register=True, index=True)
    ColorRGB(0xb39eb5, "pastel-purple",                         register=True, index=True)
    ColorRGB(0xff6961, "pastel-red",                            register=True, index=True)
    ColorRGB(0xcb99c9, "pastel-violet",                         register=True, index=True)
    ColorRGB(0xfdfd96, "pastel-yellow",                         register=True, index=True)
    ColorRGB(0x407a52, "patina",                                register=True, index=True)
    ColorRGB(0x800080, "patriarch",                             register=True, index=True)
    ColorRGB(0xd9b611, "patrinia-flowers",                      register=True, index=True)
    ColorRGB(0xffe5b4, "peach",                                 register=True, index=True, variation_map={
             0xf47983:   "momo-iro" })
    ColorRGB(0xf39998, "peach-burst",                           register=True, index=True)
    ColorRGB(0xffcc99, "peach-orange",                          register=True, index=True)
    ColorRGB(0xffdab9, "peach-puff",                            register=True, index=True)
    ColorRGB(0xfadfad, "peach-yellow",                          register=True, index=True)
    ColorRGB(0xd1e231, "pear",                                  register=True, index=True)
    ColorRGB(0xeae0c8, "pearl",                                 register=True, index=True)
    ColorRGB(0x88d8c0, "pearl-aqua",                            register=True, index=True)
    ColorRGB(0xb768a2, "pearly-purple",                         register=True, index=True)
    ColorRGB(0xf5f3ef, "penguin-white",                         register=True, index=True)
    ColorRGB(0xe6e200, "peridot",                               register=True, index=True)
    ColorRGB(0xc3cde6, "periwinkle",                            register=True, index=True)
    ColorRGB(0xe12c2c, "permanent-geranium-lake",               register=True, index=True)
    ColorRGB(0x1c39bb, "persian-blue",                          register=True, index=True)
    ColorRGB(0x00a693, "persian-green",                         register=True, index=True)
    ColorRGB(0x32127a, "persian-indigo",                        register=True, index=True)
    ColorRGB(0xd99058, "persian-orange",                        register=True, index=True)
    ColorRGB(0xf77fbe, "persian-pink",                          register=True, index=True)
    ColorRGB(0x701c1c, "persian-plum",                          register=True, index=True)
    ColorRGB(0xcc3333, "persian-red",                           register=True, index=True)
    ColorRGB(0xfe28a2, "persian-rose",                          register=True, index=True)
    ColorRGB(0xec5800, "persimmon",                             register=True, index=True)
    ColorRGB(0x934337, "persimmon-juice",                       register=True, index=True)
    ColorRGB(0xcd853f, "peru",                                  register=True, index=True)
    ColorRGB(0x8ba8b7, "pewter-blue",                           register=True, index=True)
    ColorRGB(0x0038a7, "philippine-blue",                       register=True, index=True)
    ColorRGB(0x6e3a07, "philippine-bronze",                     register=True, index=True)
    ColorRGB(0x5d1916, "philippine-brown",                      register=True, index=True)
    ColorRGB(0xb17304, "philippine-gold",                       register=True, index=True)
    ColorRGB(0x8c8c8c, "philippine-gray",                       register=True, index=True)
    ColorRGB(0x008543, "philippine-green",                      register=True, index=True)
    ColorRGB(0xff7300, "philippine-orange",                     register=True, index=True)
    ColorRGB(0xfa1a8e, "philippine-pink",                       register=True, index=True)
    ColorRGB(0xce1127, "philippine-red",                        register=True, index=True)
    ColorRGB(0xb3b3b3, "philippine-silver",                     register=True, index=True)
    ColorRGB(0x81007f, "philippine-violet",                     register=True, index=True)
    ColorRGB(0xfecb00, "philippine-yellow",                     register=True, index=True)
    ColorRGB(0xdf00ff, "phlox",                                 register=True, index=True)
    ColorRGB(0x000f89, "phthalo-blue",                          register=True, index=True)
    ColorRGB(0x123524, "phthalo-green",                         register=True, index=True)
    ColorRGB(0x45b1e8, "picton-blue",                           register=True, index=True)
    ColorRGB(0xc30b4e, "pictorial-carmine",                     register=True, index=True)
    ColorRGB(0xfddde6, "piggy-pink",                            register=True, index=True)
    ColorRGB(0x01796f, "pine-green",                            register=True, index=True)
    ColorRGB(0x454d32, "pine-needle",                           register=True, index=True)
    ColorRGB(0x2a2f23, "pine-tree",                             register=True, index=True)
    ColorRGB(0x563c0d, "pineapple",                             register=True, index=True)
    ColorRGB(0xffc0cb, "pink",                                  register=True, index=True, variation_map={
             0xd74894:   "pantone" })
    ColorRGB(0xfc74fd, "pink-flamingo",                         register=True, index=True)
    ColorRGB(0xffddf4, "pink-lace",                             register=True, index=True)
    ColorRGB(0xd8b2d1, "pink-lavender",                         register=True, index=True)
    ColorRGB(0xe7accf, "pink-pearl",                            register=True, index=True)
    ColorRGB(0x980036, "pink-raspberry",                        register=True, index=True)
    ColorRGB(0xf78fa7, "pink-sherbet",                          register=True, index=True)
    ColorRGB(0x93c572, "pistachio",                             register=True, index=True)
    ColorRGB(0x391285, "pixie-powder",                          register=True, index=True)
    ColorRGB(0x6e5f57, "plain-mouse",                           register=True, index=True)
    ColorRGB(0xe5e4e2, "platinum",                              register=True, index=True)
    ColorRGB(0x8e4585, "plum",                                  register=True, index=True)
    ColorRGB(0x97645a, "plum-blossom-mouse",                    register=True, index=True)
    ColorRGB(0xfa9258, "plum-dyed",                             register=True, index=True)
    ColorRGB(0x8f4155, "plum-purple",                           register=True, index=True)
    ColorRGB(0x5946b2, "plump-purple",                          register=True, index=True)
    ColorRGB(0x35654d, "poker-green",                           register=True, index=True)
    ColorRGB(0x985538, "polished-brown",                        register=True, index=True)
    ColorRGB(0x5da493, "polished-pine",                         register=True, index=True)
    ColorRGB(0x660c21, "pomegranate",                           register=True, index=True)
    ColorRGB(0x96a53c, "pomelo",                                register=True, index=True)
    ColorRGB(0xbfbd70, "pomelo-olive",                          register=True, index=True)
    ColorRGB(0xf9ffe3, "pomelo-white",                          register=True, index=True)
    ColorRGB(0xf6a08c, "poppy-petal",                           register=True, index=True)
    ColorRGB(0xbe4f62, "popstar",                               register=True, index=True)
    ColorRGB(0x936900, "porcupine",                             register=True, index=True)
    ColorRGB(0xff5a36, "portland-orange",                       register=True, index=True)
    ColorRGB(0xb0e0e6, "powder-blue",                           register=True, index=True)
    ColorRGB(0xff85cf, "princess-perfume",                      register=True, index=True)
    ColorRGB(0xf58025, "princeton-orange",                      register=True, index=True)
    ColorRGB(0x003153, "prussian-blue",                         register=True, index=True, variation_map={
             0x003171:   "konjo-iro" })
    ColorRGB(0xcc8899, "puce",                                  register=True, index=True)
    ColorRGB(0x722f37, "puce-red",                              register=True, index=True)
    ColorRGB(0x644117, "pullman-brown",                         register=True, index=True)
    ColorRGB(0x3b331c, "pullman-green",                         register=True, index=True)
    ColorRGB(0xff7518, "pumpkin",                               register=True, index=True)
    ColorRGB(0xc3272b, "pure-crimson",                          register=True, index=True)
    ColorRGB(0x6a0dad, "purple",                                register=True, index=True, variation_map={
             0x9f00c5:   "munsell", 
             0x4f284b:   "murasaki", 
             0xa020f0:   "x11" })
    ColorRGB(0x69359c, "purple-heart",                          register=True, index=True)
    ColorRGB(0x512c31, "purple-kite",                           register=True, index=True)
    ColorRGB(0x9678b6, "purple-mountain-majesty",               register=True, index=True)
    ColorRGB(0x4e5180, "purple-navy",                           register=True, index=True)
    ColorRGB(0xfe4eda, "purple-pizzazz",                        register=True, index=True)
    ColorRGB(0x9c51b6, "purple-plum",                           register=True, index=True)
    ColorRGB(0x50404d, "purple-taupe",                          register=True, index=True)
    ColorRGB(0x9a4eae, "purpureus",                             register=True, index=True)
    ColorRGB(0x51484f, "quartz",                                register=True, index=True)
    ColorRGB(0x436b95, "queen-blue",                            register=True, index=True)
    ColorRGB(0xe8ccd7, "queen-pink",                            register=True, index=True)
    ColorRGB(0xa6a6a6, "quick-silver",                          register=True, index=True)
    ColorRGB(0x8e3a59, "quinacridone-magenta",                  register=True, index=True)
    ColorRGB(0x6a5445, "quincy",                                register=True, index=True)
    ColorRGB(0x491e3c, "rabbit-ear-iris",                       register=True, index=True)
    ColorRGB(0xff355e, "radical-red",                           register=True, index=True)
    ColorRGB(0x242124, "raisin-black",                          register=True, index=True)
    ColorRGB(0xfbab60, "rajah",                                 register=True, index=True)
    ColorRGB(0xc71232, "rambutan",                              register=True, index=True)
    ColorRGB(0xa72127, "rambutan-red",                          register=True, index=True)
    ColorRGB(0xe3b130, "rape-blossom-brown",                    register=True, index=True)
    ColorRGB(0xa17917, "rapeseed-oil",                          register=True, index=True)
    ColorRGB(0xe30b5d, "raspberry",                             register=True, index=True)
    ColorRGB(0xe25098, "raspberry-pink",                        register=True, index=True)
    ColorRGB(0xd68a59, "raw-sienna",                            register=True, index=True)
    ColorRGB(0x826644, "raw-umber",                             register=True, index=True)
    ColorRGB(0xff33cc, "razzle-dazzle-rose",                    register=True, index=True)
    ColorRGB(0xe3256b, "razzmatazz",                            register=True, index=True)
    ColorRGB(0x8d4e85, "razzmic-berry",                         register=True, index=True)
    ColorRGB(0x663399, "rebecca-purple",                        register=True, index=True)
    ColorRGB(0xee204d, "red",                                   register=True, index=True, variation_map={
             0xf2003c:   "munsell", 
             0xc40233:   "ncs", 
             0xfe2712:   "ryb", 
             0x800000:   "xterm" })
    ColorRGB(0x672422, "red-bean",                              register=True, index=True)
    ColorRGB(0x9d2b22, "red-birch",                             register=True, index=True)
    ColorRGB(0xfb8136, "red-bronze",                            register=True, index=True)
    ColorRGB(0xa13d2d, "red-brown",                             register=True, index=True, variation_map={
             0x8b352d:   "lit-chestnut-plum" })
    ColorRGB(0xb62020, "red-cola",                              register=True, index=True)
    ColorRGB(0x860111, "red-devil",                             register=True, index=True)
    ColorRGB(0xf07f5e, "red-incense",                           register=True, index=True)
    ColorRGB(0x913228, "red-kite",                              register=True, index=True)
    ColorRGB(0x9f5233, "red-ochre",                             register=True, index=True)
    ColorRGB(0xff4500, "red-orange",                            register=True, index=True, variation_map={
             0xdc3023:   "lit-orangutan" })
    ColorRGB(0xdb5a6b, "red-plum",                              register=True, index=True)
    ColorRGB(0xe40078, "red-purple",                            register=True, index=True)
    ColorRGB(0xfd3a4a, "red-salsa",                             register=True, index=True)
    ColorRGB(0x922b3e, "red-violet",                            register=True, index=True, variation_map={
             0xc0448f:   "crayola" })
    ColorRGB(0xbb7796, "red-wisteria",                          register=True, index=True)
    ColorRGB(0xa45a52, "redwood",                               register=True, index=True)
    ColorRGB(0x522d80, "regalia",                               register=True, index=True)
    ColorRGB(0x002387, "resolution-blue",                       register=True, index=True)
    ColorRGB(0x777696, "rhythm",                                register=True, index=True)
    ColorRGB(0x004040, "rich-black",                            register=True, index=True, variation_map={
             0x010b13:   "fogra29", 
             0x010203:   "fogra39" })
    ColorRGB(0xf1a7fe, "rich-brilliant-lavender",               register=True, index=True)
    ColorRGB(0x0892d0, "rich-electric-blue",                    register=True, index=True)
    ColorRGB(0xf57f4f, "rich-gardenia",                         register=True, index=True)
    ColorRGB(0xa76bcf, "rich-lavender",                         register=True, index=True)
    ColorRGB(0xb666d2, "rich-lilac",                            register=True, index=True)
    ColorRGB(0x444c38, "rifle-green",                           register=True, index=True)
    ColorRGB(0x534a32, "rikan-brown",                           register=True, index=True)
    ColorRGB(0xff7952, "rinsed-out-red",                        register=True, index=True)
    ColorRGB(0xffc324, "ripe-mango",                            register=True, index=True)
    ColorRGB(0x00cccc, "robin-egg-blue",                        register=True, index=True)
    ColorRGB(0x8a7f80, "rocket-metallic",                       register=True, index=True)
    ColorRGB(0x838996, "roman-silver",                          register=True, index=True)
    ColorRGB(0x290e05, "root-beer",                             register=True, index=True)
    ColorRGB(0xf9429e, "rose-bonbon",                           register=True, index=True)
    ColorRGB(0x9e5e6f, "rose-dust",                             register=True, index=True)
    ColorRGB(0x674846, "rose-ebony",                            register=True, index=True)
    ColorRGB(0x960145, "rose-garnet",                           register=True, index=True)
    ColorRGB(0xb76e79, "rose-gold",                             register=True, index=True)
    ColorRGB(0xff66cc, "rose-pink",                             register=True, index=True)
    ColorRGB(0xbd559c, "rose-quartz-pink",                      register=True, index=True)
    ColorRGB(0xc21e56, "rose-red",                              register=True, index=True)
    ColorRGB(0x905d5d, "rose-taupe",                            register=True, index=True)
    ColorRGB(0xab4e52, "rose-vale",                             register=True, index=True)
    ColorRGB(0x65000b, "rosewood",                              register=True, index=True)
    ColorRGB(0xd40000, "rosso-corsa",                           register=True, index=True)
    ColorRGB(0xbc8f8f, "rosy-brown",                            register=True, index=True)
    ColorRGB(0x0038a8, "royal-azure",                           register=True, index=True)
    ColorRGB(0x002366, "royal-blue",                            register=True, index=True, variation_map={
             0x4169e1:   "light" })
    ColorRGB(0x523b35, "royal-brown",                           register=True, index=True)
    ColorRGB(0xca2c92, "royal-fuchsia",                         register=True, index=True)
    ColorRGB(0x136207, "royal-green",                           register=True, index=True)
    ColorRGB(0xf99245, "royal-orange",                          register=True, index=True)
    ColorRGB(0xe73895, "royal-pink",                            register=True, index=True)
    ColorRGB(0x7851a9, "royal-purple",                          register=True, index=True)
    ColorRGB(0xd00060, "royal-red",                             register=True, index=True, variation_map={
             0x9b1c31:   "2" })
    ColorRGB(0xce4676, "ruber",                                 register=True, index=True)
    ColorRGB(0xd10056, "rubine-red",                            register=True, index=True)
    ColorRGB(0xe0115f, "ruby",                                  register=True, index=True)
    ColorRGB(0x9b111e, "ruby-red",                              register=True, index=True)
    ColorRGB(0xff0028, "ruddy",                                 register=True, index=True)
    ColorRGB(0xbb6528, "ruddy-brown",                           register=True, index=True)
    ColorRGB(0xe18e96, "ruddy-pink",                            register=True, index=True)
    ColorRGB(0xa81c07, "rufous",                                register=True, index=True)
    ColorRGB(0x716675, "rum",                                   register=True, index=True)
    ColorRGB(0x80461b, "russet",                                register=True, index=True)
    ColorRGB(0x679267, "russian-green",                         register=True, index=True)
    ColorRGB(0x32174d, "russian-violet",                        register=True, index=True)
    ColorRGB(0xb7410e, "rust",                                  register=True, index=True)
    ColorRGB(0x6a7f7a, "rusted-light-blue",                     register=True, index=True)
    ColorRGB(0x898a74, "rusty-celadon",                         register=True, index=True)
    ColorRGB(0xda2c43, "rusty-red",                             register=True, index=True)
    ColorRGB(0x455859, "rusty-storage",                         register=True, index=True)
    ColorRGB(0x3a403b, "rusty-storeroom",                       register=True, index=True)
    ColorRGB(0x043927, "sacramento-state-green",                register=True, index=True)
    ColorRGB(0x8b4513, "saddle-brown",                          register=True, index=True)
    ColorRGB(0xff7800, "safety-orange",                         register=True, index=True, variation_map={
             0xff6700:   "blaze-orange" })
    ColorRGB(0xeed202, "safety-yellow",                         register=True, index=True)
    ColorRGB(0x5a4f74, "safflower",                             register=True, index=True)
    ColorRGB(0xf4c430, "saffron",                               register=True, index=True)
    ColorRGB(0xbcb88a, "sage",                                  register=True, index=True)
    ColorRGB(0xfa8072, "salmon",                                register=True, index=True)
    ColorRGB(0xff91a4, "salmon-pink",                           register=True, index=True)
    ColorRGB(0xe7968b, "salmon-rose",                           register=True, index=True)
    ColorRGB(0x12279e, "samsung-blue",                          register=True, index=True)
    ColorRGB(0xecd540, "sandstorm",                             register=True, index=True)
    ColorRGB(0xf4a460, "sandy-brown",                           register=True, index=True)
    ColorRGB(0xfdd9b5, "sandy-tan",                             register=True, index=True)
    ColorRGB(0x92000a, "sangria",                               register=True, index=True)
    ColorRGB(0x507d2a, "sap-green",                             register=True, index=True)
    ColorRGB(0x7e2639, "sappanwood",                            register=True, index=True)
    ColorRGB(0xa24f46, "sappanwood-incense",                    register=True, index=True)
    ColorRGB(0x0f52ba, "sapphire",                              register=True, index=True)
    ColorRGB(0xff4681, "sasquatch-socks",                       register=True, index=True)
    ColorRGB(0xcba135, "satin-sheen-gold",                      register=True, index=True)
    ColorRGB(0xec956c, "sawtooth-oak",                          register=True, index=True)
    ColorRGB(0xff2400, "scarlet",                               register=True, index=True, variation_map={
             0xcf3a24:   "blood" })
    ColorRGB(0xffd800, "school-bus-yellow",                     register=True, index=True)
    ColorRGB(0x351f19, "scorched-brown",                        register=True, index=True)
    ColorRGB(0x66ff66, "screamin-green",                        register=True, index=True)
    ColorRGB(0x006994, "sea-blue",                              register=True, index=True)
    ColorRGB(0x9fe2bf, "sea-foam-green",                        register=True, index=True)
    ColorRGB(0x2e8b57, "sea-green",                             register=True, index=True, variation_map={
             0x00ffcd:   "crayola" })
    ColorRGB(0x4bc7cf, "sea-serpent",                           register=True, index=True)
    ColorRGB(0x59260b, "seal-brown",                            register=True, index=True)
    ColorRGB(0xfff5ee, "seashell",                              register=True, index=True)
    ColorRGB(0xffba00, "selective-yellow",                      register=True, index=True)
    ColorRGB(0x826b58, "sen-no-rikyus-tea",                     register=True, index=True)
    ColorRGB(0x704214, "sepia",                                 register=True, index=True)
    ColorRGB(0xb1b7af, "sequoia-beige",                         register=True, index=True)
    ColorRGB(0x00a870, "sesame-street-green",                   register=True, index=True)
    ColorRGB(0x8a795d, "shadow",                                register=True, index=True)
    ColorRGB(0x778ba5, "shadow-blue",                           register=True, index=True)
    ColorRGB(0xffcff1, "shampoo",                               register=True, index=True)
    ColorRGB(0x009e60, "shamrock-green",                        register=True, index=True)
    ColorRGB(0xffe670, "shandy",                                register=True, index=True)
    ColorRGB(0x8fd400, "sheen-green",                           register=True, index=True)
    ColorRGB(0xd98695, "shimmering-blush",                      register=True, index=True)
    ColorRGB(0x5fa778, "shiny-shamrock",                        register=True, index=True)
    ColorRGB(0xfc0fc0, "shocking-pink",                         register=True, index=True, variation_map={
             0xff6fff:   "crayola" })
    ColorRGB(0x354e4b, "silk-crepe-brown",                      register=True, index=True)
    ColorRGB(0xaaa9ad, "silver",                                register=True, index=True)
    ColorRGB(0xacacac, "silver-chalice",                        register=True, index=True)
    ColorRGB(0xafb1ae, "silver-foil",                           register=True, index=True)
    ColorRGB(0x97867c, "silver-gray",                           register=True, index=True)
    ColorRGB(0x5d89ba, "silver-lake-blue",                      register=True, index=True)
    ColorRGB(0xc4aead, "silver-pink",                           register=True, index=True)
    ColorRGB(0xbfc1c2, "silver-sand",                           register=True, index=True)
    ColorRGB(0x4c3d30, "simmered-seaweed",                      register=True, index=True)
    ColorRGB(0xcb410b, "sinopia",                               register=True, index=True)
    ColorRGB(0x7a942e, "siskin-sprout-yellow",                  register=True, index=True)
    ColorRGB(0xff3855, "sizzling-red",                          register=True, index=True)
    ColorRGB(0xffdb00, "sizzling-sunrise",                      register=True, index=True)
    ColorRGB(0x007474, "skobeloff",                             register=True, index=True)
    ColorRGB(0x87ceeb, "sky-blue",                              register=True, index=True, variation_map={
             0x76d7ea:   "crayola", 
             0x4d8fac:   "sora-iro" })
    ColorRGB(0xcf71af, "sky-magenta",                           register=True, index=True)
    ColorRGB(0x6a5acd, "slate-blue",                            register=True, index=True)
    ColorRGB(0x708090, "slate-gray",                            register=True, index=True)
    ColorRGB(0x299617, "slimy-green",                           register=True, index=True)
    ColorRGB(0xff6d3a, "smashed-pumpkin",                       register=True, index=True)
    ColorRGB(0xc84186, "smitten",                               register=True, index=True)
    ColorRGB(0x738276, "smoke",                                 register=True, index=True)
    ColorRGB(0x832a0d, "smokey-topaz",                          register=True, index=True)
    ColorRGB(0x100c08, "smoky-black",                           register=True, index=True)
    ColorRGB(0x933d41, "smoky-topaz",                           register=True, index=True)
    ColorRGB(0xfffafa, "snow",                                  register=True, index=True)
    ColorRGB(0xcec8ef, "soap",                                  register=True, index=True)
    ColorRGB(0x545a2c, "soldier-green",                         register=True, index=True)
    ColorRGB(0x893843, "solid-pink",                            register=True, index=True)
    ColorRGB(0x757575, "sonic-silver",                          register=True, index=True)
    ColorRGB(0x4d4b3a, "sooty-willow-bamboo",                   register=True, index=True)
    ColorRGB(0x1d2951, "space-cadet",                           register=True, index=True)
    ColorRGB(0x807532, "spanish-bistre",                        register=True, index=True)
    ColorRGB(0x0070b8, "spanish-blue",                          register=True, index=True)
    ColorRGB(0xd10047, "spanish-carmine",                       register=True, index=True)
    ColorRGB(0xe51a4c, "spanish-crimson",                       register=True, index=True)
    ColorRGB(0x989898, "spanish-gray",                          register=True, index=True)
    ColorRGB(0x009150, "spanish-green",                         register=True, index=True)
    ColorRGB(0xe86100, "spanish-orange",                        register=True, index=True)
    ColorRGB(0xf7bfbe, "spanish-pink",                          register=True, index=True)
    ColorRGB(0x66033c, "spanish-purple",                        register=True, index=True)
    ColorRGB(0xe60026, "spanish-red",                           register=True, index=True)
    ColorRGB(0x4c2882, "spanish-violet",                        register=True, index=True)
    ColorRGB(0x007f5c, "spanish-viridian",                      register=True, index=True)
    ColorRGB(0xf6b511, "spanish-yellow",                        register=True, index=True)
    ColorRGB(0x8c4736, "sparrow-brown",                         register=True, index=True)
    ColorRGB(0x9e1316, "spartan-crimson",                       register=True, index=True)
    ColorRGB(0x8b5f4d, "spicy-mix",                             register=True, index=True)
    ColorRGB(0xb35c44, "spicy-red-brown",                       register=True, index=True)
    ColorRGB(0x0fc0fc, "spiro-disco-ball",                      register=True, index=True)
    ColorRGB(0xfdfe03, "sponge",                                register=True, index=True)
    ColorRGB(0xa7fc00, "spring-bud",                            register=True, index=True)
    ColorRGB(0x87ff2a, "spring-frost",                          register=True, index=True)
    ColorRGB(0xec2131, "sprint-red",                            register=True, index=True)
    ColorRGB(0xffdd05, "sprint-yellow",                         register=True, index=True)
    ColorRGB(0x23297a, "st-patricks-blue",                      register=True, index=True)
    ColorRGB(0x78779b, "stained-red",                           register=True, index=True)
    ColorRGB(0x007bb8, "star-command-blue",                     register=True, index=True)
    ColorRGB(0xd3b17d, "steamed-chestnut",                      register=True, index=True)
    ColorRGB(0x4682b4, "steel-blue",                            register=True, index=True)
    ColorRGB(0xcc33cc, "steel-pink",                            register=True, index=True)
    ColorRGB(0x5f8a8b, "steel-teal",                            register=True, index=True)
    ColorRGB(0xa09484, "stone-terrace",                         register=True, index=True)
    ColorRGB(0xcf142b, "stop-red",                              register=True, index=True)
    ColorRGB(0x3d4035, "storeroom-brown",                       register=True, index=True)
    ColorRGB(0x4f666a, "stormcloud",                            register=True, index=True)
    ColorRGB(0xe4d96f, "straw",                                 register=True, index=True)
    ColorRGB(0xfc5a8d, "strawberry",                            register=True, index=True)
    ColorRGB(0xd9463e, "strawberry-daiquiri",                   register=True, index=True)
    ColorRGB(0x8b171a, "strawberry-jam",                        register=True, index=True)
    ColorRGB(0xc83f49, "strawberry-red",                        register=True, index=True)
    ColorRGB(0xe9399e, "strong-boy-pink",                       register=True, index=True)
    ColorRGB(0xffa26b, "stylish-persimmon",                     register=True, index=True)
    ColorRGB(0x914e75, "sugar-plum",                            register=True, index=True)
    ColorRGB(0xe08a1e, "sumac-dyed",                            register=True, index=True, variation_map={
             0x592b1f:   "korozen" })
    ColorRGB(0xff404c, "sunburnt-cyclops",                      register=True, index=True)
    ColorRGB(0xffcc33, "sunglow",                               register=True, index=True)
    ColorRGB(0xf2f27a, "sunny",                                 register=True, index=True)
    ColorRGB(0xe3ab57, "sunray",                                register=True, index=True)
    ColorRGB(0xc27863, "sunrise-coral",                         register=True, index=True)
    ColorRGB(0xfd5e53, "sunset-orange",                         register=True, index=True)
    ColorRGB(0xffc922, "sunset-yellow",                         register=True, index=True)
    ColorRGB(0xcf6ba9, "super-pink",                            register=True, index=True)
    ColorRGB(0xf8b889, "superuser",                             register=True, index=True)
    ColorRGB(0xa83731, "sweet-brown",                           register=True, index=True)
    ColorRGB(0xf29eab, "sweet-sixteen",                         register=True, index=True)
    ColorRGB(0xd2b48c, "tan",                                   register=True, index=True, variation_map={
             0xd99a6c:   "crayola" })
    ColorRGB(0xf94d00, "tangelo",                               register=True, index=True)
    ColorRGB(0xf28500, "tangerine",                             register=True, index=True)
    ColorRGB(0xffcc00, "tangerine-yellow",                      register=True, index=True)
    ColorRGB(0xff4200, "taobao-orange",                         register=True, index=True)
    ColorRGB(0x003b6f, "tardis-blue",                           register=True, index=True)
    ColorRGB(0xfb4d46, "tart-orange",                           register=True, index=True)
    ColorRGB(0x976e9a, "tatarian-aster",                        register=True, index=True)
    ColorRGB(0x8b8589, "taupe-gray",                            register=True, index=True)
    ColorRGB(0xd0f0c0, "tea-green",                             register=True, index=True)
    ColorRGB(0x008080, "teal",                                  register=True, index=True)
    ColorRGB(0x367588, "teal-blue",                             register=True, index=True)
    ColorRGB(0x99e6b3, "teal-deer",                             register=True, index=True)
    ColorRGB(0x00827f, "teal-green",                            register=True, index=True)
    ColorRGB(0xcf3476, "telemagenta",                           register=True, index=True)
    ColorRGB(0x3c2126, "temptress",                             register=True, index=True)
    ColorRGB(0xcd5700, "tenne",                                 register=True, index=True)
    ColorRGB(0xe2725b, "terra-cotta",                           register=True, index=True)
    ColorRGB(0x785e49, "the-color-of-an-undried-wall",          register=True, index=True)
    ColorRGB(0xa87ca0, "thin",                                  register=True, index=True)
    ColorRGB(0xd8bfd8, "thistle",                               register=True, index=True, variation_map={
             0xebb0d7:   "crayola" })
    ColorRGB(0x317589, "thousand-herb",                         register=True, index=True)
    ColorRGB(0x3b3429, "thousand-year-old-brown",               register=True, index=True)
    ColorRGB(0x374231, "thousand-year-old-green",               register=True, index=True)
    ColorRGB(0xf7665a, "thrice-dyed-crimson",                   register=True, index=True)
    ColorRGB(0xfc89ac, "tickle-me-pink",                        register=True, index=True)
    ColorRGB(0x0abab5, "tiffany-blue",                          register=True, index=True)
    ColorRGB(0xe08d3c, "tigers-eye",                            register=True, index=True)
    ColorRGB(0xdbd7d2, "timberwolf",                            register=True, index=True)
    ColorRGB(0x878681, "titanium",                              register=True, index=True)
    ColorRGB(0xeee600, "titanium-yellow",                       register=True, index=True)
    ColorRGB(0xff6347, "tomato",                                register=True, index=True)
    ColorRGB(0xb21807, "tomato-sauce",                          register=True, index=True)
    ColorRGB(0x746cc0, "toolbox",                               register=True, index=True)
    ColorRGB(0xffc87c, "topaz",                                 register=True, index=True)
    ColorRGB(0xfd0e35, "tractor-red",                           register=True, index=True)
    ColorRGB(0xa4345d, "tree-peony",                            register=True, index=True)
    ColorRGB(0x808080, "trolley-gray",                          register=True, index=True)
    ColorRGB(0x00755e, "tropical-rain-forest",                  register=True, index=True)
    ColorRGB(0xcda4de, "tropical-violet",                       register=True, index=True)
    ColorRGB(0x0073cf, "true-blue",                             register=True, index=True, variation_map={
             0x2d68c4:   "2" })
    ColorRGB(0x8f1d21, "true-red",                              register=True, index=True)
    ColorRGB(0x3e8ede, "tufts-blue",                            register=True, index=True)
    ColorRGB(0xff878d, "tulip",                                 register=True, index=True)
    ColorRGB(0xdeaa88, "tumbleweed",                            register=True, index=True)
    ColorRGB(0xb57281, "turkish-rose",                          register=True, index=True)
    ColorRGB(0xe69b3a, "turmeric",                              register=True, index=True)
    ColorRGB(0x40e0d0, "turquoise",                             register=True, index=True)
    ColorRGB(0x00ffef, "turquoise-blue",                        register=True, index=True)
    ColorRGB(0xa0d6b4, "turquoise-green",                       register=True, index=True)
    ColorRGB(0x00c5cd, "turquoise-surf",                        register=True, index=True)
    ColorRGB(0x7c4848, "tuscan-red",                            register=True, index=True)
    ColorRGB(0xc09999, "tuscany",                               register=True, index=True)
    ColorRGB(0x8a496b, "twilight-lavender",                     register=True, index=True)
    ColorRGB(0x26a7de, "twitter-blue",                          register=True, index=True)
    ColorRGB(0x0033aa, "ua-blue",                               register=True, index=True)
    ColorRGB(0xd9004c, "ua-red",                                register=True, index=True)
    ColorRGB(0x8878c3, "ube",                                   register=True, index=True)
    ColorRGB(0x536895, "ucla-blue",                             register=True, index=True)
    ColorRGB(0xffb300, "ucla-gold",                             register=True, index=True)
    ColorRGB(0xba0001, "ue-red",                                register=True, index=True)
    ColorRGB(0x3cd070, "ufo-green",                             register=True, index=True)
    ColorRGB(0xfc6c85, "ultra-red",                             register=True, index=True)
    ColorRGB(0x5d8cae, "ultramarine",                           register=True, index=True)
    ColorRGB(0x4166f5, "ultramarine-blue",                      register=True, index=True)
    ColorRGB(0x635147, "umber",                                 register=True, index=True)
    ColorRGB(0xffddca, "unbleached-silk",                       register=True, index=True)
    ColorRGB(0xbcb58c, "underside-of-willow-leaves",            register=True, index=True)
    ColorRGB(0x5b92e5, "united-nations-blue",                   register=True, index=True)
    ColorRGB(0xb78727, "university-of-california-gold",         register=True, index=True)
    ColorRGB(0xf77f00, "university-of-tennessee-orange",        register=True, index=True)
    ColorRGB(0x7b1113, "up-maroon",                             register=True, index=True)
    ColorRGB(0xae2029, "upsdell-red",                           register=True, index=True)
    ColorRGB(0xe1ad21, "urobilin",                              register=True, index=True)
    ColorRGB(0x004f98, "usafa-blue",                            register=True, index=True)
    ColorRGB(0xd3003f, "utah-crimson",                          register=True, index=True)
    ColorRGB(0x080808, "vampire-black",                         register=True, index=True)
    ColorRGB(0x664228, "van-dyke-brown",                        register=True, index=True)
    ColorRGB(0xf38fa9, "vanilla-ice",                           register=True, index=True)
    ColorRGB(0xc5b358, "vegas-gold",                            register=True, index=True)
    ColorRGB(0x224634, "velvet",                                register=True, index=True)
    ColorRGB(0xc80815, "venetian-red",                          register=True, index=True)
    ColorRGB(0x43b3ae, "verdigris",                             register=True, index=True)
    ColorRGB(0xcd040b, "verizon-red",                           register=True, index=True, variation_map={
             0xec1c24:   "2000-2015" })
    ColorRGB(0xd9381e, "vermilion",                             register=True, index=True)
    ColorRGB(0x18880d, "verse-green",                           register=True, index=True)
    ColorRGB(0x74bbfb, "very-light-azure",                      register=True, index=True)
    ColorRGB(0x6666ff, "very-light-blue",                       register=True, index=True)
    ColorRGB(0x64e986, "very-light-malachite-green",            register=True, index=True)
    ColorRGB(0xffb077, "very-light-tangelo",                    register=True, index=True)
    ColorRGB(0xffdfbf, "very-pale-orange",                      register=True, index=True)
    ColorRGB(0xffffbf, "very-pale-yellow",                      register=True, index=True)
    ColorRGB(0xf4e9ce, "victorian-white",                       register=True, index=True)
    ColorRGB(0x6d2b50, "vine-grape",                            register=True, index=True)
    ColorRGB(0x38a32a, "vine-green",                            register=True, index=True)
    ColorRGB(0x7f00ff, "violet",                                register=True, index=True, variation_map={
             0x963d7f:   "crayola", 
             0x8601af:   "ryb" })
    ColorRGB(0x324ab2, "violet-blue",                           register=True, index=True, variation_map={
             0x766ec8:   "crayola" })
    ColorRGB(0xf75394, "violet-red",                            register=True, index=True, variation_map={
             0x891446:   "2" })
    ColorRGB(0x8366f4, "violets-are-blue",                      register=True, index=True)
    ColorRGB(0x674403, "violin-brown",                          register=True, index=True)
    ColorRGB(0x009698, "viridian-green",                        register=True, index=True)
    ColorRGB(0x7c9ed9, "vista-blue",                            register=True, index=True)
    ColorRGB(0xef3939, "vivaldi-red",                           register=True, index=True)
    ColorRGB(0x922724, "vivid-auburn",                          register=True, index=True)
    ColorRGB(0x9f1d35, "vivid-burgundy",                        register=True, index=True)
    ColorRGB(0xda1d81, "vivid-cerise",                          register=True, index=True)
    ColorRGB(0x00aaee, "vivid-cerulean",                        register=True, index=True)
    ColorRGB(0xcc0033, "vivid-crimson",                         register=True, index=True)
    ColorRGB(0xff9900, "vivid-gamboge",                         register=True, index=True)
    ColorRGB(0xa6d608, "vivid-lime-green",                      register=True, index=True)
    ColorRGB(0x00cc33, "vivid-malachite",                       register=True, index=True)
    ColorRGB(0xb80ce3, "vivid-mulberry",                        register=True, index=True)
    ColorRGB(0xff5f00, "vivid-orange",                          register=True, index=True)
    ColorRGB(0xffa000, "vivid-orange-peel",                     register=True, index=True)
    ColorRGB(0xcc00ff, "vivid-orchid",                          register=True, index=True)
    ColorRGB(0xff006c, "vivid-raspberry",                       register=True, index=True)
    ColorRGB(0xf70d1a, "vivid-red",                             register=True, index=True)
    ColorRGB(0xdf6124, "vivid-red-tangelo",                     register=True, index=True)
    ColorRGB(0x00ccff, "vivid-sky-blue",                        register=True, index=True)
    ColorRGB(0xf07427, "vivid-tangelo",                         register=True, index=True)
    ColorRGB(0xffa089, "vivid-tangerine",                       register=True, index=True)
    ColorRGB(0xe56024, "vivid-vermilion",                       register=True, index=True)
    ColorRGB(0x9f00ff, "vivid-violet",                          register=True, index=True)
    ColorRGB(0xffe302, "vivid-yellow",                          register=True, index=True)
    ColorRGB(0xbfc0ee, "vodka",                                 register=True, index=True)
    ColorRGB(0xceff00, "volt",                                  register=True, index=True)
    ColorRGB(0x34b233, "wageningen-green",                      register=True, index=True)
    ColorRGB(0x9f7462, "walnut-dyed",                           register=True, index=True)
    ColorRGB(0x004242, "warm-black",                            register=True, index=True)
    ColorRGB(0xffb3a7, "washed-out-crimson",                    register=True, index=True)
    ColorRGB(0xec8254, "washed-out-persimmon",                  register=True, index=True)
    ColorRGB(0xd4f1f9, "water",                                 register=True, index=True)
    ColorRGB(0xb56c60, "water-persimmon",                       register=True, index=True)
    ColorRGB(0xeeff1b, "watermelon-yellow",                     register=True, index=True)
    ColorRGB(0xa4f4f9, "waterspout",                            register=True, index=True)
    ColorRGB(0x593a27, "weathered-bamboo",                      register=True, index=True)
    ColorRGB(0x1f8eed, "weebly-blue",                           register=True, index=True)
    ColorRGB(0xff9a00, "weebly-orange",                         register=True, index=True)
    ColorRGB(0x7c98ab, "weldon-blue",                           register=True, index=True)
    ColorRGB(0x645452, "wenge",                                 register=True, index=True)
    ColorRGB(0xf5deb3, "wheat",                                 register=True, index=True)
    ColorRGB(0xc5c8c6, "white",                                 register=True, index=True)
    ColorRGB(0xede6d6, "white-chocolate",                       register=True, index=True)
    ColorRGB(0xe6e0d4, "white-coffee",                          register=True, index=True)
    ColorRGB(0xb9a193, "white-mouse",                           register=True, index=True)
    ColorRGB(0xce9f6f, "white-oak",                             register=True, index=True)
    ColorRGB(0xc48e69, "white-tea",                             register=True, index=True)
    ColorRGB(0xa5ba93, "whitish-green",                         register=True, index=True)
    ColorRGB(0xa2add0, "wild-blue-yonder",                      register=True, index=True)
    ColorRGB(0xd470a2, "wild-orchid",                           register=True, index=True)
    ColorRGB(0xff43a4, "wild-strawberry",                       register=True, index=True)
    ColorRGB(0x8c9e5e, "willow-dye",                            register=True, index=True)
    ColorRGB(0x817b69, "willow-gray",                           register=True, index=True)
    ColorRGB(0x9c8a4d, "willow-tea",                            register=True, index=True)
    ColorRGB(0xfd5800, "willpower-orange",                      register=True, index=True)
    ColorRGB(0xab4c3d, "wilted-brown",                          register=True, index=True)
    ColorRGB(0xa75502, "windsor-tan",                           register=True, index=True)
    ColorRGB(0xb11226, "wine-red",                              register=True, index=True)
    ColorRGB(0xff007c, "winter-sky",                            register=True, index=True)
    ColorRGB(0xa0e6ff, "winter-wizard",                         register=True, index=True)
    ColorRGB(0x56887d, "wintergreen-dream",                     register=True, index=True)
    ColorRGB(0xc9a0dc, "wisteria",                              register=True, index=True, variation_map={
             0x89729e:   "fuji-iro" })
    ColorRGB(0x4d3b3c, "wisteria-and-burnt-bamboo",             register=True, index=True)
    ColorRGB(0x875f9a, "wisteria-purple",                       register=True, index=True)
    ColorRGB(0x738678, "xanadu",                                register=True, index=True)
    ColorRGB(0x0e7a0d, "xbox-green",                            register=True, index=True)
    ColorRGB(0xfd4900, "xiaomi-orange",                         register=True, index=True)
    ColorRGB(0x0f4d92, "yale-blue",                             register=True, index=True)
    ColorRGB(0x1c2841, "yankees-blue",                          register=True, index=True)
    ColorRGB(0xfce883, "yellow",                                register=True, index=True, variation_map={
             0xefcc00:   "munsell", 
             0xfedf00:   "pantone", 
             0xfefe33:   "ryb", 
             0x808000:   "xterm" })
    ColorRGB(0x9acd32, "yellow-green",                          register=True, index=True, variation_map={
             0x30b21a:   "color-wheel", 
             0xc5e384:   "crayola" })
    ColorRGB(0xffae42, "yellow-orange",                         register=True, index=True, variation_map={
             0xff9505:   "color-wheel" })
    ColorRGB(0xfff000, "yellow-rose",                           register=True, index=True)
    ColorRGB(0x896c39, "yellow-sea-pine-brown",                 register=True, index=True)
    ColorRGB(0x2e5090, "yin-mn-blue",                           register=True, index=True)
    ColorRGB(0x6b9362, "young-bamboo",                          register=True, index=True)
    ColorRGB(0xb2071d, "youtube-red",                           register=True, index=True)
    ColorRGB(0x0014a8, "zaffre",                                register=True, index=True)
    ColorRGB(0xebc2af, "zinnwaldite",                           register=True, index=True)
    ColorRGB(0x2c1608, "zinnwaldite-brown",                     register=True, index=True)
    ColorRGB(0x39a78e, "zomp",                                  register=True, index=True)
    # fmt: on
