"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzIdToNameMappingFunctionCodeCache = exports.AzIdToNameMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AzIdToNameMapping extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handlerPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'handlerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowSSMParameterEdit',
                    actions: [
                        'ssm:PutParameter',
                        'ssm:DeleteParameter',
                        'ssm:AddTagsToResource',
                    ],
                    resources: [
                        '*',
                    ],
                    conditions: {
                        StringEquals: {
                            'aws:ResourceTag/CdkAzMappingParameter': 'True',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowDescribeAZs',
                    actions: [
                        'ec2:DescribeAvailabilityZones',
                    ],
                    resources: [
                        '*',
                    ],
                }),
            ],
        });
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'handlerRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                handlerPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            handler: 'index.handler',
            description: 'Stores VPC mappings into parameter store',
            timeout: aws_cdk_lib_1.Duration.seconds(5),
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
            role,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler,
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        const mapping = new aws_cdk_lib_1.CustomResource(this, 'mapping', {
            serviceToken: provider.serviceToken,
            properties: {
                azIds: props.azIds || ['use1-az2', 'use1-az4', 'use1-az6'],
                prefix: props.ssmParameterPrefix || '/az-mapping/',
            },
        });
        this.mapping = mapping.getAtt('azIds').toString();
    }
}
exports.AzIdToNameMapping = AzIdToNameMapping;
_a = JSII_RTTI_SYMBOL_1;
AzIdToNameMapping[_a] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMapping", version: "0.0.41" };
class AzIdToNameMappingFunctionCodeCache extends aws_cdk_lib_1.aws_s3.Bucket {
    constructor(scope, id, props) {
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const autoDeleteObjects = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            removalPolicy,
            autoDeleteObjects,
            ...props,
        });
        /** Force the final unzipped asset to be a zip by nesting zips */
        const bundlingCmds = [
            'mkdir -p /asset-output',
            'mkdir -p temp',
            // 'pip install -r /asset-input/requirements.txt -t /asset-input/temp',
            'cp index.py /asset-input/temp/index.py',
            'cd temp',
            'zip -r lambda.zip .',
            'zip -r /asset-output/temp.zip lambda.zip',
            'cd ..',
            'rm -rf ./temp',
        ];
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'Deployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(path.join(__dirname, '../lambda'), {
                    bundling: {
                        image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                        command: [
                            'bash', '-c', bundlingCmds.join(' && '),
                        ],
                    },
                })],
            destinationBucket: this,
            exclude: ['__pycache__/*', '*.pyc'],
            include: ['*.py'],
        });
        this.lambdaCode = aws_cdk_lib_1.aws_lambda.Code.fromBucket(this, 'index.py');
    }
    /**
     * Add access to the whole organization to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgId The organization ID to require for any accounts accessing the bucket.
     */
    addOrgWideAccessPolicy(principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: [
                's3:GetObject',
            ],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified accounts to get
     * the lambda function code from the bucket.
     *
     * @param principalAccountId The account ID to add access for.
     * @param principalOrgId (Optional) The organization ID to require for the account accessing the bucket.
     */
    addAccountAccessPolicy(principalAccountId, principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal(principalAccountId)],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: principalOrgId === undefined ? undefined : {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified organizational units to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgPaths The organizational unit paths to add access for.
     */
    addOrgOuAccessPolicy(principalOrgPaths) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringLike: {
                    'aws:PrincipalOrgPaths': principalOrgPaths,
                },
            },
        }));
    }
}
exports.AzIdToNameMappingFunctionCodeCache = AzIdToNameMappingFunctionCodeCache;
_b = JSII_RTTI_SYMBOL_1;
AzIdToNameMappingFunctionCodeCache[_b] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMappingFunctionCodeCache", version: "0.0.41" };
;
//# sourceMappingURL=data:application/json;base64,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