# SCRIP

[![Documentation Status](https://readthedocs.org/projects/scrip/badge/?version=latest)](https://scrip.readthedocs.io/en/latest/?badge=latest)  


SCRIP(**S**ingle **C**ell **R**egulatory network **I**nference using ChI**P**-seq) is a tool for evaluating the binding enrichment of specific TR at single-cell resolution based on scATAC-seq.

## Documentation

For the detailed usage and examples of SCRIP, please refer to the [documentation](https://scriptscatac.readthedocs.io/en/latest/).  

## Installation

Dependency, please install them first:

```bash
libpng12-0 tabix
```

Install SCRIP

```bash
git clone git@github.com:wanglabtongji/SCRIP.git
cd SCRIP
python setup.py install
```

## Usage

### SCRIP all functions

```log
usage: SCRIP [-h] [--version] {enrich,impute,target,config} ...

SCRIP

positional arguments:
  {enrich,impute,target,config}
    enrich              Main function.
    impute              Imputation Factor function.
    target              Calculate targets based on factor peak count.
    config              Configuration.

optional arguments:
  -h, --help            show this help message and exit
  --version             show program's version number and exit

For command line options of each command, type: SCRIP COMMAND -h
```

### SCRIP enrich function  

```log
usage: SCRIP enrich [-h] -i FEATURE_MATRIX -s {hs,mm} [-p PROJECT] [--min_cells MIN_CELLS] [--min_peaks MIN_PEAKS] [--max_peaks MAX_PEAKS]
                     [-t N_CORES] [-y] [--clean]

optional arguments:
  -h, --help            show this help message and exit

Input files arguments:
  -i FEATURE_MATRIX, --input_feature_matrix FEATURE_MATRIX
                        A cell by peak matrix . REQUIRED.
  -s {hs,mm}, --species {hs,mm}
                        Species. "hs"(human) or "mm"(mouse). REQUIRED.

Output arguments:
  -p PROJECT, --project PROJECT
                        Project name, which will be used to generate output files folder. DEFAULT: Random generate.

Preprocessing paramater arguments:
  --min_cells MIN_CELLS
                        Minimal cell cutoff for features. Auto will take 0.05% of total cell number.DEFAULT: "auto".
  --min_peaks MIN_PEAKS
                        Minimal peak cutoff for cells. Auto will take the mean-3*std of all feature number (if less than 500 is 500). DEFAULT: "auto".
  --max_peaks MAX_PEAKS
                        Max peak cutoff for cells. This will help you to remove the doublet cells. Auto will take the mean+5*std of all feature
                        number. DEFAULT: "auto".

Other options:
  -t N_CORES, --thread N_CORES
                        Number of cores use to run SCRIP. DEFAULT: 16.
  -y, --yes             Whether ask for confirmation. DEFAULT: False.
  --clean               Whether delete tmp files(including bed and search results) generated by SCRIP. DEFAULT: False.
```

### SCRIP impute function

```log
usage: SCRIP impute [-h] -i FEATURE_MATRIX -s {hs,mm} [-p PROJECT] [-f {h5ad,mtx}] --factor FACTOR [--ref_baseline REF_BASELINE] [--remove_others]
                     [--min_cells MIN_CELLS] [--min_peaks MIN_PEAKS] [--max_peaks MAX_PEAKS] [-t N_CORES]

optional arguments:
  -h, --help            show this help message and exit

Input files arguments:
  -i FEATURE_MATRIX, --input_feature_matrix FEATURE_MATRIX
                        A cell by peak matrix. h5 or h5ad supported. REQUIRED.
  -s {hs,mm}, --species {hs,mm}
                        Species. "hs"(human) or "mm"(mouse). REQUIRED.

Output arguments:
  -p PROJECT, --project PROJECT
                        Project name, which will be used to generate output files folder. DEFAULT: Random generate.
  -f {h5ad,mtx}, --format {h5ad,mtx}
                        Format generate for output RP count. DEFAULT: h5ad.

Peak imputation paramater arguments:
  --factor FACTOR       The factor you want to impute. REQUIRED.
  --ref_baseline REF_BASELINE
                        Remove dataset which peaks number less than this value. DEFAULT: 500.
  --remove_others       Remove signal not from best match. DEFAULT: False.

Other options:
  --min_cells MIN_CELLS
                        Minimal cell cutoff for features. Auto will take 0.05% of total cell number.DEFAULT: "auto".
  --min_peaks MIN_PEAKS
                        Minimal peak cutoff for cells. Auto will take the mean-3*std of all feature number (if less than 500 is 500). DEFAULT: "auto".
  --max_peaks MAX_PEAKS
                        Max peak cutoff for cells. This will help you to remove the doublet cells. Auto will take the mean+5*std of all feature
                        number. DEFAULT: "auto".
  -t N_CORES, --thread N_CORES
                        Number of cores use to run SCRIP. DEFAULT: 16.
```

### SCRIP target function  

```log
usage: SCRIP target [-h] -i FEATURE_MATRIX -s {hs,mm} [-o OUTPUT] [-d DECAY]

optional arguments:
  -h, --help            show this help message and exit

Input files arguments:
  -i FEATURE_MATRIX, --input_feature_matrix FEATURE_MATRIX
                        A cell by peak matrix. h5 or h5ad supported. REQUIRED.
  -s {hs,mm}, --species {hs,mm}
                        Species. "hs"(human) or "mm"(mouse). REQUIRED.

Output arguments:
  -o OUTPUT, --output OUTPUT
                        output h5ad file. DEFAULT: RP.h5ad

Other options:
  -d DECAY, --decay DECAY
                        Range to the effect of peaks. DEFAULT: 10000.
```

### SCRIP config function  

```log
usage: SCRIP config [-h] [--show] [--human_tf_index HUMAN_TF_INDEX] [--human_hm_index HUMAN_HM_INDEX] [--mouse_tf_index MOUSE_TF_INDEX]
                     [--mouse_hm_index MOUSE_HM_INDEX]

optional arguments:
  -h, --help            show this help message and exit
  --show
  --human_tf_index HUMAN_TF_INDEX
  --human_hm_index HUMAN_HM_INDEX
  --mouse_tf_index MOUSE_TF_INDEX
  --mouse_hm_index MOUSE_HM_INDEX
```
