# Directory structure

The input and output files and directories of all *steinbock* CLI commands can be controlled via command-line options. However, without explicitly specifying input/output arguments, the following typical directory structure is assumed when working with the *steinbock* CLI:

    steinbock data/working directory
    |
    ├── raw                       (user-provided, if starting from raw data)
    |
    ├── img                       (user-provided, if not starting from raw data)
    ├── panel.csv                 (user-provided, if not starting from raw data)
    |
    ├── ilastik_img
    ├── ilastik_crops
    ├── pixel_classifier.ilp
    ├── ilastik_probabilities
    |
    ├── cell_segmentation.cppipe
    ├── masks
    |
    ├── intensities
    ├── regionprops
    └── neighbors

Depending on the choice of [preprocessing approaches](../cli/preprocessing.md), either the `raw` directory containing the raw data, or the `img` directory containing the images and a `panel.csv` file must be provided by the user. All other files and directories are generated by the *steinbock* Docker container when following a supported workflow.
