# Synopsis

This repository contains popular Machine Learning algorithms, which have been introduced in various blog posts (http://ataspinar.com). Most of the algorithms are accompanied with blog-posts in which I try to explain the mathematics behind and the interpretation of these algorithms. 


# Motivation
Machine Learning is fun! But more importantly, Machine Learning is easy. 
But the academic literature or even (wikipedia-pages) is full with unnecessary complicated terminology, notation and formulae. This gives people the idea that these ML algorithms can only be understood with a full understanding of advanced math and statistics. Stripped from all of these superfluous language we are left with simple maths which can be expressed in a few lines of code. 

# Notebooks explaining the mathematics
I have also provided some notebooks, explaining the mathematics of some Machine Learning algorithms. 
+ [Linear Regression and Logistic Regression](https://github.com/taspinar/siml/blob/master/notebooks/Linear%20Regression%2C%20Logistic%20Regression.ipynb)
+ [Naive Bayes Classification](https://github.com/taspinar/siml/blob/master/notebooks/Naive_Bayes.ipynb)
+ [Perceptron Classification](https://github.com/taspinar/siml/blob/master/notebooks/Perceptron.ipynb)

+ [Classification with Scikit-Learn](https://github.com/taspinar/siml/blob/master/notebooks/scikit_classification.ipynb)
+ [Machine Learning with Signal Analysis techniques](https://github.com/taspinar/siml/blob/master/notebooks/Machine%20Learning%20with%20Signal%20Processing%20techniques.ipynb)

# Notebooks explaining Machine Learning with the Wavelet Transform
+ [Introduction to PyWavelets (for Wavelet Analysis](https://github.com/taspinar/siml/blob/master/notebooks/WV1%20-%20Using%20PyWavelets%20for%20Wavelet%20Analysis.ipynb)
+ [Using Wavelets to Visualize the Scaleogram, time-axis and Fourier Transform](https://github.com/taspinar/siml/blob/master/notebooks/WV2%20-%20Visualizing%20the%20Scaleogram%2C%20time-axis%20and%20Fourier%20Transform.ipynb)
+ [Classification of signals using the Continuous Wavelet Transform and Convolutional Neural Networks](https://github.com/taspinar/siml/blob/master/notebooks/WV3%20-%20Classification%20of%20signals%20using%20the%20CWT%20and%20CNN.ipynb)
+ [Classification of ECG signals using the Discrete Wavelet Transform and Gradient Boosting](https://github.com/taspinar/siml/blob/master/notebooks/WV4%20-%20Classification%20of%20ECG%20signals%20using%20the%20Discrete%20Wavelet%20Transform.ipynb)
+ [Classification of signals using the Discrete Wavelet Transform and several classifiers](https://github.com/taspinar/siml/blob/master/notebooks/WV5%20-%20Classification%20of%20the%20UCI-HAR%20dataset%20using%20Discrete%20Wavelet%20Transform..ipynb)

# Installation
To install **siML**:
```python
(sudo) pip install siml
```

or you can clone the repository and in the folder containing setup.py
```python
python setup.py install
```


# Code Example
TODO
