from enum import Enum

from pygame import constants as c

__all__ = ("AudioFormatFlag", "ByteOrder", "PygameAppCode", "PygameBlendModes", "PygameEventCode", "PygameMouseFlags", "PygameScrapType", "PygameSurfaceFlags", "PygameUserEventCode", "SDL_AudioAllowChangeFlags", "SDL_BlendMode", "SDL_EventType", "SDL_GLattr", "SDL_GLcontextFlag", "SDL_GLcontextReleaseFlag", "SDL_GLprofile", "SDL_GameControllerAxis", "SDL_GameControllerButton", "SDL_HatPositions", "SDL_KeyCode", "SDL_Keymod", "SDL_Scancode", "SDL_SystemCursor", "ScrapClipType", "PyamerTimerConstants")


# class AccessWrapper:
#     def __init__(self, wrapped):
#         self.wrapped = wrapped
#         self._accessed = set()
#         self._aliases = {
#             "BLEND_RGB_ADD", "BLEND_RGB_SUB", "BLEND_RGB_MULT", "BLEND_RGB_MIN", "BLEND_RGB_MAX",
#             "K_KP0", "K_KP1", "K_KP2", "K_KP3", "K_KP4", "K_KP5", "K_KP6", "K_KP7", "K_KP8", "K_KP9",
#             "KSCAN_KP0", "KSCAN_KP1", "KSCAN_KP2", "KSCAN_KP3", "KSCAN_KP4", "KSCAN_KP5", "KSCAN_KP6", "KSCAN_KP7", "KSCAN_KP8", "KSCAN_KP9",
#             "K_LMETA", "K_RMETA", "K_LSUPER", "K_RSUPER", "KMOD_LMETA", "KMOD_RMETA", "KMOD_META",
#             "KSCAN_LMETA", "KSCAN_RMETA", "KSCAN_LSUPER", "KSCAN_RSUPER",
#             "K_NUMLOCK", "K_SCROLLOCK", "K_PRINT", "K_BREAK", "K_EURO", 
#             "KSCAN_NUMLOCK", "KSCAN_SCROLLOCK", "KSCAN_PRINT", "KSCAN_BREAK", "KSCAN_EURO",
#             "GL_SWAP_CONTROL"
#         }

#     def __getattr__(self, key):
#         self._accessed.add(key)
#         return getattr(self.wrapped, key)

#     @property
#     def _unaccessed(self):
#         all_attrs = set(a for a in dir(self.wrapped) if a[:1] != "_")
#         return list(all_attrs - self._aliases - self._accessed)


# c = AccessWrapper(c)


class ByteOrder(Enum):
    LIL_ENDIAN = c.LIL_ENDIAN
    BIG_ENDIAN = c.BIG_ENDIAN


class PygameSurfaceFlags(Enum):
    SWSURFACE = c.SWSURFACE
    HWSURFACE = c.HWSURFACE
    RESIZABLE = c.RESIZABLE
    ASYNCBLIT = c.ASYNCBLIT
    OPENGL = c.OPENGL
    OPENGLBLIT = c.OPENGLBLIT
    ANYFORMAT = c.ANYFORMAT
    HWPALETTE = c.HWPALETTE
    DOUBLEBUF = c.DOUBLEBUF
    FULLSCREEN = c.FULLSCREEN
    HWACCEL = c.HWACCEL
    SRCCOLORKEY = c.SRCCOLORKEY
    RLEACCELOK = c.RLEACCELOK
    RLEACCEL = c.RLEACCEL
    SRCALPHA = c.SRCALPHA
    PREALLOC = c.PREALLOC
    NOFRAME = c.NOFRAME
    SHOWN = c.SHOWN
    HIDDEN = c.HIDDEN
    SCALED = c.SCALED


class SDL_GLattr(Enum):
    GL_RED_SIZE = c.GL_RED_SIZE
    GL_GREEN_SIZE = c.GL_GREEN_SIZE
    GL_BLUE_SIZE = c.GL_BLUE_SIZE
    GL_ALPHA_SIZE = c.GL_ALPHA_SIZE
    GL_BUFFER_SIZE = c.GL_BUFFER_SIZE
    GL_DOUBLEBUFFER = c.GL_DOUBLEBUFFER
    GL_DEPTH_SIZE = c.GL_DEPTH_SIZE
    GL_STENCIL_SIZE = c.GL_STENCIL_SIZE
    GL_ACCUM_RED_SIZE = c.GL_ACCUM_RED_SIZE
    GL_ACCUM_GREEN_SIZE = c.GL_ACCUM_GREEN_SIZE
    GL_ACCUM_BLUE_SIZE = c.GL_ACCUM_BLUE_SIZE
    GL_ACCUM_ALPHA_SIZE = c.GL_ACCUM_ALPHA_SIZE
    GL_STEREO = c.GL_STEREO
    GL_MULTISAMPLEBUFFERS = c.GL_MULTISAMPLEBUFFERS
    GL_MULTISAMPLESAMPLES = c.GL_MULTISAMPLESAMPLES
    GL_ACCELERATED_VISUAL = c.GL_ACCELERATED_VISUAL
    GL_CONTEXT_MAJOR_VERSION = c.GL_CONTEXT_MAJOR_VERSION
    GL_CONTEXT_MINOR_VERSION = c.GL_CONTEXT_MINOR_VERSION
    GL_CONTEXT_FLAGS = c.GL_CONTEXT_FLAGS
    GL_CONTEXT_PROFILE_MASK = c.GL_CONTEXT_PROFILE_MASK
    GL_SHARE_WITH_CURRENT_CONTEXT = c.GL_SHARE_WITH_CURRENT_CONTEXT
    GL_FRAMEBUFFER_SRGB_CAPABLE = c.GL_FRAMEBUFFER_SRGB_CAPABLE
    GL_CONTEXT_RELEASE_BEHAVIOR = c.GL_CONTEXT_RELEASE_BEHAVIOR


class SDL_GLcontextFlag(Enum):
    GL_CONTEXT_DEBUG_FLAG = c.GL_CONTEXT_DEBUG_FLAG
    GL_CONTEXT_FORWARD_COMPATIBLE_FLAG = c.GL_CONTEXT_FORWARD_COMPATIBLE_FLAG
    GL_CONTEXT_ROBUST_ACCESS_FLAG = c.GL_CONTEXT_ROBUST_ACCESS_FLAG
    GL_CONTEXT_RESET_ISOLATION_FLAG = c.GL_CONTEXT_RESET_ISOLATION_FLAG


class SDL_GLprofile(Enum):
    GL_CONTEXT_PROFILE_CORE = c.GL_CONTEXT_PROFILE_CORE
    GL_CONTEXT_PROFILE_COMPATIBILITY = c.GL_CONTEXT_PROFILE_COMPATIBILITY
    GL_CONTEXT_PROFILE_ES = c.GL_CONTEXT_PROFILE_ES


class SDL_GLcontextReleaseFlag(Enum):
    GL_CONTEXT_RELEASE_BEHAVIOR_NONE = c.GL_CONTEXT_RELEASE_BEHAVIOR_NONE
    GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = c.GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH


class SDL_BlendMode(Enum):
    BLENDMODE_NONE = c.BLENDMODE_NONE
    BLENDMODE_BLEND = c.BLENDMODE_BLEND
    BLENDMODE_ADD = c.BLENDMODE_ADD
    BLENDMODE_MOD = c.BLENDMODE_MOD


class AudioFormatFlag(Enum):
    AUDIO_U8 = c.AUDIO_U8
    AUDIO_S8 = c.AUDIO_S8
    AUDIO_U16LSB = c.AUDIO_U16LSB
    AUDIO_S16LSB = c.AUDIO_S16LSB
    AUDIO_U16MSB = c.AUDIO_U16MSB
    AUDIO_S16MSB = c.AUDIO_S16MSB
    AUDIO_U16 = c.AUDIO_U16
    AUDIO_S16 = c.AUDIO_S16
    AUDIO_U16SYS = c.AUDIO_U16SYS
    AUDIO_S16SYS = c.AUDIO_S16SYS


class PygameScrapType(Enum):
    SCRAP_TEXT = c.SCRAP_TEXT
    SCRAP_BMP = c.SCRAP_BMP
    SCRAP_PPM = c.SCRAP_PPM
    SCRAP_PBM = c.SCRAP_PBM


class ScrapClipType(Enum):
    SCRAP_CLIPBOARD = c.SCRAP_CLIPBOARD
    SCRAP_SELECTION = c.SCRAP_SELECTION


class PygameBlendModes(Enum):
    BLEND_ADD = BLEND_RGB_ADD = c.BLEND_ADD
    BLEND_SUB = BLEND_RGB_SUB = c.BLEND_SUB
    BLEND_MULT = BLEND_RGB_MULT = c.BLEND_MULT
    BLEND_MIN = BLEND_RGB_MIN = c.BLEND_MIN
    BLEND_MAX = BLEND_RGB_MAX = c.BLEND_MAX
    BLEND_RGBA_ADD = c.BLEND_RGBA_ADD
    BLEND_RGBA_SUB = c.BLEND_RGBA_SUB
    BLEND_RGBA_MULT = c.BLEND_RGBA_MULT
    BLEND_RGBA_MIN = c.BLEND_RGBA_MIN
    BLEND_RGBA_MAX = c.BLEND_RGBA_MAX
    BLEND_PREMULTIPLIED = c.BLEND_PREMULTIPLIED
    BLEND_ALPHA_SDL2 = c.BLEND_ALPHA_SDL2


class PygameEventCode(Enum):
    NOEVENT = c.NOEVENT
    ACTIVEEVENT = c.ACTIVEEVENT
    VIDEORESIZE = c.VIDEORESIZE
    VIDEOEXPOSE = c.VIDEOEXPOSE
    MIDIIN = c.MIDIIN
    MIDIOUT = c.MIDIOUT
    WINDOWSHOWN = c.WINDOWSHOWN
    WINDOWHIDDEN = c.WINDOWHIDDEN
    WINDOWEXPOSED = c.WINDOWEXPOSED
    WINDOWMOVED = c.WINDOWMOVED
    WINDOWRESIZED = c.WINDOWRESIZED
    WINDOWSIZECHANGED = c.WINDOWSIZECHANGED
    WINDOWMINIMIZED = c.WINDOWMINIMIZED
    WINDOWMAXIMIZED = c.WINDOWMAXIMIZED
    WINDOWRESTORED = c.WINDOWRESTORED
    WINDOWENTER = c.WINDOWENTER
    WINDOWLEAVE = c.WINDOWLEAVE
    WINDOWFOCUSGAINED = c.WINDOWFOCUSGAINED
    WINDOWFOCUSLOST = c.WINDOWFOCUSLOST
    WINDOWCLOSE = c.WINDOWCLOSE
    WINDOWTAKEFOCUS = c.WINDOWTAKEFOCUS
    WINDOWHITTEST = c.WINDOWHITTEST
    USEREVENT = c.USEREVENT
    NUMEVENTS = c.NUMEVENTS


class PygameUserEventCode(Enum):
    USEREVENT_DROPFILE = c.USEREVENT_DROPFILE


class PygameMouseFlags(Enum):
    BUTTON_LEFT = c.BUTTON_LEFT
    BUTTON_MIDDLE = c.BUTTON_MIDDLE
    BUTTON_RIGHT = c.BUTTON_RIGHT
    BUTTON_WHEELUP = c.BUTTON_WHEELUP
    BUTTON_WHEELDOWN = c.BUTTON_WHEELDOWN
    BUTTON_X1 = c.BUTTON_X1
    BUTTON_X2 = c.BUTTON_X2


class SDL_EventType(Enum):
    QUIT = c.QUIT
    SYSWMEVENT = c.SYSWMEVENT
    KEYDOWN = c.KEYDOWN
    KEYUP = c.KEYUP
    TEXTEDITING = c.TEXTEDITING
    TEXTINPUT = c.TEXTINPUT
    MOUSEMOTION = c.MOUSEMOTION
    MOUSEBUTTONDOWN = c.MOUSEBUTTONDOWN
    MOUSEBUTTONUP = c.MOUSEBUTTONUP
    MOUSEWHEEL = c.MOUSEWHEEL
    JOYAXISMOTION = c.JOYAXISMOTION
    JOYBALLMOTION = c.JOYBALLMOTION
    JOYHATMOTION = c.JOYHATMOTION
    JOYBUTTONDOWN = c.JOYBUTTONDOWN
    JOYBUTTONUP = c.JOYBUTTONUP
    JOYDEVICEADDED = c.JOYDEVICEADDED
    JOYDEVICEREMOVED = c.JOYDEVICEREMOVED
    CONTROLLERAXISMOTION = c.CONTROLLERAXISMOTION
    CONTROLLERBUTTONDOWN = c.CONTROLLERBUTTONDOWN
    CONTROLLERBUTTONUP = c.CONTROLLERBUTTONUP
    CONTROLLERDEVICEADDED = c.CONTROLLERDEVICEADDED
    CONTROLLERDEVICEREMOVED = c.CONTROLLERDEVICEREMOVED
    CONTROLLERDEVICEREMAPPED = c.CONTROLLERDEVICEREMAPPED
    FINGERDOWN = c.FINGERDOWN
    FINGERUP = c.FINGERUP
    FINGERMOTION = c.FINGERMOTION
    MULTIGESTURE = c.MULTIGESTURE
    DROPFILE = c.DROPFILE
    DROPTEXT = c.DROPTEXT
    DROPBEGIN = c.DROPBEGIN
    DROPCOMPLETE = c.DROPCOMPLETE
    AUDIODEVICEADDED = c.AUDIODEVICEADDED
    AUDIODEVICEREMOVED = c.AUDIODEVICEREMOVED


class SDL_HatPositions(Enum):
    HAT_CENTERED = c.HAT_CENTERED
    HAT_UP = c.HAT_UP
    HAT_RIGHT = c.HAT_RIGHT
    HAT_DOWN = c.HAT_DOWN
    HAT_LEFT = c.HAT_LEFT
    HAT_RIGHTUP = c.HAT_RIGHTUP
    HAT_RIGHTDOWN = c.HAT_RIGHTDOWN
    HAT_LEFTDOWN = c.HAT_LEFTDOWN
    HAT_LEFTUP = c.HAT_LEFTUP


class SDL_AudioAllowChangeFlags(Enum):
    AUDIO_ALLOW_FREQUENCY_CHANGE = c.AUDIO_ALLOW_FREQUENCY_CHANGE
    AUDIO_ALLOW_FORMAT_CHANGE = c.AUDIO_ALLOW_FORMAT_CHANGE
    AUDIO_ALLOW_CHANNELS_CHANGE = c.AUDIO_ALLOW_CHANNELS_CHANGE
    AUDIO_ALLOW_ANY_CHANGE = c.AUDIO_ALLOW_ANY_CHANGE


class SDL_GameControllerAxis(Enum):
    CONTROLLER_AXIS_INVALID = c.CONTROLLER_AXIS_INVALID
    CONTROLLER_AXIS_LEFTX = c.CONTROLLER_AXIS_LEFTX
    CONTROLLER_AXIS_LEFTY = c.CONTROLLER_AXIS_LEFTY
    CONTROLLER_AXIS_RIGHTX = c.CONTROLLER_AXIS_RIGHTX
    CONTROLLER_AXIS_RIGHTY = c.CONTROLLER_AXIS_RIGHTY
    CONTROLLER_AXIS_TRIGGERLEFT = c.CONTROLLER_AXIS_TRIGGERLEFT
    CONTROLLER_AXIS_TRIGGERRIGHT = c.CONTROLLER_AXIS_TRIGGERRIGHT
    CONTROLLER_AXIS_MAX = c.CONTROLLER_AXIS_MAX


class SDL_GameControllerButton(Enum):
    CONTROLLER_BUTTON_INVALID = c.CONTROLLER_BUTTON_INVALID
    CONTROLLER_BUTTON_A = c.CONTROLLER_BUTTON_A
    CONTROLLER_BUTTON_B = c.CONTROLLER_BUTTON_B
    CONTROLLER_BUTTON_X = c.CONTROLLER_BUTTON_X
    CONTROLLER_BUTTON_Y = c.CONTROLLER_BUTTON_Y
    CONTROLLER_BUTTON_BACK = c.CONTROLLER_BUTTON_BACK
    CONTROLLER_BUTTON_GUIDE = c.CONTROLLER_BUTTON_GUIDE
    CONTROLLER_BUTTON_START = c.CONTROLLER_BUTTON_START
    CONTROLLER_BUTTON_LEFTSTICK = c.CONTROLLER_BUTTON_LEFTSTICK
    CONTROLLER_BUTTON_RIGHTSTICK = c.CONTROLLER_BUTTON_RIGHTSTICK
    CONTROLLER_BUTTON_LEFTSHOULDER = c.CONTROLLER_BUTTON_LEFTSHOULDER
    CONTROLLER_BUTTON_RIGHTSHOULDER = c.CONTROLLER_BUTTON_RIGHTSHOULDER
    CONTROLLER_BUTTON_DPAD_UP = c.CONTROLLER_BUTTON_DPAD_UP
    CONTROLLER_BUTTON_DPAD_DOWN = c.CONTROLLER_BUTTON_DPAD_DOWN
    CONTROLLER_BUTTON_DPAD_LEFT = c.CONTROLLER_BUTTON_DPAD_LEFT
    CONTROLLER_BUTTON_DPAD_RIGHT = c.CONTROLLER_BUTTON_DPAD_RIGHT
    CONTROLLER_BUTTON_MAX = c.CONTROLLER_BUTTON_MAX


class SDL_KeyCode(Enum):
    K_AC_BACK = c.K_AC_BACK
    K_UNKNOWN = c.K_UNKNOWN
    K_BACKSPACE = c.K_BACKSPACE
    K_TAB = c.K_TAB
    K_CLEAR = c.K_CLEAR
    K_RETURN = c.K_RETURN
    K_ESCAPE = c.K_ESCAPE
    K_SPACE = c.K_SPACE
    K_QUOTE = c.K_QUOTE
    K_COMMA = c.K_COMMA
    K_MINUS = c.K_MINUS
    K_PERIOD = c.K_PERIOD
    K_SLASH = c.K_SLASH
    K_0 = c.K_0
    K_1 = c.K_1
    K_2 = c.K_2
    K_3 = c.K_3
    K_4 = c.K_4
    K_5 = c.K_5
    K_6 = c.K_6
    K_7 = c.K_7
    K_8 = c.K_8
    K_9 = c.K_9
    K_SEMICOLON = c.K_SEMICOLON
    K_EQUALS = c.K_EQUALS
    K_LEFTBRACKET = c.K_LEFTBRACKET
    K_BACKSLASH = c.K_BACKSLASH
    K_RIGHTBRACKET = c.K_RIGHTBRACKET
    K_BACKQUOTE = c.K_BACKQUOTE
    K_a = c.K_a
    K_b = c.K_b
    K_c = c.K_c
    K_d = c.K_d
    K_e = c.K_e
    K_f = c.K_f
    K_g = c.K_g
    K_h = c.K_h
    K_i = c.K_i
    K_j = c.K_j
    K_k = c.K_k
    K_l = c.K_l
    K_m = c.K_m
    K_n = c.K_n
    K_o = c.K_o
    K_p = c.K_p
    K_q = c.K_q
    K_r = c.K_r
    K_s = c.K_s
    K_t = c.K_t
    K_u = c.K_u
    K_v = c.K_v
    K_w = c.K_w
    K_x = c.K_x
    K_y = c.K_y
    K_z = c.K_z
    K_DELETE = c.K_DELETE
    K_KP_0 = K_KP0 = c.K_KP_0
    K_KP_1 = K_KP1 = c.K_KP_1
    K_KP_2 = K_KP2 = c.K_KP_2
    K_KP_3 = K_KP3 = c.K_KP_3
    K_KP_4 = K_KP4 = c.K_KP_4
    K_KP_5 = K_KP5 = c.K_KP_5
    K_KP_6 = K_KP6 = c.K_KP_6
    K_KP_7 = K_KP7 = c.K_KP_7
    K_KP_8 = K_KP8 = c.K_KP_8
    K_KP_9 = K_KP9 = c.K_KP_9
    K_KP_PERIOD = c.K_KP_PERIOD
    K_KP_DIVIDE = c.K_KP_DIVIDE
    K_KP_MULTIPLY = c.K_KP_MULTIPLY
    K_KP_MINUS = c.K_KP_MINUS
    K_KP_PLUS = c.K_KP_PLUS
    K_KP_ENTER = c.K_KP_ENTER
    K_KP_EQUALS = c.K_KP_EQUALS
    K_UP = c.K_UP
    K_DOWN = c.K_DOWN
    K_RIGHT = c.K_RIGHT
    K_LEFT = c.K_LEFT
    K_INSERT = c.K_INSERT
    K_HOME = c.K_HOME
    K_END = c.K_END
    K_PAGEUP = c.K_PAGEUP
    K_PAGEDOWN = c.K_PAGEDOWN
    K_F1 = c.K_F1
    K_F2 = c.K_F2
    K_F3 = c.K_F3
    K_F4 = c.K_F4
    K_F5 = c.K_F5
    K_F6 = c.K_F6
    K_F7 = c.K_F7
    K_F8 = c.K_F8
    K_F9 = c.K_F9
    K_F10 = c.K_F10
    K_F11 = c.K_F11
    K_F12 = c.K_F12
    K_F13 = c.K_F13
    K_F14 = c.K_F14
    K_F15 = c.K_F15
    K_NUMLOCKCLEAR = K_NUMLOCK = c.K_NUMLOCKCLEAR
    K_CAPSLOCK = c.K_CAPSLOCK
    K_SCROLLLOCK = K_SCROLLOCK = c.K_SCROLLLOCK
    K_RSHIFT = c.K_RSHIFT
    K_LSHIFT = c.K_LSHIFT
    K_RCTRL = c.K_RCTRL
    K_LCTRL = c.K_LCTRL
    K_RALT = c.K_RALT
    K_LALT = c.K_LALT
    K_LGUI = K_LMETA = K_LSUPER = c.K_LGUI
    K_RGUI = K_RMETA = K_RSUPER = c.K_RGUI
    K_MODE = c.K_MODE
    K_HELP = c.K_HELP
    K_PRINTSCREEN = K_PRINT = c.K_PRINTSCREEN
    K_SYSREQ = c.K_SYSREQ
    K_PAUSE = K_BREAK = c.K_PAUSE
    K_MENU = c.K_MENU
    K_POWER = c.K_POWER
    K_CURRENCYUNIT = K_EURO = c.K_CURRENCYUNIT
    K_CURRENCYSUBUNIT = c.K_CURRENCYSUBUNIT
    K_EXCLAIM = c.K_EXCLAIM
    K_QUOTEDBL = c.K_QUOTEDBL
    K_HASH = c.K_HASH
    K_DOLLAR = c.K_DOLLAR
    K_AMPERSAND = c.K_AMPERSAND
    K_PERCENT = c.K_PERCENT
    K_LEFTPAREN = c.K_LEFTPAREN
    K_RIGHTPAREN = c.K_RIGHTPAREN
    K_ASTERISK = c.K_ASTERISK
    K_PLUS = c.K_PLUS
    K_COLON = c.K_COLON
    K_LESS = c.K_LESS
    K_GREATER = c.K_GREATER
    K_QUESTION = c.K_QUESTION
    K_AT = c.K_AT
    K_CARET = c.K_CARET
    K_UNDERSCORE = c.K_UNDERSCORE


class SDL_Keymod(Enum):
    KMOD_NONE = c.KMOD_NONE
    KMOD_LSHIFT = c.KMOD_LSHIFT
    KMOD_RSHIFT = c.KMOD_RSHIFT
    KMOD_LCTRL = c.KMOD_LCTRL
    KMOD_RCTRL = c.KMOD_RCTRL
    KMOD_LALT = c.KMOD_LALT
    KMOD_RALT = c.KMOD_RALT
    KMOD_LGUI = KMOD_LMETA = c.KMOD_LGUI
    KMOD_RGUI = KMOD_RMETA = c.KMOD_RGUI
    KMOD_NUM = c.KMOD_NUM
    KMOD_CAPS = c.KMOD_CAPS
    KMOD_MODE = c.KMOD_MODE

    KMOD_CTRL = c.KMOD_CTRL
    KMOD_SHIFT = c.KMOD_SHIFT
    KMOD_ALT = c.KMOD_ALT
    KMOD_GUI = KMOD_META = c.KMOD_GUI


class SDL_Scancode(Enum):
    KSCAN_AC_BACK = c.KSCAN_AC_BACK
    KSCAN_UNKNOWN = c.KSCAN_UNKNOWN
    KSCAN_BACKSPACE = c.KSCAN_BACKSPACE
    KSCAN_TAB = c.KSCAN_TAB
    KSCAN_CLEAR = c.KSCAN_CLEAR
    KSCAN_RETURN = c.KSCAN_RETURN
    KSCAN_ESCAPE = c.KSCAN_ESCAPE
    KSCAN_SPACE = c.KSCAN_SPACE
    KSCAN_APOSTROPHE = c.KSCAN_APOSTROPHE
    KSCAN_COMMA = c.KSCAN_COMMA
    KSCAN_MINUS = c.KSCAN_MINUS
    KSCAN_PERIOD = c.KSCAN_PERIOD
    KSCAN_SLASH = c.KSCAN_SLASH
    KSCAN_0 = c.KSCAN_0
    KSCAN_1 = c.KSCAN_1
    KSCAN_2 = c.KSCAN_2
    KSCAN_3 = c.KSCAN_3
    KSCAN_4 = c.KSCAN_4
    KSCAN_5 = c.KSCAN_5
    KSCAN_6 = c.KSCAN_6
    KSCAN_7 = c.KSCAN_7
    KSCAN_8 = c.KSCAN_8
    KSCAN_9 = c.KSCAN_9
    KSCAN_SEMICOLON = c.KSCAN_SEMICOLON
    KSCAN_EQUALS = c.KSCAN_EQUALS
    KSCAN_LEFTBRACKET = c.KSCAN_LEFTBRACKET
    KSCAN_BACKSLASH = c.KSCAN_BACKSLASH
    KSCAN_RIGHTBRACKET = c.KSCAN_RIGHTBRACKET
    KSCAN_GRAVE = c.KSCAN_GRAVE
    KSCAN_A = c.KSCAN_A
    KSCAN_B = c.KSCAN_B
    KSCAN_C = c.KSCAN_C
    KSCAN_D = c.KSCAN_D
    KSCAN_E = c.KSCAN_E
    KSCAN_F = c.KSCAN_F
    KSCAN_G = c.KSCAN_G
    KSCAN_H = c.KSCAN_H
    KSCAN_I = c.KSCAN_I
    KSCAN_J = c.KSCAN_J
    KSCAN_K = c.KSCAN_K
    KSCAN_L = c.KSCAN_L
    KSCAN_M = c.KSCAN_M
    KSCAN_N = c.KSCAN_N
    KSCAN_O = c.KSCAN_O
    KSCAN_P = c.KSCAN_P
    KSCAN_Q = c.KSCAN_Q
    KSCAN_R = c.KSCAN_R
    KSCAN_S = c.KSCAN_S
    KSCAN_T = c.KSCAN_T
    KSCAN_U = c.KSCAN_U
    KSCAN_V = c.KSCAN_V
    KSCAN_W = c.KSCAN_W
    KSCAN_X = c.KSCAN_X
    KSCAN_Y = c.KSCAN_Y
    KSCAN_Z = c.KSCAN_Z
    KSCAN_DELETE = c.KSCAN_DELETE

    KSCAN_KP_0 = KSCAN_KP0 = c.KSCAN_KP_0
    KSCAN_KP_1 = KSCAN_KP1 = c.KSCAN_KP_1
    KSCAN_KP_2 = KSCAN_KP2 = c.KSCAN_KP_2
    KSCAN_KP_3 = KSCAN_KP3 = c.KSCAN_KP_3
    KSCAN_KP_4 = KSCAN_KP4 = c.KSCAN_KP_4
    KSCAN_KP_5 = KSCAN_KP5 = c.KSCAN_KP_5
    KSCAN_KP_6 = KSCAN_KP6 = c.KSCAN_KP_6
    KSCAN_KP_7 = KSCAN_KP7 = c.KSCAN_KP_7
    KSCAN_KP_8 = KSCAN_KP8 = c.KSCAN_KP_8
    KSCAN_KP_9 = KSCAN_KP9 = c.KSCAN_KP_9
    KSCAN_KP_PERIOD = c.KSCAN_KP_PERIOD
    KSCAN_KP_DIVIDE = c.KSCAN_KP_DIVIDE
    KSCAN_KP_MULTIPLY = c.KSCAN_KP_MULTIPLY
    KSCAN_KP_MINUS = c.KSCAN_KP_MINUS
    KSCAN_KP_PLUS = c.KSCAN_KP_PLUS
    KSCAN_KP_ENTER = c.KSCAN_KP_ENTER
    KSCAN_KP_EQUALS = c.KSCAN_KP_EQUALS
    KSCAN_UP = c.KSCAN_UP
    KSCAN_DOWN = c.KSCAN_DOWN
    KSCAN_RIGHT = c.KSCAN_RIGHT
    KSCAN_LEFT = c.KSCAN_LEFT
    KSCAN_INSERT = c.KSCAN_INSERT
    KSCAN_HOME = c.KSCAN_HOME
    KSCAN_END = c.KSCAN_END
    KSCAN_PAGEUP = c.KSCAN_PAGEUP
    KSCAN_PAGEDOWN = c.KSCAN_PAGEDOWN
    KSCAN_F1 = c.KSCAN_F1
    KSCAN_F2 = c.KSCAN_F2
    KSCAN_F3 = c.KSCAN_F3
    KSCAN_F4 = c.KSCAN_F4
    KSCAN_F5 = c.KSCAN_F5
    KSCAN_F6 = c.KSCAN_F6
    KSCAN_F7 = c.KSCAN_F7
    KSCAN_F8 = c.KSCAN_F8
    KSCAN_F9 = c.KSCAN_F9
    KSCAN_F10 = c.KSCAN_F10
    KSCAN_F11 = c.KSCAN_F11
    KSCAN_F12 = c.KSCAN_F12
    KSCAN_F13 = c.KSCAN_F13
    KSCAN_F14 = c.KSCAN_F14
    KSCAN_F15 = c.KSCAN_F15

    KSCAN_NUMLOCKCLEAR = KSCAN_NUMLOCK = c.KSCAN_NUMLOCKCLEAR
    KSCAN_CAPSLOCK = c.KSCAN_CAPSLOCK
    KSCAN_SCROLLLOCK = KSCAN_SCROLLOCK = c.KSCAN_SCROLLLOCK
    KSCAN_RSHIFT = c.KSCAN_RSHIFT
    KSCAN_LSHIFT = c.KSCAN_LSHIFT
    KSCAN_RCTRL = c.KSCAN_RCTRL
    KSCAN_LCTRL = c.KSCAN_LCTRL
    KSCAN_RALT = c.KSCAN_RALT
    KSCAN_LALT = c.KSCAN_LALT
    KSCAN_RGUI = KSCAN_RMETA = KSCAN_RSUPER = c.KSCAN_RGUI
    KSCAN_LGUI = KSCAN_LMETA = KSCAN_LSUPER = c.KSCAN_LGUI
    KSCAN_MODE = c.KSCAN_MODE

    KSCAN_HELP = c.KSCAN_HELP
    KSCAN_PRINTSCREEN = KSCAN_PRINT = c.KSCAN_PRINTSCREEN
    KSCAN_SYSREQ = c.KSCAN_SYSREQ
    KSCAN_PAUSE = KSCAN_BREAK = c.KSCAN_PAUSE
    KSCAN_MENU = c.KSCAN_MENU
    KSCAN_POWER = c.KSCAN_POWER
    KSCAN_CURRENCYUNIT = KSCAN_EURO = c.KSCAN_CURRENCYUNIT
    KSCAN_CURRENCYSUBUNIT = c.KSCAN_CURRENCYSUBUNIT

    KSCAN_INTERNATIONAL1 = c.KSCAN_INTERNATIONAL1
    KSCAN_INTERNATIONAL2 = c.KSCAN_INTERNATIONAL2
    KSCAN_INTERNATIONAL3 = c.KSCAN_INTERNATIONAL3
    KSCAN_INTERNATIONAL4 = c.KSCAN_INTERNATIONAL4
    KSCAN_INTERNATIONAL5 = c.KSCAN_INTERNATIONAL5
    KSCAN_INTERNATIONAL6 = c.KSCAN_INTERNATIONAL6
    KSCAN_INTERNATIONAL7 = c.KSCAN_INTERNATIONAL7
    KSCAN_INTERNATIONAL8 = c.KSCAN_INTERNATIONAL8
    KSCAN_INTERNATIONAL9 = c.KSCAN_INTERNATIONAL9
    KSCAN_LANG1 = c.KSCAN_LANG1
    KSCAN_LANG2 = c.KSCAN_LANG2
    KSCAN_LANG3 = c.KSCAN_LANG3
    KSCAN_LANG4 = c.KSCAN_LANG4
    KSCAN_LANG5 = c.KSCAN_LANG5
    KSCAN_LANG6 = c.KSCAN_LANG6
    KSCAN_LANG7 = c.KSCAN_LANG7
    KSCAN_LANG8 = c.KSCAN_LANG8
    KSCAN_LANG9 = c.KSCAN_LANG9
    KSCAN_NONUSBACKSLASH = c.KSCAN_NONUSBACKSLASH
    KSCAN_NONUSHASH = c.KSCAN_NONUSHASH


class PygameAppCode(Enum):
    APPFOCUSMOUSE = c.APPFOCUSMOUSE
    APPINPUTFOCUS = c.APPINPUTFOCUS
    APPACTIVE = c.APPACTIVE


class SDL_SystemCursor(Enum):
    SYSTEM_CURSOR_ARROW = c.SYSTEM_CURSOR_ARROW
    SYSTEM_CURSOR_IBEAM = c.SYSTEM_CURSOR_IBEAM
    SYSTEM_CURSOR_WAIT = c.SYSTEM_CURSOR_WAIT
    SYSTEM_CURSOR_CROSSHAIR = c.SYSTEM_CURSOR_CROSSHAIR
    SYSTEM_CURSOR_WAITARROW = c.SYSTEM_CURSOR_WAITARROW
    SYSTEM_CURSOR_SIZENWSE = c.SYSTEM_CURSOR_SIZENWSE
    SYSTEM_CURSOR_SIZENESW = c.SYSTEM_CURSOR_SIZENESW
    SYSTEM_CURSOR_SIZEWE = c.SYSTEM_CURSOR_SIZEWE
    SYSTEM_CURSOR_SIZENS = c.SYSTEM_CURSOR_SIZENS
    SYSTEM_CURSOR_SIZEALL = c.SYSTEM_CURSOR_SIZEALL
    SYSTEM_CURSOR_NO = c.SYSTEM_CURSOR_NO
    SYSTEM_CURSOR_HAND = c.SYSTEM_CURSOR_HAND


class PyamerTimerConstants(Enum):
    TIMER_RESOLUTION = c.TIMER_RESOLUTION


# if __name__ == "__main__":
#     print(c._unaccessed)
