import React from 'react';
import { classNames } from '../../utils/classNames';
/**
 * A wrapper component around the selectors that create dropdowns in the toolbar
 * that allows the user to see all the editing options Mito supports.
 *
 * If one of these dropdowns is open and you mouse over a different dropdown, it will
 * switch to that new one.
 */
const ToolbarDropdownSelector = (props) => {
    const selected = props.uiState.currOpenToolbarDropdown === props.type;
    return (React.createElement("div", null,
        React.createElement("p", { className: classNames('toolbar-dropdown-selector', { 'toolbar-dropdown-selector-selected': selected }), onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: props.type });
                });
            }, onMouseEnter: () => {
                props.setUIState(prevUIState => {
                    if (prevUIState.currOpenToolbarDropdown !== undefined && !selected) {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: props.type });
                    }
                    return prevUIState;
                });
            } }, props.type),
        props.children));
};
export default ToolbarDropdownSelector;
//# sourceMappingURL=ToolbarDropdownSelector.js.map