/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class SortedDuplicateEntityPipeValidator
implements SinkSource {
    private Sink sink;
    private EntityContainerComparator comparator = new EntityContainerComparator(new EntityByTypeThenIdComparator());
    private EntityContainer previousEntityContainer;

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    @Override
    public void complete() {
        this.sink.complete();
    }

    @Override
    public void process(EntityContainer entityContainer) {
        if (this.previousEntityContainer != null && this.comparator.compare(this.previousEntityContainer, entityContainer) > 0) {
            throw new OsmosisRuntimeException("Pipeline entities are not sorted, previous entity type=" + (Object)((Object)this.previousEntityContainer.getEntity().getType()) + ", id=" + this.previousEntityContainer.getEntity().getId() + ", version=" + this.previousEntityContainer.getEntity().getVersion() + " current entity type=" + (Object)((Object)entityContainer.getEntity().getType()) + ", id=" + entityContainer.getEntity().getId() + ", version=" + entityContainer.getEntity().getVersion() + ".");
        }
        this.sink.process(entityContainer);
        this.previousEntityContainer = entityContainer;
    }

    @Override
    public void close() {
        this.sink.close();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

