/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6;

import java.net.InetSocketAddress;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.ReplicationDataClientChannelPipelineFactory;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClient;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientRestartManager;

public class ReplicationDataClient
implements RunnableChangeSource {
    private NoReleaseChangeSinkWrapper changeSinkWrapper;
    private InetSocketAddress serverAddress;
    private String pathPrefix;

    public ReplicationDataClient(InetSocketAddress serverAddress, String pathPrefix) {
        this.serverAddress = serverAddress;
        this.pathPrefix = pathPrefix;
        this.changeSinkWrapper = new NoReleaseChangeSinkWrapper();
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSinkWrapper.setChangeSink(changeSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SequenceClientRestartManager clientRestartManager = new SequenceClientRestartManager();
            ReplicationDataClientChannelPipelineFactory pipelineFactory = new ReplicationDataClientChannelPipelineFactory(clientRestartManager.getControl(), (ChangeSink)this.changeSinkWrapper, this.serverAddress.getHostName(), this.pathPrefix);
            SequenceClient client = new SequenceClient(this.serverAddress, pipelineFactory);
            clientRestartManager.manageClient(client);
        }
        finally {
            this.changeSinkWrapper.realRelease();
        }
    }

    private static class NoReleaseChangeSinkWrapper
    implements ChangeSinkChangeSource {
        private ChangeSink changeSink;

        private NoReleaseChangeSinkWrapper() {
        }

        public void setChangeSink(ChangeSink changeSink) {
            this.changeSink = changeSink;
        }

        public void initialize(Map<String, Object> metaData) {
            this.changeSink.initialize(metaData);
        }

        public void process(ChangeContainer change) {
            this.changeSink.process(change);
        }

        public void complete() {
            this.changeSink.complete();
        }

        public void close() {
        }

        public void realRelease() {
            this.changeSink.close();
        }
    }
}

