/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.extract.apidb.v0_6;

import java.io.File;
import java.util.Date;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbChangeReader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.sort.v0_6.ChangeTagSorter;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.extract.apidb.common.Configuration;
import org.openstreetmap.osmosis.replication.v0_6.impl.ChangesetFileNameFormatter;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeWriter;

public class IntervalExtractor {
    private static final String TMP_FILE_NAME = "tmpchangeset.osc.gz";
    private final Configuration config;
    private final File baseDirectory;
    private final Date intervalBegin;
    private final Date intervalEnd;
    private final boolean fullHistory;

    public IntervalExtractor(Configuration config, File baseDirectory, Date intervalBegin, Date intervalEnd, boolean fullHistory) {
        this.baseDirectory = baseDirectory;
        this.config = config;
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.fullHistory = fullHistory;
    }

    public void run() {
        String fileName = new ChangesetFileNameFormatter(this.config.getChangeFileBeginFormat(), this.config.getChangeFileEndFormat()).generateFileName(this.intervalBegin, this.intervalEnd);
        File tmpFile = new File(this.baseDirectory, TMP_FILE_NAME);
        File file = new File(this.baseDirectory, fileName);
        XmlChangeWriter writer = new XmlChangeWriter(tmpFile, CompressionMethod.GZip);
        ApidbChangeReader reader = new ApidbChangeReader(this.config.getDatabaseLoginCredentials(), this.config.getDatabasePreferences(), this.intervalBegin, this.intervalEnd, this.fullHistory);
        ChangeTagSorter tagSorter = new ChangeTagSorter();
        reader.setChangeSink((ChangeSink)tagSorter);
        tagSorter.setChangeSink((ChangeSink)writer);
        reader.run();
        if (file.exists() && !file.delete()) {
            throw new OsmosisRuntimeException("Unable to delete existing file " + file + ".");
        }
        if (!tmpFile.renameTo(file)) {
            throw new OsmosisRuntimeException("Unable to rename temporary file " + tmpFile + " to " + file + ".");
        }
    }
}

