/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.Map;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityFeatureMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayNodeRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class WayNodeMapper
extends EntityFeatureMapper<DbOrderedFeature<WayNode>> {
    @Override
    public String getParentEntityName() {
        return "way";
    }

    @Override
    public String getEntityName() {
        return "way_nodes";
    }

    @Override
    public String getSqlSelect(String tablePrefix, boolean filterByEntityId, boolean orderBy) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT way_id AS entity_id, node_id, sequence_id FROM ");
        resultSql.append("way_nodes f");
        if (!tablePrefix.isEmpty()) {
            resultSql.append(" INNER JOIN ").append(tablePrefix).append(this.getParentEntityName()).append("s e ON f.").append(this.getParentEntityName()).append("_id = e.id");
        }
        if (filterByEntityId) {
            resultSql.append(" WHERE way_id = ?");
        }
        if (orderBy) {
            resultSql.append(this.getSqlDefaultOrderBy());
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDefaultOrderBy() {
        return super.getSqlDefaultOrderBy() + ", sequence_id";
    }

    @Override
    public String getSqlInsert(int rowCount) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO way_nodes (");
        resultSql.append("way_id, node_id, sequence_id) VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(:wayId, :nodeId, :sequenceId)");
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM way_nodes");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append("way_id = ?");
        }
        return resultSql.toString();
    }

    @Override
    public void populateParameters(Map<String, Object> args, DbOrderedFeature<WayNode> feature) {
        args.put("wayId", feature.getEntityId());
        args.put("nodeId", ((WayNode)feature.getFeature()).getNodeId());
        args.put("sequenceId", feature.getSequenceId());
    }

    @Override
    public RowMapper<DbOrderedFeature<WayNode>> getRowMapper() {
        return new WayNodeRowMapper();
    }
}

