/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagListener;
import org.xml.sax.Attributes;

public class NodeElementProcessor
extends EntityElementProcessor
implements TagListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_LATITUDE = "lat";
    private static final String ATTRIBUTE_NAME_LONGITUDE = "lon";
    private TagElementProcessor tagElementProcessor;
    private Node node;
    private boolean coordinatesRequired;

    public NodeElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing) {
        this(parentProcessor, sink, enableDateParsing, true);
    }

    public NodeElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing, boolean coordinatesRequired) {
        super(parentProcessor, sink, enableDateParsing);
        this.coordinatesRequired = coordinatesRequired;
        this.tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    }

    @Override
    public void begin(Attributes attributes) {
        long id = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String sversion = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (sversion == null) {
            throw new OsmosisRuntimeException("Node " + id + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int version = Integer.parseInt(sversion);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String rawUserId = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String rawUserName = attributes.getValue(ATTRIBUTE_NAME_USER);
        long changesetId = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        double latitude = this.getLatLonDouble(attributes, ATTRIBUTE_NAME_LATITUDE, id);
        double longitude = this.getLatLonDouble(attributes, ATTRIBUTE_NAME_LONGITUDE, id);
        OsmUser user = this.buildUser(rawUserId, rawUserName);
        this.node = new Node(new CommonEntityData(id, version, timestampContainer, user, changesetId), latitude, longitude);
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_TAG.equals(qName)) {
            return this.tagElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
        this.getSink().process((EntityContainer)new NodeContainer(this.node));
    }

    @Override
    public void processTag(Tag tag) {
        this.node.getTags().add(tag);
    }

    private double getLatLonDouble(Attributes attributes, String attributeName, long id) {
        String value = attributes.getValue(attributeName);
        if (value == null) {
            if (this.coordinatesRequired) {
                throw new OsmosisRuntimeException(String.format("Node %s does not have its %s attribute set; this attribute is required in current context.", id, attributeName));
            }
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new OsmosisRuntimeException(String.format("Node %s: cannot parse the %s attribute as a numeric value", id, attributeName));
        }
    }
}

