from typing import Any, Generic, Optional, Type, TypeVar

from django.db import models
from django.http import HttpRequest, HttpResponse
from django.views.generic.base import ContextMixin, TemplateResponseMixin, View

_M = TypeVar("_M", bound=models.Model)

class SingleObjectMixin(Generic[_M], ContextMixin):
    model: Type[_M] = ...
    queryset: Optional[models.query.QuerySet[_M]] = ...
    slug_field: str = ...
    context_object_name: Optional[str] = ...
    slug_url_kwarg: str = ...
    pk_url_kwarg: str = ...
    query_pk_and_slug: bool = ...
    def get_object(self, queryset: Optional[models.query.QuerySet[_M]] = ...) -> _M: ...
    def get_queryset(self) -> models.query.QuerySet[_M]: ...
    def get_slug_field(self) -> str: ...
    def get_context_object_name(self, obj: _M) -> Optional[str]: ...

class BaseDetailView(SingleObjectMixin[_M], View):
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...

class SingleObjectTemplateResponseMixin(TemplateResponseMixin):
    template_name_field: Optional[str] = ...
    template_name_suffix: str = ...

class DetailView(SingleObjectTemplateResponseMixin, BaseDetailView[_M]): ...
