from typing import Any, Callable, Dict, List, Optional, Type

from django.http.request import HttpRequest
from django.http.response import HttpResponse, HttpResponseBase

class ContextMixin:
    extra_context: Optional[Dict[str, Any]]
    def get_context_data(self, **kwargs: Any) -> Dict[str, Any]: ...

class View:
    http_method_names: List[str] = ...
    request: HttpRequest = ...
    args: Any = ...
    kwargs: Any = ...
    def __init__(self, **kwargs: Any) -> None: ...
    @classmethod
    def as_view(cls: Any, **initkwargs: Any) -> Callable[..., HttpResponseBase]: ...
    def setup(self, request: HttpRequest, *args: Any, **kwargs: Any) -> None: ...
    def dispatch(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def http_method_not_allowed(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...
    def options(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...

class TemplateResponseMixin:
    template_name: str = ...
    template_engine: Optional[str] = ...
    response_class: Type[HttpResponse] = ...
    content_type: Optional[str] = ...
    request: HttpRequest = ...
    def render_to_response(self, context: Dict[str, Any], **response_kwargs: Any) -> HttpResponse: ...
    def get_template_names(self) -> List[str]: ...

class TemplateView(TemplateResponseMixin, ContextMixin, View):
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...

class RedirectView(View):
    permanent: bool = ...
    url: Optional[str] = ...
    pattern_name: Optional[str] = ...
    query_string: bool = ...
    def get_redirect_url(self, *args: Any, **kwargs: Any) -> Optional[str]: ...
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def head(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def post(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def options(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def delete(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def put(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def patch(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
