import sys
from typing import Any, Dict, Generic, Iterable, List, Optional, Sequence, Set, Tuple, Type, TypeVar, Union, overload

from django.apps.config import AppConfig
from django.apps.registry import Apps
from django.contrib.contenttypes.fields import GenericForeignKey
from django.db.backends.base.base import BaseDatabaseWrapper
from django.db.models.base import Model
from django.db.models.constraints import BaseConstraint, UniqueConstraint
from django.db.models.fields import AutoField, Field
from django.db.models.fields.related import ManyToManyField, OneToOneField
from django.db.models.fields.reverse_related import ForeignObjectRel
from django.db.models.manager import Manager
from django.db.models.query_utils import PathInfo
from django.utils.datastructures import ImmutableList, _ListOrTuple

if sys.version_info < (3, 8):
    from typing_extensions import Literal
else:
    from typing import Literal

PROXY_PARENTS: object
EMPTY_RELATION_TREE: Any
IMMUTABLE_WARNING: str
DEFAULT_NAMES: Tuple[str, ...]

_OptionTogetherT = Union[_ListOrTuple[Union[_ListOrTuple[str], str]], Set[Tuple[str, ...]]]

@overload
def normalize_together(option_together: _ListOrTuple[Union[_ListOrTuple[str], str]]) -> Tuple[Tuple[str, ...], ...]: ...

# Any other value will be returned unchanged, but probably only set is semantically allowed
@overload
def normalize_together(option_together: Set[Tuple[str, ...]]) -> Set[Tuple[str, ...]]: ...

_T = TypeVar("_T")

def make_immutable_fields_list(name: str, data: Iterable[_T]) -> ImmutableList[_T]: ...

_M = TypeVar("_M", bound="Model")

class Options(Generic[_M]):
    constraints: List[BaseConstraint]
    FORWARD_PROPERTIES: Set[str] = ...
    REVERSE_PROPERTIES: Set[str] = ...
    default_apps: Any = ...
    local_fields: List[Field] = ...
    local_many_to_many: List[ManyToManyField] = ...
    private_fields: List[Any] = ...
    local_managers: List[Manager] = ...
    base_manager_name: Optional[str] = ...
    default_manager_name: Optional[str] = ...
    model_name: Optional[str] = ...
    verbose_name: Optional[str] = ...
    verbose_name_plural: Optional[str] = ...
    db_table: str = ...
    ordering: Optional[Sequence[str]] = ...
    indexes: List[Any] = ...
    unique_together: Sequence[Tuple[str]] = ...  # Are always normalized
    index_together: Sequence[Tuple[str]] = ...  # Are always normalized
    select_on_save: bool = ...
    default_permissions: Sequence[str] = ...
    permissions: List[Any] = ...
    object_name: Optional[str] = ...
    app_label: str = ...
    get_latest_by: Optional[Sequence[str]] = ...
    order_with_respect_to: Optional[str] = ...
    db_tablespace: str = ...
    required_db_features: List[str] = ...
    required_db_vendor: Optional[Literal["sqlite", "postgresql", "mysql", "oracle"]] = ...
    meta: Optional[type] = ...
    pk: Optional[Field] = ...
    auto_field: Optional[AutoField] = ...
    abstract: bool = ...
    managed: bool = ...
    proxy: bool = ...
    proxy_for_model: Optional[Type[Model]] = ...
    concrete_model: Optional[Type[Model]] = ...
    swappable: Optional[str] = ...
    parents: Dict[Type[Model], Union[GenericForeignKey, Field]] = ...
    auto_created: bool = ...
    related_fkey_lookups: List[Any] = ...
    apps: Apps = ...
    default_related_name: Optional[str] = ...
    model: Type[Model] = ...
    original_attrs: Dict[str, Any] = ...
    def __init__(self, meta: Optional[type], app_label: Optional[str] = ...) -> None: ...
    @property
    def label(self) -> str: ...
    @property
    def label_lower(self) -> str: ...
    @property
    def app_config(self) -> AppConfig: ...
    @property
    def installed(self) -> bool: ...
    def contribute_to_class(self, cls: Type[Model], name: str) -> None: ...
    def add_manager(self, manager: Manager) -> None: ...
    def add_field(self, field: Union[GenericForeignKey, Field[Any, Any]], private: bool = ...) -> None: ...
    # if GenericForeignKey is passed as argument, it has primary_key = True set before
    def setup_pk(self, field: Union[GenericForeignKey, Field[Any, Any]]) -> None: ...
    def setup_proxy(self, target: Type[Model]) -> None: ...
    def can_migrate(self, connection: Union[BaseDatabaseWrapper, str]) -> bool: ...
    @property
    def verbose_name_raw(self) -> str: ...
    @property
    def swapped(self) -> Optional[str]: ...
    @property
    def fields_map(self) -> Dict[str, Union[Field[Any, Any], ForeignObjectRel]]: ...
    @property
    def managers(self) -> ImmutableList[Manager]: ...
    @property
    def managers_map(self) -> Dict[str, Manager]: ...
    @property
    def base_manager(self) -> Manager: ...
    @property
    def default_manager(self) -> Optional[Manager]: ...
    @property
    def fields(self) -> ImmutableList[Field[Any, Any]]: ...
    def get_field(self, field_name: str) -> Union[Field, ForeignObjectRel, GenericForeignKey]: ...
    def get_base_chain(self, model: Type[Model]) -> List[Type[Model]]: ...
    def get_parent_list(self) -> List[Type[Model]]: ...
    def get_ancestor_link(self, ancestor: Type[Model]) -> Optional[OneToOneField]: ...
    def get_path_to_parent(self, parent: Type[Model]) -> List[PathInfo]: ...
    def get_path_from_parent(self, parent: Type[Model]) -> List[PathInfo]: ...
    def get_fields(
        self, include_parents: bool = ..., include_hidden: bool = ...
    ) -> List[Union[Field[Any, Any], ForeignObjectRel, GenericForeignKey]]: ...
    @property
    def total_unique_constraints(self) -> List[UniqueConstraint]: ...
    @property
    def db_returning_fields(self) -> List[Field[Any, Any]]: ...
