import os
import types
from typing import IO, AnyStr, Iterator, Optional, Type, TypeVar, Union, type_check_only

from django.core.files.utils import FileProxyMixin

_T = TypeVar("_T", bound="File")

class File(FileProxyMixin[AnyStr], IO[AnyStr]):
    DEFAULT_CHUNK_SIZE: int = ...
    file: Optional[IO[AnyStr]] = ...
    name: Optional[str] = ...  # type: ignore[assignment]
    mode: str = ...
    def __init__(self, file: Optional[IO[AnyStr]], name: Optional[str] = ...) -> None: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    @property
    def size(self) -> int: ...
    def chunks(self, chunk_size: Optional[int] = ...) -> Iterator[AnyStr]: ...
    def multiple_chunks(self, chunk_size: Optional[int] = ...) -> Optional[bool]: ...
    def __iter__(self) -> Iterator[AnyStr]: ...
    def __enter__(self: _T) -> _T: ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        tb: Optional[types.TracebackType],
    ) -> None: ...
    def open(self: _T, mode: Optional[str] = ...) -> _T: ...
    def close(self) -> None: ...
    @type_check_only
    def __next__(self) -> AnyStr: ...

class ContentFile(File[AnyStr]):
    file: IO[AnyStr]
    size: int = ...
    def __init__(self, content: AnyStr, name: Optional[str] = ...) -> None: ...
    def __str__(self) -> str: ...
    def __bool__(self) -> bool: ...
    def open(self: _T, mode: Optional[str] = ...) -> _T: ...
    def close(self) -> None: ...
    def write(self, data: AnyStr) -> int: ...

def endswith_cr(line: Union[bytes, str]) -> bool: ...
def endswith_lf(line: Union[bytes, str]) -> bool: ...
def equals_lf(line: Union[bytes, str]) -> bool: ...
