from typing import Any, Callable, Dict, Iterable, List, Optional, Union

from django.core.exceptions import ImproperlyConfigured

class InvalidCacheBackendError(ImproperlyConfigured): ...
class CacheKeyWarning(RuntimeWarning): ...

DEFAULT_TIMEOUT: Any
MEMCACHE_MAX_KEY_LENGTH: int

def default_key_func(key: Any, key_prefix: str, version: Any) -> str: ...
def get_key_func(key_func: Optional[Union[Callable, str]]) -> Callable: ...

class BaseCache:
    default_timeout: Optional[int] = ...
    key_prefix: str = ...
    version: int = ...
    key_func: Callable = ...
    def __init__(self, params: Dict[str, Any]) -> None: ...
    def get_backend_timeout(self, timeout: Optional[int] = ...) -> Optional[float]: ...
    def make_key(self, key: Any, version: Optional[int] = ...) -> str: ...
    def add(self, key: Any, value: Any, timeout: Optional[int] = ..., version: Optional[int] = ...) -> bool: ...
    def get(self, key: Any, default: Optional[Any] = ..., version: Optional[int] = ...) -> Any: ...
    def set(self, key: Any, value: Any, timeout: Optional[int] = ..., version: Optional[int] = ...) -> None: ...
    def touch(self, key: Any, timeout: Optional[int] = ..., version: Optional[int] = ...) -> bool: ...
    def delete(self, key: Any, version: Optional[int] = ...) -> None: ...
    def get_many(self, keys: Iterable[Any], version: Optional[int] = ...) -> Dict[Any, Any]: ...
    def get_or_set(
        self, key: Any, default: Optional[Any], timeout: Optional[int] = ..., version: Optional[int] = ...
    ) -> Optional[Any]: ...
    def has_key(self, key: Any, version: Optional[int] = ...) -> bool: ...
    def incr(self, key: Any, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def decr(self, key: Any, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def __contains__(self, key: Any) -> bool: ...
    def set_many(
        self, data: Dict[Any, Any], timeout: Optional[int] = ..., version: Optional[int] = ...
    ) -> List[Any]: ...
    def delete_many(self, keys: Iterable[Any], version: Optional[int] = ...) -> None: ...
    def clear(self) -> None: ...
    def validate_key(self, key: Any) -> None: ...
    def incr_version(self, key: Any, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def decr_version(self, key: Any, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def close(self, **kwargs: Any) -> None: ...
