import sys
from typing import Any, Callable, Dict, Iterable, Iterator, List, Mapping, Optional, Sequence, Tuple, Union

from django import forms
from django.contrib.admin.options import ModelAdmin
from django.db.models import Model
from django.db.models.fields import AutoField
from django.forms.boundfield import BoundField
from django.forms.models import ModelForm
from django.forms.utils import ErrorDict, ErrorList
from django.forms.widgets import Media, Widget
from django.utils.safestring import SafeString

if sys.version_info < (3, 8):
    from typing_extensions import TypedDict
else:
    from typing import TypedDict

ACTION_CHECKBOX_NAME: str

class ActionForm(forms.Form):
    action: Any = ...
    select_across: Any = ...

checkbox: Any

class _PrepopulatedDict(TypedDict):
    field: BoundField
    dependencies: List[BoundField]

class AdminForm:
    prepopulated_fields: List[_PrepopulatedDict]
    model_admin: Optional[ModelAdmin] = ...
    readonly_fields: Sequence[str] = ...
    form: ModelForm
    fieldsets: List[Tuple[Any, Dict[str, List[str]]]]
    def __init__(
        self,
        form: ModelForm,
        fieldsets: List[Tuple[Any, Dict[str, List[str]]]],
        prepopulated_fields: Mapping[str, Iterable[str]],
        readonly_fields: Optional[Sequence[str]] = ...,
        model_admin: Optional[ModelAdmin] = ...,
    ) -> None: ...
    def __iter__(self) -> Iterator[Fieldset]: ...
    @property
    def errors(self) -> ErrorDict: ...
    @property
    def non_field_errors(self) -> Callable[[], ErrorList]: ...
    @property
    def media(self) -> Media: ...

class Fieldset:
    form: ModelForm = ...
    classes: str = ...
    description: Optional[str] = ...
    model_admin: Optional[ModelAdmin] = ...
    readonly_fields: Sequence[str] = ...
    def __init__(
        self,
        form: ModelForm,
        name: Optional[Any] = ...,
        readonly_fields: Sequence[str] = ...,
        fields: Sequence[str] = ...,
        classes: Iterable[str] = ...,
        description: Optional[str] = ...,
        model_admin: Optional[ModelAdmin] = ...,
    ) -> None: ...
    @property
    def media(self) -> Media: ...
    def __iter__(self) -> Iterator[Fieldline]: ...

class Fieldline:
    form: ModelForm = ...
    fields: Sequence[str] = ...
    has_visible_field: bool = ...
    model_admin: Optional[ModelAdmin] = ...
    readonly_fields: Sequence[str] = ...
    def __init__(
        self,
        form: ModelForm,
        field: Union[str, Sequence[str]],
        readonly_fields: Optional[Sequence[str]] = ...,
        model_admin: Optional[ModelAdmin] = ...,
    ) -> None: ...
    def __iter__(self) -> Iterator[Union[AdminField, AdminReadonlyField]]: ...
    def errors(self) -> SafeString: ...

class AdminField:
    field: BoundField = ...
    is_first: bool = ...
    is_checkbox: bool = ...
    is_readonly: bool = ...
    def __init__(self, form: ModelForm, field: str, is_first: bool) -> None: ...
    def label_tag(self) -> SafeString: ...
    def errors(self) -> SafeString: ...

class _FieldDictT(TypedDict):
    name: str
    label: str
    help_text: str
    field: Union[Callable[[Model], Any], str]

class AdminReadonlyField:
    field: _FieldDictT = ...
    form: ModelForm = ...
    model_admin: Optional[ModelAdmin] = ...
    is_first: bool = ...
    is_checkbox: bool = ...
    is_readonly: bool = ...
    empty_value_display: Any = ...
    def __init__(
        self,
        form: ModelForm,
        field: Union[Callable[[Model], Any], str],
        is_first: bool,
        model_admin: Optional[ModelAdmin] = ...,
    ) -> None: ...
    def label_tag(self) -> SafeString: ...
    def contents(self) -> SafeString: ...

class InlineAdminFormSet:
    opts: Any = ...
    formset: Any = ...
    fieldsets: Any = ...
    model_admin: Optional[ModelAdmin] = ...
    readonly_fields: Sequence[str] = ...
    prepopulated_fields: Dict[str, Any] = ...
    classes: str = ...
    has_add_permission: bool = ...
    has_change_permission: bool = ...
    has_delete_permission: bool = ...
    has_view_permission: bool = ...
    def __init__(
        self,
        inline: Any,
        formset: Any,
        fieldsets: Any,
        prepopulated_fields: Optional[Dict[str, Any]] = ...,
        readonly_fields: Optional[Sequence[str]] = ...,
        model_admin: Optional[ModelAdmin] = ...,
        has_add_permission: bool = ...,
        has_change_permission: bool = ...,
        has_delete_permission: bool = ...,
        has_view_permission: bool = ...,
    ) -> None: ...
    def __iter__(self) -> Iterator[InlineAdminForm]: ...
    def fields(self) -> Iterator[Dict[str, Union[Dict[str, bool], bool, Widget, str]]]: ...
    def inline_formset_data(self) -> str: ...
    @property
    def forms(self): ...
    @property
    def non_form_errors(self) -> Callable[[], ErrorList]: ...
    @property
    def media(self) -> Media: ...

class InlineAdminForm(AdminForm):
    formset: Any = ...
    original: Optional[bool] = ...
    show_url: bool = ...
    absolute_url: Optional[str] = ...
    def __init__(
        self,
        formset: Any,
        form: ModelForm,
        fieldsets: Any,
        prepopulated_fields: Any,
        original: Optional[bool],
        readonly_fields: Optional[Sequence[str]] = ...,
        model_admin: Optional[ModelAdmin] = ...,
        view_on_site_url: Optional[str] = ...,
    ) -> None: ...
    def __iter__(self) -> Iterator[InlineFieldset]: ...
    def needs_explicit_pk_field(self) -> Union[bool, AutoField]: ...
    def pk_field(self) -> AdminField: ...
    def fk_field(self) -> AdminField: ...
    def deletion_field(self) -> AdminField: ...
    def ordering_field(self): ...

class InlineFieldset(Fieldset):
    formset: Any = ...
    def __init__(self, formset: Any, *args: Any, **kwargs: Any) -> None: ...
    def __iter__(self) -> Iterator[Fieldline]: ...

class AdminErrorList(forms.utils.ErrorList):
    def __init__(self, form: ModelForm, inline_formsets: Any) -> None: ...
