"""
toppy
~~~~~~
An API wrapper made for discord.py or any forks for Discord Bot List and/or Top.gg

:copyright: (c) 2022-present The Master and chawkk6404
:license: MIT
"""

from .client import Client, DBLClient, TopGGClient
from .errors import (
    BadRequest,
    ClientNotReady,
    ClientResponseError,
    Forbidden,
    HTTPException,
    NoTokenSet,
    RateLimited,
    Unauthorized
)

from . import http, utils, protocols, cog, models


__all__ = (
    # client.py
    'Client',
    'DBLClient',
    'TopGGClient',
    # errors
    'BadRequest',
    'ClientNotReady',
    'ClientResponseError',
    'Forbidden',
    'HTTPException',
    'NoTokenSet',
    'RateLimited',
    'Unauthorized'
)


__title__ = 'toppy'
__authors__ = ('The Master', 'chawkk6404')
__license__ = 'MIT'
__copyright__ = '2022-present The Master and chawkk6404'
__version__ = '1.5.0'
