//------------------------------------------------------------------------------
// Copyright 2021 H2O.ai
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//------------------------------------------------------------------------------
#ifndef dt_EXPR_RE_FEXPR_MATCH_h
#define dt_EXPR_RE_FEXPR_MATCH_h
#include <regex>
#include <string>
#include "expr/fexpr_func_unary.h"
namespace dt {
namespace expr {



class FExpr_Re_Match : public FExpr_FuncUnary {
  private:
    std::string pattern_;
    std::regex regex_;
    bool icase_;
    size_t : 56;

  public:
    FExpr_Re_Match(ptrExpr&& arg, py::oobj pattern, py::oobj icase);
    std::string name() const override;
    std::string repr() const override;
    Column evaluate1(Column&& col) const override;
};




}}  // namespace dt::expr
#endif
