# Dict of cell name to (x, y, width, height, centred?) for seasons 3, 4
def get_cells_for_season(season: int):
    if season in [20]:
        # Ravenmoor
        return cells_ravenmoor
    if season in [11]:
        # Not really season 11, but some season 10 scenarios have five tiers for
        # some reason, so we need a way to express that
        return cells_season_11
    if season in [5, 7, 8, 9, 10]:
        return cells_season_9
    if season in [3, 4]:
        return cells_season_3
    if season in [6]:
        return cells_season_6
    return {}

cells_ravenmoor = {
    'event': (15, 251, 25, 7, False),
    'event_code': (45, 251, 28, 7, False),
    'date': (78.5, 251, 27, 7, False),
    'gm_sig': (110, 251, 45.5, 7, False),
    'gm_number': (162, 251, 37, 7, True),
    'player_name': (13, 44, 30, 7, False),
    'character_name': (56.5, 44, 36.5, 7, False),
    'player_number': (99.5, 44, 20, 7, True),
    'character_number': (124.5, 44, 12, 7, True),
    'character_faction': (142, 44, 20, 7, True),
    'starting_xp': (170.5, 59.5, 30, 7, True),
    'xp_gained': (170.5, 71, 21.5, 7, True),
    'xp_gained_initials': (192, 71, 8, 7, True),
    'final_xp': (170.5, 83, 30, 7, True),
    'initial_fame': (170.5, 105, 14, 7, True),
    'initial_prestige': (185.5, 105, 14, 7, True),
    'prestige_gained': (170.5, 116.5, 21.5, 7, True),
    'prestige_gained_initials': (192, 116.5, 8, 7, True),
    'prestige_spent': (170.5, 128.5, 29.5, 7, True),
    'current_fame': (170.5, 140, 14, 7, True),
    'current_prestige': (185.5, 140, 14, 7, True),
    'starting_gp': (170.5, 160.5, 29.5, 7, True),
    'gp_gained': (170.5, 172, 21.5, 7, True),
    'gp_gained_initials': (192, 172, 8, 7, True),
    'day_job': (170.5, 183.5, 21.5, 7, True),
    'day_job_initials': (192, 183.5, 8, 7, True),
    'items_sold': (170.5, 195.5, 29.5, 7, True),
    'gp_subtotal': (170.5, 206.5, 29.5, 7, True),
    'gp_spent': (170.5, 218.5, 29.5, 7, True),
    'gp_total': (170.5, 232.5, 29.5, 7, True),
    'note_top': (13.5, 38.5, 148, 5, False),
    'note_bottom': (13, 264, 187.5, 7, False)
}


cells_season_3 = {
    'event': (15, 251, 25, 7, False),
    'event_code': (45, 251, 28, 7, False),
    'date': (78.5, 251, 27, 7, False),
    'gm_sig': (110, 251, 45.5, 7, False),
    'gm_number': (162, 251, 37, 7, True),
    'player_name': (13, 44, 30, 7, False),
    'character_name': (56.5, 44, 36.5, 7, False),
    'player_number': (99.5, 44, 20, 7, True),
    'character_number': (124.5, 44, 12, 7, True),
    'character_faction': (142, 44, 20, 7, True),
    'subtier_2_slow': (179, 38, 10.5, 9, True),
    'subtier_2_fast': (189.5, 38, 10.5, 9, True),
    'subtier_1_slow': (179, 28.7, 10.5, 9, True),
    'subtier_1_fast': (189.5, 28.7, 10.5, 9, True),
    'starting_xp': (170.5, 59.5, 30, 7, True),
    'xp_gained': (170.5, 71, 21.5, 7, True),
    'xp_gained_initials': (192, 71, 8, 7, True),
    'final_xp': (170.5, 83, 30, 7, True),
    'initial_fame': (170.5, 105, 14, 7, True),
    'initial_prestige': (185.5, 105, 14, 7, True),
    'prestige_gained': (170.5, 116.5, 21.5, 7, True),
    'prestige_gained_initials': (192, 116.5, 8, 7, True),
    'prestige_spent': (170.5, 128.5, 29.5, 7, True),
    'current_fame': (170.5, 140, 14, 7, True),
    'current_prestige': (185.5, 140, 14, 7, True),
    'starting_gp': (170.5, 160.5, 29.5, 7, True),
    'gp_gained': (170.5, 172, 21.5, 7, True),
    'gp_gained_initials': (192, 172, 8, 7, True),
    'day_job': (170.5, 183.5, 21.5, 7, True),
    'day_job_initials': (192, 183.5, 8, 7, True),
    'items_sold': (170.5, 195.5, 29.5, 7, True),
    'gp_subtotal': (170.5, 206.5, 29.5, 7, True),
    'gp_spent': (170.5, 218.5, 29.5, 7, True),
    'gp_total': (170.5, 232.5, 29.5, 7, True),
    'note_top': (13.5, 38.5, 148, 5, False),
    'note_bottom': (13, 264, 187.5, 7, False)
}

# Dict of cell name to (x, y, width, height, centred?) for seasons 7, 8, 9, 10
cells_season_9 = {
    'event': (15, 252, 36, 7, False),
    'event_code': (55, 252, 20, 7, False),
    'date': (80, 252, 27, 7, False),
    'gm_sig': (112, 252, 46, 7, False),
    'gm_number': (162, 252, 37, 7, True),
    'player_name': (15, 39.5, 29, 7, False),
    'character_name': (54.5, 39.5, 36.5, 7, False),
    'player_number': (95, 39.5, 24, 7, True),
    'character_number': (122.5, 39.5, 15.5, 7, True),
    'character_faction': (142, 39.5, 16, 7, True),
    'subtier_1_slow': (176.5, 38.5, 11.5, 9, True),
    'subtier_1_fast': (188.5, 38.5, 11.5, 9, True),
    'subtier_2_slow': (176.5, 53.5, 11.5, 9, True),
    'subtier_2_fast': (188.5, 53.5, 11.5, 9, True),
    'subtier_3_slow': (176.5, 69, 11.5, 9, True),
    'subtier_3_fast': (188.5, 69, 11.5, 9, True),
    'subtier_4_slow': (176.5, 84, 11.5, 9, True),
    'subtier_4_fast': (188.5, 84, 11.5, 9, True),
    'starting_xp': (167, 94, 33, 7, True),
    'xp_gained': (167, 106.5, 22, 7, True),
    'xp_gained_initials': (189.5, 106.5, 11, 7, True),
    'final_xp': (167, 118.7, 33, 7, True),
    'initial_prestige': (167, 132.5, 16, 7, True),
    'initial_fame': (183.5, 132.5, 16, 7, True),
    'prestige_gained': (167, 144.5, 22, 7, True),
    'prestige_gained_initials': (189.5, 144.5, 11, 7, True),
    'prestige_spent': (167, 156.5, 33, 7, True),
    'current_prestige': (167, 169, 16, 7, True),
    'current_fame': (183.5, 169, 16, 7, True),
    'starting_gp': (167, 183.5, 33, 7, True),
    'gp_gained': (167, 196.5, 22, 7, True),
    'gp_gained_initials': (189.5, 196.5, 11, 7, True),
    'day_job': (167, 208.5, 22, 7, True),
    'day_job_initials': (189.5, 208.5, 11, 7, True),
    'gp_spent': (167, 221, 33, 7, True),
    'gp_total': (167, 233.5, 33, 7, True),
    'note_top': (13.5, 59.5, 148, 5, False),
    'note_bottom': (13, 264, 187.5, 7, False)
}

cells_season_11 = {
    'event': (15, 252, 36, 7, False),
    'event_code': (55, 252, 20, 7, False),
    'date': (80, 252, 27, 7, False),
    'gm_sig': (112, 252, 46, 7, False),
    'gm_number': (162, 252, 37, 7, True),
    'player_name': (15, 39.5, 29, 7, False),
    'character_name': (54.5, 39.5, 36.5, 7, False),
    'player_number': (95, 39.5, 24, 7, True),
    'character_number': (122.5, 39.5, 15.5, 7, True),
    'character_faction': (142, 39.5, 16, 7, True),
    'subtier_1_slow': (176.5, 23.5, 11.5, 9, True),
    'subtier_1_fast': (188.5, 23.5, 11.5, 9, True),
    'subtier_2_slow': (176.5, 38.5, 11.5, 9, True),
    'subtier_2_fast': (188.5, 38.5, 11.5, 9, True),
    'subtier_3_slow': (176.5, 53.5, 11.5, 9, True),
    'subtier_3_fast': (188.5, 53.5, 11.5, 9, True),
    'subtier_4_slow': (176.5, 69, 11.5, 9, True),
    'subtier_4_fast': (188.5, 69, 11.5, 9, True),
    'subtier_5_slow': (176.5, 84, 11.5, 9, True),
    'subtier_5_fast': (188.5, 84, 11.5, 9, True),
    'starting_xp': (167, 94, 33, 7, True),
    'xp_gained': (167, 106.5, 22, 7, True),
    'xp_gained_initials': (189.5, 106.5, 11, 7, True),
    'final_xp': (167, 118.7, 33, 7, True),
    'initial_prestige': (167, 132.5, 16, 7, True),
    'initial_fame': (183.5, 132.5, 16, 7, True),
    'prestige_gained': (167, 144.5, 22, 7, True),
    'prestige_gained_initials': (189.5, 144.5, 11, 7, True),
    'prestige_spent': (167, 156.5, 33, 7, True),
    'current_prestige': (167, 169, 16, 7, True),
    'current_fame': (183.5, 169, 16, 7, True),
    'starting_gp': (167, 183.5, 33, 7, True),
    'gp_gained': (167, 196.5, 22, 7, True),
    'gp_gained_initials': (189.5, 196.5, 11, 7, True),
    'day_job': (167, 208.5, 22, 7, True),
    'day_job_initials': (189.5, 208.5, 11, 7, True),
    'gp_spent': (167, 221, 33, 7, True),
    'gp_total': (167, 233.5, 33, 7, True),
    'note_top': (13.5, 59.5, 148, 5, False),
    'note_bottom': (13, 264, 187.5, 7, False)
}


cells_season_6 = {
    'event': (15, 261, 36, 7, False),
    'event_code': (55, 261, 20, 7, False),
    'date': (80, 261, 27, 7, False),
    'gm_sig': (112, 261, 46, 7, False),
    'gm_number': (162, 261, 37, 7, True),
    'player_name': (15, 39.5, 29, 7, False),
    'character_name': (57, 39.5, 36.5, 7, False),
    'player_number': (100, 39.5, 20, 7, True),
    'character_number': (125, 39.5, 11.5, 7, True),
    'character_faction': (142, 39.5, 16, 7, True),
    'subtier_1_slow': (176.5, 38.5, 11.5, 9, True),
    'subtier_1_fast': (188.5, 38.5, 11.5, 9, True),
    'subtier_2_slow': (176.5, 52, 11.5, 9, True),
    'subtier_2_fast': (188.5, 52, 11.5, 9, True),
    'subtier_3_slow': (176.5, 66, 11.5, 9, True),
    'subtier_3_fast': (188.5, 66, 11.5, 9, True),
    'subtier_4_slow': (176.5, 79.5, 11.5, 9, True),
    'subtier_4_fast': (188.5, 79.5, 11.5, 9, True),
    'subtier_5_slow': (176.5, 93, 11.5, 9, True),
    'subtier_5_fast': (188.5, 93, 11.5, 9, True),
    'starting_xp': (167, 103, 33, 7, True),
    'xp_gained': (167, 115.5, 22, 7, True),
    'xp_gained_initials': (189, 115.5, 11, 7, True),
    'final_xp': (167, 128, 33, 7, True),
    'initial_prestige': (167, 141.5, 16, 7, True),
    'initial_fame': (183.5, 141.5, 16, 7, True),
    'prestige_gained': (167, 153.5, 22, 7, True),
    'prestige_gained_initials': (189, 153.5, 11, 7, True),
    'prestige_spent': (167, 165.7, 33, 7, True),
    'current_prestige': (167, 178.5, 16, 7, True),
    'current_fame': (183.5, 178.5, 16, 7, True),
    'starting_gp': (167, 192.5, 33, 7, True),
    'gp_gained': (167, 205, 22, 7, True),
    'gp_gained_initials': (189, 205, 11, 7, True),
    'day_job': (167, 217.5, 22, 7, True),
    'day_job_initials': (189, 217.5, 11, 7, True),
    'gp_spent': (167, 230, 33, 7, True),
    'gp_total': (167, 242.5, 33, 7, True),
    'note_top': (18, 51.5, 139.5, 4, False),
    'note_bottom': (13, 272.5, 187.5, 4, False)
}
