# coding: utf-8

"""
    Collibra Search API

    <p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_search import schemas  # noqa: F401


class SearchResultResource(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Details of the resource that matches the search criteria.
    """


    class MetaOapg:
        
        @staticmethod
        def discriminator():
            return {
                'resourceType': {
                    'SearchAssetResultResource': SearchAssetResultResource,
                    'SearchCommunityResultResource': SearchCommunityResultResource,
                    'SearchDomainResultResource': SearchDomainResultResource,
                    'SearchUserGroupResultResource': SearchUserGroupResultResource,
                    'SearchUserResultResource': SearchUserResultResource,
                }
            }
        
        class properties:
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "User": "USER",
                        "UserGroup": "USER_GROUP",
                    }
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
            id = schemas.UUIDSchema
            createdBy = schemas.UUIDSchema
            createdOn = schemas.Int64Schema
            lastModifiedOn = schemas.Int64Schema
            name = schemas.StrSchema
            __annotations__ = {
                "resourceType": resourceType,
                "id": id,
                "createdBy": createdBy,
                "createdOn": createdOn,
                "lastModifiedOn": lastModifiedOn,
                "name": name,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdBy"]) -> MetaOapg.properties.createdBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> MetaOapg.properties.lastModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["resourceType", "id", "createdBy", "createdOn", "lastModifiedOn", "name", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> typing.Union[MetaOapg.properties.resourceType, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> typing.Union[MetaOapg.properties.id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdBy"]) -> typing.Union[MetaOapg.properties.createdBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> typing.Union[MetaOapg.properties.createdOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union[MetaOapg.properties.lastModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> typing.Union[MetaOapg.properties.name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["resourceType", "id", "createdBy", "createdOn", "lastModifiedOn", "name", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, schemas.Unset] = schemas.unset,
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdBy: typing.Union[MetaOapg.properties.createdBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdOn: typing.Union[MetaOapg.properties.createdOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        lastModifiedOn: typing.Union[MetaOapg.properties.lastModifiedOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        name: typing.Union[MetaOapg.properties.name, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SearchResultResource':
        return super().__new__(
            cls,
            *args,
            resourceType=resourceType,
            id=id,
            createdBy=createdBy,
            createdOn=createdOn,
            lastModifiedOn=lastModifiedOn,
            name=name,
            _configuration=_configuration,
            **kwargs,
        )

from collibra_search.model.search_asset_result_resource import SearchAssetResultResource
from collibra_search.model.search_community_result_resource import SearchCommunityResultResource
from collibra_search.model.search_domain_result_resource import SearchDomainResultResource
from collibra_search.model.search_user_group_result_resource import SearchUserGroupResultResource
from collibra_search.model.search_user_result_resource import SearchUserResultResource
