# collibra-search
<p>The Search API allows you to create your own integration with the Collibra Search Engine.<br /> Find your data!</p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_search
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_search
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import collibra_search
from pprint import pprint
from collibra_search.apis.tags import search_api
from collibra_search.model.search_request import SearchRequest
from collibra_search.model.search_response import SearchResponse
from collibra_search.model.search_view import SearchView
from collibra_search.model.search_view_paged_response import SearchViewPagedResponse
# Defining the host is optional and defaults to http://localhost/rest/2.0
# See configuration.py for a list of all supported configuration parameters.
configuration = collibra_search.Configuration(
    host = "http://localhost/rest/2.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = collibra_search.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerAuth
configuration = collibra_search.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with collibra_search.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = search_api.SearchApi(api_client)
    offset = 0 # int | The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='offset', paramName='offset', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.', unescapedDescription='The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.', baseType='null', defaultValue='0', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='0', jsonSchema='{
  "name" : "offset",
  "in" : "query",
  "description" : "The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : 0
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='OffsetSchema', complexType='null', getter='getOffset', setter='setOffset', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='offset', min='null', max='null', defaultValue='0', defaultValueWithParam=' = data.offset;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='0', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : 0
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='Offset', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
limit = 0 # int | The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='limit', paramName='limit', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.', unescapedDescription='The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.', baseType='null', defaultValue='0', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='0', jsonSchema='{
  "name" : "limit",
  "in" : "query",
  "description" : "The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : 0
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='LimitSchema', complexType='null', getter='getLimit', setter='setLimit', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='limit', min='null', max='null', defaultValue='0', defaultValueWithParam=' = data.limit;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='0', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : 0
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='Limit', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
count_limit = -1 # int | Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='countLimit', paramName='count_limit', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped', unescapedDescription='Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped', baseType='null', defaultValue='-1', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='-1', jsonSchema='{
  "name" : "countLimit",
  "in" : "query",
  "description" : "Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : -1
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='CountLimitSchema', complexType='null', getter='getCountLimit', setter='setCountLimit', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='count_limit', min='null', max='null', defaultValue='-1', defaultValueWithParam=' = data.countLimit;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='-1', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : -1
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='CountLimit', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
name = "name_example" # str | The search term for a search view to retrieve.<br /> The query is case sensitive and does not support wildcards.<br /> Use in conjunction with `nameMatchMode`. (optional)
name_match_mode = "START" # str | The match requirements for `name` queries.<br /> Works in conjunction with `name`. The search is case-sensitive. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='nameMatchMode', paramName='name_match_mode', dataType='str', datatypeWithEnum='Name_match_modeEnum', dataFormat='null', collectionFormat='null', description='The match requirements for `name` queries.<br /> Works in conjunction with `name`. The search is case-sensitive.', unescapedDescription='The match requirements for `name` queries.<br /> Works in conjunction with `name`. The search is case-sensitive.', baseType='null', defaultValue='"ANYWHERE"', enumDefaultValue='"ANYWHERE"', enumName='Name_match_modeEnum', style='FORM', deepObject='false', allowEmptyValue='false', example='"START"', jsonSchema='{
  "name" : "nameMatchMode",
  "in" : "query",
  "description" : "The match requirements for `name` queries.<br /> Works in conjunction with `name`. The search is case-sensitive.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "string",
    "default" : "ANYWHERE",
    "enum" : [ "START", "END", "ANYWHERE", "EXACT" ]
  },
  "example" : "START"
}', isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=true, _enum=[START, END, ANYWHERE, EXACT], allowableValues={values=[START, END, ANYWHERE, EXACT], enumVars=[{name=START, isString=true, value="START"}, {name=END, isString=true, value="END"}, {name=ANYWHERE, isString=true, value="ANYWHERE"}, {name=EXACT, isString=true, value="EXACT"}]}, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='string', baseName='NameMatchModeSchema', complexType='null', getter='getNameMatchMode', setter='setNameMatchMode', description='null', dataType='str', datatypeWithEnum='Name_match_modeEnum', dataFormat='null', name='name_match_mode', min='null', max='null', defaultValue='"ANYWHERE"', defaultValueWithParam=' = data.nameMatchMode;', baseType='str', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='"ANYWHERE"', jsonSchema='{
  "type" : "string",
  "default" : "ANYWHERE",
  "enum" : [ "START", "END", "ANYWHERE", "EXACT" ]
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=true, isInnerEnum=true, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=[START, END, ANYWHERE, EXACT], allowableValues={enumVars=[{name=START, isString=true, value="START"}, {name=END, isString=true, value="END"}, {name=ANYWHERE, isString=true, value="ANYWHERE"}, {name=EXACT, isString=true, value="EXACT"}], values=[START, END, ANYWHERE, EXACT]}, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='NameMatchMode', nameInSnakeCase='null', enumName='Name_match_modeEnum', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=null, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
sort_field = "NAME" # str | The reference field for sorting the results. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='sortField', paramName='sort_field', dataType='str', datatypeWithEnum='Sort_fieldEnum', dataFormat='null', collectionFormat='null', description='The reference field for sorting the results.', unescapedDescription='The reference field for sorting the results.', baseType='null', defaultValue='"NAME"', enumDefaultValue='"NAME"', enumName='Sort_fieldEnum', style='FORM', deepObject='false', allowEmptyValue='false', example='"NAME"', jsonSchema='{
  "name" : "sortField",
  "in" : "query",
  "description" : "The reference field for sorting the results.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "string",
    "default" : "NAME",
    "enum" : [ "NAME" ]
  },
  "example" : "NAME"
}', isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=true, _enum=[NAME], allowableValues={values=[NAME], enumVars=[{name=NAME, isString=true, value="NAME"}]}, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='string', baseName='SortFieldSchema', complexType='null', getter='getSortField', setter='setSortField', description='null', dataType='str', datatypeWithEnum='Sort_fieldEnum', dataFormat='null', name='sort_field', min='null', max='null', defaultValue='"NAME"', defaultValueWithParam=' = data.sortField;', baseType='str', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='"NAME"', jsonSchema='{
  "type" : "string",
  "default" : "NAME",
  "enum" : [ "NAME" ]
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=true, isInnerEnum=true, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=[NAME], allowableValues={enumVars=[{name=NAME, isString=true, value="NAME"}], values=[NAME]}, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='SortField', nameInSnakeCase='null', enumName='Sort_fieldEnum', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=null, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
sort_order = "ASC" # str | The order in which the results are sorted. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='sortOrder', paramName='sort_order', dataType='str', datatypeWithEnum='Sort_orderEnum', dataFormat='null', collectionFormat='null', description='The order in which the results are sorted.', unescapedDescription='The order in which the results are sorted.', baseType='null', defaultValue='"ASC"', enumDefaultValue='"ASC"', enumName='Sort_orderEnum', style='FORM', deepObject='false', allowEmptyValue='false', example='"ASC"', jsonSchema='{
  "name" : "sortOrder",
  "in" : "query",
  "description" : "The order in which the results are sorted.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "string",
    "default" : "ASC",
    "enum" : [ "ASC", "DESC" ]
  }
}', isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=true, _enum=[ASC, DESC], allowableValues={values=[ASC, DESC], enumVars=[{name=ASC, isString=true, value="ASC"}, {name=DESC, isString=true, value="DESC"}]}, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='string', baseName='SortOrderSchema', complexType='null', getter='getSortOrder', setter='setSortOrder', description='null', dataType='str', datatypeWithEnum='Sort_orderEnum', dataFormat='null', name='sort_order', min='null', max='null', defaultValue='"ASC"', defaultValueWithParam=' = data.sortOrder;', baseType='str', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='"ASC"', jsonSchema='{
  "type" : "string",
  "default" : "ASC",
  "enum" : [ "ASC", "DESC" ]
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=true, isInnerEnum=true, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=[ASC, DESC], allowableValues={enumVars=[{name=ASC, isString=true, value="ASC"}, {name=DESC, isString=true, value="DESC"}], values=[ASC, DESC]}, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='SortOrder', nameInSnakeCase='null', enumName='Sort_orderEnum', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=null, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})

    try:
        # Lists search views.
        api_response = api_instance.find_views(offset=offsetlimit=limitcount_limit=count_limitname=namename_match_mode=name_match_modesort_field=sort_fieldsort_order=sort_order)
        pprint(api_response)
    except collibra_search.ApiException as e:
        print("Exception when calling SearchApi->find_views: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SearchApi* | [**find_views**](docs/apis/tags/SearchApi.md#find_views) | **get** /search/views | Lists search views.
*SearchApi* | [**get_view**](docs/apis/tags/SearchApi.md#get_view) | **get** /search/views/{viewId} | Returns the details of an existing search view.
*SearchApi* | [**search**](docs/apis/tags/SearchApi.md#search) | **post** /search | Search.

## Documentation For Models

 - [FindSearchViewsRequest](docs/models/FindSearchViewsRequest.md)
 - [PagedResponseSearchView](docs/models/PagedResponseSearchView.md)
 - [SearchAggregation](docs/models/SearchAggregation.md)
 - [SearchAssetResultResource](docs/models/SearchAssetResultResource.md)
 - [SearchCommunityResultResource](docs/models/SearchCommunityResultResource.md)
 - [SearchDomainResultResource](docs/models/SearchDomainResultResource.md)
 - [SearchFilter](docs/models/SearchFilter.md)
 - [SearchHighlight](docs/models/SearchHighlight.md)
 - [SearchInFields](docs/models/SearchInFields.md)
 - [SearchRequest](docs/models/SearchRequest.md)
 - [SearchResponse](docs/models/SearchResponse.md)
 - [SearchResponseAggregation](docs/models/SearchResponseAggregation.md)
 - [SearchResponseAggregationValue](docs/models/SearchResponseAggregationValue.md)
 - [SearchResult](docs/models/SearchResult.md)
 - [SearchResultHighlight](docs/models/SearchResultHighlight.md)
 - [SearchResultResource](docs/models/SearchResultResource.md)
 - [SearchResultStatus](docs/models/SearchResultStatus.md)
 - [SearchResultType](docs/models/SearchResultType.md)
 - [SearchUserGroupResultResource](docs/models/SearchUserGroupResultResource.md)
 - [SearchUserResultResource](docs/models/SearchUserResultResource.md)
 - [SearchView](docs/models/SearchView.md)
 - [SearchViewPagedResponse](docs/models/SearchViewPagedResponse.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication

 Authentication schemes defined for the API:
## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author



## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in collibra_search.apis and collibra_search.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from collibra_search.apis.default_api import DefaultApi`
- `from collibra_search.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import collibra_search
from collibra_search.apis import *
from collibra_search.models import *
```
