"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * A CDK construct to create Lambda functions.
 *
 * @stability stable
 */
class LambdaConstruct extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(parent, name) {
        super(parent, name);
        // most simple function with static inline code that prints the event and calls the callback function
        new aws_lambda_1.Function(this, 'InlineFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromInline('exports.handler = function (e, ctx, cb) { console.log("Event: ", e); cb(); };'),
            handler: 'index.handler',
            timeout: core_1.Duration.seconds(10),
        });
        // a function which is written in regular Node.js outside of the src folder
        new aws_lambda_1.Function(this, 'JsFunction1', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '../lambda-js')),
            handler: 'index.handler',
        });
        // a function which is written in TypeScript inside the src/lambda folder
        new aws_lambda_1.Function(this, 'JsFunction2', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambda')),
            handler: 'index.handler',
        });
        // a function which is written in Python outside of the src folder
        new aws_lambda_1.Function(this, 'PythonFunction', {
            runtime: aws_lambda_1.Runtime.PYTHON_3_8,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '../lambda-python')),
            handler: 'index.handler',
        });
        // a function which is ignored by TypeScript but still included by running a custom compile task;
        // the compile task is using 'esbuild' to bundle & minify the function, i.e. include all depedencies into one target file
        new aws_lambda_1.Function(this, 'BundledDepsFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambda-bundled')),
            handler: 'index.handler',
        });
    }
}
exports.LambdaConstruct = LambdaConstruct;
_a = JSII_RTTI_SYMBOL_1;
LambdaConstruct[_a] = { fqn: "@seeebiii/projen-test.LambdaConstruct", version: "0.1.85" };
//# sourceMappingURL=data:application/json;base64,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