"use strict";
(self["webpackChunkgrader_labextension"] = self["webpackChunkgrader_labextension"] || []).push([["lib_index_js-webpack_sharing_consume_default_jupyterlab_translation-webpack_sharing_consume_d-756503"],{

/***/ "./lib/components/assignment/assignment-files.js":
/*!*******************************************************!*\
  !*** ./lib/components/assignment/assignment-files.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentFilesComponent": () => (/* binding */ AssignmentFilesComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_file_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/file-list */ "./lib/components/util/file-list.js");
/* harmony import */ var _mui_icons_material_PublishRounded__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/PublishRounded */ "./node_modules/@mui/icons-material/PublishRounded.js");
/* harmony import */ var _mui_icons_material_GetAppRounded__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/GetAppRounded */ "./node_modules/@mui/icons-material/GetAppRounded.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _mui_icons_material_RestartAlt__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/RestartAlt */ "./node_modules/@mui/icons-material/RestartAlt.js");
/* harmony import */ var _mui_icons_material_Grading__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/Grading */ "./node_modules/@mui/icons-material/Grading.js");
/* harmony import */ var _util_repo_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/repo-type */ "./lib/components/util/repo-type.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.












/**
 * Renders the file view and additional buttons to submit, push, pull or reset the assignment.
 * @param props Props of the assignment files component
 */
const AssignmentFilesComponent = (props) => {
    const [dialog, setDialog] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [dialogContent, setDialogContent] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
        title: '',
        message: '',
        handleAgree: null,
        handleDisagree: null
    });
    const path = `${props.lecture.code}/${props.assignment.id}`;
    /**
     * Pulls from given repository by sending a request to the grader git service.
     * @param repo input which repository should be fetched
     */
    const fetchAssignmentHandler = async (repo) => {
        await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pullAssignment)(props.lecture.id, props.assignment.id, repo).then(() => (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Successfully Pulled Repo', {
            variant: 'success'
        }), error => (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error.message, {
            variant: 'error'
        }));
    };
    /**
     * Sends request to reset the student changes.
     */
    const resetAssignmentHandler = async () => {
        setDialogContent({
            title: 'Reset Assignment',
            message: 'This action will delete your current progress and reset the assignment! \n' +
                'Therefore you should copy and paste your work to a different directory before progressing. ',
            handleAgree: async () => {
                try {
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pushAssignment)(props.lecture.id, props.assignment.id, 'assignment', 'Pre-Reset');
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.resetAssignment)(props.lecture, props.assignment);
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pullAssignment)(props.lecture.id, props.assignment.id, 'assignment');
                    (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Successfully Reset Assignment', {
                        variant: 'success'
                    });
                }
                catch (e) {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Error Reset Assignment', {
                        variant: 'error'
                    });
                }
                setDialog(false);
            },
            handleDisagree: () => {
                setDialog(false);
            }
        });
        setDialog(true);
    };
    /**
     * Pushes the student submission and submits the assignment
     */
    const submitAssignmentHandler = async () => {
        setDialogContent({
            title: 'Submit Assignment',
            message: 'This action will submit your current notebooks!',
            handleAgree: async () => {
                await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.submitAssignment)(props.lecture, props.assignment, true).then(response => {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Successfully Submitted Assignment', {
                        variant: 'success'
                    });
                }, error => {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error.message, {
                        variant: 'error'
                    });
                });
                await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.getAllSubmissions)(props.lecture, props.assignment, 'none', false).then(submissions => {
                    props.setSubmissions(submissions);
                }, error => {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error, {
                        variant: 'error'
                    });
                });
                setDialog(false);
            },
            handleDisagree: () => setDialog(false)
        });
        setDialog(true);
    };
    const pushAssignmentHandler = async () => {
        await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pushAssignment)(props.lecture.id, props.assignment.id, _util_repo_type__WEBPACK_IMPORTED_MODULE_5__.RepoType.ASSIGNMENT).then(() => (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Successfully Pushed Assignment', {
            variant: 'success'
        }), error => (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error.message, {
            variant: 'error'
        }));
    };
    const isDeadlineOver = () => {
        if (props.assignment.due_date === null) {
            return false;
        }
        const time = new Date(props.assignment.due_date).getTime();
        return time < Date.now();
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_file_list__WEBPACK_IMPORTED_MODULE_6__.FilesList, { path: path, sx: { m: 2, mt: 1 } }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack, { direction: 'row', spacing: 1, sx: { m: 1, ml: 2 } },
            props.assignment.type === 'group' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: "Push Changes" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", size: "small", onClick: pushAssignmentHandler },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_PublishRounded__WEBPACK_IMPORTED_MODULE_7__["default"], { fontSize: "small", sx: { mr: 1 } }),
                    "Push"))),
            props.assignment.type === 'group' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: "Pull from Remote" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", size: "small", onClick: () => fetchAssignmentHandler('assignment') },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_GetAppRounded__WEBPACK_IMPORTED_MODULE_8__["default"], { fontSize: "small", sx: { mr: 1 } }),
                    "Pull"))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: "Submit Files in Assignment" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", color: "success", size: "small", disabled: isDeadlineOver(), onClick: () => submitAssignmentHandler() },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Grading__WEBPACK_IMPORTED_MODULE_9__["default"], { fontSize: "small", sx: { mr: 1 } }),
                    "Submit")),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: "Reset Assignment to Released Version" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", size: "small", color: "error", onClick: () => resetAssignmentHandler() },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_RestartAlt__WEBPACK_IMPORTED_MODULE_10__["default"], { fontSize: "small", sx: { mr: 1 } }),
                    "Reset"))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_11__.AgreeDialog, Object.assign({ open: dialog }, dialogContent))));
};


/***/ }),

/***/ "./lib/components/assignment/assignment-modal.js":
/*!*******************************************************!*\
  !*** ./lib/components/assignment/assignment-modal.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentModalComponent": () => (/* binding */ AssignmentModalComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _submission_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./submission-list */ "./lib/components/assignment/submission-list.js");
/* harmony import */ var _util_overlay__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/overlay */ "./lib/components/util/overlay.js");
/* harmony import */ var _feedback__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./feedback */ "./lib/components/assignment/feedback.js");
/* harmony import */ var _assignment_status__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./assignment-status */ "./lib/components/assignment/assignment-status.js");
/* harmony import */ var _assignment_files__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assignment-files */ "./lib/components/assignment/assignment-files.js");
/* harmony import */ var _util_deadline__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/deadline */ "./lib/components/util/deadline.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.









/**
 * Renders the components available in the extended assignment modal view
 * @param props props of assignment modal component
 */
const AssignmentModalComponent = (props) => {
    const [submissions, setSubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.submissions);
    const [showFeedback, setShowFeedback] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [feedbackSubmission, setFeedbackSubmission] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    /**
     * Opens the feedback view.
     * @param submission submission which feedback will be displayed
     */
    const openFeedback = (submission) => {
        setFeedbackSubmission(submission);
        setShowFeedback(true);
    };
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        setSubmissions(props.submissions);
    }, [props.submissions]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { overflow: 'scroll', height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_2__.ModalTitle, { title: props.assignment.name }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { mt: 10 } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: 'h6', sx: { ml: 2 } }, "Status"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_assignment_status__WEBPACK_IMPORTED_MODULE_3__.AssignmentStatus, { lecture: props.lecture, assignment: props.assignment, submissions: submissions }),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: 'h6', sx: { ml: 2 } },
                "Files",
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_deadline__WEBPACK_IMPORTED_MODULE_4__.DeadlineComponent, { sx: { ml: 1 }, due_date: props.assignment.due_date, compact: false, component: 'chip' })),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_assignment_files__WEBPACK_IMPORTED_MODULE_5__.AssignmentFilesComponent, { lecture: props.lecture, assignment: props.assignment, setSubmissions: setSubmissions }),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: 'h6', sx: { ml: 2, mt: 3 } }, "Submissions"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_submission_list__WEBPACK_IMPORTED_MODULE_6__.SubmissionList, { submissions: submissions, openFeedback: openFeedback, sx: { m: 2, mt: 1 } })),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_overlay__WEBPACK_IMPORTED_MODULE_7__["default"], { onClose: () => setShowFeedback(false), open: showFeedback, container: props.root },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_feedback__WEBPACK_IMPORTED_MODULE_8__.Feedback, { lecture: props.lecture, assignment: props.assignment, submission: feedbackSubmission }))));
};


/***/ }),

/***/ "./lib/components/assignment/assignment-status.js":
/*!********************************************************!*\
  !*** ./lib/components/assignment/assignment-status.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentStatus": () => (/* binding */ AssignmentStatus)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_ChatRounded__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/ChatRounded */ "./node_modules/@mui/icons-material/ChatRounded.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



/**
 * Renders the assignment status stepper.
 * @param props props of assignment status component
 */
const AssignmentStatus = (props) => {
    const [activeStep, setActiveStep] = react__WEBPACK_IMPORTED_MODULE_1__.useState(0);
    /**
     * Calculates what the current step of the student assignment is.
     */
    const getActiveStep = async () => {
        const hasFeedback = props.submissions.reduce((accum, curr) => accum || curr.feedback_available, false);
        if (hasFeedback) {
            return 3;
        }
        if (props.submissions.length > 0) {
            return 1;
        }
        return 0;
    };
    const fontSize = 14;
    const steps = [
        {
            label: 'Pulled',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } }, "You pulled from the release repository and can now work on the assignment. If you are happy with your solution you can submit it. Before the deadline you can always resubmit until you are happy with the solution."))
        },
        {
            label: 'Submitted',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } },
                "You have submitted the assignment ",
                props.submissions.length,
                " time",
                props.submissions.length == 1 ? '' : 's',
                ". The instructor can review each submission, but will most likely prioritise the latest."))
        },
        {
            label: 'Feedback available',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } },
                "You received feedback for one or more of your submissions! You can view the feedback in the list of submission when clicking on the",
                ' ',
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_ChatRounded__WEBPACK_IMPORTED_MODULE_2__["default"], { sx: { fontSize } }),
                " icon. Within the deadline you can make more submissions, regardless of whether you already received feedback."))
        }
    ];
    getActiveStep().then(s => setActiveStep(s));
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, { elevation: 0 },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, { sx: { overflowY: 'auto' } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stepper, { activeStep: activeStep, orientation: "horizontal" }, steps.map((step, index) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Step, { key: step.label },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.StepLabel, null, step.label))))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { mt: 2, ml: 2, maxWidth: '50%' } }, steps[activeStep < 2 ? activeStep : 2].description))));
};


/***/ }),

/***/ "./lib/components/assignment/assignment.js":
/*!*************************************************!*\
  !*** ./lib/components/assignment/assignment.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentComponent": () => (/* binding */ AssignmentComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/red.js");
/* harmony import */ var _mui_icons_material_CheckCircleOutlineOutlined__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/CheckCircleOutlineOutlined */ "./node_modules/@mui/icons-material/CheckCircleOutlineOutlined.js");
/* harmony import */ var _mui_icons_material_CancelOutlined__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/CancelOutlined */ "./node_modules/@mui/icons-material/CancelOutlined.js");
/* harmony import */ var _util_overlay__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/overlay */ "./lib/components/util/overlay.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _util_deadline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/deadline */ "./lib/components/util/deadline.js");
/* harmony import */ var _assignment_modal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./assignment-modal */ "./lib/components/assignment/assignment-modal.js");
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/file.service */ "./lib/services/file.service.js");
/* harmony import */ var _util_card_descriptor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/card-descriptor */ "./lib/components/util/card-descriptor.js");
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.













/**
 * Renders an assignment card which displays data abount the assignment status opens onclick the assignment modal.
 * @param props Props of assignment functional component
 */
const AssignmentComponent = (props) => {
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.assignment);
    const [displayAssignment, setDisplayAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.loadNumber)("a-opened-assignment") === props.assignment.id || false);
    const [submissions, setSubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [hasFeedback, setHasFeedback] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [files, setFiles] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [bestScore, setBestScore] = react__WEBPACK_IMPORTED_MODULE_0__.useState('-');
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_3__.getAllSubmissions)(props.lecture, assignment, 'none', false).then(response => {
            setSubmissions(response);
            const feedback = response.reduce((accum, curr) => accum || curr.feedback_available, false);
            setHasFeedback(feedback);
        });
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_4__.getFiles)(`${props.lecture.code}/${assignment.id}`).then(files => {
            if (files.length === 0) {
                (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_5__.pullAssignment)(props.lecture.id, assignment.id, 'assignment')
                    .then(_ => console.log("No Files found! Pulled assignment."));
            }
            setFiles(files);
        });
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_3__.getAllSubmissions)(props.lecture, props.assignment, 'best', false).then(submissions => {
            if (submissions.length > 0 && submissions[0].score) {
                setBestScore(submissions[0].score.toString());
            }
        });
    }, [props]);
    /**
     * Executed on assignment modal close.
     */
    const onAssignmentClose = async () => {
        setDisplayAssignment(false);
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.deleteKey)("a-opened-assignment");
        setAssignment(await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_5__.getAssignment)(props.lecture.id, assignment.id));
        const submissions = await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_3__.getAllSubmissions)(props.lecture, assignment, 'none', false);
        setSubmissions(submissions);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: {
                maxWidth: 200,
                minWidth: 200,
                height: '100%',
                m: 1.5,
                bgcolor: assignment.status === 'complete' ? '#F1F1F1' : 'white'
            }, onClick: async () => {
                setDisplayAssignment(true);
                (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.storeNumber)("a-opened-assignment", assignment.id);
            } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardActionArea, { sx: { height: '100%', display: 'flex', flexDirection: 'column' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { flexGrow: 1 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: "h5", component: "div", color: assignment.status === 'complete'
                            ? 'text.disabled'
                            : 'text.primary' }, assignment.name),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: { fontSize: 14 }, color: "text.secondary", gutterBottom: true },
                        files.length + ' File' + (files.length === 1 ? '' : 's'),
                        assignment.status === 'released' ? null : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: {
                                fontSize: 12,
                                display: 'inline-block',
                                color: _mui_material_colors__WEBPACK_IMPORTED_MODULE_6__["default"][500],
                                float: 'right'
                            } }, assignment.status === 'complete'
                            ? 'Completed'
                            : 'Not Released'))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { sx: { mt: 1, mb: 1 } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_7__.CardDescriptor, { descriptor: 'Submission', value: submissions.length }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_7__.CardDescriptor, { sx: { mt: 0.25 }, descriptor: (hasFeedback ? 'Has' : 'No') + ' Feedback', value: hasFeedback ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_CheckCircleOutlineOutlined__WEBPACK_IMPORTED_MODULE_8__["default"], { sx: { fontSize: 16, mr: -0.25, mb: -0.35 } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_CancelOutlined__WEBPACK_IMPORTED_MODULE_9__["default"], { sx: { fontSize: 16, mr: -0.25, mb: -0.35 } })) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_7__.CardDescriptor, { descriptor: 'Point', value: bestScore, ofTotal: assignment.points })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_deadline__WEBPACK_IMPORTED_MODULE_10__.DeadlineComponent, { due_date: assignment.due_date, compact: false, component: 'card' }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_overlay__WEBPACK_IMPORTED_MODULE_11__["default"], { onClose: onAssignmentClose, open: displayAssignment, container: props.root, transition: "zoom" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_assignment_modal__WEBPACK_IMPORTED_MODULE_12__.AssignmentModalComponent, { lecture: props.lecture, assignment: assignment, submissions: submissions, root: props.root }))));
};


/***/ }),

/***/ "./lib/components/assignment/feedback.js":
/*!***********************************************!*\
  !*** ./lib/components/assignment/feedback.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Feedback": () => (/* binding */ Feedback)
/* harmony export */ });
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _services_gradebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/gradebook */ "./lib/services/gradebook.js");
/* harmony import */ var _util_file_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/file-list */ "./lib/components/util/file-list.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.






/**
 * Renders the feedback of a student submission.
 * @param props Props of the feedback component
 */
const Feedback = (props) => {
    const [gradeBook, setGradeBook] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [path, setPath] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.getProperties)(props.lecture.id, props.assignment.id, props.submission.id).then(properties => {
            const gradeBook = new _services_gradebook__WEBPACK_IMPORTED_MODULE_3__.GradeBook(properties);
            setGradeBook(gradeBook);
        });
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.pullFeedback)(props.lecture, props.assignment, props.submission).then(() => {
            const feedbackPath = `feedback/${props.lecture.code}/${props.assignment.id}/${props.submission.id}`;
            setPath(feedbackPath);
        });
    }, [props.lecture, props.assignment, props.submission]);
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_4__.ModalTitle, { title: 'Feedback for ' + props.assignment.name }),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { m: 2, mt: 12 } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, { direction: "row", spacing: 2, sx: { ml: 2 } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, { sx: { mt: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Lecture"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Assignment"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Points"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Extra Credit")),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, props.lecture.name),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } },
                        props.assignment.name,
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                                display: 'inline-block',
                                fontSize: 14,
                                ml: 2,
                                height: 35
                            } }, props.assignment.type)),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, gradeBook === null || gradeBook === void 0 ? void 0 :
                        gradeBook.getPoints(),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: { display: 'inline-block', fontSize: 14, ml: 0.25 } },
                            "/", gradeBook === null || gradeBook === void 0 ? void 0 :
                            gradeBook.getMaxPoints())),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, gradeBook === null || gradeBook === void 0 ? void 0 : gradeBook.getExtraCredits())))),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { m: 2, mb: 0 } }, "Feedback Files"),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_file_list__WEBPACK_IMPORTED_MODULE_5__.FilesList, { path: path, sx: { m: 2 } })));
};


/***/ }),

/***/ "./lib/components/assignment/lecture-list.js":
/*!***************************************************!*\
  !*** ./lib/components/assignment/lecture-list.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LectureListComponent": () => (/* binding */ LectureListComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _lecture__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lecture */ "./lib/components/assignment/lecture.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



/**
 * Renders the lectures which the student addends.
 * @param props Props of the lecture file components
 */
const LectureListComponent = (props) => {
    const [lectures, setLectures] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_1__.getAllLectures)().then(lectures => {
            setLectures(lectures);
        });
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "course-list" },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("h1", null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", { className: "course-header" }, "Assignments")),
        lectures.map((el, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_lecture__WEBPACK_IMPORTED_MODULE_2__.LectureComponent, { lecture: el, root: props.root, open: true })))));
};


/***/ }),

/***/ "./lib/components/assignment/lecture.js":
/*!**********************************************!*\
  !*** ./lib/components/assignment/lecture.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LectureComponent": () => (/* binding */ LectureComponent)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _assignment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./assignment */ "./lib/components/assignment/assignment.js");
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





/**
 * Renders the lecture card which contains it's assignments.
 * @param props Props of the lecture component
 */
const LectureComponent = (props) => {
    const [assignments, setAssignments] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [expanded, setExpanded] = react__WEBPACK_IMPORTED_MODULE_1__.useState((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.loadBoolean)("a-expanded", props.lecture) !== null
        ? (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.loadBoolean)("a-expanded", props.lecture)
        : props.open);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.getAllAssignments)(props.lecture.id).then(response => {
            setAssignments(response);
        });
    }, []);
    /**
     * Toggles collapsable in the card body.
     */
    const handleExpandClick = () => {
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.storeBoolean)("a-expanded", !expanded, props.lecture);
        setExpanded(!expanded);
    };
    if (assignments === null) {
        return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.LinearProgress, null))));
    }
    if (assignments.length === 0) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, { sx: { backgroundColor: expanded ? '#fafafa' : 'background.paper' }, elevation: expanded ? 0 : 2, className: "lecture-card" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, { sx: { mb: -1, display: 'flex' } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { variant: 'h5', sx: { mr: 2 } }, props.lecture.name)),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Collapse, { in: expanded, timeout: "auto", unmountOnExit: true },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { container: true, spacing: 2, alignItems: "stretch" }, assignments.map((el) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, gridAutoColumns: '1fr', sx: {
                            maxWidth: 225,
                            minWidth: 225,
                            minHeight: '100%',
                            m: 1.5
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_assignment__WEBPACK_IMPORTED_MODULE_4__.AssignmentComponent, { lecture: props.lecture, assignment: el, root: props.root }))))))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardActions, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { size: "small", sx: { ml: 'auto' }, onClick: handleExpandClick }, (expanded ? 'Hide' : 'Show') + ' Assignments')))));
};


/***/ }),

/***/ "./lib/components/assignment/submission-list.js":
/*!******************************************************!*\
  !*** ./lib/components/assignment/submission-list.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SubmissionList": () => (/* binding */ SubmissionList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_ChatRounded__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material/ChatRounded */ "./node_modules/@mui/icons-material/ChatRounded.js");
/* harmony import */ var _services_datetime_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/datetime.service */ "./lib/services/datetime.service.js");
/* harmony import */ var _mui_icons_material_CloudDoneRounded__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material/CloudDoneRounded */ "./node_modules/@mui/icons-material/CloudDoneRounded.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





/**
 * Renders student submissions in a list
 * @param props Props of submission list component
 */
const SubmissionList = (props) => {
    /**
     * Generates submission items which will be rendered in the list
     * and will be fed using the IIterator from the FilterFileBrowserModel
     * @param submissions student submissions
     */
    const generateItems = (submissions) => {
        return submissions
            .sort((a, b) => (0,_services_datetime_service__WEBPACK_IMPORTED_MODULE_2__.utcToTimestamp)(a.submitted_at) > (0,_services_datetime_service__WEBPACK_IMPORTED_MODULE_2__.utcToTimestamp)(b.submitted_at) ? -1 : 1)
            .map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItem, { disablePadding: true, secondaryAction: value.feedback_available ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_ChatRounded__WEBPACK_IMPORTED_MODULE_3__["default"], null), size: "small", onClick: () => props.openFeedback(value) }, "Open feedback")) : null },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemIcon, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_CloudDoneRounded__WEBPACK_IMPORTED_MODULE_4__["default"], { sx: { ml: 1 } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemText, { primary: (0,_services_datetime_service__WEBPACK_IMPORTED_MODULE_2__.utcToLocalFormat)(value.submitted_at), secondary: value.feedback_available
                        ? `${value.score} Point` + (value.score === 1 ? '' : 's')
                        : null })))));
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 0, sx: props.sx },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { mt: 1 }, variant: "outlined" }, props.submissions.length === 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: 'body1', sx: { ml: 1 } }, "No Submissions Yet")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.List, { dense: false }, generateItems(props.submissions))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/assignment-modal.js":
/*!*********************************************************!*\
  !*** ./lib/components/coursemanage/assignment-modal.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentModalComponent": () => (/* binding */ AssignmentModalComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_Dashboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Dashboard */ "./node_modules/@mui/icons-material/Dashboard.js");
/* harmony import */ var _mui_icons_material_FormatListNumbered__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/FormatListNumbered */ "./node_modules/@mui/icons-material/FormatListNumbered.js");
/* harmony import */ var _mui_icons_material_QueryStats__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/QueryStats */ "./node_modules/@mui/icons-material/QueryStats.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _grading_view_grading__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./grading-view/grading */ "./lib/components/coursemanage/grading-view/grading.js");
/* harmony import */ var _overview_view_overview__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./overview-view/overview */ "./lib/components/coursemanage/overview-view/overview.js");
/* harmony import */ var _stats_view_stats__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./stats-view/stats */ "./lib/components/coursemanage/stats-view/stats.js");
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.










const AssignmentModalComponent = (props) => {
    var _a;
    const [latestSubmissions, setSubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.latestSubmissions);
    const [navigation, setNavigation] = react__WEBPACK_IMPORTED_MODULE_0__.useState((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.loadNumber)("cm-navigation", null, props.assignment) || 0);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: {
                position: 'absolute',
                bottom: 58,
                top: 0,
                left: 0,
                right: 0,
                overflowY: 'auto'
            } },
            navigation === 0 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_overview_view_overview__WEBPACK_IMPORTED_MODULE_3__.OverviewComponent, { lecture: props.lecture, assignment: props.assignment, allSubmissions: props.allSubmissions, latest_submissions: latestSubmissions, users: props.users, onClose: props.onClose })),
            navigation === 1 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_grading_view_grading__WEBPACK_IMPORTED_MODULE_4__.GradingComponent, { lecture: props.lecture, assignment: props.assignment, allSubmissions: props.allSubmissions, root: props.root })),
            navigation === 2 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_stats_view_stats__WEBPACK_IMPORTED_MODULE_5__.StatsComponent, { lecture: props.lecture, assignment: props.assignment, allSubmissions: props.allSubmissions, latestSubmissions: props.latestSubmissions, users: props.users, root: props.root }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { sx: { position: 'absolute', bottom: 0, left: 0, right: 0 }, elevation: 3 },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.BottomNavigation, { showLabels: true, value: navigation, onChange: (event, newValue) => {
                    console.log(newValue);
                    (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_2__.storeNumber)("cm-navigation", newValue, null, props.assignment);
                    setNavigation(newValue);
                    (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_6__.getAllSubmissions)(props.lecture, props.assignment, 'latest', true).then((response) => {
                        setSubmissions(response);
                    });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.BottomNavigationAction, { label: "Overview", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Dashboard__WEBPACK_IMPORTED_MODULE_7__["default"], null) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.BottomNavigationAction, { label: "Submissions", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Badge, { color: "secondary", badgeContent: (_a = props.latestSubmissions) === null || _a === void 0 ? void 0 : _a.length, showZero: props.latestSubmissions !== null },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_FormatListNumbered__WEBPACK_IMPORTED_MODULE_8__["default"], null)) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.BottomNavigationAction, { label: "Stats", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_QueryStats__WEBPACK_IMPORTED_MODULE_9__["default"], null) })))));
};


/***/ }),

/***/ "./lib/components/coursemanage/assignment.js":
/*!***************************************************!*\
  !*** ./lib/components/coursemanage/assignment.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentComponent": () => (/* binding */ AssignmentComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _util_overlay__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/overlay */ "./lib/components/util/overlay.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _assignment_modal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./assignment-modal */ "./lib/components/coursemanage/assignment-modal.js");
/* harmony import */ var _util_deadline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/deadline */ "./lib/components/util/deadline.js");
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/blue.js");
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../services/file.service */ "./lib/services/file.service.js");
/* harmony import */ var _overview_view_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./overview-view/util */ "./lib/components/coursemanage/overview-view/util.js");
/* harmony import */ var _util_card_descriptor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../util/card-descriptor */ "./lib/components/util/card-descriptor.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.













/**
 * Renders an assignment card which opens onclick the assignment modal.
 * @param props Props of assignment functional component
 * @constructor
 */
const AssignmentComponent = (props) => {
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.assignment);
    const [displaySubmissions, setDisplaySubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.loadNumber)("cm-opened-assignment") === props.assignment.id || false);
    const [files, setFiles] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const onSubmissionClose = async () => {
        setDisplaySubmissions(false);
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.deleteKey)("cm-opened-assignment");
        setAssignment(await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_4__.getAssignment)(props.lecture.id, assignment.id));
        props.onDeleted();
    };
    const [allSubmissions, setAllSubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [latestSubmissions, setLatestSubmissions] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [numAutoGraded, setNumAutoGraded] = react__WEBPACK_IMPORTED_MODULE_0__.useState(0);
    const [numManualGraded, setNumManualGraded] = react__WEBPACK_IMPORTED_MODULE_0__.useState(0);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_5__.getAllSubmissions)(props.lecture, assignment, 'none', true).then(response => {
            setAllSubmissions(response);
            let auto = 0;
            const autoUserSet = new Set();
            let manual = 0;
            const manualUserSet = new Set();
            for (const submission of response) {
                if (submission.auto_status === 'automatically_graded' &&
                    !autoUserSet.has(submission.username)) {
                    autoUserSet.add(submission.username);
                    auto++;
                }
                if (submission.manual_status === 'manually_graded' &&
                    !manualUserSet.has(submission.username)) {
                    manualUserSet.add(submission.username);
                    manual++;
                }
            }
            setNumAutoGraded(auto);
            setNumManualGraded(manual);
        }, (error) => {
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error.message, {
                variant: 'error'
            });
        });
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_5__.getAllSubmissions)(props.lecture, assignment, 'latest', true).then(response => {
            setLatestSubmissions(response);
        });
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_6__.getFiles)(`source/${props.lecture.code}/${assignment.id}`).then(files => {
            setFiles(files);
        });
    }, [assignment]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { maxWidth: 225, minWidth: 225, height: '100%', m: 1.5 }, onClick: async () => {
                await (0,_overview_view_util__WEBPACK_IMPORTED_MODULE_7__.openBrowser)(`source/${props.lecture.code}/${assignment.id}`);
                setDisplaySubmissions(true);
                (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.storeNumber)("cm-opened-assignment", assignment.id);
            } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardActionArea, { sx: { height: '100%', display: 'flex', flexDirection: 'column' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { flexGrow: 1 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: "h5", component: "div" }, assignment.name),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: { fontSize: 14 }, color: "text.secondary", gutterBottom: true },
                        files.length + ' File' + (files.length === 1 ? '' : 's'),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: {
                                fontSize: 12,
                                display: 'inline-block',
                                color: _mui_material_colors__WEBPACK_IMPORTED_MODULE_8__["default"][500],
                                float: 'right'
                            } }, assignment.status)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { sx: { mt: 1, mb: 1 } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_9__.CardDescriptor, { descriptor: 'Point', value: assignment.points, fontSizeDescriptor: 13 }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_9__.CardDescriptor, { descriptor: 'Submission', value: latestSubmissions.length, fontSizeDescriptor: 13 }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_9__.CardDescriptor, { descriptor: 'Autograded Submission', value: numAutoGraded, ofTotal: latestSubmissions.length, fontSizeDescriptor: 13 }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_card_descriptor__WEBPACK_IMPORTED_MODULE_9__.CardDescriptor, { descriptor: 'Manualgraded Submission', value: numManualGraded, ofTotal: latestSubmissions.length, fontSizeDescriptor: 13 })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_deadline__WEBPACK_IMPORTED_MODULE_10__.DeadlineComponent, { due_date: assignment.due_date, compact: false, component: 'card' }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_overlay__WEBPACK_IMPORTED_MODULE_11__["default"], { onClose: onSubmissionClose, open: displaySubmissions, container: props.root, transition: "zoom" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_assignment_modal__WEBPACK_IMPORTED_MODULE_12__.AssignmentModalComponent, { lecture: props.lecture, assignment: assignment, allSubmissions: allSubmissions, latestSubmissions: latestSubmissions, root: props.root, users: props.users, onClose: onSubmissionClose }))));
};


/***/ }),

/***/ "./lib/components/coursemanage/coursemanage.component.js":
/*!***************************************************************!*\
  !*** ./lib/components/coursemanage/coursemanage.component.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CourseManageComponent": () => (/* binding */ CourseManageComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _services_permission_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/permission.service */ "./lib/services/permission.service.js");
/* harmony import */ var _lecture__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./lecture */ "./lib/components/coursemanage/lecture.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





const CourseManageComponent = (props) => {
    const [lectures, setLectures] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    const [completedLectures, setCompletedLectures] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.UserPermissions.loadPermissions().then(() => {
            (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_3__.getAllLectures)().then(l => setLectures(l));
            (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_3__.getAllLectures)(true).then(l => setCompletedLectures(l));
        }, error => (0,notistack__WEBPACK_IMPORTED_MODULE_1__.enqueueSnackbar)(error.message, {
            variant: 'error'
        }));
    }, [props]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "course-list" },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("h1", null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", { className: "course-header" }, "Course Management")),
        lectures
            .filter(el => _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.UserPermissions.getScope(el) > _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.Scope.student)
            .map((el, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_lecture__WEBPACK_IMPORTED_MODULE_4__.LectureComponent, { lecture: el, root: props.root, expanded: true }))),
        completedLectures
            .filter(el => _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.UserPermissions.getScope(el) > _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.Scope.student)
            .map((el, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_lecture__WEBPACK_IMPORTED_MODULE_4__.LectureComponent, { lecture: el, root: props.root, expanded: false })))));
};


/***/ }),

/***/ "./lib/components/coursemanage/grading-view/grading.js":
/*!*************************************************************!*\
  !*** ./lib/components/coursemanage/grading-view/grading.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradingComponent": () => (/* binding */ GradingComponent)
/* harmony export */ });
/* harmony import */ var _mui_x_data_grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/x-data-grid */ "webpack/sharing/consume/default/@mui/x-data-grid/@mui/x-data-grid");
/* harmony import */ var _mui_x_data_grid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_x_data_grid__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_datetime_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../services/datetime.service */ "./lib/services/datetime.service.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material_Select__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/material/Select */ "./node_modules/@mui/material/Select/Select.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _mui_icons_material_NavigateNext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/icons-material/NavigateNext */ "./node_modules/@mui/icons-material/NavigateNext.js");
/* harmony import */ var _mui_icons_material_FileDownload__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/icons-material/FileDownload */ "./node_modules/@mui/icons-material/FileDownload.js");
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _services_grading_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../services/grading.service */ "./lib/services/grading.service.js");
/* harmony import */ var _util_overlay__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../util/overlay */ "./lib/components/util/overlay.js");
/* harmony import */ var _manual_grading__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./manual-grading */ "./lib/components/coursemanage/grading-view/manual-grading.js");
/* harmony import */ var _mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/Replay */ "./node_modules/@mui/icons-material/Replay.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../index */ "./lib/index.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

















/**
 * Renders the grading view in which the course management can grade student submissions and generate feedback.
 * @param props Props of the grading component
 */
const GradingComponent = (props) => {
    var _a, _b, _c, _d;
    const [option, setOption] = react__WEBPACK_IMPORTED_MODULE_1__.useState(((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_4__.loadString)("grading-submission-option", null, props.assignment) || 'none'));
    const [showDialog, setShowDialog] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const [showLogs, setShowLogs] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const [logs, setLogs] = react__WEBPACK_IMPORTED_MODULE_1__.useState(undefined);
    const [dialogContent, setDialogContent] = react__WEBPACK_IMPORTED_MODULE_1__.useState({
        title: '',
        message: '',
        handleAgree: null,
        handleDisagree: null
    });
    const [displayManualGrading, setDisplayManualGrading] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const onManualGradingClose = async () => {
        setDisplayManualGrading(false);
    };
    /**
     * Removes row selection.
     */
    const cleanSelectedRows = () => {
        setSelectedRows([]);
    };
    /**
     * Automatically grade selected submissions.
     */
    const handleAutogradeSubmissions = async () => {
        setDialogContent({
            title: 'Autograde Selected Submissions',
            message: 'Do you wish to autograde the selected submissions?',
            handleAgree: async () => {
                try {
                    const numSubs = selectedRowsData.length;
                    selectedRowsData.map(async (row) => {
                        row.auto_status = 'pending';
                        await (0,_services_grading_service__WEBPACK_IMPORTED_MODULE_5__.autogradeSubmission)(props.lecture, props.assignment, getSubmissionFromRow(row));
                        console.log('Autograded submission');
                    });
                }
                catch (err) {
                    console.error(err);
                    (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)('Error Autograding Submissions', {
                        variant: 'error'
                    });
                }
                cleanSelectedRows();
                closeDialog();
            },
            handleDisagree: () => closeDialog()
        });
        setShowDialog(true);
    };
    /**
     * Generate feedback for selected submissions.
     */
    const handleGenerateFeedback = async () => {
        setDialogContent({
            title: 'Generate Feedback',
            message: 'Do you wish to generate Feedback of the selected submissions?',
            handleAgree: async () => {
                try {
                    const numSubs = selectedRowsData.length;
                    await Promise.all(selectedRowsData.map(async (row) => {
                        await (0,_services_grading_service__WEBPACK_IMPORTED_MODULE_5__.generateFeedback)(props.lecture.id, props.assignment.id, row.id);
                        console.log('Autograded submission');
                    }));
                    (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_6__.getAllSubmissions)(props.lecture, props.assignment, option, true).then(response => {
                        setRows(generateRows(response));
                        (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)(`Generating Feedback for ${numSubs} Submissions`, {
                            variant: 'success'
                        });
                    });
                }
                catch (err) {
                    console.error(err);
                    (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)('Error Generating Feedback', {
                        variant: 'error'
                    });
                }
                cleanSelectedRows();
                closeDialog();
            },
            handleDisagree: () => closeDialog()
        });
        setShowDialog(true);
    };
    /**
     * Closes dialog window.
     */
    const closeDialog = () => setShowDialog(false);
    /**
     * Generates rows objects out of submission.
     * @param submissions submissions which are used to generate row objects
     */
    const generateRows = (submissions) => {
        console.log('Submissions');
        console.log(submissions);
        console.log('option: ' + option);
        const rows = [];
        let id = 1;
        submissions.forEach((sub) => {
            rows.push({
                id: sub.id,
                sub_id: id++,
                username: sub.username,
                submitted_at: (0,_services_datetime_service__WEBPACK_IMPORTED_MODULE_7__.utcToLocalFormat)(sub.submitted_at),
                auto_status: sub.auto_status,
                manual_status: sub.manual_status,
                logs: sub.logs,
                commit_hash: sub.commit_hash,
                feedback_available: sub.feedback_available,
                score: sub.score
            });
        });
        console.log(rows);
        return rows;
    };
    const [submissions, setSubmissions] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.allSubmissions);
    const [rows, setRows] = react__WEBPACK_IMPORTED_MODULE_1__.useState([]);
    const [selectedRows, setSelectedRows] = react__WEBPACK_IMPORTED_MODULE_1__.useState([]);
    const [selectedRowsData, setSelectedRowsData] = react__WEBPACK_IMPORTED_MODULE_1__.useState([]);
    /**
     * Updates rows by setting the new value of the submission select.
     * @param event select change event
     */
    const handleChange = (event) => {
        setOption(event.target.value);
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_4__.storeString)("grading-submission-option", event.target.value, null, props.assignment);
    };
    /**
     * Updates submissions and rows.
     */
    const updateSubmissions = () => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_6__.getAllSubmissions)(props.lecture, props.assignment, option, true).then(response => {
            setRows(generateRows(response));
            setSubmissions(response);
        });
    };
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        updateSubmissions();
    }, [option, displayManualGrading]);
    /**
     * Calculates chip color based on submission status.
     * @param value submission status
     * @return chip color
     */
    const getColor = (value) => {
        if (value === 'not_graded') {
            return 'warning';
        }
        else if (value === 'automatically_graded' ||
            value === 'manually_graded') {
            return 'success';
        }
        else if (value === 'grading_failed') {
            return 'error';
        }
        return 'primary';
    };
    /**
     * Opens log dialog which contain autograded logs from grader service.
     * @param params row which is needed to find selected submission
     */
    const openLogs = (params) => {
        const submission = getSubmissionFromRow(params.row);
        const logs = submission.logs;
        if (logs === undefined || logs === null || logs === '') {
            (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)('No logs for submission', {
                variant: 'error'
            });
            return;
        }
        setLogs(logs);
        setShowLogs(true);
    };
    const columns = [
        { field: 'sub_id', headerName: 'No.', width: 110 },
        { field: 'username', headerName: 'User', width: 130 },
        { field: 'submitted_at', headerName: 'Date', width: 170 },
        {
            field: 'auto_status',
            headerName: 'Autograde-Status',
            width: 200,
            renderCell: (params) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Chip, { variant: "outlined", label: params.value, color: getColor(params.value), clickable: true, onClick: () => openLogs(params) }))
        },
        {
            field: 'manual_status',
            headerName: 'Manualgrade-Status',
            width: 170,
            renderCell: (params) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Chip, { variant: "outlined", label: params.value, color: getColor(params.value) }))
        },
        {
            field: 'feedback_available',
            headerName: 'Feedback generated',
            width: 170,
            renderCell: (params) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Chip, { variant: "outlined", label: params.value ? 'Generated' : 'Not Generated', color: params.value ? 'success' : 'error' }))
        },
        { field: 'score', headerName: 'Score', width: 130 }
    ];
    /**
     * Returns submission based on given rows.
     * @param row row which is needed to determine submission
     */
    const getSubmissionFromRow = (row) => {
        // Leave linear search for now (there were problems with casting and the local display date when casting)
        if (row === undefined) {
            return null;
        }
        const id = row.id;
        const submission = submissions.find(s => s.id === id);
        console.log(submission);
        return submission === undefined ? null : submission;
    };
    const allManualGraded = (selection) => {
        return selection.reduce((acc, cur) => {
            return cur.manual_status === 'manually_graded' && acc;
        }, true);
    };
    const optionName = () => {
        if (option === 'latest') {
            return 'Latest';
        }
        else if (option === 'best') {
            return 'Best';
        }
        else {
            return 'All';
        }
    };
    const openFile = async (path) => {
        console.log('Opening file: ' + path);
        _index__WEBPACK_IMPORTED_MODULE_8__.GlobalObjects.commands.execute('docmanager:open', {
            path: path,
            options: {
                mode: 'tab-after' // tab-after tab-before split-bottom split-right split-left split-top
            }
        })
            .catch(error => {
            (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)(error.message, {
                variant: 'error'
            });
            console.log(error);
        });
    };
    /**
     * Exports submissions.
     */
    const handleExportSubmissions = async () => {
        try {
            await (0,_services_grading_service__WEBPACK_IMPORTED_MODULE_5__.saveSubmissions)(props.lecture, props.assignment, option);
            await openFile(`${props.lecture.code}/submissions.csv`);
            (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)('Successfully exported submissions', {
                variant: 'success'
            });
        }
        catch (err) {
            console.log(err);
            (0,notistack__WEBPACK_IMPORTED_MODULE_3__.enqueueSnackbar)('Error Exporting Submissions', {
                variant: 'error'
            });
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_9__.ModalTitle, { title: "Grading" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { ml: 2 }, display: "inline-block" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { title: "Reload" },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.IconButton, { "aria-label": "reload", onClick: updateSubmissions },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_10__["default"], null))))),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { display: 'flex', height: '50vh', marginTop: '30px' } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { style: { flexGrow: 1 } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_x_data_grid__WEBPACK_IMPORTED_MODULE_0__.DataGrid, { sx: { mb: 3, ml: 3, mr: 3 }, columns: columns, rows: rows, checkboxSelection: true, disableSelectionOnClick: true, selectionModel: selectedRows, onSelectionModelChange: e => {
                        const selectedIDs = new Set(e);
                        const selectedRowData = rows.filter(row => selectedIDs.has(row.id));
                        setSelectedRows(e);
                        setSelectedRowsData(selectedRowData);
                    } }))),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement("span", { style: { height: '15vh' } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.FormControl, { sx: { m: 3 } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.InputLabel, { id: "submission-select-label" }, "View"),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material_Select__WEBPACK_IMPORTED_MODULE_11__["default"], { labelId: "submission-select-label", id: "submission-select", value: option, label: "Age", onChange: handleChange },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { value: 'none' }, "All Submissions"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { value: 'latest' }, "Latest Submissions of Users"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { value: 'best' }, "Best Submissions of Users"))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { title: `Run Autograde Tests for ${selectedRows.length} Submission${selectedRows.length === 1 ? "" : "s"}` },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disabled: selectedRows.length === 0, sx: { m: 3 }, variant: "outlined", onClick: handleAutogradeSubmissions }, `Autograde (${selectedRows.length})`)),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_NavigateNext__WEBPACK_IMPORTED_MODULE_12__["default"], { color: selectedRowsData.length === 1 &&
                    ((_a = selectedRowsData[0]) === null || _a === void 0 ? void 0 : _a.auto_status) !== 'automatically_graded'
                    ? 'error'
                    : selectedRowsData.length !== 1 ||
                        ((_b = selectedRowsData[0]) === null || _b === void 0 ? void 0 : _b.auto_status) !== 'automatically_graded'
                        ? 'disabled'
                        : 'primary', sx: { mb: -1 } }),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { title: "Manually Grade Answers of Submission" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disabled: selectedRowsData.length !== 1 ||
                        ((_c = selectedRowsData[0]) === null || _c === void 0 ? void 0 : _c.auto_status) !== 'automatically_graded', sx: { m: 3 }, onClick: () => {
                        cleanSelectedRows();
                        setDisplayManualGrading(true);
                    }, variant: "outlined" }, 'Manualgrade')),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_NavigateNext__WEBPACK_IMPORTED_MODULE_12__["default"], { color: selectedRows.length === 0
                    ? 'disabled'
                    : allManualGraded(selectedRowsData) ||
                        props.assignment.automatic_grading === 'full_auto'
                        ? 'primary'
                        : 'error', sx: { mb: -1 } }),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { title: "Generate and Publish Feedback" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disabled: selectedRows.length === 0 ||
                        (props.assignment.automatic_grading !== 'full_auto' &&
                            !allManualGraded(selectedRowsData)), sx: { m: 3 }, onClick: handleGenerateFeedback, variant: "outlined" }, `Generate Feedback (${selectedRows.length})`)),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { startIcon: react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_FileDownload__WEBPACK_IMPORTED_MODULE_13__["default"], null), sx: { m: 3 }, onClick: handleExportSubmissions, variant: "outlined" }, `Export ${optionName()} Submissions`)),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_overlay__WEBPACK_IMPORTED_MODULE_14__["default"], { onClose: onManualGradingClose, open: displayManualGrading, container: props.root, transition: "zoom" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_manual_grading__WEBPACK_IMPORTED_MODULE_15__.ManualGrading, { lecture: props.lecture, assignment: props.assignment, submission: getSubmissionFromRow(selectedRowsData[0]), username: (_d = selectedRowsData[0]) === null || _d === void 0 ? void 0 : _d.username, onClose: onManualGradingClose })),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_16__.AgreeDialog, Object.assign({ open: showDialog }, dialogContent)),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Dialog, { open: showLogs, onClose: () => setShowLogs(false), "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { id: "alert-dialog-title" }, 'Logs'),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogContent, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, { id: "alert-dialog-description", sx: { fontSize: 10, fontFamily: "'Roboto Mono', monospace" } }, logs)),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogActions, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { onClick: () => setShowLogs(false) }, "Close")))));
};


/***/ }),

/***/ "./lib/components/coursemanage/grading-view/manual-grading.js":
/*!********************************************************************!*\
  !*** ./lib/components/coursemanage/grading-view/manual-grading.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ManualGrading": () => (/* binding */ ManualGrading)
/* harmony export */ });
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _services_gradebook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../services/gradebook */ "./lib/services/gradebook.js");
/* harmony import */ var _services_grading_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/grading.service */ "./lib/services/grading.service.js");
/* harmony import */ var _util_file_list__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/file-list */ "./lib/components/util/file-list.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/Replay */ "./node_modules/@mui/icons-material/Replay.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.










const ManualGrading = (props) => {
    const [gradeBook, setGradeBook] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [path, setPath] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [showDialog, setShowDialog] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const [dialogContent, setDialogContent] = react__WEBPACK_IMPORTED_MODULE_1__.useState({
        title: '',
        message: '',
        handleAgree: null,
        handleDisagree: null
    });
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        reloadProperties();
        (0,_services_grading_service__WEBPACK_IMPORTED_MODULE_3__.createManualFeedback)(props.lecture.id, props.assignment.id, props.submission.id).then(() => {
            const manualPath = `manualgrade/${props.lecture.code}/${props.assignment.id}/${props.submission.id}`;
            console.log('Successfully pulled autograde repo into ' + manualPath);
            setPath(manualPath);
        });
    }, [props.lecture, props.assignment, props.submission]);
    const openFinishDialog = () => {
        setDialogContent({
            title: 'Confirm Grading',
            message: 'Do you want to save the assignment grading?',
            handleAgree: finishGrading,
            handleDisagree: () => {
                setShowDialog(false);
            }
        });
        setShowDialog(true);
    };
    const finishGrading = () => {
        props.submission.manual_status = 'manually_graded';
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.updateSubmission)(props.lecture.id, props.assignment.id, props.submission.id, props.submission).then(response => {
            props.onClose();
        }, err => {
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(err.message, {
                variant: 'error'
            });
        });
    };
    const reloadProperties = () => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.getProperties)(props.lecture.id, props.assignment.id, props.submission.id).then(properties => {
            const gradeBook = new _services_gradebook__WEBPACK_IMPORTED_MODULE_5__.GradeBook(properties);
            setGradeBook(gradeBook);
        });
    };
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_6__.ModalTitle, { title: 'Manual Grading ' + props.assignment.id }),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { m: 2, mt: 12 } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, { direction: "row", spacing: 2, sx: { ml: 2 } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, { sx: { mt: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Username"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Lecture"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Assignment"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Points"),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { textAlign: "right", color: "text.secondary", sx: { fontSize: 12, height: 35 } }, "Extra Credit")),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, props.username),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, props.lecture.name),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } },
                        props.assignment.name,
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                                display: 'inline-block',
                                fontSize: 14,
                                ml: 2,
                                height: 35
                            } }, props.assignment.type)),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, gradeBook === null || gradeBook === void 0 ? void 0 :
                        gradeBook.getPoints(),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: { display: 'inline-block', fontSize: 14, ml: 0.25 } },
                            "/", gradeBook === null || gradeBook === void 0 ? void 0 :
                            gradeBook.getMaxPoints())),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.primary", sx: { display: 'inline-block', fontSize: 16, height: 35 } }, gradeBook === null || gradeBook === void 0 ? void 0 : gradeBook.getExtraCredits())))),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { m: 2, mb: 0 } }, "Submission Files"),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_file_list__WEBPACK_IMPORTED_MODULE_7__.FilesList, { path: path, sx: { m: 2 } }),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stack, { direction: 'row', sx: { ml: 2 }, spacing: 2 },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Reload" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.IconButton, { "aria-label": "reload", onClick: () => reloadProperties() },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_8__["default"], null))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { variant: "outlined", color: "success", onClick: openFinishDialog, sx: { ml: 2 } }, "Confirm Manualgrade")),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_9__.AgreeDialog, Object.assign({ open: showDialog }, dialogContent))));
};


/***/ }),

/***/ "./lib/components/coursemanage/lecture.js":
/*!************************************************!*\
  !*** ./lib/components/coursemanage/lecture.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LectureComponent": () => (/* binding */ LectureComponent)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _assignment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./assignment */ "./lib/components/coursemanage/assignment.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/red.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/storage.service */ "./lib/services/storage.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.









const LectureComponent = (props) => {
    const [lecture, setLecture] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.lecture);
    const [assignments, setAssignments] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [expanded, setExpanded] = react__WEBPACK_IMPORTED_MODULE_1__.useState((0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.loadBoolean)("cm-expanded", lecture) !== null
        ? (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.loadBoolean)("cm-expanded", lecture)
        : props.expanded === undefined
            ? false
            : props.expanded);
    const [users, setUsers] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_4__.getAllAssignments)(lecture.id).then(response => {
            setAssignments(response);
        });
        (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_5__.getUsers)(lecture).then(response => {
            setUsers(response);
        });
    }, [lecture]);
    const onAssignmentDelete = () => {
        (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_4__.getAllAssignments)(lecture.id).then(response => {
            setAssignments(response);
        });
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.deleteKey)("cm-opened-assignment");
    };
    const handleExpandClick = () => {
        (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.storeBoolean)("cm-expanded", !expanded, lecture);
        setExpanded(!expanded);
    };
    if (assignments === null) {
        return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.LinearProgress, null))));
    }
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, { sx: { backgroundColor: expanded ? '#fafafa' : 'background.paper' }, elevation: expanded ? 0 : 2, className: "lecture-card" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, { sx: { mb: -1, display: 'flex' } },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { variant: 'h5', sx: { mr: 2 } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: 'text.secondary', sx: {
                            display: 'inline-block',
                            mr: 0.75,
                            fontSize: 16
                        } }, "Lecture:"),
                    lecture.name,
                    lecture.complete ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: {
                            display: 'inline-block',
                            ml: 0.75,
                            fontSize: 16,
                            color: _mui_material_colors__WEBPACK_IMPORTED_MODULE_6__["default"][400]
                        } }, "complete")) : null),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_7__.EditLectureDialog, { lecture: lecture, handleSubmit: updatedLecture => {
                        (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_5__.updateLecture)(updatedLecture).then(response => {
                            setLecture(response);
                        }, error => {
                            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error.message, {
                                variant: 'error'
                            });
                        });
                    } })),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Collapse, { in: expanded, timeout: "auto", unmountOnExit: true },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, null,
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { container: true, spacing: 2, alignItems: "stretch" },
                        assignments.map((el) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, gridAutoColumns: '1fr', sx: {
                                maxWidth: 225,
                                minWidth: 225,
                                minHeight: '100%',
                                m: 1.5
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_assignment__WEBPACK_IMPORTED_MODULE_8__.AssignmentComponent, { lecture: lecture, assignment: el, root: props.root, users: users, onDeleted: onAssignmentDelete })))),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, gridAutoColumns: '1fr', sx: {
                                maxWidth: 225,
                                minWidth: 225,
                                minHeight: 225,
                                heigth: '100%',
                                m: 1.5
                            } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_7__.CreateDialog, { lecture: lecture, handleSubmit: () => {
                                    (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_4__.getAllAssignments)(lecture.id).then(response => {
                                        setAssignments(response);
                                    });
                                    setExpanded(true);
                                } }))))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardActions, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { size: "small", sx: { ml: 'auto' }, onClick: handleExpandClick }, (expanded ? 'Hide' : 'Show') + ' Assignments')))));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/assignment-status.js":
/*!************************************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/assignment-status.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentStatus": () => (/* binding */ AssignmentStatus)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_NewReleasesRounded__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/NewReleasesRounded */ "./node_modules/@mui/icons-material/NewReleasesRounded.js");
/* harmony import */ var _mui_icons_material_Task__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/Task */ "./node_modules/@mui/icons-material/Task.js");
/* harmony import */ var _mui_icons_material_Undo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Undo */ "./node_modules/@mui/icons-material/Undo.js");
/* harmony import */ var _mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material/Terminal */ "./node_modules/@mui/icons-material/Terminal.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.









/**
 * Calculates step of stepper based on assignment status
 * @param status assignment status
 */
const getActiveStep = (status) => {
    switch (status) {
        case 'created':
            return 0;
        case 'pushed':
            return 0;
        case 'released':
            return 1;
        case 'complete':
            return 2;
    }
};
/**
 * Renders the assignment status and instructions for the end user.
 * @param props props of assignment status
 */
const AssignmentStatus = (props) => {
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.assignment);
    const [showDialog, setShowDialog] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const [dialogContent, setDialogContent] = react__WEBPACK_IMPORTED_MODULE_1__.useState({
        title: '',
        message: '',
        handleAgree: null,
        handleDisagree: null
    });
    /**
     * Updates assignment status.
     * @param status assignment status
     * @param success alert color if successful
     * @param error alert color if not successful
     */
    const updateAssignmentStatus = async (status, success, error) => {
        try {
            console.log('releasing assignment');
            let a = assignment;
            a.status = status;
            a = await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.updateAssignment)(props.lecture.id, a);
            setAssignment(a);
            props.onAssignmentChange(a);
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(success, {
                variant: 'success'
            });
        }
        catch (err) {
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error, {
                variant: 'error'
            });
        }
    };
    /**
     * Handles assignment status change to "released" status
     */
    const handleReleaseAssignment = async () => {
        await updateAssignmentStatus('released', 'Successfully Released Assignment', 'Error Releasing Assignment');
    };
    /**
     * Handles assignment status change to "pushed" status
     */
    const handlePushAssignment = async (commitMessage) => {
        try {
            // Note: has to be in this order (release -> source)
            console.log('pushing assignment');
            await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pushAssignment)(props.lecture.id, assignment.id, 'release');
            await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.pushAssignment)(props.lecture.id, assignment.id, 'source', commitMessage);
        }
        catch (err) {
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)('Error Pushing Assignment', {
                variant: 'error'
            });
            return;
        }
        await updateAssignmentStatus('pushed', 'Successfully Pushed Assignment', 'Error Updating Assignment');
    };
    const closeDialog = () => setShowDialog(false);
    const fontSize = 16;
    const steps = [
        {
            label: 'Edit',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } },
                    "The assignment has been created and files can now be added to be pushed. You can commit and pull changes from the remote file repository through the file view or can work directly with the underlying git repositories by opening the assignment in the terminal (",
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_4__["default"], { color: 'primary', fontSize: 'inherit' }),
                    "). After you are done working on the files you can release the assignment, which makes a final commit with the current state of the assignment."),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_5__.ReleaseDialog, { assignment: assignment, handleCommit: handlePushAssignment, handleRelease: handleReleaseAssignment },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Release Assignment for Students" },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { sx: { mt: 1 }, variant: "outlined", size: "small" },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_NewReleasesRounded__WEBPACK_IMPORTED_MODULE_6__["default"], { fontSize: "small", sx: { mr: 1 } }),
                            "Release")))))
        },
        {
            label: 'Released',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } }, "The assignment has been released to students and it is not advised to push further changes to the repository. If the assignment is over you can mark it as complete in the edit menu or right here. Undoing the release of the assignment will hide the assignment from students again but their local files are unaffected by this action. When re-releasing the assignment after significant changes a new commit will be made and you will have to instruct users to reset their progress thus far or work with separate versions later on."),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Hide Released Assignment from Students" },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { sx: { mt: 1, mr: 1 }, onClick: () => updateAssignmentStatus('pushed', 'Successfully Revoked Assignment', 'Error Revoking Assignment'), variant: "outlined", size: "small" },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Undo__WEBPACK_IMPORTED_MODULE_7__["default"], { fontSize: "small", sx: { mr: 1 } }),
                        "Undo Release")),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Mark Assignment as Complete" },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { sx: { mt: 1 }, onClick: () => completeAssignment(), variant: "outlined", size: "small" },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Task__WEBPACK_IMPORTED_MODULE_8__["default"], { fontSize: "small", sx: { mr: 1 } }),
                        "Complete"))))
        },
        {
            label: 'Assignment Completed',
            description: (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize } }, "The assignment has been completed and is not visible to students anymore but all their progress will be saved. When re-activating the assignment it will again show up in the assignment view and new submissions can be made given the deadline is set accordingly."),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Undo Complete and Release Assignment" },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Button, { sx: { mt: 1 }, onClick: () => updateAssignmentStatus('released', 'Successfully Released Assignment', 'Error Releasing Assignment'), variant: "outlined", size: "small" },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Undo__WEBPACK_IMPORTED_MODULE_7__["default"], { fontSize: "small", sx: { mr: 1 } }),
                        "Undo Complete"))))
        }
    ];
    /**
     * Handles assignment status change to "complete" status
     */
    const completeAssignment = async () => {
        setDialogContent({
            title: 'Complete Assignment',
            message: `Do you want to mark ${assignment.name} as complete? This action will hide the assignment for all students!`,
            handleAgree: async () => {
                await updateAssignmentStatus('complete', 'Successfully Updated Assignment', 'Error Updating Assignment');
                closeDialog();
            },
            handleDisagree: () => closeDialog()
        });
        setShowDialog(true);
    };
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Paper, { elevation: 3 },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { overflowX: 'auto', p: 3 } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Stepper, { activeStep: getActiveStep(assignment.status), orientation: "horizontal" }, steps.map((step, index) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Step, { key: step.label },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.StepLabel, { optional: index === 2 ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { variant: "caption" }, "Last step")) : null }, step.label))))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, null, steps[getActiveStep(assignment.status)].description)),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_5__.AgreeDialog, Object.assign({ open: showDialog }, dialogContent))));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/files.js":
/*!************************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/files.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Files": () => (/* binding */ Files)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _mui_icons_material_GetAppRounded__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/GetAppRounded */ "./node_modules/@mui/icons-material/GetAppRounded.js");
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/icons-material/Replay */ "./node_modules/@mui/icons-material/Replay.js");
/* harmony import */ var _mui_icons_material_OpenInBrowser__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @mui/icons-material/OpenInBrowser */ "./node_modules/@mui/icons-material/OpenInBrowser.js");
/* harmony import */ var _mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @mui/icons-material/Terminal */ "./node_modules/@mui/icons-material/Terminal.js");
/* harmony import */ var _mui_icons_material_AddBox__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @mui/icons-material/AddBox */ "./node_modules/@mui/icons-material/AddBox.js");
/* harmony import */ var _mui_icons_material_Check__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/Check */ "./node_modules/@mui/icons-material/Check.js");
/* harmony import */ var _mui_icons_material_ErrorOutline__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/icons-material/ErrorOutline */ "./node_modules/@mui/icons-material/ErrorOutline.js");
/* harmony import */ var _util_file_list__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../util/file-list */ "./lib/components/util/file-list.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../index */ "./lib/index.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./util */ "./lib/components/coursemanage/overview-view/util.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_icons_material_PublishRounded__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/icons-material/PublishRounded */ "./node_modules/@mui/icons-material/PublishRounded.js");
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../services/file.service */ "./lib/services/file.service.js");
/* harmony import */ var _util_repo_type__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/repo-type */ "./lib/components/util/repo-type.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_4__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





















/**
 * Renders in a file list the assignment files.
 * @param props props of the file component
 */
const Files = (props) => {
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.assignment);
    const [lecture, setLecture] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.lecture);
    const [selectedDir, setSelectedDir] = react__WEBPACK_IMPORTED_MODULE_0__.useState('source');
    const [showDialog, setShowDialog] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [dialogContent, setDialogContent] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
        title: '',
        message: '',
        handleAgree: null,
        handleDisagree: null
    });
    const [reloadFilesToggle, setReloadFiles] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [repoStatus, setRepoStatus] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    const [srcChangedTimestamp, setSrcChangeTimestamp] = react__WEBPACK_IMPORTED_MODULE_0__.useState(moment__WEBPACK_IMPORTED_MODULE_2___default()().valueOf()); // now
    const [generateTimestamp, setGenerateTimestamp] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    const serverRoot = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.PageConfig.getOption('serverRoot');
    const isCommitOverwrite = () => repoStatus === 'pull_needed' || repoStatus === 'divergent';
    const isPullOverwrite = () => repoStatus === 'push_needed' || repoStatus === 'divergent';
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const srcPath = `source/${lecture.code}/${assignment.id}`;
        _index__WEBPACK_IMPORTED_MODULE_5__.GlobalObjects.docManager.services.contents.fileChanged.connect((sender, change) => {
            const { oldValue, newValue } = change;
            if (!newValue.path.includes(srcPath)) {
                return;
            }
            const modified = moment__WEBPACK_IMPORTED_MODULE_2___default()(newValue.last_modified).valueOf();
            if (srcChangedTimestamp === null || srcChangedTimestamp < modified) {
                setSrcChangeTimestamp(modified);
                console.log('New source file changed timestamp: ' + modified);
            }
        }, undefined);
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_6__.getRemoteStatus)(lecture, assignment, _util_repo_type__WEBPACK_IMPORTED_MODULE_7__.RepoType.SOURCE).then(status => {
            setRepoStatus(status);
        });
    }, [props]);
    /**
     * Reload file view.
     */
    const reloadFiles = () => {
        setReloadFiles(!reloadFilesToggle);
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_6__.getRemoteStatus)(lecture, assignment, _util_repo_type__WEBPACK_IMPORTED_MODULE_7__.RepoType.SOURCE).then(status => {
            setRepoStatus(status);
        });
    };
    /**
     * Switches between source and release directory.
     * @param dir dir which should be switched to
     */
    const handleSwitchDir = async (dir) => {
        if (dir === 'release' &&
            (generateTimestamp === null || generateTimestamp < srcChangedTimestamp)) {
            await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_8__.generateAssignment)(lecture.id, assignment).then(() => {
                (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)('Generated Student Version Notebooks', {
                    variant: 'success'
                });
                setGenerateTimestamp(moment__WEBPACK_IMPORTED_MODULE_2___default()().valueOf());
                setSelectedDir(dir);
            }, error => {
                (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)(error.message, {
                    variant: 'error'
                });
            });
        }
        else {
            setSelectedDir(dir);
        }
    };
    const closeDialog = () => setShowDialog(false);
    /**
     * Pushes files to the source und release repo.
     * @param commitMessage the commit message
     */
    const handlePushAssignment = async (commitMessage) => {
        setDialogContent({
            title: 'Push Assignment',
            message: `Do you want to push ${assignment.name}? This updates the state of the assignment on the server with your local state.`,
            handleAgree: async () => {
                try {
                    // Note: has to be in this order (release -> source)
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_8__.pushAssignment)(lecture.id, assignment.id, 'release');
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_8__.pushAssignment)(lecture.id, assignment.id, 'source', commitMessage);
                }
                catch (err) {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)('Error Pushing Assignment', {
                        variant: 'error'
                    });
                    closeDialog();
                    return;
                }
                const a = assignment;
                a.status = 'pushed';
                (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_8__.updateAssignment)(lecture.id, a).then(assignment => {
                    setAssignment(assignment);
                    (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)('Success Pushing Assignment', {
                        variant: 'success'
                    });
                    props.onAssignmentChange(assignment);
                }, error => (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)(error.message, {
                    variant: 'error'
                }));
                closeDialog();
            },
            handleDisagree: () => closeDialog()
        });
        setShowDialog(true);
    };
    /**
     * Sets the repo status text.
     * @param status repo status
     */
    const getRemoteStatusText = (status) => {
        if (status === 'up_to_date') {
            return 'The local files are up to date with the remote repository.';
        }
        else if (status === 'pull_needed') {
            return 'The remote repository has new changes. Pull now to load them.';
        }
        else if (status === 'push_needed') {
            return 'You have made changes to your local repository which you can push.';
        }
        else {
            return 'The local and remote files are divergent.';
        }
    };
    const getStatusChip = (status) => {
        if (status === 'up_to_date') {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip, { sx: { mb: 1.0 }, label: 'Up To Date', color: "success", size: "small", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Check__WEBPACK_IMPORTED_MODULE_9__["default"], null) }));
        }
        else if (status === 'pull_needed') {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip, { sx: { mb: 1.0 }, label: 'Pull Needed', color: "warning", size: "small", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_GetAppRounded__WEBPACK_IMPORTED_MODULE_10__["default"], null) }));
        }
        else if (status === 'push_needed') {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip, { sx: { mb: 1.0 }, label: 'Push Needed', color: "warning", size: "small", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_PublishRounded__WEBPACK_IMPORTED_MODULE_11__["default"], null) }));
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip, { sx: { mb: 1.0 }, label: 'Divergent', color: "error", size: "small", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_ErrorOutline__WEBPACK_IMPORTED_MODULE_12__["default"], null) }));
        }
    };
    /**
     * Pulls changes from source repository.
     */
    const handlePullAssignment = async () => {
        setDialogContent({
            title: 'Pull Assignment',
            message: `Do you want to pull ${assignment.name}? This updates your assignment with the state of the server and overwrites all changes.`,
            handleAgree: async () => {
                try {
                    await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_8__.pullAssignment)(lecture.id, assignment.id, 'source');
                    (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)('Successfully Pulled Assignment', {
                        variant: 'success'
                    });
                }
                catch (err) {
                    (0,notistack__WEBPACK_IMPORTED_MODULE_4__.enqueueSnackbar)('Error Pulling Assignment', {
                        variant: 'error'
                    });
                }
                reloadFiles();
                closeDialog();
            },
            handleDisagree: () => closeDialog()
        });
        setShowDialog(true);
    };
    const newUntitled = async () => {
        console.log('Creating untitled notebook');
        const res = await _index__WEBPACK_IMPORTED_MODULE_5__.GlobalObjects.docManager.newUntitled({
            type: 'notebook',
            path: `source/${lecture.code}/${assignment.id}`
        });
        await _index__WEBPACK_IMPORTED_MODULE_5__.GlobalObjects.docManager.openOrReveal(res.path);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { elevation: 3 },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardHeader, { title: "Files", titleTypographyProps: { display: 'inline' }, action: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: "Reload" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { "aria-label": "reload", onClick: () => reloadFiles() },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_13__["default"], null))), subheader: repoStatus !== null && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: getRemoteStatusText(repoStatus) }, getStatusChip(repoStatus))), subheaderTypographyProps: { display: 'inline', ml: 2 } }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { height: '256px', overflowY: 'auto' } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tabs, { variant: "fullWidth", value: selectedDir, onChange: (e, dir) => handleSwitchDir(dir) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { label: "Source", value: "source" }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { label: "Release", value: "release" })),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { height: 200, sx: { overflowY: 'auto' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_file_list__WEBPACK_IMPORTED_MODULE_14__.FilesList, { path: `${selectedDir}/${props.lecture.code}/${props.assignment.id}`, reloadFiles: reloadFilesToggle }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardActions, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_15__.CommitDialog, { handleCommit: msg => handlePushAssignment(msg) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: `Commit Changes${isCommitOverwrite() ? ' (Overwrites remote files!)' : ''}` },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { sx: { mt: -1 }, variant: "outlined", size: "small", color: isCommitOverwrite() ? 'error' : 'primary' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_PublishRounded__WEBPACK_IMPORTED_MODULE_11__["default"], { fontSize: "small", sx: { mr: 1 } }),
                        "Commit"))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: `Pull from Remote${isPullOverwrite() ? ' (Overwrites local changes!)' : ''}` },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { color: isPullOverwrite() ? 'error' : 'primary', sx: { mt: -1, ml: 2 }, onClick: () => handlePullAssignment(), variant: "outlined", size: "small" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_GetAppRounded__WEBPACK_IMPORTED_MODULE_10__["default"], { fontSize: "small", sx: { mr: 1 } }),
                    "Pull")),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: 'Create new notebook.' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { color: 'primary', sx: { mt: -1, ml: 2 }, onClick: newUntitled },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_AddBox__WEBPACK_IMPORTED_MODULE_16__["default"], null))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: 'Show in File-Browser' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { sx: { mt: -1, pt: 0, pb: 0 }, color: 'primary', onClick: () => (0,_util__WEBPACK_IMPORTED_MODULE_17__.openBrowser)(`${selectedDir}/${lecture.code}/${assignment.id}`) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_OpenInBrowser__WEBPACK_IMPORTED_MODULE_18__["default"], null))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { title: 'Open in Terminal' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { sx: { mt: -1, pt: 0, pb: 0 }, color: 'primary', onClick: () => (0,_util__WEBPACK_IMPORTED_MODULE_17__.openTerminal)(`${serverRoot}/${selectedDir}/${lecture.code}/${assignment.id}`) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_19__["default"], null)))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_15__.AgreeDialog, Object.assign({ open: showDialog }, dialogContent))));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/git-log.js":
/*!**************************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/git-log.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GitLog": () => (/* binding */ GitLog)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/file.service */ "./lib/services/file.service.js");
/* harmony import */ var _services_datetime_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../services/datetime.service */ "./lib/services/datetime.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




const getTimelineItem = (logItem) => {
    const date = (0,_services_datetime_service__WEBPACK_IMPORTED_MODULE_2__.utcToLocalFormat)(logItem.date);
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.ListItem, null,
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.ListItemText, { primary: logItem.commit_msg, secondary: 'Author: ' + logItem.author + ', Date: ' + date })),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Divider, null)));
};
const GitLog = (props) => {
    const [gitLogs, setGitLogs] = react__WEBPACK_IMPORTED_MODULE_1__.useState([]);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_3__.getGitLog)(props.lecture, props.assignment, props.repoType, 10).then(logs => setGitLogs(logs));
    }, [props]);
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, { elevation: 3 },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardHeader, { title: "Git Log" }),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, { sx: { height: '300px', overflowY: 'auto' } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.List, { sx: { ml: 1, mr: 1 } }, gitLogs.length > 0 ? (gitLogs.map(log => getTimelineItem(log))) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Paper, { variant: 'outlined' },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, null, "No commits yet!")))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/overview-card.js":
/*!********************************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/overview-card.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OverviewCard": () => (/* binding */ OverviewCard)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _model_assignment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../model/assignment */ "./lib/model/assignment.js");
/* harmony import */ var _util_deadline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/deadline */ "./lib/components/util/deadline.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




const OverviewCard = (props) => {
    let gradingBehaviour = 'No Automatic Grading';
    if (props.assignment.automatic_grading === _model_assignment__WEBPACK_IMPORTED_MODULE_2__.Assignment.AutomaticGradingEnum.Auto) {
        gradingBehaviour = 'Automatic Grading';
    }
    else if (props.assignment.automatic_grading ===
        _model_assignment__WEBPACK_IMPORTED_MODULE_2__.Assignment.AutomaticGradingEnum.FullAuto) {
        gradingBehaviour = 'Fully Automatic Grading';
    }
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Card, { elevation: 3 },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardHeader, { title: "Overview" }),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.CardContent, { sx: {
                alignItems: { xs: 'center' },
                height: '243px',
                minWidth: '150px',
                overflowY: 'auto'
            } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } },
                props.users.students.length,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                        display: 'inline-block',
                        ml: 0.75,
                        fontSize: 13
                    } }, 'Student' + (props.users.students.length === 1 ? '' : 's'))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } },
                props.users.tutors.length,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                        display: 'inline-block',
                        ml: 0.75,
                        fontSize: 13
                    } }, 'Tutor' + (props.users.tutors.length === 1 ? '' : 's'))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } },
                props.users.instructors.length,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                        display: 'inline-block',
                        ml: 0.75,
                        fontSize: 13
                    } }, 'Instructor' + (props.users.instructors.length === 1 ? '' : 's'))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } },
                props.allSubmissions.length,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                        display: 'inline-block',
                        ml: 0.75,
                        fontSize: 13
                    } }, 'Submission' + (props.allSubmissions.length === 1 ? '' : 's'))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Divider, { sx: { mt: 1, mb: 1 } }),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                    display: 'inline-block',
                    fontSize: 13,
                    mb: -1,
                    ml: 0.5
                } }, "Grading Behaviour:"),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } }, gradingBehaviour),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { color: "text.secondary", sx: {
                    display: 'inline-block',
                    fontSize: 13,
                    mt: 2,
                    mb: -1,
                    ml: 0.5
                } }, "Assignment Type:"),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { sx: { fontSize: 15, mt: 0.5, ml: 0.5 } }, props.assignment.type === 'user' ? 'User' : 'Group')),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_deadline__WEBPACK_IMPORTED_MODULE_3__.DeadlineComponent, { due_date: props.assignment.due_date, compact: false, component: 'card' })));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/overview.js":
/*!***************************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/overview.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OverviewComponent": () => (/* binding */ OverviewComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/dialog */ "./lib/components/util/dialog.js");
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _overview_card__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./overview-card */ "./lib/components/coursemanage/overview-view/overview-card.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _files__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./files */ "./lib/components/coursemanage/overview-view/files.js");
/* harmony import */ var _git_log__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./git-log */ "./lib/components/coursemanage/overview-view/git-log.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _assignment_status__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assignment-status */ "./lib/components/coursemanage/overview-view/assignment-status.js");
/* harmony import */ var _util_repo_type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/repo-type */ "./lib/components/util/repo-type.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.










const OverviewComponent = (props) => {
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.assignment);
    const onAssignmentChange = (assignment) => {
        setAssignment(assignment);
    };
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        console.log('Updating');
    }, [assignment]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_2__.ModalTitle, { title: assignment.name },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { ml: 2 }, display: "inline-block" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_dialog__WEBPACK_IMPORTED_MODULE_3__.EditDialog, { lecture: props.lecture, assignment: assignment, onSubmit: updatedAssignment => (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_4__.updateAssignment)(props.lecture.id, updatedAssignment).then(response => {
                        setAssignment(response);
                    }), onClose: props.onClose }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { ml: 3, mr: 3, mb: 3, mt: 3 } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { container: true, spacing: 2, alignItems: "stretch" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true, xs: 12, md: 12, lg: 12 },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_assignment_status__WEBPACK_IMPORTED_MODULE_5__.AssignmentStatus, { lecture: props.lecture, assignment: assignment, onAssignmentChange: onAssignmentChange })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true, xs: 12, md: 6, lg: 3 },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_overview_card__WEBPACK_IMPORTED_MODULE_6__.OverviewCard, { lecture: props.lecture, assignment: assignment, allSubmissions: props.allSubmissions, users: props.users })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true, xs: 12, md: 6, lg: 5 },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_files__WEBPACK_IMPORTED_MODULE_7__.Files, { lecture: props.lecture, assignment: assignment, onAssignmentChange: onAssignmentChange })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true, xs: 12, md: 6, lg: 4 },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_git_log__WEBPACK_IMPORTED_MODULE_8__.GitLog, { lecture: props.lecture, assignment: assignment, repoType: _util_repo_type__WEBPACK_IMPORTED_MODULE_9__.RepoType.SOURCE }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/overview-view/util.js":
/*!***********************************************************!*\
  !*** ./lib/components/coursemanage/overview-view/util.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "openBrowser": () => (/* binding */ openBrowser),
/* harmony export */   "openTerminal": () => (/* binding */ openTerminal)
/* harmony export */ });
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../index */ "./lib/index.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


let terminalSession = null;
const openTerminal = async (path) => {
    console.log('Opening terminal at: ' + path.replace(' ', '\\ '));
    let args = {};
    if (terminalSession !== null &&
        terminalSession.connectionStatus === 'connected') {
        args = { name: terminalSession.name };
    }
    const main = (await _index__WEBPACK_IMPORTED_MODULE_1__.GlobalObjects.commands.execute('terminal:open', args));
    if (main) {
        const terminal = main.content;
        terminalSession = terminal.session;
    }
    try {
        terminalSession.send({
            type: 'stdin',
            content: ['cd ' + path.replace(' ', '\\ ') + '\n']
        });
    }
    catch (e) {
        (0,notistack__WEBPACK_IMPORTED_MODULE_0__.enqueueSnackbar)('Error Opening Terminal', {
            variant: 'error'
        });
        main.dispose();
    }
};
const openBrowser = async (path) => {
    _index__WEBPACK_IMPORTED_MODULE_1__.GlobalObjects.commands.execute('filebrowser:go-to-path', {
        path
    })
        .catch(e => {
        (0,notistack__WEBPACK_IMPORTED_MODULE_0__.enqueueSnackbar)(e.message, {
            variant: 'error'
        });
    });
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/assignment-score.js":
/*!********************************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/assignment-score.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentScore": () => (/* binding */ AssignmentScore)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);



const AssignmentScoreTooltip = ({ active, payload, label }) => {
    if (active && payload && payload.length) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "custom-tooltip" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, "File: "),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { style: { color: payload[0].payload.fill } }, payload[0].payload.notebook)),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label" }, `${payload[0].value} Point${payload[0].value === 1 ? '' : 's'}`)));
    }
    return null;
};
const COLORS = ['#0088FE', '#00C49F', '#FFBB28', '#FF8042'];
const getData = (gb) => {
    if (gb === null)
        return [];
    return gb.getNotebooks().map((n, i) => {
        return { notebook: n, points: gb.getNotebookMaxPointsCells(n), fill: COLORS[i % COLORS.length] };
    });
};
const AssignmentScore = (props) => {
    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_0___default().useState([]);
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        const d = getData(props.gb);
        setData(d);
    }, [props.gb]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { height: 300, width: "100%" } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardHeader, { sx: { pb: 0 }, title: "Total Points", subheader: "by notebooks", subheaderTypographyProps: { variant: "caption" } }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { height: "70%", width: "100%", display: "flex", justifyContent: "center", alignItems: "center", p: 0.5 } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, { width: "100%", height: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.PieChart, { cx: "50%", cy: "50%" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { fontSize: 40, x: "50%", y: "50%", dy: 12, textAnchor: "middle" }, `${data.reduce((acc, v) => acc + v.points, 0).toFixed(1)}`),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AssignmentScoreTooltip, null) }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Pie, { data: data, dataKey: 'points', nameKey: 'notebook', innerRadius: "65%", outerRadius: "80%", paddingAngle: 5 }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/grading-progress.js":
/*!********************************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/grading-progress.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradingProgress": () => (/* binding */ GradingProgress)
/* harmony export */ });
/* harmony import */ var _stats__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stats */ "./lib/components/coursemanage/stats-view/stats.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);




const GradingProgressTooltip = ({ active, payload, label }) => {
    if (active && payload && payload.length) {
        const action = (payload[0].payload.name === "Feedback" ? "Generated" : "Graded");
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "custom-tooltip" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label", style: { color: payload[0].payload.fill } }, payload[0].payload.name),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label" }, `${(+payload[0].value * 100).toFixed(0)}% ${action}`)));
    }
    return null;
};
const getData = (submissions, users) => {
    if (users === null) {
        return { auto: 0, manual: 0, feedback: 0 };
    }
    const subs = (0,_stats__WEBPACK_IMPORTED_MODULE_3__.filterUserSubmissions)(submissions, users.instructors.concat(users.tutors));
    let totalCounts = subs.reduce((acc, v) => {
        if (v.auto_status === "automatically_graded")
            acc.a++;
        if (v.manual_status === "manually_graded")
            acc.m++;
        if (v.feedback_available)
            acc.f++;
        return acc;
    }, { a: 0, m: 0, f: 0 });
    // return {auto: 0.7, manual: 0.5, feedback: 0.2}
    if (subs.length === 0) {
        return { auto: 0, manual: 0, feedback: 0 };
    }
    // we assume latest submissions only so subs only contains unique users
    return {
        auto: totalCounts.a / subs.length,
        manual: totalCounts.m / subs.length,
        feedback: totalCounts.f / subs.length
    };
};
const GradingProgress = (props) => {
    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_0___default().useState([]);
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        const d = getData(props.latestSubmissions, props.users);
        const a = [
            { name: "Feedback", value: d.feedback, fill: '#00C49F' },
            { name: "Manual", value: d.manual, fill: '#0088FE' },
            { name: "Auto", value: d.auto, fill: '#FFBB28' },
        ];
        setData(a);
    }, [props.latestSubmissions, props.users]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { height: 300, width: "100%" } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardHeader, { sx: { pb: 0 }, title: "Grading Status", subheader: "as % of latest student submissions", subheaderTypographyProps: { variant: "caption" } }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { height: "70%", width: "100%", display: "flex", justifyContent: "center", alignItems: "center", p: 0.5 } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, { width: "100%", height: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.RadialBarChart, { cx: "50%", cy: "50%", innerRadius: "30%", outerRadius: "90%", barSize: 15, data: data },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.PolarAngleAxis, { type: "number", domain: [0, 1], angleAxisId: 0, tick: false }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.RadialBar, { background: true, dataKey: 'value', angleAxisId: 0 }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GradingProgressTooltip, null) }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Legend, { layout: "horizontal", verticalAlign: "bottom", align: "center" }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/score-distribution.js":
/*!**********************************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/score-distribution.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ScoreDistribution": () => (/* binding */ ScoreDistribution)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/storage.service */ "./lib/services/storage.service.js");




const binData = (data, min, max, numBuckets) => {
    const bucketSize = (max - min) / numBuckets;
    let currBucket = min;
    const buckets = new Array(numBuckets).fill(0).map(v => {
        return { start: currBucket, end: currBucket += bucketSize, count: v };
    });
    for (const v of data) {
        let bucketIndex = Math.floor((v - min) / bucketSize);
        bucketIndex = Math.min(bucketIndex, numBuckets - 1);
        buckets[bucketIndex].count++;
    }
    return buckets;
};
const getData = (submissions, assignment, numBuckets) => {
    const getBaseLog = (x, y) => Math.log(y) / Math.log(x);
    let decimalPlaces = -Math.floor(getBaseLog(10, assignment.points / numBuckets)) + 1;
    decimalPlaces = Math.max(decimalPlaces, 0);
    decimalPlaces = Math.min(decimalPlaces, 3);
    const data = submissions.map(s => (s.score || 0));
    const buckets = binData(data, 0, assignment.points, numBuckets);
    return buckets.map(v => {
        return { name: `${v.start.toFixed(decimalPlaces)}-${v.end.toFixed(decimalPlaces)}`, count: v.count };
    });
};
const ScoreDistributionTooltip = ({ active, payload, label }) => {
    if (active && payload && payload.length) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "custom-tooltip" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label", style: { color: "#0088FE" } }, payload[0].payload.name + " Points"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "recharts-tooltip-label" }, `${payload[0].value} Submission${payload[0].value === 1 ? '' : 's'}`)));
    }
    return null;
};
const ScoreDistribution = (props) => {
    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_0___default().useState([]);
    const startBuckets = (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.loadNumber)('score-buckets', null, props.assignment) || 10;
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        const d = getData(props.latestSubmissions, props.assignment, startBuckets);
        setData(d);
    }, [props.latestSubmissions, props.assignment]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { height: 300, width: "100%" } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardHeader, { title: "Distribution of Scores", action: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { id: "outlined-number", size: "small", margin: "dense", InputProps: { inputProps: { min: 1, max: Math.max(Math.floor(props.assignment.points), 20) } }, defaultValue: startBuckets, onChange: v => {
                    setData(getData(props.latestSubmissions, props.assignment, +v.target.value));
                    (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.storeNumber)('score-buckets', +v.target.value, null, props.assignment);
                }, label: "Buckets", type: "number", InputLabelProps: {
                    shrink: true,
                } }) }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { height: "70%", width: "100%", display: "flex", justifyContent: "center", alignItems: "center", p: 0.5 } }, (data.reduce((acc, v) => acc + v.count, 0) === 0)
            ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { color: "text.secondary" }, "No Data Available")
            : react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, { width: "100%", height: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.BarChart, { height: 150, width: 250, data: data, margin: {
                        top: 5,
                        right: 30,
                        left: 0,
                        bottom: 5,
                    }, barGap: 0, barCategoryGap: 0 },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.XAxis, { dataKey: "name" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.YAxis, { dataKey: "count" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ScoreDistributionTooltip, null) }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.Bar, { dataKey: "count", fill: "#0088FE" }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/stats.js":
/*!*********************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/stats.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StatsComponent": () => (/* binding */ StatsComponent),
/* harmony export */   "filterUserSubmissions": () => (/* binding */ filterUserSubmissions)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_modal_title__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/modal-title */ "./lib/components/util/modal-title.js");
/* harmony import */ var _mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Replay */ "./node_modules/@mui/icons-material/Replay.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _submission_timeseries__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./submission-timeseries */ "./lib/components/coursemanage/stats-view/submission-timeseries.js");
/* harmony import */ var _grading_progress__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./grading-progress */ "./lib/components/coursemanage/stats-view/grading-progress.js");
/* harmony import */ var _student_submissions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./student-submissions */ "./lib/components/coursemanage/stats-view/student-submissions.js");
/* harmony import */ var _score_distribution__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./score-distribution */ "./lib/components/coursemanage/stats-view/score-distribution.js");
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _services_gradebook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/gradebook */ "./lib/services/gradebook.js");
/* harmony import */ var _assignment_score__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./assignment-score */ "./lib/components/coursemanage/stats-view/assignment-score.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");













const filterUserSubmissions = (submissions, users) => {
    return submissions.filter((v, i, a) => !users.includes(v.username));
};
const StatsComponent = (props) => {
    const [submissions, setSubmissions] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.allSubmissions);
    const [latestSubmissions, setLatestSubmissions] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.latestSubmissions);
    const [gb, setGb] = react__WEBPACK_IMPORTED_MODULE_1__.useState(null);
    const [users, setUsers] = react__WEBPACK_IMPORTED_MODULE_1__.useState(props.users);
    const updateSubmissions = async () => {
        setSubmissions(await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.getAllSubmissions)(props.lecture, props.assignment, "none", true));
        setLatestSubmissions(await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.getAllSubmissions)(props.lecture, props.assignment, "latest", true));
        setUsers(await (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_3__.getUsers)(props.lecture));
        setGb(new _services_gradebook__WEBPACK_IMPORTED_MODULE_4__.GradeBook(await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_5__.getAssignmentProperties)(props.lecture.id, props.assignment.id)));
    };
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.getAllSubmissions)(props.lecture, props.assignment, "none", true).then(response => {
            setSubmissions(response);
        });
        (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_2__.getAllSubmissions)(props.lecture, props.assignment, "latest", true).then(response => {
            setLatestSubmissions(response);
        });
    }, [props.allSubmissions, props.latestSubmissions]);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_3__.getUsers)(props.lecture).then(response => {
            setUsers(response);
        });
    }, [props.users]);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_5__.getAssignmentProperties)(props.lecture.id, props.assignment.id).then(properties => {
            setGb(new _services_gradebook__WEBPACK_IMPORTED_MODULE_4__.GradeBook(properties));
        });
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_util_modal_title__WEBPACK_IMPORTED_MODULE_6__.ModalTitle, { title: `${props.assignment.name} Stats` },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { ml: 2 }, display: "inline-block" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Tooltip, { title: "Reload" },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.IconButton, { "aria-label": "reload", onClick: updateSubmissions },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_icons_material_Replay__WEBPACK_IMPORTED_MODULE_7__["default"], null))))),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { ml: 3, mr: 3, mb: 3, mt: 3 } },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { container: true, spacing: 2, alignItems: "stretch" },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, xs: 12 },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_submission_timeseries__WEBPACK_IMPORTED_MODULE_8__.SubmissionTimeSeries, { lecture: props.lecture, assignment: props.assignment, allSubmissions: submissions, latestSubmissions: latestSubmissions, users: users, root: props.root })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, xs: 4 },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_grading_progress__WEBPACK_IMPORTED_MODULE_9__.GradingProgress, { lecture: props.lecture, assignment: props.assignment, allSubmissions: submissions, latestSubmissions: latestSubmissions, users: users, root: props.root })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, xs: 4 },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_student_submissions__WEBPACK_IMPORTED_MODULE_10__.StudentSubmissions, { lecture: props.lecture, assignment: props.assignment, allSubmissions: submissions, latestSubmissions: latestSubmissions, users: users, root: props.root })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, xs: 4 },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_assignment_score__WEBPACK_IMPORTED_MODULE_11__.AssignmentScore, { gb: gb })),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true, xs: 12 },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_score_distribution__WEBPACK_IMPORTED_MODULE_12__.ScoreDistribution, { lecture: props.lecture, assignment: props.assignment, allSubmissions: submissions, latestSubmissions: latestSubmissions, users: users, root: props.root }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/student-submissions.js":
/*!***********************************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/student-submissions.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StudentSubmissions": () => (/* binding */ StudentSubmissions)
/* harmony export */ });
/* harmony import */ var _stats__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stats */ "./lib/components/coursemanage/stats-view/stats.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_2__);




const getData = (submissions, users) => {
    if (users.students.length === 0)
        return 0;
    const subs = (0,_stats__WEBPACK_IMPORTED_MODULE_3__.filterUserSubmissions)(submissions, users.instructors.concat(users.tutors));
    return subs.length / users.students.length;
};
const StudentSubmissions = (props) => {
    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(0);
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        const d = getData(props.latestSubmissions, props.users);
        setData(d);
    }, [props.latestSubmissions, props.users]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { height: 300, width: "100%" } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardHeader, { sx: { pb: 0 }, title: "Student Submissions", subheader: "as % of total students", subheaderTypographyProps: { variant: "caption" } }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CardContent, { sx: { height: "70%", width: "100%", display: "flex", justifyContent: "center", alignItems: "center", p: 0.5 } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, { width: "100%", height: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.RadialBarChart, { cx: "50%", cy: "50%", innerRadius: "70%", outerRadius: "90%", barSize: 15, data: [{ name: "Submissions", value: data, fill: '#0088FE' }] },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("text", { fontSize: 40, x: "50%", y: "50%", dy: 12, textAnchor: "middle" }, `${Math.floor(data * 100)}%`),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.PolarAngleAxis, { type: "number", domain: [0, 1], angleAxisId: 0, tick: false }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(recharts__WEBPACK_IMPORTED_MODULE_2__.RadialBar, { background: true, dataKey: 'value', angleAxisId: 0 }))))));
};


/***/ }),

/***/ "./lib/components/coursemanage/stats-view/submission-timeseries.js":
/*!*************************************************************************!*\
  !*** ./lib/components/coursemanage/stats-view/submission-timeseries.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SubmissionTimeSeries": () => (/* binding */ SubmissionTimeSeries)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recharts */ "webpack/sharing/consume/default/recharts/recharts");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(recharts__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _services_storage_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/storage.service */ "./lib/services/storage.service.js");





const SubmissionTimeSeriesTooltip = ({ active, payload, label }) => {
    if (active && payload && payload.length) {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: "custom-tooltip" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", { className: "recharts-tooltip-label" }, moment__WEBPACK_IMPORTED_MODULE_3___default()(payload[0].payload.time).format('DD. MMM')),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", { className: "recharts-tooltip-label" }, `${payload[0].value} Submission${payload[0].value === 1 ? '' : 's'}`)));
    }
    return null;
};
const getData = (submissions) => {
    if (submissions.length === 0)
        return [];
    const map = submissions
        .map(s => moment__WEBPACK_IMPORTED_MODULE_3___default()(s.submitted_at).startOf("day").valueOf())
        .reduce((acc, v) => {
        const c = acc.has(v) ? acc.get(v) : 0;
        acc.set(v, c + 1);
        return acc;
    }, new Map());
    const dates = [];
    let currDate = moment__WEBPACK_IMPORTED_MODULE_3___default()(Math.min(...map.keys())).subtract(2, 'days');
    let lastDate = moment__WEBPACK_IMPORTED_MODULE_3___default()();
    while (currDate.add(1, 'days').diff(lastDate) < 0) {
        dates.push(currDate.valueOf());
    }
    return dates.map(d => {
        if (map.has(d)) {
            return { time: d, n: map.get(d) };
        }
        else {
            return { time: d, n: 0 };
        }
    });
};
const SubmissionTimeSeries = (props) => {
    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const d = getData(props.allSubmissions);
        setData(d);
    }, [props.allSubmissions]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Card, { sx: { height: 300, width: "100%" } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CardHeader, { title: "Submissions" }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CardContent, { sx: { height: "70%", width: "100%", display: "flex", justifyContent: "center", alignItems: "center", p: 0.5 } }, (data.length === 0)
            ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, { color: "text.secondary" }, "No Data Available")
            : react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.ResponsiveContainer, { width: "100%", height: "100%" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.AreaChart, { height: 150, width: 250, data: data, margin: {
                        top: 5,
                        right: 30,
                        left: 0,
                        bottom: 5,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("linearGradient", { id: "gradient", x1: "0", y1: "0", x2: "0", y2: "1" },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", { offset: "5%", stopColor: "#0088FE", stopOpacity: 0.8 }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", { offset: "95%", stopColor: "#0088FE", stopOpacity: 0.2 }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.XAxis, { dataKey: "time", tickFormatter: (unixTime) => moment__WEBPACK_IMPORTED_MODULE_3___default()(unixTime).format('DD. MMM') }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.YAxis, { dataKey: "n" }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { label: "Number of Submissions", content: react__WEBPACK_IMPORTED_MODULE_0__.createElement(SubmissionTimeSeriesTooltip, null) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Area, { type: "monotone", dataKey: "n", stroke: "#0088FE", strokeWidth: 2, fillOpacity: 1, fill: "url(#gradient)" }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(recharts__WEBPACK_IMPORTED_MODULE_1__.Brush, { height: 15, startIndex: (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_4__.loadNumber)("stats-sub-brush-start", null, props.assignment) || 0, onChange: e => {
                            (0,_services_storage_service__WEBPACK_IMPORTED_MODULE_4__.storeNumber)("stats-sub-brush-start", e.startIndex, null, props.assignment);
                        } }))))));
};


/***/ }),

/***/ "./lib/components/notebook/create-assignment/creation-component.js":
/*!*************************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/creation-component.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AntSwitch": () => (/* binding */ AntSwitch),
/* harmony export */   "CreationComponent": () => (/* binding */ CreationComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model */ "./lib/components/notebook/model.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



const AntSwitch = (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Switch)(({ theme }) => ({
    width: 28,
    height: 16,
    padding: 0,
    display: 'flex',
    '&:active': {
        '& .MuiSwitch-thumb': {
            width: 15
        },
        '& .MuiSwitch-switchBase.Mui-checked': {
            transform: 'translateX(9px)'
        }
    },
    '& .MuiSwitch-switchBase': {
        padding: 2,
        '&.Mui-checked': {
            transform: 'translateX(12px)',
            color: '#fff',
            '& + .MuiSwitch-track': {
                opacity: 1,
                backgroundColor: theme.palette.mode === 'dark' ? '#177ddc' : '#1890ff'
            }
        }
    },
    '& .MuiSwitch-thumb': {
        boxShadow: '0 2px 4px 0 rgb(0 35 11 / 20%)',
        width: 12,
        height: 12,
        borderRadius: 6,
        transition: theme.transitions.create(['width'], {
            duration: 200
        })
    },
    '& .MuiSwitch-track': {
        borderRadius: 16 / 2,
        opacity: 1,
        backgroundColor: theme.palette.mode === 'dark'
            ? 'rgba(255,255,255,.35)'
            : 'rgba(0,0,0,.25)',
        boxSizing: 'border-box'
    }
}));
const randomString = (length) => {
    let result = '';
    const chars = 'abcdef0123456789';
    let i;
    for (i = 0; i < length; i++) {
        result += chars[Math.floor(Math.random() * chars.length)];
    }
    return result;
};
const CreationComponent = (props) => {
    const nbgraderData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.getNbgraderData(props.cell.model.metadata);
    const toolData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.newToolData(nbgraderData, props.cell.model.type);
    const [type, setType] = react__WEBPACK_IMPORTED_MODULE_0__.useState(toolData.type);
    const [id, setId] = react__WEBPACK_IMPORTED_MODULE_0__.useState(toolData.id);
    const [points, setPoints] = react__WEBPACK_IMPORTED_MODULE_0__.useState(toolData.points);
    const [hintChecked, setChecked] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.cell.model.metadata.has('hint'));
    const [hint, setHint] = react__WEBPACK_IMPORTED_MODULE_0__.useState(hintChecked ? props.cell.model.metadata.get('hint') : '');
    const handleHintChange = (event) => {
        setChecked(event.target.checked);
    };
    const updateMetadata = () => {
        toolData.type = type;
        if (id === undefined) {
            setId('cell-' + randomString(16));
        }
        else {
            toolData.id = id;
        }
        toolData.points = points;
        const data = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.newNbgraderData(toolData);
        _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.setNbgraderData(data, props.cell.model.metadata);
        //TODO: Currently we set the optional hint differently than the grader data, but maybe we should do it like this
        if (hintChecked) {
            props.cell.model.metadata.set('hint', hint);
        }
        else {
            props.cell.model.metadata.delete('hint');
        }
    };
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        updateMetadata();
    });
    const alertStyle = { width: 250 };
    const gradableCell = type !== 'readonly' &&
        type !== 'solution' &&
        type !== '';
    const solutionCell = type === 'solution' || type === 'manual';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { mt: 2, mb: 1, ml: 3 } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { container: true, spacing: 1 },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { label: "Type", select: true, size: "small", sx: { minWidth: 150 }, value: type, onChange: e => {
                            setType(e.target.value);
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "" }, "-"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "readonly" }, "Readonly"),
                        props.cell.model.type === 'code' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "solution" }, "Autograded answer")),
                        props.cell.model.type === 'code' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "tests" }, "Autograded tests")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "manual" }, "Manual graded answer"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem, { value: "task" }, "Manual graded task"))),
                type !== '' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { size: "small", label: "ID", value: id, onChange: e => setId(e.target.value), error: id === '', helperText: id === '' ? 'ID not set' : ' ' }))),
                gradableCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { size: "small", label: "Points", value: points, type: "number", onChange: e => setPoints(parseInt(e.target.value)), InputProps: {
                            inputProps: {
                                max: 10000,
                                min: 0
                            }
                        }, error: points === undefined, helperText: points === undefined ? 'Points not set' : ' ' }))),
                solutionCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(AntSwitch, { sx: { mt: 2, ml: 1 }, checked: hintChecked, onChange: handleHintChange, inputProps: { 'aria-label': 'controlled' } }))),
                solutionCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { size: "small", label: "Optional hint", value: hint, disabled: !hintChecked, onChange: e => setHint(e.target.value) }))),
                type === '' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Alert, { variant: "outlined", sx: alertStyle, severity: "warning" }, "Type not set"))),
                points === 0 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Alert, { variant: "outlined", sx: alertStyle, severity: "warning" }, "Gradable cell with zero points")))))));
};


/***/ }),

/***/ "./lib/components/notebook/create-assignment/creation-switch.js":
/*!**********************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/creation-switch.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CreationModeSwitch": () => (/* binding */ CreationModeSwitch)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _creation_widget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./creation-widget */ "./lib/components/notebook/create-assignment/creation-widget.js");
/* harmony import */ var _error_widget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error-widget */ "./lib/components/notebook/create-assignment/error-widget.js");
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @blueprintjs/core */ "webpack/sharing/consume/default/@blueprintjs/core/@blueprintjs/core");
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




class CreationModeSwitch extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            mode: false
        };
        this.handleChange = async () => {
            this.setState({ mode: !this.state.mode }, () => {
                const ids = new Set();
                this.onChange(this.state.mode);
                this.notebook.widgets.map((c) => {
                    const currentLayout = c.layout;
                    if (this.state.mode) {
                        currentLayout.insertWidget(0, new _creation_widget__WEBPACK_IMPORTED_MODULE_2__.CreationWidget(c));
                    }
                    else {
                        currentLayout.widgets.map(w => {
                            if (w instanceof _creation_widget__WEBPACK_IMPORTED_MODULE_2__.CreationWidget || w instanceof _error_widget__WEBPACK_IMPORTED_MODULE_3__.ErrorWidget) {
                                currentLayout.removeWidget(w);
                            }
                        });
                    }
                });
            });
        };
        this.state.mode = props.mode || false;
        this.notebook = props.notebook;
        this.notebookpanel = props.notebookpanel;
        this.onChange = this.props.onChange;
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__.Switch, { className: "jp-Toolbar-item", style: { marginTop: "-1px" }, checked: this.state.mode, label: "Creation Mode", onChange: this.handleChange })));
    }
}


/***/ }),

/***/ "./lib/components/notebook/create-assignment/creation-widget.js":
/*!**********************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/creation-widget.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CreationWidget": () => (/* binding */ CreationWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _creation_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./creation-component */ "./lib/components/notebook/create-assignment/creation-component.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



class CreationWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(cell) {
        super();
        this.cell = cell;
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_creation_component__WEBPACK_IMPORTED_MODULE_2__.CreationComponent, { cell: this.cell }));
    }
}


/***/ }),

/***/ "./lib/components/notebook/create-assignment/error-component.js":
/*!**********************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/error-component.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorComponent": () => (/* binding */ ErrorComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


const ErrorComponent = (props) => {
    //const alertStyle = { width: 250 };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Alert, { variant: "filled", severity: "error" }, props.err));
};


/***/ }),

/***/ "./lib/components/notebook/create-assignment/error-widget.js":
/*!*******************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/error-widget.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorWidget": () => (/* binding */ ErrorWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _error_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error-component */ "./lib/components/notebook/create-assignment/error-component.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



class ErrorWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(cell, err) {
        super();
        this.cell = cell;
        this.err = err;
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_1__.createElement(_error_component__WEBPACK_IMPORTED_MODULE_2__.ErrorComponent, { err: this.err });
    }
}


/***/ }),

/***/ "./lib/components/notebook/create-assignment/validator.js":
/*!****************************************************************!*\
  !*** ./lib/components/notebook/create-assignment/validator.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Validator": () => (/* binding */ Validator)
/* harmony export */ });
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @blueprintjs/core */ "webpack/sharing/consume/default/@blueprintjs/core/@blueprintjs/core");
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model */ "./lib/components/notebook/model.js");
/* harmony import */ var _error_widget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error-widget */ "./lib/components/notebook/create-assignment/error-widget.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





const Validator = (props) => {
    const [dialogOpen, setDialog] = react__WEBPACK_IMPORTED_MODULE_1__.useState(false);
    const [results, setResult] = react__WEBPACK_IMPORTED_MODULE_1__.useState([]);
    const validateNotebook = () => {
        //check duplicate ids
        const ids = new Set();
        const result = [];
        console.log('started validation');
        props.notebook.widgets.map((c) => {
            c.layout.widgets.map((w) => {
                if (w instanceof _error_widget__WEBPACK_IMPORTED_MODULE_3__.ErrorWidget) {
                    c.layout.removeWidget(w);
                }
            });
        });
        props.notebook.widgets.map((c) => {
            const metadata = _model__WEBPACK_IMPORTED_MODULE_4__.CellModel.getNbgraderData(c.model.metadata);
            const toolData = _model__WEBPACK_IMPORTED_MODULE_4__.CellModel.newToolData(metadata, c.model.type);
            if (metadata !== null) {
                if (metadata.grade_id !== null) {
                    if (ids.has(metadata.grade_id)) {
                        console.log('duplicate id found');
                        const layout = c.layout;
                        layout.insertWidget(0, new _error_widget__WEBPACK_IMPORTED_MODULE_3__.ErrorWidget(c, 'Duplicate ID found'));
                        result.push({
                            id: metadata.grade_id,
                            type: 'error',
                            msg: 'Duplicate ID found'
                        });
                    }
                    else {
                        ids.add(metadata.grade_id);
                    }
                }
            }
            else {
                result.push({
                    id: 'Warning',
                    type: 'warning',
                    msg: 'Cell with no type found'
                });
            }
        });
        setResult(result);
        setDialog(true);
    };
    const handleClose = () => {
        setDialog(false);
    };
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_0__.Button, { className: "jp-ToolbarButtonComponent grader-toolbar-button", onClick: validateNotebook, icon: "automatic-updates", minimal: true, intent: "success", small: true }, "Validate"),
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Dialog, { open: dialogOpen, onClose: handleClose, "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description" },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { id: "alert-dialog-title" }, 'Validation Report'),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogContent, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Stack, { spacing: 2 },
                    results.length === 0 && (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { width: '450px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Alert, { severity: "success" },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.AlertTitle, null, "No errors found")))),
                    results.map((e) => (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { width: '450px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Alert, { severity: e.type },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.AlertTitle, null, e.id),
                            e.msg)))))),
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogActions, null,
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { onClick: handleClose, autoFocus: true }, "Ok")))));
};


/***/ }),

/***/ "./lib/components/notebook/manual-grading/data-widget/data-component.js":
/*!******************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/data-widget/data-component.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataComponent": () => (/* binding */ DataComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../model */ "./lib/components/notebook/model.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



const DataComponent = (props) => {
    const nbgraderData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.getNbgraderData(props.cell.model.metadata);
    const toolData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.newToolData(nbgraderData, props.cell.model.type);
    const gradableCell = toolData.type !== 'readonly' &&
        toolData.type !== 'solution' &&
        toolData.type !== '';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { mt: 2, mb: 1, ml: 3 } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { container: true, spacing: 2 },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, null,
                        "Type: ",
                        toolData.type)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, null,
                        "ID: ",
                        toolData.id)),
                toolData.type === 'tests' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, null,
                        "Autograded Points:",
                        ' ',
                        props.gradebook.getAutoGradeScore(props.nbname, toolData.id)))),
                gradableCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, null,
                        "Max Points: ",
                        toolData.points)))))));
};


/***/ }),

/***/ "./lib/components/notebook/manual-grading/data-widget/data-widget.js":
/*!***************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/data-widget/data-widget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataWidget": () => (/* binding */ DataWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _data_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-component */ "./lib/components/notebook/manual-grading/data-widget/data-component.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



class DataWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(cell, gradebook, nbname) {
        super();
        this.cell = cell;
        this.gradebook = gradebook;
        this.nbname = nbname;
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_data_component__WEBPACK_IMPORTED_MODULE_2__.DataComponent, { cell: this.cell, gradebook: this.gradebook, nbname: this.nbname }));
    }
}


/***/ }),

/***/ "./lib/components/notebook/manual-grading/grade-widget/comment-component.js":
/*!**********************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/grade-widget/comment-component.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CommentComponent": () => (/* binding */ CommentComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


const CommentComponent = (props) => {
    const [comment, setComment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.gradebook.getComment(props.nbname, props.toolData.id));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { label: "Comment", size: "small", value: comment, onChange: e => {
                setComment(e.target.value);
                props.metadata.set('updated', true);
                props.gradebook.setComment(props.nbname, props.toolData.id, e.target.value);
            } })));
};


/***/ }),

/***/ "./lib/components/notebook/manual-grading/grade-widget/grade-component.js":
/*!********************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/grade-widget/grade-component.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradeComponent": () => (/* binding */ GradeComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _points_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./points-component */ "./lib/components/notebook/manual-grading/grade-widget/points-component.js");
/* harmony import */ var _comment_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./comment-component */ "./lib/components/notebook/manual-grading/grade-widget/comment-component.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




const GradeComponent = (props) => {
    const metadata = props.notebook.model.metadata;
    if (!metadata.has('updated')) {
        metadata.set('updated', false);
    }
    const gradableCell = props.toolData.type !== 'readonly' &&
        props.toolData.type !== 'solution' &&
        props.toolData.type !== '';
    const showCommment = props.toolData.type === 'task' ||
        props.toolData.type === 'manual' ||
        props.toolData.type === 'solution';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null, props.toolData.type !== 'readonly' && props.toolData.type !== '' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, { sx: { mt: 2, mb: 1, ml: 5 } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { container: true, spacing: 2 },
            showCommment && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_comment_component__WEBPACK_IMPORTED_MODULE_2__.CommentComponent, { metadata: metadata, nbgraderData: props.nbgraderData, toolData: props.toolData, gradebook: props.gradebook, nbname: props.nbname })),
            gradableCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_points_component__WEBPACK_IMPORTED_MODULE_3__.PointsComponent, { metadata: metadata, nbgraderData: props.nbgraderData, toolData: props.toolData, gradebook: props.gradebook, nbname: props.nbname })),
            gradableCell && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_points_component__WEBPACK_IMPORTED_MODULE_3__.ExtraCreditComponent, { metadata: metadata, nbgraderData: props.nbgraderData, toolData: props.toolData, gradebook: props.gradebook, nbname: props.nbname })))))));
};


/***/ }),

/***/ "./lib/components/notebook/manual-grading/grade-widget/grade-widget.js":
/*!*****************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/grade-widget/grade-widget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradeWidget": () => (/* binding */ GradeWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _grade_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./grade-component */ "./lib/components/notebook/manual-grading/grade-widget/grade-component.js");
/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../model */ "./lib/components/notebook/model.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




class GradeWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(cell, notebook, gradebook, nbname) {
        super();
        this.cell = cell;
        this.notebook = notebook;
        this.gradebook = gradebook;
        this.nbname = nbname;
        this.nbgraderData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.getNbgraderData(this.cell.model.metadata);
        this.toolData = _model__WEBPACK_IMPORTED_MODULE_2__.CellModel.newToolData(this.nbgraderData, this.cell.model.type);
    }
    render() {
        if (this.toolData.type !== '' && this.toolData.type !== 'readonly') {
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_grade_component__WEBPACK_IMPORTED_MODULE_3__.GradeComponent, { notebook: this.notebook, nbgraderData: this.nbgraderData, toolData: this.toolData, gradebook: this.gradebook, nbname: this.nbname }));
        }
        else {
            return null;
        }
    }
}


/***/ }),

/***/ "./lib/components/notebook/manual-grading/grade-widget/points-component.js":
/*!*********************************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/grade-widget/points-component.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExtraCreditComponent": () => (/* binding */ ExtraCreditComponent),
/* harmony export */   "PointsComponent": () => (/* binding */ PointsComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


const PointsComponent = (props) => {
    const [points, setPoints] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.gradebook.getGradeScore(props.nbname, props.toolData.id));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { size: "small", label: "Points", type: "number", value: points, onChange: e => {
                setPoints(parseInt(e.target.value));
                props.metadata.set('updated', true);
                props.gradebook.setManualScore(props.nbname, props.toolData.id, parseInt(e.target.value));
            }, InputProps: {
                inputProps: {
                    max: props.toolData.points,
                    min: 0
                }
            } })));
};
const ExtraCreditComponent = (props) => {
    const [extraCredit, setExtraCredit] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.gradebook.getExtraCredit(props.nbname, props.toolData.id));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, { item: true },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.TextField, { size: "small", label: "Extra Credit", type: "number", value: extraCredit, onChange: e => {
                setExtraCredit(parseInt(e.target.value));
                props.metadata.set('updated', true);
                props.gradebook.setExtraCredit(props.nbname, props.toolData.id, parseInt(e.target.value));
            }, InputProps: {
                inputProps: {
                    max: 10000,
                    min: 0
                }
            } })));
};


/***/ }),

/***/ "./lib/components/notebook/manual-grading/grading-switch.js":
/*!******************************************************************!*\
  !*** ./lib/components/notebook/manual-grading/grading-switch.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradingModeSwitch": () => (/* binding */ GradingModeSwitch)
/* harmony export */ });
/* harmony import */ var _services_gradebook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../services/gradebook */ "./lib/services/gradebook.js");
/* harmony import */ var _services_submissions_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/submissions.service */ "./lib/services/submissions.service.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @blueprintjs/core */ "webpack/sharing/consume/default/@blueprintjs/core/@blueprintjs/core");
/* harmony import */ var _blueprintjs_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _blueprintjs_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @blueprintjs/icons */ "./node_modules/@blueprintjs/icons/lib/esm/generated/iconNames.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _data_widget_data_widget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./data-widget/data-widget */ "./lib/components/notebook/manual-grading/data-widget/data-widget.js");
/* harmony import */ var _grade_widget_grade_widget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./grade-widget/grade-widget */ "./lib/components/notebook/manual-grading/grade-widget/grade-widget.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.











class GradingModeSwitch extends react__WEBPACK_IMPORTED_MODULE_2__.Component {
    constructor(props) {
        super(props);
        this.state = {
            mode: false,
            saveButtonText: 'Save',
        };
        this.handleChange = async () => {
            const properties = await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.getProperties)(this.lecture.id, this.assignment.id, this.subID);
            this.gradeBook = new _services_gradebook__WEBPACK_IMPORTED_MODULE_5__.GradeBook(properties);
            this.setState({ mode: !this.state.mode }, () => {
                this.onChange(this.state.mode);
                this.notebook.widgets.map((c) => {
                    const currentLayout = c.layout;
                    if (this.state.mode) {
                        currentLayout.insertWidget(0, new _data_widget_data_widget__WEBPACK_IMPORTED_MODULE_6__.DataWidget(c, this.gradeBook, this.notebookPaths[4].split('.').slice(0, -1).join('.')));
                        currentLayout.addWidget(new _grade_widget_grade_widget__WEBPACK_IMPORTED_MODULE_7__.GradeWidget(c, this.notebook, this.gradeBook, this.notebookPaths[4].split('.').slice(0, -1).join('.')));
                    }
                    else {
                        currentLayout.widgets.map(w => {
                            if (w instanceof _data_widget_data_widget__WEBPACK_IMPORTED_MODULE_6__.DataWidget || w instanceof _grade_widget_grade_widget__WEBPACK_IMPORTED_MODULE_7__.GradeWidget) {
                                currentLayout.removeWidget(w);
                            }
                        });
                    }
                });
            });
        };
        this.state.mode = props.mode || false;
        this.notebook = props.notebook;
        this.notebookpanel = props.notebookpanel;
        this.notebookPaths =
            this.notebookpanel.context.contentsModel.path.split('/');
        this.subID = +this.notebookPaths[3];
        this.onChange = this.props.onChange;
    }
    async componentDidMount() {
        const lectures = await (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_8__.getAllLectures)();
        this.lecture = lectures.find(l => l.code === this.notebookPaths[1]);
        this.assignment = await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_9__.getAssignment)(this.lecture.id, +this.notebookPaths[2]);
        const properties = await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.getProperties)(this.lecture.id, this.assignment.id, this.subID);
        this.gradeBook = new _services_gradebook__WEBPACK_IMPORTED_MODULE_5__.GradeBook(properties);
        this.notebookpanel.context.saveState.connect((sender, saveState) => {
            if (saveState === 'started') {
                this.saveProperties();
                console.log('Saved');
            }
        });
    }
    async saveProperties() {
        const metadata = this.notebook.model.metadata;
        //if there were no updates return
        if (!metadata.get('updated')) {
            return;
        }
        metadata.set('updated', false);
        this.setState({ saveButtonText: 'Saving' });
        try {
            await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.updateProperties)(this.lecture.id, this.assignment.id, this.subID, this.gradeBook.properties);
            this.setState({ saveButtonText: 'Saved' });
            //console.log("saved")
            setTimeout(() => this.setState({ saveButtonText: 'Save' }), 2000);
            const submission = await (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.getSubmission)(this.lecture.id, this.assignment.id, this.subID);
            console.log(submission);
            submission.manual_status = 'being_edited';
            (0,_services_submissions_service__WEBPACK_IMPORTED_MODULE_4__.updateSubmission)(this.lecture.id, this.assignment.id, this.subID, submission);
        }
        catch (err) {
            this.setState({ saveButtonText: 'Save' });
            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)('Error saving properties', err);
        }
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_2__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, { container: true, spacing: 2 },
            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, { item: true },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__.Switch, { style: { marginTop: "-1px" }, checked: this.state.mode, label: "Grading Mode", onChange: this.handleChange })),
            react__WEBPACK_IMPORTED_MODULE_2__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, { item: true },
                react__WEBPACK_IMPORTED_MODULE_2__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Box, null,
                    react__WEBPACK_IMPORTED_MODULE_2__.createElement(_blueprintjs_core__WEBPACK_IMPORTED_MODULE_1__.Button, { className: "jp-ToolbarButtonComponent grader-toolbar-button", onClick: () => this.saveProperties(), icon: (this.state.saveButtonText === "Saved" ? _blueprintjs_icons__WEBPACK_IMPORTED_MODULE_10__.SAVED : _blueprintjs_icons__WEBPACK_IMPORTED_MODULE_10__.FLOPPY_DISK), minimal: true, intent: "success", small: true }, this.state.saveButtonText)))));
    }
}


/***/ }),

/***/ "./lib/components/notebook/model.js":
/*!******************************************!*\
  !*** ./lib/components/notebook/model.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CellModel": () => (/* binding */ CellModel),
/* harmony export */   "NBGRADER_SCHEMA_VERSION": () => (/* binding */ NBGRADER_SCHEMA_VERSION),
/* harmony export */   "NbgraderData": () => (/* binding */ NbgraderData),
/* harmony export */   "ToolData": () => (/* binding */ ToolData)
/* harmony export */ });
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.
const NBGRADER_KEY = 'nbgrader';
const NBGRADER_SCHEMA_VERSION = 3;
/**
 * A namespace for conversions between {@link NbgraderData} and
 * {@link ToolData} and for reading and writing to notebook cells' metadata.
 */
var CellModel;
(function (CellModel) {
    /**
     * Cleans invalid nbgrader data if necessary.
     *
     * @returns Whether cleaning occurred.
     */
    function cleanNbgraderData(cellMetadata, cellType) {
        const data = CellModel.getNbgraderData(cellMetadata);
        if (data == null || !PrivateNbgraderData.isInvalid(data, cellType)) {
            return false;
        }
        data.schema_version = NBGRADER_SCHEMA_VERSION;
        data.solution = false;
        data.grade = false;
        data.locked = false;
        data.task = false;
        CellModel.setNbgraderData(data, cellMetadata);
        return true;
    }
    CellModel.cleanNbgraderData = cleanNbgraderData;
    /**
     * Removes the "cell_type" property from the nbgrader data.
     */
    function clearCellType(cellMetadata) {
        const data = cellMetadata.get(NBGRADER_KEY);
        if (data == null) {
            return;
        }
        if ('cell_type' in data) {
            data['cell_type'] = undefined;
        }
        cellMetadata.set(NBGRADER_KEY, data);
    }
    CellModel.clearCellType = clearCellType;
    /**
     * Read the nbgrader data from a cell's metadata.
     *
     * @returns The nbgrader data, or null if it doesn't exist.
     */
    function getNbgraderData(cellMetadata) {
        if (cellMetadata == null) {
            return null;
        }
        const nbgraderValue = cellMetadata.get('nbgrader');
        if (nbgraderValue == null) {
            return null;
        }
        return nbgraderValue.valueOf();
    }
    CellModel.getNbgraderData = getNbgraderData;
    /**
     * @returns True if the cell is gradable.
     */
    function isGraded(data) {
        return PrivateNbgraderData.isGraded(data);
    }
    CellModel.isGraded = isGraded;
    /**
     * @returns True if the cell relevant to nbgrader. A cell is relevant if it is
     * gradable or contains autograder tests.
     */
    function isRelevantToNbgrader(data) {
        return (PrivateNbgraderData.isGraded(data) || PrivateNbgraderData.isSolution(data));
    }
    CellModel.isRelevantToNbgrader = isRelevantToNbgrader;
    /**
     * Converts {@link ToolData} to {@link NbgraderData}.
     *
     * @returns The converted data, or null if the nbgrader cell type is not set.
     */
    function newNbgraderData(data) {
        if (data.type === '') {
            return null;
        }
        const nbgraderData = new NbgraderData();
        nbgraderData.grade = PrivateToolData.getGrade(data);
        nbgraderData.grade_id = PrivateToolData.getGradeId(data);
        nbgraderData.locked = PrivateToolData.getLocked(data);
        nbgraderData.points = PrivateToolData.getPoints(data);
        nbgraderData.schema_version = PrivateToolData.getSchemeaVersion();
        nbgraderData.solution = PrivateToolData.getSolution(data);
        nbgraderData.task = PrivateToolData.getTask(data);
        return nbgraderData;
    }
    CellModel.newNbgraderData = newNbgraderData;
    /**
     * Converts {@link NbgraderData} to {@link ToolData}.
     *
     * @param data The data to convert. Can be null.
     * @param cellType The notebook cell widget type.
     */
    function newToolData(data, cellType) {
        const toolData = new ToolData();
        if (PrivateNbgraderData.isInvalid(data, cellType)) {
            toolData.type = '';
            return toolData;
        }
        toolData.type = PrivateNbgraderData.getType(data, cellType);
        if (toolData.type === '') {
            return toolData;
        }
        if (PrivateNbgraderData.isGrade(data) ||
            PrivateNbgraderData.isSolution(data) ||
            PrivateNbgraderData.isLocked(data)) {
            toolData.id = PrivateNbgraderData.getGradeId(data);
        }
        if (PrivateNbgraderData.isGraded(data)) {
            toolData.points = PrivateNbgraderData.getPoints(data);
        }
        toolData.locked = PrivateNbgraderData.isLocked(data);
        return toolData;
    }
    CellModel.newToolData = newToolData;
    /**
     * Writes the nbgrader data to a cell's metadata.
     *
     * @param data The nbgrader data. If null, the nbgrader entry, if it exists,
     * will be removed from the metadata.
     */
    function setNbgraderData(data, cellMetadata) {
        if (data == null) {
            if (cellMetadata.has(NBGRADER_KEY)) {
                cellMetadata.delete(NBGRADER_KEY);
            }
            return;
        }
        const currentDataJson = cellMetadata.get(NBGRADER_KEY);
        const currentData = currentDataJson == null
            ? null
            : currentDataJson.valueOf();
        if (currentData != data) {
            cellMetadata.set(NBGRADER_KEY, data.toJson());
        }
    }
    CellModel.setNbgraderData = setNbgraderData;
})(CellModel || (CellModel = {}));
var PrivateNbgraderData;
(function (PrivateNbgraderData) {
    function getGradeId(nbgraderData) {
        if (nbgraderData == null || nbgraderData.grade_id == null) {
            return '';
        }
        return nbgraderData.grade_id;
    }
    PrivateNbgraderData.getGradeId = getGradeId;
    function getPoints(nbgraderData) {
        if (nbgraderData == null) {
            return 0;
        }
        return PrivateNbgraderData._to_float(nbgraderData.points);
    }
    PrivateNbgraderData.getPoints = getPoints;
    function getSchemeaVersion(nbgraderData) {
        if (nbgraderData === null) {
            return 0;
        }
        return nbgraderData.schema_version;
    }
    PrivateNbgraderData.getSchemeaVersion = getSchemeaVersion;
    function getType(nbgraderData, cellType) {
        if (PrivateNbgraderData.isTask(nbgraderData)) {
            return 'task';
        }
        else if (PrivateNbgraderData.isSolution(nbgraderData) &&
            isGrade(nbgraderData)) {
            return 'manual';
        }
        else if (PrivateNbgraderData.isSolution(nbgraderData) &&
            cellType === 'code') {
            return 'solution';
        }
        else if (PrivateNbgraderData.isGrade(nbgraderData) &&
            cellType === 'code') {
            return 'tests';
        }
        else if (PrivateNbgraderData.isLocked(nbgraderData)) {
            return 'readonly';
        }
        else {
            return '';
        }
    }
    PrivateNbgraderData.getType = getType;
    function isGrade(nbgraderData) {
        return nbgraderData != null && nbgraderData.grade === true;
    }
    PrivateNbgraderData.isGrade = isGrade;
    function isGraded(nbgraderData) {
        return (PrivateNbgraderData.isGrade(nbgraderData) ||
            PrivateNbgraderData.isTask(nbgraderData));
    }
    PrivateNbgraderData.isGraded = isGraded;
    function isInvalid(nbgraderData, cellType) {
        return (!PrivateNbgraderData.isTask(nbgraderData) &&
            cellType !== 'code' &&
            PrivateNbgraderData.isSolution(nbgraderData) !=
                PrivateNbgraderData.isGrade(nbgraderData));
    }
    PrivateNbgraderData.isInvalid = isInvalid;
    function isLocked(nbgraderData) {
        return (!PrivateNbgraderData.isSolution(nbgraderData) &&
            (PrivateNbgraderData.isGraded(nbgraderData) ||
                (nbgraderData != null && nbgraderData.locked === true)));
    }
    PrivateNbgraderData.isLocked = isLocked;
    function isSolution(nbgraderData) {
        return nbgraderData != null && nbgraderData.solution === true;
    }
    PrivateNbgraderData.isSolution = isSolution;
    function isTask(nbgraderData) {
        return nbgraderData != null && nbgraderData.task === true;
    }
    PrivateNbgraderData.isTask = isTask;
    function _to_float(val) {
        if (val == null || val === '') {
            return 0;
        }
        const valType = typeof val;
        if (valType === 'string') {
            return parseFloat(val);
        }
        else if (valType === 'number') {
            return val;
        }
        return 0;
    }
    PrivateNbgraderData._to_float = _to_float;
})(PrivateNbgraderData || (PrivateNbgraderData = {}));
var PrivateToolData;
(function (PrivateToolData) {
    function getGrade(data) {
        return data.type === 'manual' || data.type === 'tests';
    }
    PrivateToolData.getGrade = getGrade;
    function getGradeId(data) {
        return data.id == null ? '' : data.id;
    }
    PrivateToolData.getGradeId = getGradeId;
    function getLocked(data) {
        if (PrivateToolData.getSolution(data)) {
            return false;
        }
        if (PrivateToolData.getGrade(data)) {
            return true;
        }
        return (data.type === 'task' || data.type === 'tests' || data.type === 'readonly');
    }
    PrivateToolData.getLocked = getLocked;
    function getPoints(data) {
        if (!PrivateToolData.getGrade(data) && !PrivateToolData.getTask(data)) {
            return undefined;
        }
        return data.points >= 0 ? data.points : 0;
    }
    PrivateToolData.getPoints = getPoints;
    function getSchemeaVersion() {
        return NBGRADER_SCHEMA_VERSION;
    }
    PrivateToolData.getSchemeaVersion = getSchemeaVersion;
    function getSolution(data) {
        return data.type === 'manual' || data.type === 'solution';
    }
    PrivateToolData.getSolution = getSolution;
    function getTask(data) {
        return data.type === 'task';
    }
    PrivateToolData.getTask = getTask;
})(PrivateToolData || (PrivateToolData = {}));
/**
 * Dummy class for representing the nbgrader cell metadata.
 */
class NbgraderData {
    toJson() {
        const json = {};
        if (this.grade != null) {
            json['grade'] = this.grade;
        }
        if (this.grade_id != null) {
            json['grade_id'] = this.grade_id;
        }
        if (this.locked != null) {
            json['locked'] = this.locked;
        }
        if (this.points != null) {
            json['points'] = this.points;
        }
        if (this.schema_version != null) {
            json['schema_version'] = this.schema_version;
        }
        if (this.solution != null) {
            json['solution'] = this.solution;
        }
        if (this.task != null) {
            json['task'] = this.task;
        }
        return json;
    }
}
/**
 * Dummy class for representing the UI input/output values.
 */
class ToolData {
}


/***/ }),

/***/ "./lib/components/notebook/slider.js":
/*!*******************************************!*\
  !*** ./lib/components/notebook/slider.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotebookModeSwitch": () => (/* binding */ NotebookModeSwitch)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _switch_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./switch-factory */ "./lib/components/notebook/switch-factory.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


class NotebookModeSwitch extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(mode, notebookpanel, notebook) {
        super();
        this.mode = mode;
        const onChange = (m) => {
            this.mode = m;
        };
        const props = {
            notebook: notebook,
            notebookpanel: notebookpanel,
            mode: mode,
            onChange: onChange
        };
        this.component = _switch_factory__WEBPACK_IMPORTED_MODULE_1__.SwitchModeFactory.getSwitch(props);
    }
    render() {
        return this.component;
    }
}


/***/ }),

/***/ "./lib/components/notebook/student-plugin/deadline-widget.js":
/*!*******************************************************************!*\
  !*** ./lib/components/notebook/student-plugin/deadline-widget.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeadlineWidget": () => (/* binding */ DeadlineWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _deadline_wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./deadline-wrapper */ "./lib/components/notebook/student-plugin/deadline-wrapper.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



class DeadlineWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(path) {
        super();
        this.notebookPaths = path.split('/');
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_1__.createElement(_deadline_wrapper__WEBPACK_IMPORTED_MODULE_2__.DeadlineWrapper, { notebookPaths: this.notebookPaths });
    }
}


/***/ }),

/***/ "./lib/components/notebook/student-plugin/deadline-wrapper.js":
/*!********************************************************************!*\
  !*** ./lib/components/notebook/student-plugin/deadline-wrapper.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeadlineWrapper": () => (/* binding */ DeadlineWrapper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_deadline__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/deadline */ "./lib/components/util/deadline.js");
/* harmony import */ var _services_lectures_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../services/lectures.service */ "./lib/services/lectures.service.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);





/**
 * React Component which handles all request which are needed to get the assignment deadline
 * Why is this needed => we can not to the requests in the widget because the constructor can not handle async requests
 * There is probably a better way to do this
 * @param props props of the component
 */
const DeadlineWrapper = (props) => {
    const [lecture, setLecture] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    const [assignment, setAssignment] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (lecture === null) {
            (0,_services_lectures_service__WEBPACK_IMPORTED_MODULE_2__.getAllLectures)().then(response => {
                const l = response.find(l => l.code === props.notebookPaths[0]);
                if (l === undefined) {
                    return;
                }
                setLecture(l);
            });
        }
        if (lecture === null) {
            return;
        }
        (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_3__.getAssignment)(lecture.id, +props.notebookPaths[1]).then(response => {
            setAssignment(response);
        });
    }, [lecture]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, null, assignment !== null ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_util_deadline__WEBPACK_IMPORTED_MODULE_4__.DeadlineComponent, { due_date: assignment.due_date, compact: false, component: 'chip' })) : null));
};


/***/ }),

/***/ "./lib/components/notebook/student-plugin/hint-component.js":
/*!******************************************************************!*\
  !*** ./lib/components/notebook/student-plugin/hint-component.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HintComponent": () => (/* binding */ HintComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);


const HintComponent = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Collapse, { in: props.show },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Alert, { sx: { mt: 1, mb: 1 }, severity: "info" }, props.hint)));
};


/***/ }),

/***/ "./lib/components/notebook/student-plugin/hint-widget.js":
/*!***************************************************************!*\
  !*** ./lib/components/notebook/student-plugin/hint-widget.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HintWidget": () => (/* binding */ HintWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _hint_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hint-component */ "./lib/components/notebook/student-plugin/hint-component.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



class HintWidget extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {
    constructor(hint) {
        super();
        this.showAlert = true;
        this.hint = hint;
    }
    toggleShowAlert() {
        this.showAlert = !this.showAlert;
    }
    setHint(hint) {
        this.hint = hint;
    }
    render() {
        return react__WEBPACK_IMPORTED_MODULE_1__.createElement(_hint_component__WEBPACK_IMPORTED_MODULE_2__.HintComponent, { hint: this.hint, show: this.showAlert });
    }
}


/***/ }),

/***/ "./lib/components/notebook/switch-factory.js":
/*!***************************************************!*\
  !*** ./lib/components/notebook/switch-factory.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SwitchModeFactory": () => (/* binding */ SwitchModeFactory)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _services_permission_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/permission.service */ "./lib/services/permission.service.js");
/* harmony import */ var _create_assignment_creation_switch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./create-assignment/creation-switch */ "./lib/components/notebook/create-assignment/creation-switch.js");
/* harmony import */ var _create_assignment_validator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./create-assignment/validator */ "./lib/components/notebook/create-assignment/validator.js");
/* harmony import */ var _manual_grading_grading_switch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./manual-grading/grading-switch */ "./lib/components/notebook/manual-grading/grading-switch.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.






class SwitchModeFactory {
    static getSwitch(props) {
        const paths = props.notebookpanel.context.contentsModel.path.split('/');
        const path = paths[0];
        const permissions = _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.UserPermissions.getPermissions();
        const lecturecode = paths[1];
        let hasPermission = false;
        if (permissions.hasOwnProperty(lecturecode)) {
            hasPermission = permissions[lecturecode] !== _services_permission_service__WEBPACK_IMPORTED_MODULE_2__.Scope.student;
        }
        if (!hasPermission) {
            return null;
        }
        switch (path) {
            case 'manualgrade':
                return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_manual_grading_grading_switch__WEBPACK_IMPORTED_MODULE_3__.GradingModeSwitch, { notebook: props.notebook, notebookpanel: props.notebookpanel, mode: props.mode, onChange: props.onChange }));
            case 'source':
                return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { container: true, spacing: 2 },
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true },
                        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_create_assignment_creation_switch__WEBPACK_IMPORTED_MODULE_4__.CreationModeSwitch, { notebook: props.notebook, notebookpanel: props.notebookpanel, mode: props.mode, onChange: props.onChange })),
                    react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Grid, { item: true },
                        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_create_assignment_validator__WEBPACK_IMPORTED_MODULE_5__.Validator, { notebook: props.notebook }))));
            default:
                return null;
        }
    }
}


/***/ }),

/***/ "./lib/components/util/card-descriptor.js":
/*!************************************************!*\
  !*** ./lib/components/util/card-descriptor.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardDescriptor": () => (/* binding */ CardDescriptor)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);


const CardDescriptor = (props) => {
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: Object.assign({ fontSize: props.fontSize }, props.sx) },
        props.value,
        (props.ofTotal) ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { sx: { fontSize: props.fontSizeTotal, ml: 0, display: 'inline-block' } }, '/' + props.ofTotal) : null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { color: "text.secondary", sx: {
                display: 'inline-block',
                ml: 0.75,
                fontSize: props.fontSizeDescriptor
            } }, props.descriptor + (props.value === 1 || react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(props.value) ? '' : 's')));
};
CardDescriptor.defaultProps = {
    fontSize: 16,
    fontSizeTotal: 10,
    fontSizeDescriptor: 14,
    sx: { mt: 0.5, ml: 0.5 },
};


/***/ }),

/***/ "./lib/components/util/deadline.js":
/*!*****************************************!*\
  !*** ./lib/components/util/deadline.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeadlineComponent": () => (/* binding */ DeadlineComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material_AccessAlarmRounded__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/AccessAlarmRounded */ "./node_modules/@mui/icons-material/AccessAlarmRounded.js");
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/grey.js");
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/orange.js");
/* harmony import */ var _mui_material_colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/colors */ "./node_modules/@mui/material/colors/red.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.





const compactTimeUnits = {
    w: 'W',
    d: 'd',
    h: 'h',
    m: 'm',
    s: 's'
};
const fullTimeUnits = {
    w: 'Week',
    d: 'Day',
    h: 'Hour',
    m: 'Minute',
    s: 'Second'
};
const getTimeUnit = (timeUnit, value, compact) => {
    if (compact) {
        return `${value}${compactTimeUnits[timeUnit]}`;
    }
    if (value === 1) {
        return `${value} ${fullTimeUnits[timeUnit]}`;
    }
    else {
        return `${value} ${fullTimeUnits[timeUnit]}s`;
    }
};
const calculateTimeLeft = (date) => {
    const difference = +date - +new Date();
    const timeLeft = {
        weeks: Math.floor(difference / (1000 * 60 * 60 * 24 * 7)),
        days: Math.floor((difference / (1000 * 60 * 60 * 24)) % 7),
        hours: Math.floor((difference / (1000 * 60 * 60)) % 24),
        minutes: Math.floor((difference / 1000 / 60) % 60),
        seconds: Math.floor((difference / 1000) % 60)
    };
    return timeLeft;
};
function getDisplayDate(date, compact) {
    if (date === undefined) {
        return 'No Deadline 😁';
    }
    const time = calculateTimeLeft(date);
    if (time.weeks === 0) {
        if (time.days === 0) {
            return `${getTimeUnit('h', time.hours, compact)} ${getTimeUnit('m', time.minutes, compact)} ${getTimeUnit('s', time.seconds, compact)}`;
        }
        else {
            return `${getTimeUnit('d', time.days, compact)} ${getTimeUnit('h', time.hours, compact)} ${getTimeUnit('m', time.minutes, compact)}`;
        }
    }
    else if (time.weeks > 0) {
        return `${getTimeUnit('w', time.weeks, compact)} ${getTimeUnit('d', time.days, compact)} ${getTimeUnit('h', time.hours, compact)}`;
    }
    else {
        return 'Deadline over!';
    }
}
function getCardColor(c) {
    if (c === 'default') {
        return _mui_material_colors__WEBPACK_IMPORTED_MODULE_3__["default"][300];
    }
    else if (c === 'warning') {
        return _mui_material_colors__WEBPACK_IMPORTED_MODULE_4__["default"][500];
    }
    else {
        return _mui_material_colors__WEBPACK_IMPORTED_MODULE_5__["default"][500];
    }
}
const DeadlineComponent = (props) => {
    const [date, setDate] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.due_date !== null
        ? moment__WEBPACK_IMPORTED_MODULE_1___default().utc(props.due_date).local().toDate()
        : undefined);
    const [displayDate, setDisplayDate] = react__WEBPACK_IMPORTED_MODULE_0__.useState(getDisplayDate(date, props.compact));
    const [interval, setNewInterval] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    const [color, setColor] = react__WEBPACK_IMPORTED_MODULE_0__.useState('default');
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const d = props.due_date !== null
            ? moment__WEBPACK_IMPORTED_MODULE_1___default().utc(props.due_date).local().toDate()
            : undefined;
        setDate(d);
        setDisplayDate(getDisplayDate(d, props.compact));
        updateTimeoutInterval(d);
        let c = 'default';
        const time = calculateTimeLeft(d);
        if (d !== undefined) {
            if (time.weeks === 0 && time.days === 0) {
                c = 'warning';
                if (time.hours === 0) {
                    c = 'error';
                }
            }
            if (+d - +new Date() < 0) {
                c = 'error';
            }
        }
        setColor(c);
    }, [props]);
    const updateTimeoutInterval = (date) => {
        if (interval) {
            clearInterval(interval);
        }
        const time = calculateTimeLeft(date);
        const timeout = time.weeks === 0 && time.days === 0 ? 1000 : 10000;
        const newInterval = setInterval(() => {
            setDisplayDate(getDisplayDate(date, props.compact));
        }, timeout);
        setNewInterval(newInterval);
    };
    return props.component === 'chip' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Chip, { sx: props.sx, size: "small", icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_AccessAlarmRounded__WEBPACK_IMPORTED_MODULE_6__["default"], null), label: displayDate, color: color })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CardContent, { sx: { backgroundColor: getCardColor(color), p: 1, width: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, { variant: "overline", align: "left", sx: { fontSize: 9, ml: 1 } }, "Deadline"),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, { align: "center", sx: { fontSize: 12, m: 0, mt: -1 } }, displayDate)));
};


/***/ }),

/***/ "./lib/components/util/dialog.js":
/*!***************************************!*\
  !*** ./lib/components/util/dialog.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AgreeDialog": () => (/* binding */ AgreeDialog),
/* harmony export */   "CommitDialog": () => (/* binding */ CommitDialog),
/* harmony export */   "CreateDialog": () => (/* binding */ CreateDialog),
/* harmony export */   "EditDialog": () => (/* binding */ EditDialog),
/* harmony export */   "EditLectureDialog": () => (/* binding */ EditLectureDialog),
/* harmony export */   "ReleaseDialog": () => (/* binding */ ReleaseDialog),
/* harmony export */   "default": () => (/* binding */ NewAssignmentCard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! formik */ "webpack/sharing/consume/default/formik/formik");
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! yup */ "webpack/sharing/consume/default/yup/yup");
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_lab_AdapterDateFns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/lab/AdapterDateFns */ "webpack/sharing/consume/default/@date-io/date-fns/@date-io/date-fns");
/* harmony import */ var _mui_lab_AdapterDateFns__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_AdapterDateFns__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _mui_lab_LocalizationProvider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/lab/LocalizationProvider */ "./node_modules/@mui/x-date-pickers/LocalizationProvider/LocalizationProvider.js");
/* harmony import */ var _mui_lab_DateTimePicker__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/lab/DateTimePicker */ "./node_modules/@mui/x-date-pickers/DateTimePicker/DateTimePicker.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/lab */ "webpack/sharing/consume/default/@mui/lab/@mui/lab");
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_lab__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Edit */ "./node_modules/@mui/icons-material/Edit.js");
/* harmony import */ var _services_assignments_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../services/assignments.service */ "./lib/services/assignments.service.js");
/* harmony import */ var _mui_icons_material_HelpOutlineOutlined__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/icons-material/HelpOutlineOutlined */ "./node_modules/@mui/icons-material/HelpOutlineOutlined.js");
/* harmony import */ var _mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/icons-material/Add */ "./node_modules/@mui/icons-material/Add.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_6__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.














const gradingBehaviourHelp = `Specifies the behaviour when a students submits an assignment.\n
No Automatic Grading: No action is taken on submit.\n
Automatic Grading: The assignment is being autograded as soon as the students makes a submission.\n
Fully Automatic Grading: The assignment is autograded and feedback is generated as soon as the student makes a submission. 
(requires all scores to be based on autograde results)`;
const validationSchema = yup__WEBPACK_IMPORTED_MODULE_2__.object({
    name: yup__WEBPACK_IMPORTED_MODULE_2__.string()
        .min(4, 'Name should be 4-50 character length')
        .max(50, 'Name should be 4-50 character length')
        .required('Name is required'),
    due_date: yup__WEBPACK_IMPORTED_MODULE_2__.date()
        .min(moment__WEBPACK_IMPORTED_MODULE_6___default().utc().toDate(), 'Deadline must be set in the future')
        .nullable(),
    type: yup__WEBPACK_IMPORTED_MODULE_2__.mixed().oneOf(['user', 'group']),
    automatic_grading: yup__WEBPACK_IMPORTED_MODULE_2__.mixed().oneOf(['unassisted', 'auto', 'full_auto']),
    max_submissions: yup__WEBPACK_IMPORTED_MODULE_2__.number()
        .min(1, 'Students must be able to at least submit once')
});
const EditDialog = (props) => {
    const [checked, setChecked] = react__WEBPACK_IMPORTED_MODULE_0__.useState(props.assignment.due_date !== null);
    const formik = (0,formik__WEBPACK_IMPORTED_MODULE_1__.useFormik)({
        initialValues: {
            name: props.assignment.name,
            due_date: props.assignment.due_date !== null
                ? new Date(props.assignment.due_date)
                : null,
            type: props.assignment.type,
            automatic_grading: props.assignment.automatic_grading,
            max_submissions: props.assignment.max_submissions
        },
        validationSchema: validationSchema,
        onSubmit: values => {
            values.max_submissions = +values.max_submissions;
            const updatedAssignment = Object.assign(props.assignment, values);
            if (props.onSubmit) {
                props.onSubmit(updatedAssignment);
            }
            setOpen(false);
        }
    });
    const [openDialog, setOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Tooltip, { title: 'Edit Assignment' },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.IconButton, { sx: { mt: -1 }, onClick: e => {
                    e.stopPropagation();
                    setOpen(true);
                }, onMouseDown: event => event.stopPropagation(), "aria-label": "edit" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_7__["default"], null))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: openDialog, onBackdropClick: () => setOpen(false) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, null, "Edit Assignment"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", { onSubmit: formik.handleSubmit },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, { spacing: 2, sx: { ml: 2, mr: 2 } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { variant: "outlined", fullWidth: true, id: "name", name: "name", label: "Assignment Name", value: formik.values.name, onChange: formik.handleChange, error: formik.touched.name && Boolean(formik.errors.name), helperText: formik.touched.name && formik.errors.name }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab_LocalizationProvider__WEBPACK_IMPORTED_MODULE_8__.LocalizationProvider, { dateAdapter: (_mui_lab_AdapterDateFns__WEBPACK_IMPORTED_MODULE_9___default()) },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, { control: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, { checked: checked, onChange: async (e) => {
                                        setChecked(e.target.checked);
                                        if (!e.target.checked) {
                                            await formik.setFieldValue('due_date', null);
                                        }
                                        else {
                                            await formik.setFieldValue('due_date', new Date());
                                        }
                                    } }), label: "Set Deadline" }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab_DateTimePicker__WEBPACK_IMPORTED_MODULE_10__.DateTimePicker, { ampm: false, disabled: !checked, renderInput: (props) => {
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, Object.assign({}, props, { helperText: formik.touched.due_date && formik.errors.due_date, error: formik.touched.due_date &&
                                            Boolean(formik.errors.due_date) })));
                                }, label: "DateTimePicker", value: formik.values.due_date, onChange: date => {
                                    formik.setFieldValue('due_date', date);
                                } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, { control: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, { checked: Boolean(formik.values.max_submissions), value: Boolean(formik.values.max_submissions), onChange: async (e) => {
                                    console.log('Before: ' + formik.values.max_submissions);
                                    if (e.target.checked) {
                                        await formik.setFieldValue('max_submissions', 1);
                                    }
                                    else {
                                        await formik.setFieldValue('max_submissions', undefined);
                                    }
                                    console.log('After: ' + formik.values.max_submissions);
                                } }), label: "Limit Number of Submissions" }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { variant: "outlined", fullWidth: true, disabled: !formik.values.max_submissions, type: 'number', id: "max-submissions", name: "max_submissions", placeholder: "Submissions", value: formik.values.max_submissions, onChange: e => {
                                formik.setFieldValue('max_submissions', e.target.value);
                            }, helperText: formik.touched.max_submissions &&
                                formik.errors.max_submissions, error: formik.values.max_submissions < 1 }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.InputLabel, { id: "demo-simple-select-label-auto" },
                            "Auto-Grading Behaviour",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Tooltip, { title: gradingBehaviourHelp },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_HelpOutlineOutlined__WEBPACK_IMPORTED_MODULE_11__["default"], { fontSize: 'small', sx: { ml: 1.5, mt: 1.0 } }))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { select: true, id: "assignment-type-select", value: formik.values.automatic_grading, label: "Auto-Grading Behaviour", placeholder: "Grading", onChange: e => {
                                formik.setFieldValue('automatic_grading', e.target.value);
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'unassisted' }, "No Automatic Grading"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'auto' }, "Automatic Grading"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'full_auto' }, "Fully Automatic Grading")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { fullWidth: true, color: "error", variant: "contained", disabled: props.assignment.status === 'released' ||
                                props.assignment.status === 'complete', onClick: async () => {
                                await (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_12__.deleteAssignment)(props.lecture.id, props.assignment.id).then(response => {
                                    setOpen(false);
                                    props.onClose();
                                }, (error) => {
                                    (0,notistack__WEBPACK_IMPORTED_MODULE_5__.enqueueSnackbar)(error.message, {
                                        variant: 'error'
                                    });
                                });
                            } }, "Delete Assignment"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("small", { hidden: props.assignment.status !== 'released' &&
                                props.assignment.status !== 'complete' }, "Can not delete assignment while it is released!"))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "outlined", onClick: () => {
                            setOpen(false);
                        } }, "Cancel"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "contained", type: "submit" }, "Submit"))))));
};
const validationSchemaLecture = yup__WEBPACK_IMPORTED_MODULE_2__.object({
    name: yup__WEBPACK_IMPORTED_MODULE_2__.string()
        .min(4, 'Name should be 4-50 characters long')
        .max(50, 'Name should be 4-50 characters long')
        .required('Name is required'),
    complete: yup__WEBPACK_IMPORTED_MODULE_2__.boolean()
});
const EditLectureDialog = (props) => {
    const formik = (0,formik__WEBPACK_IMPORTED_MODULE_1__.useFormik)({
        initialValues: {
            name: props.lecture.name,
            complete: props.lecture.complete
        },
        validationSchema: validationSchemaLecture,
        onSubmit: values => {
            const updatedLecture = Object.assign(props.lecture, values);
            console.log(updatedLecture);
            props.handleSubmit(updatedLecture);
            setOpen(false);
        }
    });
    const [openDialog, setOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Tooltip, { title: 'Edit Lecture' },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.IconButton, { sx: { mt: -1 }, onClick: e => {
                    e.stopPropagation();
                    setOpen(true);
                }, onMouseDown: event => event.stopPropagation(), "aria-label": "edit" },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_7__["default"], null))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: openDialog, onBackdropClick: () => setOpen(false) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, null, "Edit Lecture"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", { onSubmit: formik.handleSubmit },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, { spacing: 2 },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { variant: "outlined", fullWidth: true, id: "name", name: "name", label: "Lecture Name", value: formik.values.name, onChange: formik.handleChange, error: formik.touched.name && Boolean(formik.errors.name), helperText: formik.touched.name && formik.errors.name }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, { control: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, { value: formik.values.complete, checked: formik.values.complete, onChange: e => {
                                    formik.setFieldValue('complete', e.target.checked);
                                } }), label: "Complete" }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "outlined", onClick: () => {
                            setOpen(false);
                        } }, "Cancel"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "contained", type: "submit" }, "Submit"))))));
};
function NewAssignmentCard(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Card, { sx: { width: 225, height: '100%', m: 1.5, backgroundColor: '#fcfcfc' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Tooltip, { title: 'New Assignment' },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.CardActionArea, { onClick: props.onClick, sx: {
                    width: '100%',
                    height: '100%',
                    display: 'flex',
                    justifyContent: 'center',
                    alignItems: 'center'
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_13__["default"], { sx: { fontSize: 50 }, color: "disabled" })))));
}
const CreateDialog = (props) => {
    const formik = (0,formik__WEBPACK_IMPORTED_MODULE_1__.useFormik)({
        initialValues: {
            name: 'Assignment',
            due_date: null,
            type: 'user',
            automatic_grading: 'unassisted',
            max_submissions: undefined
        },
        validationSchema: validationSchema,
        onSubmit: values => {
            const updatedAssignment = {
                name: values.name,
                due_date: values.due_date,
                type: values.type,
                automatic_grading: values.automatic_grading,
                max_submissions: +values.max_submissions
            };
            (0,_services_assignments_service__WEBPACK_IMPORTED_MODULE_12__.createAssignment)(props.lecture.id, updatedAssignment).then(a => console.log(a), error => {
                (0,notistack__WEBPACK_IMPORTED_MODULE_5__.enqueueSnackbar)(error.message, {
                    variant: 'error'
                });
            });
            setOpen(false);
            props.handleSubmit();
        }
    });
    const [openDialog, setOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Box, { sx: { minHeight: 225, height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(NewAssignmentCard, { onClick: e => {
                e.stopPropagation();
                setOpen(true);
            } }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: openDialog, onBackdropClick: () => setOpen(false), onClose: () => setOpen(false) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, null, "Create Assignment"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", { onSubmit: formik.handleSubmit },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, { spacing: 2 },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { variant: "outlined", fullWidth: true, id: "name", name: "name", label: "Assignment Name", value: formik.values.name, onChange: formik.handleChange, error: formik.touched.name && Boolean(formik.errors.name), helperText: formik.touched.name && formik.errors.name }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab_LocalizationProvider__WEBPACK_IMPORTED_MODULE_8__.LocalizationProvider, { dateAdapter: (_mui_lab_AdapterDateFns__WEBPACK_IMPORTED_MODULE_9___default()) },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, { control: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, { value: false, onChange: async (e) => {
                                        console.log('Before: ' + formik.values.due_date);
                                        if (e.target.checked) {
                                            await formik.setFieldValue('due_date', new Date());
                                        }
                                        else {
                                            await formik.setFieldValue('due_date', null);
                                        }
                                        console.log('After: ' + formik.values.due_date);
                                    } }), label: "Set Deadline" }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab_DateTimePicker__WEBPACK_IMPORTED_MODULE_10__.DateTimePicker, { ampm: false, disabled: formik.values.due_date === null, renderInput: (props) => {
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, Object.assign({}, props, { helperText: formik.touched.due_date && formik.errors.due_date, error: formik.touched.due_date &&
                                            Boolean(formik.errors.due_date) })));
                                }, label: "DateTimePicker", value: formik.values.due_date, onChange: date => {
                                    formik.setFieldValue('due_date', date);
                                } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.FormControlLabel, { control: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Checkbox, { value: Boolean(formik.values.max_submissions), onChange: async (e) => {
                                    console.log('Before: ' + formik.values.max_submissions);
                                    if (e.target.checked) {
                                        await formik.setFieldValue('max_submissions', 1);
                                    }
                                    else {
                                        await formik.setFieldValue('max_submissions', undefined);
                                    }
                                    console.log('After: ' + formik.values.max_submissions);
                                } }), label: "Limit Number of Submissions" }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { variant: "outlined", fullWidth: true, disabled: !formik.values.max_submissions, type: 'number', id: "max-submissions", name: "max_submissions", placeholder: "Submissions", value: formik.values.max_submissions, onChange: e => {
                                formik.setFieldValue('max_submissions', e.target.value);
                            }, error: formik.values.max_submissions < 1 }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.InputLabel, { id: "demo-simple-select-label-auto" },
                            "Auto-Grading Behaviour",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Tooltip, { title: gradingBehaviourHelp },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_HelpOutlineOutlined__WEBPACK_IMPORTED_MODULE_11__["default"], { fontSize: 'small', sx: { ml: 1.5, mt: 1.0 } }))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { select: true, id: "assignment-type-select", value: formik.values.automatic_grading, label: "Auto-Grading Behaviour", placeholder: "Grading", onChange: e => {
                                formik.setFieldValue('automatic_grading', e.target.value);
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'unassisted' }, "No Automatic Grading"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'auto' }, "Automatic Grading"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'full_auto' }, "Fully Automatic Grading")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.InputLabel, { id: "demo-simple-select-label" }, "Type"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Select, { labelId: "assignment-type-select-label", id: "assignment-type-select", value: formik.values.type, label: "Type", onChange: e => {
                                formik.setFieldValue('type', e.target.value);
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'user' }, "User"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem, { value: 'group' }, "Group")))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "outlined", onClick: () => {
                            setOpen(false);
                        } }, "Cancel"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "contained", type: "submit" }, "Create"))))));
};
const CommitDialog = (props) => {
    const [open, setOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [message, setMessage] = react__WEBPACK_IMPORTED_MODULE_0__.useState('');
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Box, { onClick: () => setOpen(true) }, props.children),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: open, onBackdropClick: () => setOpen(false), onClose: () => setOpen(false), fullWidth: true, maxWidth: 'sm' },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, null, "Commit Files"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { sx: { mt: 2, width: '100%' }, id: "outlined-textarea", label: "Commit Message", placeholder: "Commit Message", value: message, onChange: event => setMessage(event.target.value), multiline: true })),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "outlined", onClick: () => {
                        setOpen(false);
                    } }, "Cancel"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "contained", type: "submit", disabled: message === '', onClick: () => {
                        props.handleCommit(message);
                        setOpen(false);
                    } }, "Commit")))));
};
const AgreeDialog = (props) => {
    const [loading, setLoading] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const executeAction = async (action) => {
        setLoading(true);
        await action();
        setLoading(false);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: props.open, onClose: props.handleDisagree, onBackdropClick: props.handleDisagree, "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description" },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, { id: "alert-dialog-title" }, props.title),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContentText, { id: "alert-dialog-description" }, props.message)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { onClick: props.handleDisagree }, "Disagree"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab__WEBPACK_IMPORTED_MODULE_4__.LoadingButton, { loading: loading, onClick: () => executeAction(props.handleAgree), autoFocus: true }, "Agree"))));
};
const ReleaseDialog = (props) => {
    const [agreeOpen, setAgreeOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [commitOpen, setCommitOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [message, setMessage] = react__WEBPACK_IMPORTED_MODULE_0__.useState('');
    const [loading, setLoading] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const agreeMessage = `Do you want to release "${props.assignment.name}" for all students? Before releasing, all changes are pushed again as the release version.`;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Box, { onClick: () => setAgreeOpen(true) }, props.children),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(AgreeDialog, { open: agreeOpen, title: 'Release Assignment', message: agreeMessage, handleAgree: () => {
                setAgreeOpen(false);
                setCommitOpen(true);
            }, handleDisagree: () => setAgreeOpen(false) }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog, { open: commitOpen, onBackdropClick: () => setCommitOpen(false), onClose: () => setCommitOpen(false), fullWidth: true, maxWidth: 'sm' },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, null, "Commit Files"),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogContent, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.TextField, { sx: { mt: 2, width: '100%' }, id: "outlined-textarea", label: "Commit Message", placeholder: "Commit Message", value: message, onChange: event => setMessage(event.target.value), multiline: true })),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.DialogActions, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button, { color: "primary", variant: "outlined", onClick: () => {
                        setCommitOpen(false);
                    } }, "Cancel"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab__WEBPACK_IMPORTED_MODULE_4__.LoadingButton, { loading: loading, color: "primary", variant: "contained", type: "submit", disabled: message === '', onClick: async () => {
                        setLoading(true);
                        await props.handleCommit(message);
                        await props.handleRelease();
                        setLoading(false);
                        setCommitOpen(false);
                    } }, "Commit and Release")))));
};


/***/ }),

/***/ "./lib/components/util/file-list.js":
/*!******************************************!*\
  !*** ./lib/components/util/file-list.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilesList": () => (/* binding */ FilesList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_InsertDriveFileRounded__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/icons-material/InsertDriveFileRounded */ "./node_modules/@mui/icons-material/InsertDriveFileRounded.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../index */ "./lib/index.js");
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/file.service */ "./lib/services/file.service.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.






const FilesList = (props) => {
    const [files, setFiles] = react__WEBPACK_IMPORTED_MODULE_0__.useState([]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        (0,_services_file_service__WEBPACK_IMPORTED_MODULE_3__.getFiles)(props.path).then(files => setFiles(files));
    }, [props]);
    const openFile = async (path) => {
        console.log('Opening file: ' + path);
        _index__WEBPACK_IMPORTED_MODULE_4__.GlobalObjects.commands.execute('docmanager:open', {
            path: path,
            options: {
                mode: 'tab-after' // tab-after tab-before split-bottom split-right split-left split-top
            }
        })
            .catch(error => {
            (0,notistack__WEBPACK_IMPORTED_MODULE_2__.enqueueSnackbar)(error, {
                variant: 'error'
            });
            console.log(error);
        });
    };
    // generateItems will be fed using the IIterator from the FilterFileBrowserModel
    const generateItems = (files) => {
        return files.map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItem, { disablePadding: true },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemButton, { onClick: () => openFile(value.path), dense: true },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemIcon, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_InsertDriveFileRounded__WEBPACK_IMPORTED_MODULE_5__["default"], null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemText, { primary: value.name })))));
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 0, sx: props.sx },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Card, { sx: { mt: 1, height: '80%' }, variant: "outlined" }, files.length === 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, { variant: 'body1', sx: { ml: 1 } }, "No Files Found")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.List, { dense: false }, generateItems(files))))));
};


/***/ }),

/***/ "./lib/components/util/modal-title.js":
/*!********************************************!*\
  !*** ./lib/components/util/modal-title.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalTitle": () => (/* binding */ ModalTitle)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material?808c");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.


const ModalTitle = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Box, { sx: { m: 3, top: 3 } },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_0__.Typography, { display: "inline-block", variant: "h4" }, props.title),
        props.children));
};


/***/ }),

/***/ "./lib/components/util/overlay.js":
/*!****************************************!*\
  !*** ./lib/components/util/overlay.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LoadingOverlay)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material_Modal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/Modal */ "./node_modules/@mui/material/Modal/Modal.js");
/* harmony import */ var _mui_material_Fade__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/Fade */ "./node_modules/@mui/material/Fade/Fade.js");
/* harmony import */ var _mui_material_Box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Box */ "./node_modules/@mui/material/Box/Box.js");
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Close */ "./node_modules/@mui/icons-material/Close.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/IconButton/IconButton.js");
/* harmony import */ var _mui_material_Zoom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/Zoom */ "./node_modules/@mui/material/Zoom/Zoom.js");
/* harmony import */ var _mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/CircularProgress */ "./node_modules/@mui/material/CircularProgress/CircularProgress.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.








function LoadingOverlay(props) {
    const baseStyle = {
        position: 'absolute',
        top: 0,
        bottom: 0,
        width: '100%',
        height: '100%',
        bgcolor: 'background.paper'
    };
    const style = Object.assign(Object.assign({}, baseStyle), props.sx);
    const Transitions = {
        fade: _mui_material_Fade__WEBPACK_IMPORTED_MODULE_1__["default"],
        zoom: _mui_material_Zoom__WEBPACK_IMPORTED_MODULE_2__["default"]
    };
    const Transition = Transitions[props.transition];
    let content;
    if (props.loading) {
        if (props.skeleton === null) {
            content = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_3__["default"], { sx: {
                    position: 'absolute',
                    top: '50%',
                    left: '50%'
                } }));
        }
        else {
            content = props.skeleton;
        }
    }
    else {
        content = props.children;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_Modal__WEBPACK_IMPORTED_MODULE_4__["default"], { open: props.open, onClose: props.onClose, hideBackdrop: true, "aria-labelledby": "modal-modal-title", "aria-describedby": "modal-modal-description", container: props.container, keepMounted: props.keepMounted, disableEnforceFocus: true, disableEscapeKeyDown: props.disableEscapeKeyDown, sx: { position: 'absolute', width: '100%', height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(Transition, { in: props.open, timeout: props.timeout },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_Box__WEBPACK_IMPORTED_MODULE_5__["default"], { sx: style, className: '.mui-fixed' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_6__["default"], { className: '.mui-fixed', size: "small", sx: {
                        position: 'absolute',
                        right: '20px',
                        top: '20px',
                        zIndex: 1000000
                    }, onClick: props.onClose },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_7__["default"], null)),
                content))));
}
LoadingOverlay.defaultProps = {
    loading: false,
    skeleton: null,
    timeout: 200,
    transition: 'fade',
    sx: {}
};


/***/ }),

/***/ "./lib/components/util/repo-type.js":
/*!******************************************!*\
  !*** ./lib/components/util/repo-type.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RepoType": () => (/* binding */ RepoType)
/* harmony export */ });
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.
var RepoType;
(function (RepoType) {
    RepoType["SOURCE"] = "source";
    RepoType["RELEASE"] = "release";
    RepoType["ASSIGNMENT"] = "assignment";
})(RepoType || (RepoType = {}));


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GlobalObjects": () => (/* binding */ GlobalObjects),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/launcher */ "webpack/sharing/consume/default/@jupyterlab/launcher");
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _widgets_coursemanage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./widgets/coursemanage */ "./lib/widgets/coursemanage.js");
/* harmony import */ var _components_notebook_slider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/notebook/slider */ "./lib/components/notebook/slider.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/filebrowser */ "webpack/sharing/consume/default/@jupyterlab/filebrowser");
/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _services_permission_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./services/permission.service */ "./lib/services/permission.service.js");
/* harmony import */ var _widgets_assignment_list__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./widgets/assignment-list */ "./lib/widgets/assignment-list.js");
/* harmony import */ var _components_notebook_create_assignment_creation_widget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/notebook/create-assignment/creation-widget */ "./lib/components/notebook/create-assignment/creation-widget.js");
/* harmony import */ var _jupyterlab_ui_components_lib_icon_iconimports__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @jupyterlab/ui-components/lib/icon/iconimports */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _components_notebook_student_plugin_hint_widget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/notebook/student-plugin/hint-widget */ "./lib/components/notebook/student-plugin/hint-widget.js");
/* harmony import */ var _components_notebook_student_plugin_deadline_widget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/notebook/student-plugin/deadline-widget */ "./lib/components/notebook/student-plugin/deadline-widget.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.
/* eslint-disable no-constant-condition */
/* eslint-disable @typescript-eslint/no-unused-vars */
/* eslint-disable no-prototype-builtins */
















var AssignmentsCommandIDs;
(function (AssignmentsCommandIDs) {
    AssignmentsCommandIDs.create = 'assignments:create';
    AssignmentsCommandIDs.open = 'assignments:open';
})(AssignmentsCommandIDs || (AssignmentsCommandIDs = {}));
var CourseManageCommandIDs;
(function (CourseManageCommandIDs) {
    CourseManageCommandIDs.create = 'coursemanage:create';
    CourseManageCommandIDs.open = 'coursemanage:open';
})(CourseManageCommandIDs || (CourseManageCommandIDs = {}));
var NotebookExecuteIDs;
(function (NotebookExecuteIDs) {
    NotebookExecuteIDs.run = 'notebookplugin:run-cell';
})(NotebookExecuteIDs || (NotebookExecuteIDs = {}));
var RevertCellIDs;
(function (RevertCellIDs) {
    RevertCellIDs.revert = 'notebookplugin:revert-cell';
})(RevertCellIDs || (RevertCellIDs = {}));
var ShowHintIDs;
(function (ShowHintIDs) {
    ShowHintIDs.show = 'notebookplugin:show-hint';
})(ShowHintIDs || (ShowHintIDs = {}));
var GradingCommandIDs;
(function (GradingCommandIDs) {
    GradingCommandIDs.create = 'grading:create';
    GradingCommandIDs.open = 'grading:open';
})(GradingCommandIDs || (GradingCommandIDs = {}));
var ManualGradeCommandIDs;
(function (ManualGradeCommandIDs) {
    ManualGradeCommandIDs.create = 'manualgrade:create';
    ManualGradeCommandIDs.open = 'manualgrade:open';
})(ManualGradeCommandIDs || (ManualGradeCommandIDs = {}));
var FeedbackCommandIDs;
(function (FeedbackCommandIDs) {
    FeedbackCommandIDs.create = 'feedback:create';
    FeedbackCommandIDs.open = 'feedback:open';
})(FeedbackCommandIDs || (FeedbackCommandIDs = {}));
var DeadlineCommandIDs;
(function (DeadlineCommandIDs) {
    DeadlineCommandIDs.open = 'deadline:open';
})(DeadlineCommandIDs || (DeadlineCommandIDs = {}));
class GlobalObjects {
}
/**
 * Initialization data for the grading extension.
 */
const extension = {
    id: 'coursemanage:plugin',
    autoStart: true,
    requires: [
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette,
        _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_2__.ILauncher,
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__.INotebookTools,
        _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__.IDocumentManager,
        _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_6__.IFileBrowserFactory,
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__.INotebookTracker,
        _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer
    ],
    activate: (app, palette, launcher, nbtools, docManager, browserFactory, tracker, restorer) => {
        console.log('JupyterLab extension grader_labextension is activated!');
        console.log('JupyterFrontEnd:', app);
        console.log('ICommandPalette:', palette);
        console.log('Tracker', tracker);
        GlobalObjects.commands = app.commands;
        GlobalObjects.docRegistry = app.docRegistry;
        GlobalObjects.serviceManager = app.serviceManager;
        GlobalObjects.docManager = docManager;
        GlobalObjects.browserFactory = browserFactory;
        GlobalObjects.tracker = tracker;
        const assignmentTracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({
            namespace: 'grader-assignments'
        });
        restorer.restore(assignmentTracker, {
            command: AssignmentsCommandIDs.open,
            name: () => 'grader-assignments'
        });
        const courseManageTracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({
            namespace: 'grader-coursemanage'
        });
        restorer.restore(courseManageTracker, {
            command: CourseManageCommandIDs.open,
            name: () => 'grader-coursemanage'
        });
        //Creation of in-cell widget for create assignment
        const connectTrackerSignals = (tracker) => {
            tracker.currentChanged.connect(async () => {
                const notebookPanel = tracker.currentWidget;
                //Notebook not yet loaded
                if (notebookPanel === null) {
                    return;
                }
                const notebook = tracker.currentWidget.content;
                const mode = false;
                notebookPanel.context.ready.then(() => {
                    //Creation of widget switch
                    const switcher = new _components_notebook_slider__WEBPACK_IMPORTED_MODULE_7__.NotebookModeSwitch(mode, notebookPanel, notebook);
                    tracker.currentWidget.toolbar.insertItem(10, 'Mode', switcher);
                    //Creation of deadline widget
                    const deadlineWidget = new _components_notebook_student_plugin_deadline_widget__WEBPACK_IMPORTED_MODULE_8__.DeadlineWidget(tracker.currentWidget.context.path);
                    tracker.currentWidget.toolbar.insertItem(11, 'Deadline', deadlineWidget);
                });
            }, undefined);
            tracker.activeCellChanged.connect(() => {
                const notebookPanel = tracker.currentWidget;
                //Notebook not yet loaded
                if (notebookPanel === null) {
                    return;
                }
                const notebook = tracker.currentWidget.content;
                const contentsModel = notebookPanel.context.contentsModel;
                if (contentsModel === null) {
                    return;
                }
                const notebookPaths = contentsModel.path.split('/');
                if (notebookPaths[0] === 'manualgrade') {
                    return;
                }
                let switcher = null;
                notebookPanel.toolbar.layout.widgets.map(w => {
                    if (w instanceof _components_notebook_slider__WEBPACK_IMPORTED_MODULE_7__.NotebookModeSwitch) {
                        switcher = w;
                    }
                });
                const cell = notebook.activeCell;
                //check if in creationmode and new cell was inserted
                if (switcher.mode &&
                    cell.layout.widgets.every(w => {
                        return !(w instanceof _components_notebook_create_assignment_creation_widget__WEBPACK_IMPORTED_MODULE_9__.CreationWidget);
                    })) {
                    cell.layout.insertWidget(0, new _components_notebook_create_assignment_creation_widget__WEBPACK_IMPORTED_MODULE_9__.CreationWidget(cell));
                }
            }, undefined);
        };
        /* ##### Course Manage View Widget ##### */
        let command = CourseManageCommandIDs.create;
        app.commands.addCommand(command, {
            execute: () => {
                // Create a blank content widget inside of a MainAreaWidget
                const gradingView = new _widgets_coursemanage__WEBPACK_IMPORTED_MODULE_10__.CourseManageView();
                const gradingWidget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.MainAreaWidget({
                    content: gradingView
                });
                gradingWidget.id = 'coursemanage-jupyterlab';
                gradingWidget.title.label = 'Course Management';
                gradingWidget.title.closable = true;
                courseManageTracker.add(gradingWidget);
                return gradingWidget;
            }
        });
        command = AssignmentsCommandIDs.create;
        app.commands.addCommand(command, {
            execute: () => {
                // Create a blank content widget inside a MainAreaWidget
                const assignmentList = new _widgets_assignment_list__WEBPACK_IMPORTED_MODULE_11__.AssignmentList();
                const assignmentWidget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.MainAreaWidget({
                    content: assignmentList
                });
                assignmentWidget.id = 'assignments-jupyterlab';
                assignmentWidget.title.label = 'Assignments';
                assignmentWidget.title.closable = true;
                assignmentTracker.add(assignmentWidget);
                return assignmentWidget;
            }
        });
        // If the user has no instructor roles in any lecture we do not display the course management
        _services_permission_service__WEBPACK_IMPORTED_MODULE_12__.UserPermissions.loadPermissions()
            .then(() => {
            const permissions = _services_permission_service__WEBPACK_IMPORTED_MODULE_12__.UserPermissions.getPermissions();
            let sum = 0;
            for (const el in permissions) {
                if (permissions.hasOwnProperty(el)) {
                    sum += permissions[el];
                }
            }
            if (sum !== 0) {
                console.log('Non-student permissions found! Adding coursemanage launcher and connecting creation mode');
                connectTrackerSignals(tracker);
                command = CourseManageCommandIDs.open;
                app.commands.addCommand(command, {
                    label: 'Course Management',
                    execute: async () => {
                        const gradingWidget = await app.commands.execute(CourseManageCommandIDs.create);
                        if (!gradingWidget.isAttached) {
                            // Attach the widget to the main work area if it's not there
                            app.shell.add(gradingWidget, 'main');
                        }
                        // Activate the widget
                        app.shell.activateById(gradingWidget.id);
                    },
                    icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.checkIcon
                });
                // Add the command to the launcher
                console.log('Add course management launcher');
                launcher.add({
                    command: command,
                    category: 'Assignments',
                    rank: 0
                });
            }
            // only add assignment list if user permissions can be loaded
            command = AssignmentsCommandIDs.open;
            app.commands.addCommand(command, {
                label: 'Assignments',
                execute: async () => {
                    const assignmentWidget = await app.commands.execute(AssignmentsCommandIDs.create);
                    if (!assignmentWidget.isAttached) {
                        // Attach the widget to the main work area if it's not there
                        app.shell.add(assignmentWidget, 'main');
                    }
                    // Activate the widget
                    app.shell.activateById(assignmentWidget.id);
                },
                icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.editIcon
            });
            // Add the command to the launcher
            console.log('Add assignment launcher');
            launcher.add({
                command: command,
                category: 'Assignments',
                rank: 0
            });
        })
            .catch(_ => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showErrorMessage)('Grader Service Unavailable', 'Could not connect to the grader service! Please contact your system administrator!'));
        command = NotebookExecuteIDs.run;
        app.commands.addCommand(command, {
            label: 'Run cell',
            execute: async () => {
                await app.commands.execute('notebook:run-cell');
            },
            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.runIcon
        });
        command = RevertCellIDs.revert;
        app.commands.addCommand(command, {
            label: 'Revert cell',
            isVisible: () => {
                if (tracker.activeCell === null) {
                    return false;
                }
                return tracker.activeCell.model.metadata.has('revert');
            },
            isEnabled: () => {
                if (tracker.activeCell === null) {
                    return false;
                }
                return tracker.activeCell.model.metadata.has('revert');
            },
            execute: () => {
                (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
                    title: "Do you want to revert the cell to it's original state?",
                    body: 'This will overwrite your current changes!',
                    buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: 'Revert' })]
                }).then(result => {
                    if (!result.button.accept) {
                        return;
                    }
                    tracker.activeCell.model.value.clear();
                    tracker.activeCell.model.value.insert(0, tracker.activeCell.model.metadata.get('revert').toString());
                });
            },
            icon: _jupyterlab_ui_components_lib_icon_iconimports__WEBPACK_IMPORTED_MODULE_13__.undoIcon
        });
        command = ShowHintIDs.show;
        app.commands.addCommand(command, {
            label: 'Show hint',
            isVisible: () => {
                if (tracker.activeCell === null) {
                    return false;
                }
                return tracker.activeCell.model.metadata.has('hint');
            },
            isEnabled: () => {
                if (tracker.activeCell === null) {
                    return false;
                }
                return tracker.activeCell.model.metadata.has('hint');
            },
            execute: () => {
                let hintWidget = null;
                tracker.activeCell.layout.widgets.map(widget => {
                    if (widget instanceof _components_notebook_student_plugin_hint_widget__WEBPACK_IMPORTED_MODULE_14__.HintWidget) {
                        hintWidget = widget;
                    }
                });
                if (hintWidget === null) {
                    tracker.activeCell.layout.addWidget(new _components_notebook_student_plugin_hint_widget__WEBPACK_IMPORTED_MODULE_14__.HintWidget(tracker.activeCell.model.metadata.get('hint').toString()));
                }
                else {
                    hintWidget.toggleShowAlert();
                    hintWidget.setHint(tracker.activeCell.model.metadata.get('hint').toString());
                    hintWidget.update();
                }
            },
            icon: _jupyterlab_ui_components_lib_icon_iconimports__WEBPACK_IMPORTED_MODULE_13__.listIcon
        });
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (extension);


/***/ }),

/***/ "./lib/model/assignment.js":
/*!*********************************!*\
  !*** ./lib/model/assignment.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Assignment": () => (/* binding */ Assignment)
/* harmony export */ });
/**
 * Grader Extension API Schemas
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var Assignment;
(function (Assignment) {
    Assignment.TypeEnum = {
        User: 'user',
        Group: 'group'
    };
    Assignment.StatusEnum = {
        Created: 'created',
        Pushed: 'pushed',
        Released: 'released',
        Complete: 'complete'
    };
    Assignment.AutomaticGradingEnum = {
        Unassisted: 'unassisted',
        Auto: 'auto',
        FullAuto: 'full_auto'
    };
})(Assignment || (Assignment = {}));


/***/ }),

/***/ "./lib/services/assignments.service.js":
/*!*********************************************!*\
  !*** ./lib/services/assignments.service.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createAssignment": () => (/* binding */ createAssignment),
/* harmony export */   "deleteAssignment": () => (/* binding */ deleteAssignment),
/* harmony export */   "fetchAssignment": () => (/* binding */ fetchAssignment),
/* harmony export */   "generateAssignment": () => (/* binding */ generateAssignment),
/* harmony export */   "getAllAssignments": () => (/* binding */ getAllAssignments),
/* harmony export */   "getAssignment": () => (/* binding */ getAssignment),
/* harmony export */   "getAssignmentProperties": () => (/* binding */ getAssignmentProperties),
/* harmony export */   "pullAssignment": () => (/* binding */ pullAssignment),
/* harmony export */   "pushAssignment": () => (/* binding */ pushAssignment),
/* harmony export */   "resetAssignment": () => (/* binding */ resetAssignment),
/* harmony export */   "updateAssignment": () => (/* binding */ updateAssignment)
/* harmony export */ });
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

function createAssignment(lectureId, assignment) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.POST, `/lectures/${lectureId}/assignments`, assignment);
}
function getAllAssignments(lectureId) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectureId}/assignments`);
}
function getAssignment(lectureId, assignmentId) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectureId}/assignments/${assignmentId}`);
}
function getAssignmentProperties(lectureId, assignmentId) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectureId}/assignments/${assignmentId}/properties`);
}
function updateAssignment(lectureId, assignment) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, `/lectures/${lectureId}/assignments/${assignment.id}`, assignment);
}
function generateAssignment(lectureId, assignment) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, `/lectures/${lectureId}/assignments/${assignment.id}/generate`);
}
function fetchAssignment(lectureId, assignmentId, instructor = false, metadataOnly = false) {
    let url = `/lectures/${lectureId}/assignments/${assignmentId}`;
    if (instructor || metadataOnly) {
        let searchParams = new URLSearchParams({
            "instructor-version": String(instructor),
            "metadata-only": String(metadataOnly)
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function deleteAssignment(lectureId, assignmentId) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.DELETE, `/lectures/${lectureId}/assignments/${assignmentId}`);
}
function pushAssignment(lectureId, assignmentId, repoType, commitMessage) {
    let url = `/lectures/${lectureId}/assignments/${assignmentId}/push/${repoType}`;
    if (commitMessage) {
        let searchParams = new URLSearchParams({
            "commit-message": commitMessage
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, url);
}
function pullAssignment(lectureId, assignmentId, repoType) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectureId}/assignments/${assignmentId}/pull/${repoType}`);
}
function resetAssignment(lecture, assignment) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignments/${assignment.id}/reset`);
}


/***/ }),

/***/ "./lib/services/datetime.service.js":
/*!******************************************!*\
  !*** ./lib/services/datetime.service.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "localToUTC": () => (/* binding */ localToUTC),
/* harmony export */   "utcToLocal": () => (/* binding */ utcToLocal),
/* harmony export */   "utcToLocalFormat": () => (/* binding */ utcToLocalFormat),
/* harmony export */   "utcToTimestamp": () => (/* binding */ utcToTimestamp)
/* harmony export */ });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

// 2021-09-03T11:57
function localToUTC(time) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default()(time).utc().format('YYYY-MM-DDTHH:mm:ss.sss') + 'Z';
}
function utcToLocal(time) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(time).local().format('YYYY-MM-DDTHH:mm:ss.sss');
}
function utcToLocalFormat(time) {
    const locale = window.navigator.language;
    const localeData = moment__WEBPACK_IMPORTED_MODULE_0___default().localeData(locale);
    const format = localeData.longDateFormat('L') + ' HH:mm:ss';
    return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(time).local().format(format);
}
function utcToTimestamp(time) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default()(time, 'YYYY-MM-DDTHH:mm:ss.sss').valueOf();
}


/***/ }),

/***/ "./lib/services/file.service.js":
/*!**************************************!*\
  !*** ./lib/services/file.service.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getFiles": () => (/* binding */ getFiles),
/* harmony export */   "getGitLog": () => (/* binding */ getGitLog),
/* harmony export */   "getRemoteStatus": () => (/* binding */ getRemoteStatus)
/* harmony export */ });
/* harmony import */ var _jupyterlab_filebrowser_lib_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/filebrowser/lib/model */ "./node_modules/@jupyterlab/filebrowser/lib/model.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../index */ "./lib/index.js");
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.



const getFiles = async (path) => {
    if (path === null)
        return [];
    const model = new _jupyterlab_filebrowser_lib_model__WEBPACK_IMPORTED_MODULE_0__.FilterFileBrowserModel({
        auto: true,
        manager: _index__WEBPACK_IMPORTED_MODULE_1__.GlobalObjects.docManager
    });
    try {
        await model.cd(path);
    }
    catch (_) {
        return [];
    }
    if (model.path !== path) {
        return [];
    }
    const items = model.items();
    const files = [];
    let f = items.next();
    while (f !== undefined) {
        files.push(f);
        f = items.next();
    }
    console.log('getting files from path ' + path);
    return files;
};
function getGitLog(lecture, assignment, repo, nCommits) {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/log/${repo}/`;
    let searchParams = new URLSearchParams({
        "n": String(nCommits)
    });
    url += '?' + searchParams;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_2__.request)(_request_service__WEBPACK_IMPORTED_MODULE_2__.HTTPMethod.GET, url);
}
function getRemoteStatus(lecture, assignment, repo) {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/remote-status/${repo}/`;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_2__.request)(_request_service__WEBPACK_IMPORTED_MODULE_2__.HTTPMethod.GET, url);
}


/***/ }),

/***/ "./lib/services/gradebook.js":
/*!***********************************!*\
  !*** ./lib/services/gradebook.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GradeBook": () => (/* binding */ GradeBook)
/* harmony export */ });
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.
class GradeBook {
    constructor(properties) {
        this.properties = properties;
    }
    getNotebooks() {
        return Object.keys(this.properties['notebooks']);
    }
    setComment(notebook, cellId, comment) {
        this.properties['notebooks'][notebook]['comments_dict'][cellId]['manual_comment'] = comment;
    }
    getComment(notebook, cellId) {
        return this.properties['notebooks'][notebook]['comments_dict'][cellId]['manual_comment'];
    }
    setManualScore(notebook, cellId, score) {
        try {
            this.properties['notebooks'][notebook]['grades_dict'][cellId]['manual_score'] = score;
        }
        catch (error) {
            this.createTaskGrade(notebook, cellId, score);
        }
    }
    createTaskGrade(notebook, cellId, score) {
        const maxScore = this.properties['notebooks'][notebook]['task_cells_dict'][cellId]['max_score'];
        const grade = {
            cell_id: cellId,
            notebook_id: notebook,
            id: cellId,
            auto_score: null,
            manual_score: score,
            extra_credit: null,
            needs_manual_grade: false,
            max_score_gradecell: null,
            max_score_taskcell: maxScore,
            failed_tests: null
        };
        this.properties['notebooks'][notebook]['grades_dict'][cellId] = grade;
    }
    getManualScore(notebook, cellId) {
        return this.properties['notebooks'][notebook]['grades_dict'][cellId]['manual_score'];
    }
    setExtraCredit(notebook, cellId, credit) {
        this.properties['notebooks'][notebook]['grades_dict'][cellId]['extra_credit'] = credit;
    }
    getExtraCredit(notebook, cellId) {
        const extraCredit = this.properties['notebooks'][notebook]['grades_dict'][cellId]['extra_credit'];
        if (extraCredit) {
            return extraCredit;
        }
        else {
            return 0.0;
        }
    }
    setNeedsManualGrading(notebook, cellId, needsGrading) {
        this.properties['notebooks'][notebook]['grades_dict'][cellId]['needs_manual_grade'] = needsGrading;
    }
    getNeedsManualGrading(notebook, cellId) {
        return this.properties['notebooks'][notebook]['grades_dict'][cellId]['needs_manual_grade'];
    }
    getNotebookGradingInfo(notebook) {
        const grades_dict = this.properties['notebooks'][notebook]['grades_dict'];
        return Object.keys(grades_dict)
            .map(v => this.getNeedsManualGrading(notebook, v))
            .reduce((r, v) => r || v, false);
    }
    getGradingInfo() {
        const map = new Map();
        for (const notebook of Object.keys(this.properties['notebooks'])) {
            map.set(notebook, this.getNotebookGradingInfo(notebook));
        }
        return map;
    }
    getGradeScore(notebook, cellId) {
        const grade = this.properties['notebooks'][notebook]['grades_dict'][cellId];
        if (grade['manual_score'] === null && grade['auto_score'] === null) {
            return 0.0;
        }
        else if (grade['manual_score'] === null) {
            return grade['auto_score'];
        }
        else if (grade['auto_score'] === null) {
            return grade['manual_score'];
        }
        else {
            return grade['manual_score'];
        }
    }
    getAutoGradeScore(notebook, cellId) {
        return this.properties['notebooks'][notebook]['grades_dict'][cellId]['auto_score'];
    }
    getGradeMaxScore(notebook, cellId) {
        const grade = this.properties['notebooks'][notebook]['grades_dict'][cellId];
        if (grade['max_score_taskcell'] !== null) {
            return grade['max_score_taskcell'];
        }
        else if (grade['max_score_gradecell'] !== null) {
            return grade['max_score_gradecell'];
        }
        else {
            return 0.0;
        }
    }
    getGradeCellMaxScore(notebook, cellId) {
        return this.properties['notebooks'][notebook]['grade_cells_dict'][cellId]['max_score'];
    }
    getNotebookPoints(notebook) {
        let sum = 0;
        const grades_dict = this.properties['notebooks'][notebook]['grades_dict'];
        for (const cellId of Object.keys(grades_dict)) {
            sum += this.getGradeScore(notebook, cellId);
        }
        return sum;
    }
    getPoints() {
        let sum = 0;
        for (const notebook of Object.keys(this.properties['notebooks'])) {
            sum += this.getNotebookPoints(notebook);
        }
        return sum;
    }
    getNotebookMaxPoints(notebook) {
        let sum = 0;
        // add task cells to grades dict if they are not there
        const task_cells_dict = this.properties['notebooks'][notebook]['task_cells_dict'];
        for (const cellId of Object.keys(task_cells_dict)) {
            if (this.properties['notebooks'][notebook]['grades_dict'][cellId] ===
                undefined) {
                console.log('Adding grade for task cell: ' + cellId);
                this.createTaskGrade(notebook, cellId, null);
            }
        }
        const grades_dict = this.properties['notebooks'][notebook]['grades_dict'];
        for (const cellId of Object.keys(grades_dict)) {
            sum += this.getGradeMaxScore(notebook, cellId);
        }
        return sum;
    }
    getNotebookMaxPointsCells(notebook) {
        let sum = 0;
        const grades_dict = this.properties['notebooks'][notebook]['grade_cells_dict'];
        for (const cellId of Object.keys(grades_dict)) {
            sum += this.getGradeCellMaxScore(notebook, cellId);
        }
        return sum;
    }
    getMaxPoints() {
        let sum = 0;
        for (const notebook of Object.keys(this.properties['notebooks'])) {
            sum += this.getNotebookMaxPoints(notebook);
        }
        return sum;
    }
    getNotebookExtraCredit(notebook) {
        let sum = 0;
        const grades_dict = this.properties['notebooks'][notebook]['grades_dict'];
        for (const cellId of Object.keys(grades_dict)) {
            sum += this.getExtraCredit(notebook, cellId);
        }
        return sum;
    }
    getExtraCredits() {
        let sum = 0;
        for (const notebook of Object.keys(this.properties['notebooks'])) {
            sum += this.getNotebookExtraCredit(notebook);
        }
        return sum;
    }
}


/***/ }),

/***/ "./lib/services/grading.service.js":
/*!*****************************************!*\
  !*** ./lib/services/grading.service.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "autogradeSubmission": () => (/* binding */ autogradeSubmission),
/* harmony export */   "createManualFeedback": () => (/* binding */ createManualFeedback),
/* harmony export */   "deleteManualFeedback": () => (/* binding */ deleteManualFeedback),
/* harmony export */   "generateFeedback": () => (/* binding */ generateFeedback),
/* harmony export */   "getGrade": () => (/* binding */ getGrade),
/* harmony export */   "getManualFeedback": () => (/* binding */ getManualFeedback),
/* harmony export */   "getStudentSubmissions": () => (/* binding */ getStudentSubmissions),
/* harmony export */   "saveSubmissions": () => (/* binding */ saveSubmissions),
/* harmony export */   "updateManualFeedback": () => (/* binding */ updateManualFeedback)
/* harmony export */ });
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

function createManualFeedback(lectid, assignid, subid) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectid}/assignments/${assignid}/grading/${subid}/manual`);
}
function saveSubmissions(lecture, assignment, filter = "none") {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/submissions/save`;
    if (filter) {
        const searchParams = new URLSearchParams({
            filter: filter
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, url);
}
function autogradeSubmission(lecture, assignment, submission) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignments/${assignment.id}/grading/${submission.id}/auto`);
}
function generateFeedback(lecture_id, assignment_id, submission_id) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture_id}/assignments/${assignment_id}/grading/${submission_id}/feedback`);
}
//response is not a schema => any
//TODO: should prob be changed
function getStudentSubmissions(lecture, assignment) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignements/${assignment.id}/grading`);
}
function getManualFeedback(lecture, assignment, student) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignments/${assignment.id}/grading/${student.name}/manual`);
}
function updateManualFeedback(lecture, assignment, student, manual) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, `/lectures/${lecture.id}/assignements/${assignment.id}/grading/${student.name}/manual`, manual);
}
function deleteManualFeedback(lecture, assignment, student, manual) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.DELETE, `/lectures/${lecture.id}/assignments/${assignment.id}/grading/${student.name}/manual`, manual);
}
function getGrade(lecture, assignment, student) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignments/${assignment.id}/grading/${student.name}/score`);
}


/***/ }),

/***/ "./lib/services/lectures.service.js":
/*!******************************************!*\
  !*** ./lib/services/lectures.service.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createLecture": () => (/* binding */ createLecture),
/* harmony export */   "deleteLecture": () => (/* binding */ deleteLecture),
/* harmony export */   "getAllLectures": () => (/* binding */ getAllLectures),
/* harmony export */   "getLecture": () => (/* binding */ getLecture),
/* harmony export */   "getUsers": () => (/* binding */ getUsers),
/* harmony export */   "updateLecture": () => (/* binding */ updateLecture)
/* harmony export */ });
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

function createLecture(lecture) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.POST, '/lectures', lecture);
}
function getAllLectures(complete = false) {
    let url = '/lectures';
    if (complete) {
        let searchParams = new URLSearchParams({
            "complete": String(complete)
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function updateLecture(lecture) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, `/lectures/${lecture.id}`, lecture);
}
function getLecture(lectureId) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lectureId}`);
}
function deleteLecture(lectureId) {
    (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.DELETE, `/lectures/${lectureId}`);
}
//TODO: create Datapackage model to replace any
function getUsers(lecture) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/users`);
}


/***/ }),

/***/ "./lib/services/permission.service.js":
/*!********************************************!*\
  !*** ./lib/services/permission.service.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Scope": () => (/* binding */ Scope),
/* harmony export */   "UserPermissions": () => (/* binding */ UserPermissions)
/* harmony export */ });
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

var Scope;
(function (Scope) {
    Scope[Scope["student"] = 0] = "student";
    Scope[Scope["tutor"] = 1] = "tutor";
    Scope[Scope["instructor"] = 2] = "instructor";
    Scope[Scope["admin"] = 3] = "admin";
})(Scope || (Scope = {}));
var UserPermissions;
(function (UserPermissions) {
    let permissions = null;
    async function loadPermissions() {
        permissions = {};
        let response = await (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, '/permissions');
        response.forEach(role => {
            permissions[role.lecture_code] = role.scope;
        });
    }
    UserPermissions.loadPermissions = loadPermissions;
    function getPermissions() {
        return permissions;
    }
    UserPermissions.getPermissions = getPermissions;
    function getScope(lecture) {
        if (permissions === null) {
            return null;
        }
        return permissions[lecture.code];
    }
    UserPermissions.getScope = getScope;
})(UserPermissions || (UserPermissions = {}));


/***/ }),

/***/ "./lib/services/request.service.js":
/*!*****************************************!*\
  !*** ./lib/services/request.service.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HTTPMethod": () => (/* binding */ HTTPMethod),
/* harmony export */   "request": () => (/* binding */ request)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "webpack/sharing/consume/default/rxjs/rxjs");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/dist/esm5/internal/operators/switchMap.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




var HTTPMethod;
(function (HTTPMethod) {
    HTTPMethod["GET"] = "GET";
    HTTPMethod["POST"] = "POST";
    HTTPMethod["PUT"] = "PUT";
    HTTPMethod["DELETE"] = "DELETE";
})(HTTPMethod || (HTTPMethod = {}));
function request(method, endPoint, body = null, headers = null) {
    const options = {};
    options.method = method;
    if (body) {
        options.body = JSON.stringify(body);
    }
    if (headers) {
        options.headers = headers;
    }
    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
    let requestUrl = '';
    // ServerConnection only allows requests to notebook baseUrl
    requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(settings.baseUrl, '/grader_labextension', // API Namespace
    endPoint);
    return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, options, settings).then(async (response) => {
        if (!response.ok) {
            throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response, response.statusText);
        }
        let data = await response.text();
        if (data.length > 0) {
            try {
                data = JSON.parse(data);
            }
            catch (error) {
                console.log('Not a JSON response body.', response);
            }
        }
        console.log('Request ' + method.toString() + ' URL: ' + requestUrl);
        console.log(data);
        return data;
    });
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.lastValueFrom)((0,rxjs__WEBPACK_IMPORTED_MODULE_2__.from)(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(requestUrl, options, settings)).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.switchMap)(async (response) => {
        if (!response.ok) {
            throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response, await response.text());
        }
        let data = await response.text();
        if (data.length > 0) {
            try {
                data = JSON.parse(data);
            }
            catch (error) {
                console.log('Not a JSON response body.', response);
            }
        }
        console.log('Request ' + method.toString() + ' URL: ' + requestUrl);
        console.log(data);
        return data;
    })));
}


/***/ }),

/***/ "./lib/services/storage.service.js":
/*!*****************************************!*\
  !*** ./lib/services/storage.service.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "deleteKey": () => (/* binding */ deleteKey),
/* harmony export */   "loadBoolean": () => (/* binding */ loadBoolean),
/* harmony export */   "loadNumber": () => (/* binding */ loadNumber),
/* harmony export */   "loadObject": () => (/* binding */ loadObject),
/* harmony export */   "loadString": () => (/* binding */ loadString),
/* harmony export */   "storeBoolean": () => (/* binding */ storeBoolean),
/* harmony export */   "storeNumber": () => (/* binding */ storeNumber),
/* harmony export */   "storeObject": () => (/* binding */ storeObject),
/* harmony export */   "storeString": () => (/* binding */ storeString)
/* harmony export */ });
function getKey(key, lecture, assignment) {
    if (lecture) {
        key = key + `-l${lecture.id}`;
    }
    if (assignment) {
        key = key + `-a${assignment.id}`;
    }
    return "grader:" + key;
}
function deleteKey(key) {
    key = getKey(key);
    localStorage.removeItem(key);
}
function storeString(key, value, lecture, assignment) {
    key = getKey(key, lecture, assignment);
    localStorage.setItem(key, value);
}
function loadString(key, lecture, assignment) {
    key = getKey(key, lecture, assignment);
    return localStorage.getItem(key);
}
function storeBoolean(key, value, lecture, assignment) {
    storeString(key, String(value), lecture, assignment);
}
function loadBoolean(key, lecture, assignment) {
    const v = loadString(key, lecture, assignment);
    if (v === null) {
        return null;
    }
    else {
        return v === "true";
    }
}
function storeNumber(key, value, lecture, assignment) {
    storeString(key, String(value), lecture, assignment);
}
function loadNumber(key, lecture, assignment) {
    const v = loadString(key, lecture, assignment);
    if (v === null) {
        return null;
    }
    else {
        return +v;
    }
}
function storeObject(key, value, lecture, assignment) {
    storeString(key, JSON.stringify(value), lecture, assignment);
}
function loadObject(key, lecture, assignment) {
    return JSON.parse(loadString(key, lecture, assignment));
}


/***/ }),

/***/ "./lib/services/submissions.service.js":
/*!*********************************************!*\
  !*** ./lib/services/submissions.service.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getAllSubmissions": () => (/* binding */ getAllSubmissions),
/* harmony export */   "getFeedback": () => (/* binding */ getFeedback),
/* harmony export */   "getProperties": () => (/* binding */ getProperties),
/* harmony export */   "getSubmission": () => (/* binding */ getSubmission),
/* harmony export */   "getSubmissions": () => (/* binding */ getSubmissions),
/* harmony export */   "pullFeedback": () => (/* binding */ pullFeedback),
/* harmony export */   "submitAssignment": () => (/* binding */ submitAssignment),
/* harmony export */   "updateProperties": () => (/* binding */ updateProperties),
/* harmony export */   "updateSubmission": () => (/* binding */ updateSubmission)
/* harmony export */ });
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./request.service */ "./lib/services/request.service.js");
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

function submitAssignment(lecture, assignment, submit = false) {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/push/assignment`;
    if (submit) {
        const searchParams = new URLSearchParams({
            submit: String(submit)
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, url);
}
async function pullFeedback(lecture, assignment, submission) {
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, `/lectures/${lecture.id}/assignments/${assignment.id}/grading/${submission.id}/pull/feedback`);
}
function getSubmissions(lecture, assignment, filter = 'none') {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/submissions`;
    if (filter) {
        const searchParams = new URLSearchParams({
            filter: filter
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function getAllSubmissions(lecture, assignment, filter = 'none', instructor = true) {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/submissions`;
    if (filter || instructor) {
        const searchParams = new URLSearchParams({
            'instructor-version': String(instructor),
            filter: filter
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function getFeedback(lecture, assignment, latest = false, instructor = false) {
    let url = `/lectures/${lecture.id}/assignments/${assignment.id}/feedback`;
    if (latest || instructor) {
        const searchParams = new URLSearchParams({
            'instructor-version': String(instructor),
            latest: String(latest)
        });
        url += '?' + searchParams;
    }
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function getProperties(lectureId, assignmentId, submissionId) {
    const url = `/lectures/${lectureId}/assignments/${assignmentId}/submissions/${submissionId}/properties`;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function updateProperties(lectureId, assignmentId, submissionId, properties) {
    const url = `/lectures/${lectureId}/assignments/${assignmentId}/submissions/${submissionId}/properties`;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, url, properties);
}
function getSubmission(lectureId, assignmentId, submissionId) {
    const url = `/lectures/${lectureId}/assignments/${assignmentId}/submissions/${submissionId}`;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.GET, url);
}
function updateSubmission(lectureId, assignmentId, submissionId, sub) {
    const url = `/lectures/${lectureId}/assignments/${assignmentId}/submissions/${submissionId}`;
    return (0,_request_service__WEBPACK_IMPORTED_MODULE_0__.request)(_request_service__WEBPACK_IMPORTED_MODULE_0__.HTTPMethod.PUT, url, sub);
}


/***/ }),

/***/ "./lib/widgets/assignment-list.js":
/*!****************************************!*\
  !*** ./lib/widgets/assignment-list.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AssignmentList": () => (/* binding */ AssignmentList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_assignment_lecture_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/assignment/lecture-list */ "./lib/components/assignment/lecture-list.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




class AssignmentList extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    /**
     * Construct a new assignment list widget
     */
    constructor(options = {}) {
        super();
        this.id = options.id;
        this.addClass('GradingWidget');
    }
    render() {
        const root = this.node;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(notistack__WEBPACK_IMPORTED_MODULE_2__.SnackbarProvider, { maxSnack: 3 },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_assignment_lecture_list__WEBPACK_IMPORTED_MODULE_3__.LectureListComponent, { root: root })));
    }
}


/***/ }),

/***/ "./lib/widgets/coursemanage.js":
/*!*************************************!*\
  !*** ./lib/widgets/coursemanage.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CourseManageView": () => (/* binding */ CourseManageView)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_coursemanage_coursemanage_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/coursemanage/coursemanage.component */ "./lib/components/coursemanage/coursemanage.component.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) 2022, TU Wien
// All rights reserved.
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.




class CourseManageView extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {
    /**
     * Construct a new grading widget
     */
    constructor(options = {}) {
        super();
        this.id = options.id;
        this.addClass('GradingWidget');
    }
    render() {
        const root = this.node;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(notistack__WEBPACK_IMPORTED_MODULE_2__.SnackbarProvider, { maxSnack: 3 },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_coursemanage_coursemanage_component__WEBPACK_IMPORTED_MODULE_3__.CourseManageComponent, { root: root })));
    }
}


/***/ })

}]);
//# sourceMappingURL=lib_index_js-webpack_sharing_consume_default_jupyterlab_translation-webpack_sharing_consume_d-756503.bd64c67ec908db8ae22f.js.map