from reportlab.lib import pagesizes as ps
from reportlab.lib.colors import Color

_COLORS = {
    None: (0, 0, 0),  # default  -> black
    'black': (0, 0, 0),
}

_PAGES = {
    'A0': (2383.937007874016, 3370.393700787402),
    'A1': (1683.7795275590554, 2383.937007874016),
    'A10': (73.70078740157481, 104.88188976377954),
    'A2': (1190.5511811023623, 1683.7795275590554),
    'A3': (841.8897637795277, 1190.5511811023623),
    'A4': (595.2755905511812, 841.8897637795277),
    'A5': (419.52755905511816, 595.2755905511812),
    'A6': (297.6377952755906, 419.52755905511816),
    'A7': (209.76377952755908, 297.6377952755906),
    'A8': (147.40157480314963, 209.76377952755908),
    'A9': (104.88188976377954, 147.40157480314963),
    'B0': (2834.645669291339, 4008.188976377953),
    'B1': (2004.0944881889766, 2834.645669291339),
    'B10': (87.87401574803151, 124.7244094488189),
    'B2': (1417.3228346456694, 2004.0944881889766),
    'B3': (1000.6299212598426, 1417.3228346456694),
    'B4': (708.6614173228347, 1000.6299212598426),
    'B5': (498.8976377952756, 708.6614173228347),
    'B6': (354.33070866141736, 498.8976377952756),
    'B7': (249.4488188976378, 354.33070866141736),
    'B8': (175.74803149606302, 249.4488188976378),
    'B9': (124.7244094488189, 175.74803149606302),
    'C0': (2599.3700787401576, 3676.5354330708665),
    'C1': (1836.8503937007877, 2599.3700787401576),
    'C10': (79.37007874015748, 113.38582677165356),
    'C2': (1298.2677165354332, 1836.8503937007877),
    'C3': (918.4251968503938, 1298.2677165354332),
    'C4': (649.1338582677166, 918.4251968503938),
    'C5': (459.2125984251969, 649.1338582677166),
    'C6': (323.1496062992126, 459.2125984251969),
    'C7': (229.60629921259846, 323.1496062992126),
    'C8': (161.5748031496063, 229.60629921259846),
    'C9': (113.38582677165356, 161.5748031496063),
    'ELEVENSEVENTEEN': (792.0, 1224.0),
    'GOV_LEGAL': (612.0, 936.0),
    'GOV_LETTER': (576.0, 756.0),
    'HALF_LETTER': (396.0, 576.0),
    'JUNIOR_LEGAL': (360.0, 576.0),
    'LEDGER': (1224.0, 792.0),
    'LEGAL': (612.0, 1008.0),
    'LETTER': (612.0, 792.0),
    'TABLOID': (792.0, 1224.0),
    'legal': (612.0, 1008.0),
    'letter': (612.0, 792.0),
}

_FONTS = ['Helvetica']

_ROTATION = {
    1: 60,
    2: ''
}


def get_font(name):
    assert name in _FONTS, f'Font: "{name}" is not supported yet, pick from: {_FONTS}'
    return name


def get_color(color, transparency=0):
    return Color(*_COLORS[color], alpha=(1 - (transparency / 100)))


def get_page(size):
    page_size = _PAGES['A4']
    if isinstance(size, list):
        assert len(size) == 2, f'Invalid page size: {size}, should be a list with two ' \
                               f'integer values. Exmaple --> [600, 800]'
        page_size = size

    if isinstance(size, str):
        supported = list(_PAGES.keys())
        assert size in supported, f'Invalid page size: {size}, pick from: {supported}'
        page_size = _PAGES[size]
    return page_size


def get_rotation(orientation):
    return _ROTATION[orientation]
