// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#ifndef games_h__
#define games_h__

#include "frotz_interface.h"


zword* default_ram_addrs                (int*);
char** default_intro_actions            (int*);
int   default_victory                   (void);
char* default_clean_observation         (char*);
int   default_game_over                 (void);
int   default_get_num_world_objs        (void);
int   default_get_self_object_num       (void);
int   default_get_moves                 (void);
short default_get_score                 (void);
int   default_max_score                 (void);
int   default_ignore_moved_obj          (zword obj_num, zword dest_num);
int   default_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   default_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  default_clean_world_objs          (zobject* objs);

zword* acorn_ram_addrs                  (int*);
char** acorn_intro_actions              (int*);
int   acorn_victory                     (void);
char* acorn_clean_observation           (char*);
int   acorn_game_over                   (void);
int   acorn_get_num_world_objs          (void);
int   acorn_get_self_object_num         (void);
int   acorn_get_moves                   (void);
short acorn_get_score                   (void);
int   acorn_max_score                   (void);
int   acorn_ignore_moved_obj            (zword obj_num, zword dest_num);
int   acorn_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   acorn_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  acorn_clean_world_objs            (zobject* objs);

zword* adventureland_ram_addrs          (int*);
char** adventureland_intro_actions      (int*);
int   adventureland_victory             (void);
char* adventureland_clean_observation   (char*);
int   adventureland_game_over           (void);
int   adventureland_get_num_world_objs  (void);
int   adventureland_get_self_object_num (void);
int   adventureland_get_moves           (void);
short adventureland_get_score           (void);
int   adventureland_max_score           (void);
int   adventureland_ignore_moved_obj    (zword obj_num, zword dest_num);
int   adventureland_ignore_attr_diff    (zword obj_num, zword attr_idx);
int   adventureland_ignore_attr_clr     (zword obj_num, zword attr_idx);
void  adventureland_clean_world_objs    (zobject* objs);

zword* advent_ram_addrs                 (int*);
char** advent_intro_actions             (int*);
int   advent_victory                    (void);
char* advent_clean_observation          (char*);
int   advent_game_over                  (void);
int   advent_get_num_world_objs         (void);
int   advent_get_self_object_num        (void);
int   advent_get_moves                  (void);
short advent_get_score                  (void);
int   advent_max_score                  (void);
int   advent_ignore_moved_obj           (zword obj_num, zword dest_num);
int   advent_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   advent_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  advent_clean_world_objs           (zobject* objs);

zword* afflicted_ram_addrs              (int*);
char** afflicted_intro_actions          (int*);
int   afflicted_victory                 (void);
char* afflicted_clean_observation       (char*);
int   afflicted_game_over               (void);
int   afflicted_get_num_world_objs      (void);
int   afflicted_get_self_object_num     (void);
int   afflicted_get_moves               (void);
short afflicted_get_score               (void);
int   afflicted_max_score               (void);
int   afflicted_ignore_moved_obj        (zword obj_num, zword dest_num);
int   afflicted_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   afflicted_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  afflicted_clean_world_objs        (zobject* objs);

zword* anchor_ram_addrs                 (int*);
char** anchor_intro_actions             (int*);
int   anchor_victory                    (void);
char* anchor_clean_observation          (char*);
int   anchor_game_over                  (void);
int   anchor_get_num_world_objs         (void);
int   anchor_get_self_object_num        (void);
int   anchor_get_moves                  (void);
short anchor_get_score                  (void);
int   anchor_max_score                  (void);
int   anchor_ignore_moved_obj           (zword obj_num, zword dest_num);
int   anchor_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   anchor_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  anchor_clean_world_objs           (zobject* objs);

zword* awaken_ram_addrs                 (int*);
char** awaken_intro_actions             (int*);
int   awaken_victory                    (void);
char* awaken_clean_observation          (char*);
int   awaken_game_over                  (void);
int   awaken_get_num_world_objs         (void);
int   awaken_get_self_object_num        (void);
int   awaken_get_moves                  (void);
short awaken_get_score                  (void);
int   awaken_max_score                  (void);
int   awaken_ignore_moved_obj           (zword obj_num, zword dest_num);
int   awaken_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   awaken_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  awaken_clean_world_objs           (zobject* objs);

zword* balances_ram_addrs               (int*);
char** balances_intro_actions           (int*);
int   balances_victory                  (void);
char* balances_clean_observation        (char*);
int   balances_game_over                (void);
int   balances_get_num_world_objs       (void);
int   balances_get_self_object_num      (void);
int   balances_get_moves                (void);
short balances_get_score                (void);
int   balances_max_score                (void);
int   balances_ignore_moved_obj         (zword obj_num, zword dest_num);
int   balances_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   balances_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  balances_clean_world_objs         (zobject* objs);

zword* ballyhoo_ram_addrs               (int*);
char** ballyhoo_intro_actions           (int*);
int   ballyhoo_victory                  (void);
char* ballyhoo_clean_observation        (char*);
int   ballyhoo_game_over                (void);
int   ballyhoo_get_num_world_objs       (void);
int   ballyhoo_get_self_object_num      (void);
int   ballyhoo_get_moves                (void);
short ballyhoo_get_score                (void);
int   ballyhoo_max_score                (void);
int   ballyhoo_ignore_moved_obj         (zword obj_num, zword dest_num);
int   ballyhoo_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   ballyhoo_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  ballyhoo_clean_world_objs         (zobject* objs);

zword* curses_ram_addrs                 (int*);
char** curses_intro_actions             (int*);
int   curses_victory                    (void);
char* curses_clean_observation          (char*);
int   curses_game_over                  (void);
int   curses_get_num_world_objs         (void);
int   curses_get_self_object_num        (void);
int   curses_get_moves                  (void);
short curses_get_score                  (void);
int   curses_max_score                  (void);
int   curses_ignore_moved_obj           (zword obj_num, zword dest_num);
int   curses_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   curses_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  curses_clean_world_objs           (zobject* objs);

zword* cutthroat_ram_addrs              (int*);
char** cutthroat_intro_actions          (int*);
int   cutthroat_victory                 (void);
char* cutthroat_clean_observation       (char*);
int   cutthroat_game_over               (void);
int   cutthroat_get_num_world_objs      (void);
int   cutthroat_get_self_object_num     (void);
int   cutthroat_get_moves               (void);
short cutthroat_get_score               (void);
int   cutthroat_max_score               (void);
int   cutthroat_ignore_moved_obj        (zword obj_num, zword dest_num);
int   cutthroat_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   cutthroat_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  cutthroat_clean_world_objs        (zobject* objs);

zword* deephome_ram_addrs               (int*);
char** deephome_intro_actions           (int*);
int   deephome_victory                  (void);
char* deephome_clean_observation        (char*);
int   deephome_game_over                (void);
int   deephome_get_num_world_objs       (void);
int   deephome_get_self_object_num      (void);
int   deephome_get_moves                (void);
short deephome_get_score                (void);
int   deephome_max_score                (void);
int   deephome_ignore_moved_obj         (zword obj_num, zword dest_num);
int   deephome_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   deephome_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  deephome_clean_world_objs         (zobject* objs);

zword* detective_ram_addrs              (int*);
char** detective_intro_actions          (int*);
int   detective_victory                 (void);
char* detective_clean_observation       (char*);
int   detective_game_over               (void);
int   detective_get_num_world_objs      (void);
int   detective_get_self_object_num     (void);
int   detective_get_moves               (void);
short detective_get_score               (void);
int   detective_max_score               (void);
int   detective_ignore_moved_obj        (zword obj_num, zword dest_num);
int   detective_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   detective_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  detective_clean_world_objs        (zobject* objs);

zword* dragon_ram_addrs                 (int*);
char** dragon_intro_actions             (int*);
int   dragon_victory                    (void);
char* dragon_clean_observation          (char*);
int   dragon_game_over                  (void);
int   dragon_get_num_world_objs         (void);
int   dragon_get_self_object_num        (void);
int   dragon_get_moves                  (void);
short dragon_get_score                  (void);
int   dragon_max_score                  (void);
int   dragon_ignore_moved_obj           (zword obj_num, zword dest_num);
int   dragon_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   dragon_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  dragon_clean_world_objs           (zobject* objs);

zword* enchanter_ram_addrs              (int*);
char** enchanter_intro_actions          (int*);
int   enchanter_victory                 (void);
char* enchanter_clean_observation       (char*);
int   enchanter_game_over               (void);
int   enchanter_get_num_world_objs      (void);
int   enchanter_get_self_object_num     (void);
int   enchanter_get_moves               (void);
short enchanter_get_score               (void);
int   enchanter_max_score               (void);
int   enchanter_ignore_moved_obj        (zword obj_num, zword dest_num);
int   enchanter_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   enchanter_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  enchanter_clean_world_objs        (zobject* objs);

zword* enter_ram_addrs                  (int*);
char** enter_intro_actions              (int*);
int   enter_victory                     (void);
char* enter_clean_observation           (char*);
int   enter_game_over                   (void);
int   enter_get_num_world_objs          (void);
int   enter_get_self_object_num         (void);
int   enter_get_moves                   (void);
short enter_get_score                   (void);
int   enter_max_score                   (void);
int   enter_ignore_moved_obj            (zword obj_num, zword dest_num);
int   enter_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   enter_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  enter_clean_world_objs            (zobject* objs);

zword* gold_ram_addrs                   (int*);
char** gold_intro_actions               (int*);
int   gold_victory                      (void);
char* gold_clean_observation            (char*);
int   gold_game_over                    (void);
int   gold_get_num_world_objs           (void);
int   gold_get_self_object_num          (void);
int   gold_get_moves                    (void);
short gold_get_score                    (void);
int   gold_max_score                    (void);
int   gold_ignore_moved_obj             (zword obj_num, zword dest_num);
int   gold_ignore_attr_diff             (zword obj_num, zword attr_idx);
int   gold_ignore_attr_clr              (zword obj_num, zword attr_idx);
void  gold_clean_world_objs             (zobject* objs);

zword* hhgg_ram_addrs                   (int*);
char** hhgg_intro_actions               (int*);
int   hhgg_victory                      (void);
char* hhgg_clean_observation            (char*);
int   hhgg_game_over                    (void);
int   hhgg_get_num_world_objs           (void);
int   hhgg_get_self_object_num          (void);
int   hhgg_get_moves                    (void);
short hhgg_get_score                    (void);
int   hhgg_max_score                    (void);
int   hhgg_ignore_moved_obj             (zword obj_num, zword dest_num);
int   hhgg_ignore_attr_diff             (zword obj_num, zword attr_idx);
int   hhgg_ignore_attr_clr              (zword obj_num, zword attr_idx);
void  hhgg_clean_world_objs             (zobject* objs);

zword* hollywood_ram_addrs              (int*);
char** hollywood_intro_actions          (int*);
int   hollywood_victory                 (void);
char* hollywood_clean_observation       (char*);
int   hollywood_game_over               (void);
int   hollywood_get_num_world_objs      (void);
int   hollywood_get_self_object_num     (void);
int   hollywood_get_moves               (void);
short hollywood_get_score               (void);
int   hollywood_max_score               (void);
int   hollywood_ignore_moved_obj        (zword obj_num, zword dest_num);
int   hollywood_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   hollywood_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  hollywood_clean_world_objs        (zobject* objs);

zword* huntdark_ram_addrs               (int*);
char** huntdark_intro_actions           (int*);
int   huntdark_victory                  (void);
char* huntdark_clean_observation        (char*);
int   huntdark_game_over                (void);
int   huntdark_get_num_world_objs       (void);
int   huntdark_get_self_object_num      (void);
int   huntdark_get_moves                (void);
short huntdark_get_score                (void);
int   huntdark_max_score                (void);
int   huntdark_ignore_moved_obj         (zword obj_num, zword dest_num);
int   huntdark_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   huntdark_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  huntdark_clean_world_objs         (zobject* objs);

zword* infidel_ram_addrs                (int*);
char** infidel_intro_actions            (int*);
int   infidel_victory                   (void);
char* infidel_clean_observation         (char*);
int   infidel_game_over                 (void);
int   infidel_get_num_world_objs        (void);
int   infidel_get_self_object_num       (void);
int   infidel_get_moves                 (void);
short infidel_get_score                 (void);
int   infidel_max_score                 (void);
int   infidel_ignore_moved_obj          (zword obj_num, zword dest_num);
int   infidel_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   infidel_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  infidel_clean_world_objs          (zobject* objs);

zword* inhumane_ram_addrs               (int*);
char** inhumane_intro_actions           (int*);
int   inhumane_victory                  (void);
char* inhumane_clean_observation        (char*);
int   inhumane_game_over                (void);
int   inhumane_get_num_world_objs       (void);
int   inhumane_get_self_object_num      (void);
int   inhumane_get_moves                (void);
short inhumane_get_score                (void);
int   inhumane_max_score                (void);
int   inhumane_ignore_moved_obj         (zword obj_num, zword dest_num);
int   inhumane_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   inhumane_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  inhumane_clean_world_objs         (zobject* objs);

zword* jewel_ram_addrs                  (int*);
char** jewel_intro_actions              (int*);
int   jewel_victory                     (void);
char* jewel_clean_observation           (char*);
int   jewel_game_over                   (void);
int   jewel_get_num_world_objs          (void);
int   jewel_get_self_object_num         (void);
int   jewel_get_moves                   (void);
short jewel_get_score                   (void);
int   jewel_max_score                   (void);
int   jewel_ignore_moved_obj            (zword obj_num, zword dest_num);
int   jewel_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   jewel_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  jewel_clean_world_objs            (zobject* objs);

zword* karn_ram_addrs                   (int*);
char** karn_intro_actions               (int*);
int   karn_victory                      (void);
char* karn_clean_observation            (char*);
int   karn_game_over                    (void);
int   karn_get_num_world_objs           (void);
int   karn_get_self_object_num          (void);
int   karn_get_moves                    (void);
short karn_get_score                    (void);
int   karn_max_score                    (void);
int   karn_ignore_moved_obj             (zword obj_num, zword dest_num);
int   karn_ignore_attr_diff             (zword obj_num, zword attr_idx);
int   karn_ignore_attr_clr              (zword obj_num, zword attr_idx);
void  karn_clean_world_objs             (zobject* objs);

zword* library_ram_addrs                (int*);
char** library_intro_actions            (int*);
int   library_victory                   (void);
char* library_clean_observation         (char*);
int   library_game_over                 (void);
int   library_get_num_world_objs        (void);
int   library_get_self_object_num       (void);
int   library_get_moves                 (void);
short library_get_score                 (void);
int   library_max_score                 (void);
int   library_ignore_moved_obj          (zword obj_num, zword dest_num);
int   library_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   library_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  library_clean_world_objs          (zobject* objs);

zword* loose_ram_addrs                  (int*);
char** loose_intro_actions              (int*);
int   loose_victory                     (void);
char* loose_clean_observation           (char*);
int   loose_game_over                   (void);
int   loose_get_num_world_objs          (void);
int   loose_get_self_object_num         (void);
int   loose_get_moves                   (void);
short loose_get_score                   (void);
int   loose_max_score                   (void);
int   loose_ignore_moved_obj            (zword obj_num, zword dest_num);
int   loose_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   loose_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  loose_clean_world_objs            (zobject* objs);

zword* lostpig_ram_addrs                (int*);
char** lostpig_intro_actions            (int*);
int   lostpig_victory                   (void);
char* lostpig_clean_observation         (char*);
int   lostpig_game_over                 (void);
int   lostpig_get_num_world_objs        (void);
int   lostpig_get_self_object_num       (void);
int   lostpig_get_moves                 (void);
short lostpig_get_score                 (void);
int   lostpig_max_score                 (void);
int   lostpig_ignore_moved_obj          (zword obj_num, zword dest_num);
int   lostpig_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   lostpig_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  lostpig_clean_world_objs          (zobject* objs);

zword* ludicorp_ram_addrs               (int*);
char** ludicorp_intro_actions           (int*);
int   ludicorp_victory                  (void);
char* ludicorp_clean_observation        (char*);
int   ludicorp_game_over                (void);
int   ludicorp_get_num_world_objs       (void);
int   ludicorp_get_self_object_num      (void);
int   ludicorp_get_moves                (void);
short ludicorp_get_score                (void);
int   ludicorp_max_score                (void);
int   ludicorp_ignore_moved_obj         (zword obj_num, zword dest_num);
int   ludicorp_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   ludicorp_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  ludicorp_clean_world_objs         (zobject* objs);

zword* lurking_ram_addrs                (int*);
char** lurking_intro_actions            (int*);
int   lurking_victory                   (void);
char* lurking_clean_observation         (char*);
int   lurking_game_over                 (void);
int   lurking_get_num_world_objs        (void);
int   lurking_get_self_object_num       (void);
int   lurking_get_moves                 (void);
short lurking_get_score                 (void);
int   lurking_max_score                 (void);
int   lurking_ignore_moved_obj          (zword obj_num, zword dest_num);
int   lurking_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   lurking_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  lurking_clean_world_objs          (zobject* objs);

zword* moonlit_ram_addrs                (int*);
char** moonlit_intro_actions            (int*);
int   moonlit_victory                   (void);
char* moonlit_clean_observation         (char*);
int   moonlit_game_over                 (void);
int   moonlit_get_num_world_objs        (void);
int   moonlit_get_self_object_num       (void);
int   moonlit_get_moves                 (void);
short moonlit_get_score                 (void);
int   moonlit_max_score                 (void);
int   moonlit_ignore_moved_obj          (zword obj_num, zword dest_num);
int   moonlit_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   moonlit_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  moonlit_clean_world_objs          (zobject* objs);

zword* murdac_ram_addrs                 (int*);
char** murdac_intro_actions             (int*);
int   murdac_victory                    (void);
char* murdac_clean_observation          (char*);
int   murdac_game_over                  (void);
int   murdac_get_num_world_objs         (void);
int   murdac_get_self_object_num        (void);
int   murdac_get_moves                  (void);
short murdac_get_score                  (void);
int   murdac_max_score                  (void);
int   murdac_ignore_moved_obj           (zword obj_num, zword dest_num);
int   murdac_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   murdac_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  murdac_clean_world_objs           (zobject* objs);

zword* night_ram_addrs                  (int*);
char** night_intro_actions              (int*);
int   night_victory                     (void);
char* night_clean_observation           (char*);
int   night_game_over                   (void);
int   night_get_num_world_objs          (void);
int   night_get_self_object_num         (void);
int   night_get_moves                   (void);
short night_get_score                   (void);
int   night_max_score                   (void);
int   night_ignore_moved_obj            (zword obj_num, zword dest_num);
int   night_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   night_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  night_clean_world_objs            (zobject* objs);

zword* nine05_ram_addrs                 (int*);
char** nine05_intro_actions             (int*);
int   nine05_victory                    (void);
char* nine05_clean_observation          (char*);
int   nine05_game_over                  (void);
int   nine05_get_num_world_objs         (void);
int   nine05_get_self_object_num        (void);
int   nine05_get_moves                  (void);
short nine05_get_score                  (void);
int   nine05_max_score                  (void);
int   nine05_ignore_moved_obj           (zword obj_num, zword dest_num);
int   nine05_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   nine05_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  nine05_clean_world_objs           (zobject* objs);

zword* omniquest_ram_addrs              (int*);
char** omniquest_intro_actions          (int*);
int   omniquest_victory                 (void);
char* omniquest_clean_observation       (char*);
int   omniquest_game_over               (void);
int   omniquest_get_num_world_objs      (void);
int   omniquest_get_self_object_num     (void);
int   omniquest_get_moves               (void);
short omniquest_get_score               (void);
int   omniquest_max_score               (void);
int   omniquest_ignore_moved_obj        (zword obj_num, zword dest_num);
int   omniquest_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   omniquest_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  omniquest_clean_world_objs        (zobject* objs);

zword* partyfoul_ram_addrs              (int*);
char** partyfoul_intro_actions          (int*);
int   partyfoul_victory                 (void);
char* partyfoul_clean_observation       (char*);
int   partyfoul_game_over               (void);
int   partyfoul_get_num_world_objs      (void);
int   partyfoul_get_self_object_num     (void);
int   partyfoul_get_moves               (void);
short partyfoul_get_score               (void);
int   partyfoul_max_score               (void);
int   partyfoul_ignore_moved_obj        (zword obj_num, zword dest_num);
int   partyfoul_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   partyfoul_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  partyfoul_clean_world_objs        (zobject* objs);

zword* pentari_ram_addrs                (int*);
char** pentari_intro_actions            (int*);
int   pentari_victory                   (void);
char* pentari_clean_observation         (char*);
int   pentari_game_over                 (void);
int   pentari_get_num_world_objs        (void);
int   pentari_get_self_object_num       (void);
int   pentari_get_moves                 (void);
short pentari_get_score                 (void);
int   pentari_max_score                 (void);
int   pentari_ignore_moved_obj          (zword obj_num, zword dest_num);
int   pentari_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   pentari_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  pentari_clean_world_objs          (zobject* objs);

zword* planetfall_ram_addrs             (int*);
char** planetfall_intro_actions         (int*);
int   planetfall_victory                (void);
char* planetfall_clean_observation      (char*);
int   planetfall_game_over              (void);
int   planetfall_get_num_world_objs     (void);
int   planetfall_get_self_object_num    (void);
int   planetfall_get_moves              (void);
short planetfall_get_score              (void);
int   planetfall_max_score              (void);
int   planetfall_ignore_moved_obj       (zword obj_num, zword dest_num);
int   planetfall_ignore_attr_diff       (zword obj_num, zword attr_idx);
int   planetfall_ignore_attr_clr        (zword obj_num, zword attr_idx);
void  planetfall_clean_world_objs       (zobject* objs);

zword* plundered_ram_addrs              (int*);
char** plundered_intro_actions          (int*);
int   plundered_victory                 (void);
char* plundered_clean_observation       (char*);
int   plundered_game_over               (void);
int   plundered_get_num_world_objs      (void);
int   plundered_get_self_object_num     (void);
int   plundered_get_moves               (void);
short plundered_get_score               (void);
int   plundered_max_score               (void);
int   plundered_ignore_moved_obj        (zword obj_num, zword dest_num);
int   plundered_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   plundered_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  plundered_clean_world_objs        (zobject* objs);

zword* reverb_ram_addrs                 (int*);
char** reverb_intro_actions             (int*);
int   reverb_victory                    (void);
char* reverb_clean_observation          (char*);
int   reverb_game_over                  (void);
int   reverb_get_num_world_objs         (void);
int   reverb_get_self_object_num        (void);
int   reverb_get_moves                  (void);
short reverb_get_score                  (void);
int   reverb_max_score                  (void);
int   reverb_ignore_moved_obj           (zword obj_num, zword dest_num);
int   reverb_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   reverb_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  reverb_clean_world_objs           (zobject* objs);

zword* seastalker_ram_addrs             (int*);
char** seastalker_intro_actions         (int*);
int   seastalker_victory                (void);
char* seastalker_clean_observation      (char*);
int   seastalker_game_over              (void);
int   seastalker_get_num_world_objs     (void);
int   seastalker_get_self_object_num    (void);
int   seastalker_get_moves              (void);
short seastalker_get_score              (void);
int   seastalker_max_score              (void);
int   seastalker_ignore_moved_obj       (zword obj_num, zword dest_num);
int   seastalker_ignore_attr_diff       (zword obj_num, zword attr_idx);
int   seastalker_ignore_attr_clr        (zword obj_num, zword attr_idx);
void  seastalker_clean_world_objs       (zobject* objs);

zword* sherbet_ram_addrs                (int*);
char** sherbet_intro_actions            (int*);
int   sherbet_victory                   (void);
char* sherbet_clean_observation         (char*);
int   sherbet_game_over                 (void);
int   sherbet_get_num_world_objs        (void);
int   sherbet_get_self_object_num       (void);
int   sherbet_get_moves                 (void);
short sherbet_get_score                 (void);
int   sherbet_max_score                 (void);
int   sherbet_ignore_moved_obj          (zword obj_num, zword dest_num);
int   sherbet_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   sherbet_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  sherbet_clean_world_objs          (zobject* objs);

zword* sherlock_ram_addrs               (int*);
char** sherlock_intro_actions           (int*);
int   sherlock_victory                  (void);
char* sherlock_clean_observation        (char*);
int   sherlock_game_over                (void);
int   sherlock_get_num_world_objs       (void);
int   sherlock_get_self_object_num      (void);
int   sherlock_get_moves                (void);
short sherlock_get_score                (void);
int   sherlock_max_score                (void);
int   sherlock_ignore_moved_obj         (zword obj_num, zword dest_num);
int   sherlock_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   sherlock_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  sherlock_clean_world_objs         (zobject* objs);

zword* snacktime_ram_addrs              (int*);
char** snacktime_intro_actions          (int*);
int   snacktime_victory                 (void);
char* snacktime_clean_observation       (char*);
int   snacktime_game_over               (void);
int   snacktime_get_num_world_objs      (void);
int   snacktime_get_self_object_num     (void);
int   snacktime_get_moves               (void);
short snacktime_get_score               (void);
int   snacktime_max_score               (void);
int   snacktime_ignore_moved_obj        (zword obj_num, zword dest_num);
int   snacktime_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   snacktime_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  snacktime_clean_world_objs        (zobject* objs);

zword* sorcerer_ram_addrs               (int*);
char** sorcerer_intro_actions           (int*);
int   sorcerer_victory                  (void);
char* sorcerer_clean_observation        (char*);
int   sorcerer_game_over                (void);
int   sorcerer_get_num_world_objs       (void);
int   sorcerer_get_self_object_num      (void);
int   sorcerer_get_moves                (void);
short sorcerer_get_score                (void);
int   sorcerer_max_score                (void);
int   sorcerer_ignore_moved_obj         (zword obj_num, zword dest_num);
int   sorcerer_ignore_attr_diff         (zword obj_num, zword attr_idx);
int   sorcerer_ignore_attr_clr          (zword obj_num, zword attr_idx);
void  sorcerer_clean_world_objs         (zobject* objs);

zword* spellbrkr_ram_addrs              (int*);
char** spellbrkr_intro_actions          (int*);
int   spellbrkr_victory                 (void);
char* spellbrkr_clean_observation       (char*);
int   spellbrkr_game_over               (void);
int   spellbrkr_get_num_world_objs      (void);
int   spellbrkr_get_self_object_num     (void);
int   spellbrkr_get_moves               (void);
short spellbrkr_get_score               (void);
int   spellbrkr_max_score               (void);
int   spellbrkr_ignore_moved_obj        (zword obj_num, zword dest_num);
int   spellbrkr_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   spellbrkr_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  spellbrkr_clean_world_objs        (zobject* objs);

zword* spirit_ram_addrs                 (int*);
char** spirit_intro_actions             (int*);
int   spirit_victory                    (void);
char* spirit_clean_observation          (char*);
int   spirit_game_over                  (void);
int   spirit_get_num_world_objs         (void);
int   spirit_get_self_object_num        (void);
int   spirit_get_moves                  (void);
short spirit_get_score                  (void);
int   spirit_max_score                  (void);
int   spirit_ignore_moved_obj           (zword obj_num, zword dest_num);
int   spirit_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   spirit_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  spirit_clean_world_objs           (zobject* objs);

zword* temple_ram_addrs                 (int*);
char** temple_intro_actions             (int*);
int   temple_victory                    (void);
char* temple_clean_observation          (char*);
int   temple_game_over                  (void);
int   temple_get_num_world_objs         (void);
int   temple_get_self_object_num        (void);
int   temple_get_moves                  (void);
short temple_get_score                  (void);
int   temple_max_score                  (void);
int   temple_ignore_moved_obj           (zword obj_num, zword dest_num);
int   temple_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   temple_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  temple_clean_world_objs           (zobject* objs);

zword* theatre_ram_addrs                (int*);
char** theatre_intro_actions            (int*);
int   theatre_victory                   (void);
char* theatre_clean_observation         (char*);
int   theatre_game_over                 (void);
int   theatre_get_num_world_objs        (void);
int   theatre_get_self_object_num       (void);
int   theatre_get_moves                 (void);
short theatre_get_score                 (void);
int   theatre_max_score                 (void);
int   theatre_ignore_moved_obj          (zword obj_num, zword dest_num);
int   theatre_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   theatre_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  theatre_clean_world_objs          (zobject* objs);

zword* trinity_ram_addrs                (int*);
char** trinity_intro_actions            (int*);
int   trinity_victory                   (void);
char* trinity_clean_observation         (char*);
int   trinity_game_over                 (void);
int   trinity_get_num_world_objs        (void);
int   trinity_get_self_object_num       (void);
int   trinity_get_moves                 (void);
short trinity_get_score                 (void);
int   trinity_max_score                 (void);
int   trinity_ignore_moved_obj          (zword obj_num, zword dest_num);
int   trinity_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   trinity_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  trinity_clean_world_objs          (zobject* objs);

zword* tryst_ram_addrs                  (int*);
char** tryst_intro_actions              (int*);
int   tryst_victory                     (void);
char* tryst_clean_observation           (char*);
int   tryst_game_over                   (void);
int   tryst_get_num_world_objs          (void);
int   tryst_get_self_object_num         (void);
int   tryst_get_moves                   (void);
short tryst_get_score                   (void);
int   tryst_max_score                   (void);
int   tryst_ignore_moved_obj            (zword obj_num, zword dest_num);
int   tryst_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   tryst_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  tryst_clean_world_objs            (zobject* objs);

zword* weapon_ram_addrs                 (int*);
char** weapon_intro_actions             (int*);
int   weapon_victory                    (void);
char* weapon_clean_observation          (char*);
int   weapon_game_over                  (void);
int   weapon_get_num_world_objs         (void);
int   weapon_get_self_object_num        (void);
int   weapon_get_moves                  (void);
short weapon_get_score                  (void);
int   weapon_max_score                  (void);
int   weapon_ignore_moved_obj           (zword obj_num, zword dest_num);
int   weapon_ignore_attr_diff           (zword obj_num, zword attr_idx);
int   weapon_ignore_attr_clr            (zword obj_num, zword attr_idx);
void  weapon_clean_world_objs           (zobject* objs);

zword* wishbringer_ram_addrs            (int*);
char** wishbringer_intro_actions        (int*);
int   wishbringer_victory               (void);
char* wishbringer_clean_observation     (char*);
int   wishbringer_game_over             (void);
int   wishbringer_get_num_world_objs    (void);
int   wishbringer_get_self_object_num   (void);
int   wishbringer_get_moves             (void);
short wishbringer_get_score             (void);
int   wishbringer_max_score             (void);
int   wishbringer_ignore_moved_obj      (zword obj_num, zword dest_num);
int   wishbringer_ignore_attr_diff      (zword obj_num, zword attr_idx);
int   wishbringer_ignore_attr_clr       (zword obj_num, zword attr_idx);
void  wishbringer_clean_world_objs      (zobject* objs);

zword* yomomma_ram_addrs                (int*);
char** yomomma_intro_actions            (int*);
int   yomomma_victory                   (void);
char* yomomma_clean_observation         (char*);
int   yomomma_game_over                 (void);
int   yomomma_get_num_world_objs        (void);
int   yomomma_get_self_object_num       (void);
int   yomomma_get_moves                 (void);
short yomomma_get_score                 (void);
int   yomomma_max_score                 (void);
int   yomomma_ignore_moved_obj          (zword obj_num, zword dest_num);
int   yomomma_ignore_attr_diff          (zword obj_num, zword attr_idx);
int   yomomma_ignore_attr_clr           (zword obj_num, zword attr_idx);
void  yomomma_clean_world_objs          (zobject* objs);

zword* zenon_ram_addrs                  (int*);
char** zenon_intro_actions              (int*);
int   zenon_victory                     (void);
char* zenon_clean_observation           (char*);
int   zenon_game_over                   (void);
int   zenon_get_num_world_objs          (void);
int   zenon_get_self_object_num         (void);
int   zenon_get_moves                   (void);
short zenon_get_score                   (void);
int   zenon_max_score                   (void);
int   zenon_ignore_moved_obj            (zword obj_num, zword dest_num);
int   zenon_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   zenon_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  zenon_clean_world_objs            (zobject* objs);

zword* zork1_ram_addrs                  (int*);
char** zork1_intro_actions              (int*);
int   zork1_victory                     (void);
char* zork1_clean_observation           (char*);
int   zork1_game_over                   (void);
int   zork1_get_num_world_objs          (void);
int   zork1_get_self_object_num         (void);
int   zork1_get_moves                   (void);
short zork1_get_score                   (void);
int   zork1_max_score                   (void);
int   zork1_ignore_moved_obj            (zword obj_num, zword dest_num);
int   zork1_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   zork1_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  zork1_clean_world_objs            (zobject* objs);

zword* zork2_ram_addrs                  (int*);
char** zork2_intro_actions              (int*);
int   zork2_victory                     (void);
char* zork2_clean_observation           (char*);
int   zork2_game_over                   (void);
int   zork2_get_num_world_objs          (void);
int   zork2_get_self_object_num         (void);
int   zork2_get_moves                   (void);
short zork2_get_score                   (void);
int   zork2_max_score                   (void);
int   zork2_ignore_moved_obj            (zword obj_num, zword dest_num);
int   zork2_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   zork2_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  zork2_clean_world_objs            (zobject* objs);

zword* zork3_ram_addrs                  (int*);
char** zork3_intro_actions              (int*);
int   zork3_victory                     (void);
char* zork3_clean_observation           (char*);
int   zork3_game_over                   (void);
int   zork3_get_num_world_objs          (void);
int   zork3_get_self_object_num         (void);
int   zork3_get_moves                   (void);
short zork3_get_score                   (void);
int   zork3_max_score                   (void);
int   zork3_ignore_moved_obj            (zword obj_num, zword dest_num);
int   zork3_ignore_attr_diff            (zword obj_num, zword attr_idx);
int   zork3_ignore_attr_clr             (zword obj_num, zword attr_idx);
void  zork3_clean_world_objs            (zobject* objs);

zword* ztuu_ram_addrs                   (int*);
char** ztuu_intro_actions               (int*);
int   ztuu_victory                      (void);
char* ztuu_clean_observation            (char*);
int   ztuu_game_over                    (void);
int   ztuu_get_num_world_objs           (void);
int   ztuu_get_self_object_num          (void);
int   ztuu_get_moves                    (void);
short ztuu_get_score                    (void);
int   ztuu_max_score                    (void);
int   ztuu_ignore_moved_obj             (zword obj_num, zword dest_num);
int   ztuu_ignore_attr_diff             (zword obj_num, zword attr_idx);
int   ztuu_ignore_attr_clr              (zword obj_num, zword attr_idx);
void  ztuu_clean_world_objs             (zobject* objs);

zword* textworld_ram_addrs              (int*);
char** textworld_intro_actions          (int*);
int   textworld_victory                 (void);
char* textworld_clean_observation       (char*);
int   textworld_game_over               (void);
int   textworld_get_num_world_objs      (void);
int   textworld_get_self_object_num     (void);
int   textworld_get_moves               (void);
short textworld_get_score               (void);
int   textworld_max_score               (void);
int   textworld_ignore_moved_obj        (zword obj_num, zword dest_num);
int   textworld_ignore_attr_diff        (zword obj_num, zword attr_idx);
int   textworld_ignore_attr_clr         (zword obj_num, zword attr_idx);
void  textworld_clean_world_objs        (zobject* objs);
void  textworld_parse_object_tree       (char* text);
void  textworld_parse_player_object     (char* text);

#endif
