"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureFlowLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_log_bucket_1 = require("@gammarer/aws-secure-log-bucket");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
class SecureFlowLogBucket extends aws_secure_log_bucket_1.SecureLogBucket {
    constructor(scope, id, props) {
        super(scope, id, props);
        // 👇Get current account
        const account = cdk.Stack.of(this).account;
        // 👇バケットACLアクセス権
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['s3:GetBucketAcl'],
            principals: [
                new iam.ServicePrincipal('delivery.logs.amazonaws.com'),
            ],
            resources: [this.bucketArn],
        }));
        // 👇バケット書き込みアクセス権
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['s3:PutObject'],
            principals: [
                new iam.ServicePrincipal('delivery.logs.amazonaws.com'),
            ],
            //resources: [`${this.bucketArn}/AWSLogs/${account}/*`],
            resources: (() => {
                if (props?.keyPrefixes && props.keyPrefixes.length > 0) {
                    const resources = [];
                    for (const keyPrefix of props.keyPrefixes) {
                        resources.push(`${this.bucketArn}/${keyPrefix}/AWSLogs/${account}/*`);
                    }
                    return resources;
                }
                return [`${this.bucketArn}/AWSLogs/${account}/*`];
            })(),
            conditions: {
                StringEquals: {
                    's3:x-amz-acl': 'bucket-owner-full-control',
                },
            },
        }));
    }
}
exports.SecureFlowLogBucket = SecureFlowLogBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureFlowLogBucket[_a] = { fqn: "@gammarer/aws-secure-flow-log-bucket.SecureFlowLogBucket", version: "0.3.15" };
//# sourceMappingURL=data:application/json;base64,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