
## 概述
EasyPruner是一个轻量且实用的PyTorch神经网络剪枝工具包，提供了一系列即插即用的网络结构裁剪接口。任何不具备模型压缩知识背景的工程师都可通过在PyTorch工程代码中添加几行代码实现网络模型的精准瘦身，并导出用于多种平台部署的onnx模型。可使模型保持现有精度水平的情况下，成倍提升执行效率和存储效率。<br />​<br />
<a name="EHucI"></a>
## 特点
**透明性**：不需懂模型压缩知识即可流畅使用。<br />**灵活性**：无需更换训练框架，也不用为剪枝接口重构训练或评测代码，仅在原训练框架中进行几行代码增	加，即插即用。<br />**通用性**：支持所有工程场景中常用的网络结构，例如ResNet、VGGNet、Inception、MobileNet等；支持多种训练框架代码，open-mmlab系列开源框架、u版YOLO系列等。<br />**精确性**：吸取神经网络剪枝的最新研究成果，提供在公开评测集上处于SOTA水平的剪枝方法，可对网络冗余连接进行精确识别，在一些常规任务上可以实现无损压缩。<br />**实用性**：剪枝后的模型可直接导出onnx，实现在NPU、ARM、GPU、CPU等多种平台的通用部署<br />

<a name="BXs1U"></a>
## 创新
与其他开源模型剪枝工具项目相比，本项目做了如下创新，以使剪枝工具更加强大：

1. 提出基于ONNX的图分析的网络拓扑排序方法，可以实现前后依赖算子的自动化识别，以兼容多样化的训练框架。
1. 提出基于自研GradDecay稀疏方法的进阶剪枝模式，该方法可以在不增加训练成本的情况下，最大限度保留网络原始表达能力，在一般情况下实现无损剪枝，在大剪枝率情况下依旧保持低精度损失。
<a name="vu0WR"></a>
## 功能介绍
本工具包提供两种剪枝模式，分别具有不同的代码修改方式，以及剪枝效果，用户可自行选择：<br />**快捷模式**：遵循 “模型加载-->裁剪-->常规微调”三段式，易用性更强，代码修改便捷<br />**进阶模式**：遵循 “模型加载-->稀疏微调-->裁剪”三段式，适合大剪枝率剪枝，需找到训练代码中的权重更新部分，进行修改。
<a name="C2W7S"></a>



详细使用文档请参加语雀：

https://www.yuque.com/books/share/d1639c26-4a93-4274-b028-3134ebcada17?# 《EasyPruner剪枝工具》
 
