#
#  Copyright (c) 2025, NVIDIA CORPORATION. All rights reserved.
#
# NVIDIA CORPORATION and its licensors retain all intellectual property
# and proprietary rights in and to this software, related documentation
# and any modifications thereto.  Any use, reproduction, disclosure or
# distribution of this software and related documentation without an
# express license agreement from NVIDIA CORPORATION is strictly
# prohibited.
#
from enum import Enum


class ApplicationType(str, Enum):
    """
    The type of training application, such as pytorch, jax, etc.
    Currently, only pytorch and jax are supported
    """

    # This is supported and the default.
    PYTORCH = "pytorch"
    # Support for this will be added by https://jirasw.nvidia.com/browse/HEIMDALL-1310
    JAX = "jax"
    # This is not supported yet.
    TENSORFLOW = "tensorflow"
