"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosPseudo = void 0;
const token_1 = require("./token");
const ROS_REGION = "ALIYUN::Region";
const ROS_STACKID = "ALIYUN::StackId";
const ROS_STACKNAME = "ALIYUN::StackName";
const ROS_NOVALUE = "ALIYUN::NoValue";
const ROS_ACCOUNTID = "ALIYUN::AccountId";
const ROS_TENANTID = "ALIYUN::TenantId";
const ROS_INDEX = "ALIYUN::Index";
/**
 * Accessor for pseudo parameters
 */
class RosPseudo {
    constructor() { }
    static get accountId() {
        return this.asString(ROS_ACCOUNTID);
    }
    static get region() {
        return this.asString(ROS_REGION);
    }
    static get stackId() {
        return this.asString(ROS_STACKID);
    }
    static get stackName() {
        return this.asString(ROS_STACKNAME);
    }
    static get noValue() {
        return token_1.Token.asAny({ Ref: ROS_NOVALUE });
    }
    static get tenantId() {
        return this.asString(ROS_TENANTID);
    }
    static get index() {
        return token_1.Token.asNumber({ Ref: ROS_INDEX });
    }
    static asString(name) {
        return token_1.Token.asString({ Ref: name }, { displayHint: name });
    }
}
exports.RosPseudo = RosPseudo;
//# sourceMappingURL=data:application/json;base64,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