# What is Launchable?

{% hint style="warning" %}
Launchable is available for early access. [Grab an invite →](https://www.launchableinc.com/invite)
{% endhint %}

**Launchable** is a test insight analysis product that uses machine learning to optimize test execution by running the right tests at the right time in your development workflow.

We help teams dramatically reduce their testing cycle times to produce higher quality software, faster.

Our mission is to make it possible for all development teams to apply state of the art testing techniques within their environment, reducing the risk of changes, and delivering greater value to their customers.

## With Launchable you can...

* **Run tests earlier and more often with adaptive subsets of long running test suites.** For instance, if you have a multi-hour test suite that runs after every merge, you could create a dynamic subset that would run every time a developer pushes new code. This subset would only run tests that are most relevant to the changes being tested, dropping execution time and eliminating hours waiting for post-merge tests to complete.
* **Find out about test failures much sooner by reordering tests** to run the most likely to fail tests first. On average, most test failures occur roughly halfway through the run. For instance, if your test suite takes 40 minutes to run, reordering the suite based on likelihood of failure can reveal failures much closer to the start of the run instead of waiting 20 minutes or more to know that something broke. Launchable reordering is dynamic: the tests that are most relevant to the code being tested are run first.

The Launchable algorithm is language and framework agnostic, making flexible for many different environments and use cases.

## How we help

1. **Reduced anxiety and stress:** Faster feedback means you don't have to juggle so many concurrent tasks. After all, fewer balls in the air means fewer dropped.
2. **Reduced workload:** Get the right success/failure signals _in context_ while working on relevant tasks. You don't have to come back to tasks days or weeks later.
3. **More time:** You can resolve issues earlier, leaving more time for other things. Free up your evenings to be with family and get more time for the right projects during the day!
4. **Happy developers:** Adopting modern testing practices that reduce workload and stress makes developers happier. 😄

