# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
# and limitations under the License.
"""Default constants for Git Repository Research MCP Server."""


class Constants:
    """Constants used throughout the Git Repository Research MCP Server."""

    # Text file patterns for repository file filtering
    TEXT_FILE_INCLUDE_PATTERNS = [
        '*.py',
        '*.js',
        '*.ts',
        '*.jsx',
        '*.tsx',
        '*.html',
        '*.htm',
        '*.css',
        '*.scss',
        '*.sass',
        '*.less',
        '*.json',
        '*.xml',
        '*.yaml',
        '*.yml',
        '*.md',
        '*.rst',
        '*.txt',
        '*.java',
        '*.c',
        '*.cpp',
        '*.h',
        '*.hpp',
        '*.cs',
        '*.rb',
        '*.php',
        '*.go',
        '*.rs',
        '*.swift',
        '*.sh',
        '*.bash',
        '*.zsh',
        '*.sql',
        '*.kt',
        '*.kts',
        '*.dart',
        '*.lua',
        '*.r',
        '*.pl',
        '*.ps1',
        '*.config',
        '*.conf',
        '*.cfg',
        '*.ini',
        '*.toml',
        '*.graphql',
        '*.proto',
        'Dockerfile',
        'docker-compose.yml',
        'Makefile',
        'README*',
        'LICENSE*',
        'CONTRIBUTING*',
    ]

    TEXT_FILE_EXCLUDE_PATTERNS = [
        # Binary image files
        '*.jpg',
        '*.jpeg',
        '*.png',
        '*.gif',
        '*.bmp',
        '*.tiff',
        '*.ico',
        '*.svg',
        '*.webp',
        # Document and media files
        '*.pdf',
        '*.docx',
        '*.xlsx',
        '*.pptx',
        '*.doc',
        '*.xls',
        '*.ppt',
        '*.mp3',
        '*.mp4',
        '*.wav',
        '*.avi',
        '*.mov',
        '*.ogg',
        '*.flac',
        # Archive files
        '*.zip',
        '*.tar',
        '*.gz',
        '*.rar',
        '*.7z',
        '*.bz2',
        '*.xz',
        '*.tgz',
        # Binary executable, object and library files
        '*.exe',
        '*.dll',
        '*.so',
        '*.dylib',
        '*.class',
        '*.jar',
        '*.war',
        '*.ear',
        '*.pyc',
        '*.pyo',
        '*.o',
        '*.obj',
        '*.a',
        '*.lib',
        '*.bin',
        '*.whl',
        # Data files
        '*.dat',
        '*.db',
        '*.sqlite',
        '*.sqlite3',
        '*.mdb',
        '*.ldb',
        '*.frm',
        # Lock files and package-specific files
        '*.lock',
        'package-lock.json',
        'yarn.lock',
        'poetry.lock',
        # Common dependency directories
        'node_modules/**',
        'bower_components/**',
        'jspm_packages/**',
        'vendor/**',
        '.gradle/**',
        '.maven/**',
        '.nuget/**',
        # Virtual environments
        '.venv/**',
        'venv/**',
        'env/**',
        'virtualenv/**',
        'ENV/**',
        '.env/**',
        '.tox/**',
        # Build and distribution directories
        'dist/**',
        'build/**',
        'target/**',
        'bin/**',
        'obj/**',
        '__pycache__/**',
        '.pytest_cache/**',
        '*.egg-info/**',
        '.eggs/**',
        '.coverage/**',
        # Git and version control
        '.git/**',
        '.github/**',
        '.hg/**',
        '.svn/**',
        'CVS/**',
        # IDE and editor directories
        '.vscode/**',
        '.idea/**',
        '.vs/**',
        '.settings/**',
        '.project/**',
        '.classpath/**',
        '*.sublime-*',
        # Minified files
        '*.min.js',
        '*.min.css',
        '*.map',
        # Various config directories
        '.cache/**',
        '.config/**',
        # Logs and temporary files
        'logs/**',
        '*.log',
        '*.tmp',
        '*.temp',
        # OS specific files
        '.DS_Store',
        'Thumbs.db',
        'desktop.ini',
        # Large data files
        '*.csv',
        '*.tsv',  # Consider including these if needed for analysis
        '*.parquet',
        '*.avro',
        '*.orc',
        # Machine learning specific
        '*.onnx',
        '*.pb',
        '*.pt',
        '*.pth',
        '*.h5',
        '*.hdf5',
        '*.pkl',
        '*.pickle',
    ]

    # Default directory for storing indices
    DEFAULT_INDEX_DIR = '.git_repo_research'

    # Default patterns for file inclusion
    DEFAULT_INCLUDE_PATTERNS = [
        '**/*.md',
        '**/*.py',
        '**/*.js',
        '**/*.ts',
        '**/*.java',
        '**/*.go',
        '**/*.rs',
        '**/*.c',
        '**/*.cpp',
        '**/*.h',
        '**/*.hpp',
        '**/*.cs',
        '**/*.rb',
        '**/*.php',
        '**/*.scala',
        '**/*.swift',
        '**/*.kt',
        '**/*.groovy',
        '**/*.sh',
        '**/*.bash',
        '**/*.ps1',
        '**/*.md',
        '**/*.rst',
        '**/*.txt',
        '**/*.html',
        '**/*.css',
        '**/*.scss',
        '**/*.sass',
        '**/*.less',
        '**/*.json',
        '**/*.yml',
        '**/*.yaml',
        '**/*.xml',
        '**/*.toml',
        '**/*.ini',
        '**/*.cfg',
        '**/*.conf',
        '**/*.properties',
        '**/*.tf',
        '**/*.tfvars',
        '**/*.cdk.ts',
        '**/*.jsx',
        '**/*.tsx',
        '**/*.vue',
        '**/*.sql',
        '**/*.graphql',
        '**/*.proto',
        '**/*.dockerfile',
        'Dockerfile',
        'docker-compose.yml',
        'Makefile',
        'CMakeLists.txt',
        '**/*.gradle',
        'LICENSE',
        'README*',
        'CHANGELOG*',
        'CONTRIBUTING*',
        'CODE_OF_CONDUCT*',
    ]

    # Default patterns for file exclusion
    DEFAULT_EXCLUDE_PATTERNS = [
        '**/.git/**',
        '**/.github/**',
        '**/.svn/**',
        '**/.hg/**',
        '**/.bzr/**',
        '**/node_modules/**',
        '**/venv/**',
        '**/.venv/**',
        '**/env/**',
        '**/.env/**',
        '**/__pycache__/**',
        '**/.pytest_cache/**',
        '**/.coverage/**',
        '**/coverage/**',
        '**/dist/**',
        '**/build/**',
        '**/.DS_Store',
        '**/*.pyc',
        '**/*.pyo',
        '**/*.pyd',
        '**/*.so',
        '**/*.dll',
        '**/*.exe',
        '**/*.bin',
        '**/*.obj',
        '**/*.o',
        '**/*.a',
        '**/*.lib',
        '**/*.dylib',
        '**/*.ncb',
        '**/*.sdf',
        '**/*.suo',
        '**/*.pdb',
        '**/*.idb',
        '**/*.jpg',
        '**/*.jpeg',
        '**/*.png',
        '**/*.gif',
        '**/*.svg',
        '**/*.ico',
        '**/*.mp4',
        '**/*.mov',
        '**/*.wmv',
        '**/*.flv',
        '**/*.avi',
        '**/*.mkv',
        '**/*.mp3',
        '**/*.wav',
        '**/*.flac',
        '**/*.zip',
        '**/*.tar.gz',
        '**/*.tar',
        '**/*.rar',
        '**/*.7z',
        '**/*.pdf',
        '**/*.docx',
        '**/*.xlsx',
        '**/*.pptx',
        '**/logs/**',
        '**/log/**',
        '**/.idea/**',
        '**/.vscode/**',
        '**/.classpath',
        '**/.project',
        '**/.settings/**',
        '**/.gradle/**',
        '**/target/**',
    ]
