import numpy as np
import pandas as pd



class AeroProfiles:

    def __init__(self):
        # for profile in [ffa_241, ffa_301, ffa_360, ffa_480, ffa_600, cylinder]:
        alpha_values = np.array([-180, -175, -170, -165, -160, -155, -150, -145, -140, -135, -130,
                                 -125, -120, -115, -110, -105, -100, -95, -90, -85, -80, -75,
                                 -70, -65, -60, -55, -50, -45, -40, -39, -38, -37, -36,
                                 -35, -34, -33, -32, -30, -28, -26, -24, -22, -20, -18,
                                 -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4,
                                 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26,
                                 28, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40,
                                 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95,
                                 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150,
                                 155, 160, 165, 170, 175, 180])

        self.ffa_241 = pd.DataFrame({'alpha': alpha_values,
                                     'Cl': np.array([0., 0.1736, 0.342, 0.5, 0.6428, 0.766, 0.866,
                                                     0.9397, 0.9848, 1., 0.9848, 0.9397, 0.866, 0.766,
                                                     0.6428, 0.5, 0.342, 0.1736, 0., -0.1736, -0.342,
                                                     -0.5, -0.6428, -0.766, -0.866, -0.9397, -0.9848, -1.012,
                                                     -1.0376, -1.0419, -1.0462, -1.0525, -1.0568, -1.0611, -1.0654,
                                                     -1.0717, -1.0765, -1.0889, -1.0993, -1.1168, -1.1282, -1.1215,
                                                     -1.1148, -1.0919, -1.0691, -1.0379, -1.0067, -0.8479, -0.6892,
                                                     -0.4278, -0.1665, 0.0863, 0.3391, 0.5867, 0.8301, 1.0656,
                                                     1.2914, 1.5012, 1.6886, 1.8103, 1.8139, 1.7545, 1.6071,
                                                     1.5257, 1.4428, 1.3826, 1.3218, 1.2583, 1.1944, 1.1734,
                                                     1.1568, 1.1379, 1.1248, 1.1177, 1.1024, 1.0891, 1.0755,
                                                     1.0175, 0.9716, 0.9268, 0.866, 0.766, 0.6428, 0.5,
                                                     0.342, 0.1736, 0., -0.1736, -0.342, -0.5, -0.6428,
                                                     -0.766, -0.866, -0.9397, -0.9848, -1., -0.9848, -0.9397,
                                                     -0.866, -0.766, -0.6428, -0.5, -0.342, -0.1736, 0.]),
                                     'Cd': np.array([0., 0.0114, 0.0452, 0.1005, 0.1755, 0.2679, 0.375, 0.4935,
                                                     0.6197, 0.75, 0.8803, 1.0065, 1.125, 1.2321, 1.3245, 1.3995,
                                                     1.4548, 1.4886, 1.5, 1.4886, 1.4548, 1.3995, 1.3245, 1.2321,
                                                     1.125, 1.0065, 0.8603, 0.712, 0.5475, 0.5165, 0.4816, 0.4487,
                                                     0.4177, 0.3848, 0.3558, 0.3289, 0.3031, 0.256, 0.209, 0.1756,
                                                     0.1423, 0.1183, 0.0943, 0.0765, 0.0587, 0.0454, 0.0321, 0.023,
                                                     0.0138, 0.0118, 0.0098, 0.0095, 0.0092, 0.0094, 0.0099, 0.0109,
                                                     0.0124, 0.0144, 0.0173, 0.0226, 0.0354, 0.0647, 0.1035, 0.1437,
                                                     0.1841, 0.229, 0.2738, 0.3278, 0.3816, 0.4209, 0.4504, 0.4815,
                                                     0.5105, 0.545, 0.5737, 0.5999, 0.628, 0.7578, 0.882, 1.0104,
                                                     1.125, 1.2321, 1.3245, 1.3995, 1.4548, 1.4886, 1.5, 1.4886,
                                                     1.4548, 1.3995, 1.3245, 1.2321, 1.125, 1.0065, 0.8803, 0.75,
                                                     0.6197, 0.4935, 0.375, 0.2679, 0.1755, 0.1005, 0.0452, 0.0114,
                                                     0.])})

        self.ffa_301 = pd.DataFrame({'alpha': alpha_values,
                                     'Cl': np.array([0., 0.1736, 0.342, 0.5, 0.6428, 0.766,
                                                     0.866, 0.9397, 0.9848, 1., 0.9848, 0.9397,
                                                     0.866, 0.766, 0.6428, 0.5, 0.342, 0.1736,
                                                     0., -0.1736, -0.342, -0.5, -0.6428, -0.766,
                                                     -0.866, -0.9397, -0.9848, -1., -1.0216, -1.0239,
                                                     -1.0162, -1.0185, -1.0108, -1.0031, -0.9954, -0.9777,
                                                     -0.96353, -0.96034, -0.95716, -0.94406, -0.93096, -0.90466,
                                                     -0.87836, -0.84588, -0.8134, -0.77281, -0.73222, -0.69346,
                                                     -0.65469, -0.45069, -0.2467, 0.02948, 0.30565, 0.56697,
                                                     0.81993, 1.06139, 1.28736, 1.48403, 1.63878, 1.71231,
                                                     1.60446, 1.4184, 1.30631, 1.25093, 1.19555, 1.17741,
                                                     1.15927, 1.14777, 1.13626, 1.1509, 1.1629, 1.1648,
                                                     1.1565, 1.1482, 1.1499, 1.1415, 1.123, 1.0304,
                                                     0.9756, 0.9208, 0.866, 0.766, 0.6428, 0.5,
                                                     0.342, 0.1736, 0., -0.1736, -0.342, -0.5,
                                                     -0.6428, -0.766, -0.866, -0.9397, -0.9848, -1.,
                                                     -0.9848, -0.9397, -0.866, -0.766, -0.6428, -0.5,
                                                     -0.342, -0.1736, 0.]),
                                     'Cd': np.array([0., 0.0099, 0.0392, 0.0871, 0.1521, 0.2322, 0.325,
                                                     0.4277, 0.5371, 0.65, 0.7629, 0.8723, 0.975, 1.0678,
                                                     1.1479, 1.2129, 1.2608, 1.2901, 1.3, 1.2901, 1.2608,
                                                     1.2129, 1.1479, 1.0678, 0.975, 0.8723, 0.7629, 0.65,
                                                     0.5422, 0.5206, 0.4991, 0.4775, 0.4559, 0.4344, 0.4128,
                                                     0.3913, 0.28972, 0.2563, 0.22288, 0.19412, 0.16535, 0.14171,
                                                     0.11807, 0.09862, 0.07917, 0.06434, 0.04951, 0.0381, 0.02669,
                                                     0.02036, 0.01402, 0.01292, 0.01182, 0.01193, 0.01247, 0.01355,
                                                     0.01523, 0.01797, 0.02239, 0.03217, 0.05845, 0.09922, 0.13948,
                                                     0.1784, 0.21731, 0.25524, 0.29318, 0.3328, 0.37242, 0.4288,
                                                     0.4501, 0.4712, 0.4922, 0.5131, 0.534, 0.5547, 0.5753,
                                                     0.6772, 0.77647, 0.87573, 0.975, 1.0678, 1.1479, 1.2129,
                                                     1.2608, 1.2901, 1.3, 1.2901, 1.2608, 1.2129, 1.1479,
                                                     1.0678, 0.975, 0.8723, 0.7629, 0.65, 0.5371, 0.4277,
                                                     0.325, 0.2322, 0.1521, 0.0871, 0.0392, 0.0099, 0.])})

        self.ffa_360 = pd.DataFrame({'alpha': alpha_values,
                                     'Cl': np.array([0., 0.1736, 0.342, 0.5, 0.6428, 0.766,
                                                     0.866, 0.9397, 0.9848, 1., 0.9848, 0.9397,
                                                     0.866, 0.766, 0.6428, 0.5, 0.342, 0.1736,
                                                     0., -0.1736, -0.342, -0.5, -0.6428, -0.766,
                                                     -0.866, -0.9397, -0.9848, -1., -0.9716, -0.9639,
                                                     -0.9362, -0.9285, -0.9008, -0.8931, -0.8754, -0.8477,
                                                     -0.82638, -0.81775, -0.80912, -0.79237, -0.77563, -0.7441,
                                                     -0.71257, -0.66785, -0.62313, -0.57418, -0.52523, -0.48272,
                                                     -0.4402, -0.29832, -0.15643, 0.17445, 0.50533, 0.8241,
                                                     1.12091, 1.38972, 1.62544, 1.80606, 1.81594, 1.50898,
                                                     1.3248, 1.23631, 1.17287, 1.16267, 1.15246, 1.15474,
                                                     1.15701, 1.15597, 1.15493, 1.1609, 1.1729, 1.1748,
                                                     1.1665, 1.1682, 1.1499, 1.1315, 1.113, 1.0304,
                                                     0.9756, 0.9208, 0.866, 0.766, 0.6428, 0.5,
                                                     0.342, 0.1736, 0., -0.1736, -0.342, -0.5,
                                                     -0.6428, -0.766, -0.866, -0.9397, -0.9848, -1.,
                                                     -0.9848, -0.9397, -0.866, -0.766, -0.6428, -0.5,
                                                     -0.342, -0.1736, 0.]),
                                     'Cd': np.array([0., 0.0099, 0.0392, 0.0871, 0.1521, 0.2322, 0.325,
                                                     0.4277, 0.5371, 0.65, 0.7629, 0.8723, 0.975, 1.0678,
                                                     1.1479, 1.2129, 1.2608, 1.2901, 1.3, 1.2901, 1.2608,
                                                     1.2129, 1.1479, 1.0678, 0.975, 0.8723, 0.7629, 0.65,
                                                     0.5422, 0.5206, 0.4991, 0.4775, 0.4559, 0.4344, 0.4128,
                                                     0.3913, 0.30151, 0.26767, 0.23383, 0.20448, 0.17513, 0.15126,
                                                     0.12739, 0.1085, 0.08961, 0.07483, 0.06004, 0.04851, 0.03699,
                                                     0.02943, 0.02187, 0.02028, 0.01868, 0.01878, 0.01964, 0.0213,
                                                     0.02404, 0.02895, 0.0445, 0.09361, 0.1422, 0.18569, 0.22942,
                                                     0.26752, 0.30562, 0.34339, 0.38116, 0.4206, 0.46004, 0.4288,
                                                     0.4501, 0.4712, 0.4922, 0.5131, 0.534, 0.5547, 0.5753,
                                                     0.6772, 0.77647, 0.87573, 0.975, 1.0678, 1.1479, 1.2129,
                                                     1.2608, 1.2901, 1.3, 1.2901, 1.2608, 1.2129, 1.1479,
                                                     1.0678, 0.975, 0.8723, 0.7629, 0.65, 0.5371, 0.4277,
                                                     0.325, 0.2322, 0.1521, 0.0871, 0.0392, 0.0099, 0.])})

        self.ffa_480 = pd.DataFrame({'alpha': alpha_values,
                                     'Cl': np.array([0., 0.1736, 0.342, 0.5, 0.6428, 0.766,
                                                     0.866, 0.9397, 0.9848, 1., 0.9848, 0.9397,
                                                     0.866, 0.766, 0.6428, 0.5, 0.342, 0.1736,
                                                     0., -0.1736, -0.342, -0.5, -0.6428, -0.766,
                                                     -0.866, -0.9397, -0.9848, -1., -0.9816, -0.9539,
                                                     -0.9262, -0.8885, -0.8308, -0.7731, -0.7254, -0.6577,
                                                     -0.61106, -0.56083, -0.5106, -0.44936, -0.38812, -0.31614,
                                                     -0.24416, -0.16413, -0.0841, 0.00209, 0.08829, 0.17217,
                                                     0.25606, 0.31794, 0.37982, 0.35731, 0.33479, 0.56519,
                                                     0.87689, 1.04252, 0.92747, 0.82497, 0.79054, 0.78946,
                                                     0.81288, 0.85046, 0.89457, 0.9356, 0.97664, 1.01588,
                                                     1.05513, 1.08428, 1.11343, 1.1309, 1.1429, 1.1448,
                                                     1.1465, 1.1382, 1.1299, 1.1215, 1.103, 1.0304,
                                                     0.9756, 0.9208, 0.866, 0.766, 0.6428, 0.5,
                                                     0.342, 0.1736, 0., -0.1736, -0.342, -0.5,
                                                     -0.6428, -0.766, -0.866, -0.9397, -0.9848, -1.,
                                                     -0.9848, -0.9397, -0.866, -0.766, -0.6428, -0.5,
                                                     -0.342, -0.1736, 0.]),
                                     'Cd': np.array([0., 0.0099, 0.0392, 0.0871, 0.1521, 0.2322, 0.325,
                                                     0.4277, 0.5371, 0.65, 0.7629, 0.8723, 0.975, 1.0678,
                                                     1.1479, 1.2129, 1.2608, 1.2901, 1.3, 1.2901, 1.2608,
                                                     1.2129, 1.1479, 1.0678, 0.975, 0.8723, 0.7629, 0.65,
                                                     0.5422, 0.5206, 0.4991, 0.4775, 0.4559, 0.4344, 0.4128,
                                                     0.3913, 0.29229, 0.26626, 0.24023, 0.2169, 0.19358, 0.17325,
                                                     0.15293, 0.13546, 0.11799, 0.10351, 0.08903, 0.07732, 0.06561,
                                                     0.05631, 0.04701, 0.04055, 0.0341, 0.03159, 0.03427, 0.04507,
                                                     0.07814, 0.11741, 0.15594, 0.19348, 0.22998, 0.26564, 0.30073,
                                                     0.3361, 0.37148, 0.40562, 0.43976, 0.47353, 0.5073, 0.4288,
                                                     0.4501, 0.4712, 0.4922, 0.5131, 0.534, 0.5547, 0.5753,
                                                     0.6772, 0.77647, 0.87573, 0.975, 1.0678, 1.1479, 1.2129,
                                                     1.2608, 1.2901, 1.3, 1.2901, 1.2608, 1.2129, 1.1479,
                                                     1.0678, 0.975, 0.8723, 0.7629, 0.65, 0.5371, 0.4277,
                                                     0.325, 0.2322, 0.1521, 0.0871, 0.0392, 0.0099, 0.])})

        self.ffa_600 = pd.DataFrame({'alpha': alpha_values,
                                     'Cl': np.array([0., 0.1736, 0.342, 0.5, 0.6428, 0.766,
                                                     0.866, 0.9397, 0.9848, 1., 0.9848, 0.9397,
                                                     0.866, 0.766, 0.6428, 0.5, 0.342, 0.1736,
                                                     0., -0.1736, -0.342, -0.5, -0.6428, -0.766,
                                                     -0.866, -0.9397, -0.9848, -1., -0.9616, -0.8639,
                                                     -0.7762, -0.6785, -0.6008, -0.4931, -0.4154, -0.3277,
                                                     -0.23711, -0.15736, -0.07762, 0.01154, 0.1007, 0.19623,
                                                     0.29176, 0.39325, 0.49474, 0.60044, 0.70614, 0.78805,
                                                     0.86996, 0.82873, 0.78751, 0.59461, 0.4017, 0.0776,
                                                     -0.3593, -0.19967, -0.02697, 0.11253, 0.23024, 0.32953,
                                                     0.41863, 0.49785, 0.53987, 0.60206, 0.66425, 0.73839,
                                                     0.81253, 0.86424, 0.91596, 0.9509, 0.9729, 0.9848,
                                                     1.0165, 1.0382, 1.0499, 1.0515, 1.053, 1.0304,
                                                     0.9756, 0.9208, 0.866, 0.766, 0.6428, 0.5,
                                                     0.342, 0.1736, 0., -0.1736, -0.342, -0.5,
                                                     -0.6428, -0.766, -0.866, -0.9397, -0.9848, -1.,
                                                     -0.9848, -0.9397, -0.866, -0.766, -0.6428, -0.5,
                                                     -0.342, -0.1736, 0.]),
                                     'Cd': np.array([0., 0.0099, 0.0392, 0.0871, 0.1521, 0.2322, 0.325,
                                                     0.4277, 0.5371, 0.65, 0.7629, 0.8723, 0.975, 1.0678,
                                                     1.1479, 1.2129, 1.2608, 1.2901, 1.3, 1.2901, 1.2608,
                                                     1.2129, 1.1479, 1.0678, 0.975, 0.8723, 0.7629, 0.65,
                                                     0.5422, 0.5206, 0.4991, 0.4775, 0.4559, 0.4344, 0.4128,
                                                     0.3913, 0.24294, 0.22318, 0.20343, 0.18578, 0.16813, 0.15258,
                                                     0.13703, 0.12397, 0.11091, 0.10087, 0.09082, 0.08365, 0.07648,
                                                     0.0748, 0.07311, 0.07553, 0.07795, 0.07795, 0.07082, 0.07983,
                                                     0.09587, 0.1149, 0.13648, 0.16072, 0.18678, 0.21498, 0.24894,
                                                     0.28157, 0.31419, 0.34423, 0.37427, 0.40682, 0.43937, 0.4288,
                                                     0.4501, 0.4712, 0.4922, 0.5131, 0.534, 0.5547, 0.5753,
                                                     0.6772, 0.77647, 0.87573, 0.975, 1.0678, 1.1479, 1.2129,
                                                     1.2608, 1.2901, 1.3, 1.2901, 1.2608, 1.2129, 1.1479,
                                                     1.0678, 0.975, 0.8723, 0.7629, 0.65, 0.5371, 0.4277,
                                                     0.325, 0.2322, 0.1521, 0.0871, 0.0392, 0.0099, 0.])})

        self.cylinder = pd.DataFrame({'alpha': alpha_values,
                                      'Cl': np.array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                                      'Cd': np.array([0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
                                                      0.6])})

    def get_profile(self):
        return self.cylinder


if __name__ == '__main__':
    AP = AeroProfiles()
    df = AP.get_profile()
    print(df.head())
