<div align="center">
<img src="https://raw.githubusercontent.com/OSOceanAcoustics/echopype/master/docs/source/_static/echopype_logo_banner.png" width="400">
</div>

# Echopype

<a href="https://travis-ci.org/OSOceanAcoustics/echopype">
<img src="https://travis-ci.org/OSOceanAcoustics/echopype.svg?branch=master"/>
</a>

<a href="https://echopype.readthedocs.io/en/latest/?badge=latest">
<img src="https://readthedocs.org/projects/echopype/badge/?version=latest"/>
</a>

<a href="https://mybinder.org/v2/gh/OSOceanAcoustics/echopype/master">
<img src="https://mybinder.org/badge_logo.svg"/>
</a>

<a href="https://doi.org/10.5281/zenodo.3907000">
<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.3907000.svg" alt="DOI">
</a>

Echopype is a package built to enable interoperability and scalability
in ocean sonar data processing.
These data are widely used for obtaining information about the distribution and
abundance of marine animals, such as fish and krill.
Our ability to collect large volumes of sonar data from a variety of
ocean platforms has grown significantly in the last decade.
However, most of the new data remain under-utilized.
echopype aims to address the root cause of this problem - the lack of
interoperable data format and scalable analysis workflows that adapt well
with increasing data volume - by providing open-source tools as entry points for
scientists to make discovery using these new data.


## Installation

Echopype can be installed from PyPI:

```bash
$ pip install echopype
```

or through conda:
```bash
$ conda install -c conda-forge echopype
```

When creating an conda environment to work with echopype, do
```bash
$ conda create -c conda-forge --name echopype python=3.8 --file requirements.txt --file requirements-dev.txt
```

## Functionality and Usage

Echopype converts data stored in manufacturer-specific binary formats from
the following echosounders into standardized netCDF or zarr files,
based on which all subsequent computations are performed.

- ``.raw`` files generated by Simrad's EK60, EK80, and EA640 echosounders
- ``.01A`` files generated by ASL Environmental Sciences' AZFP echosounder

Data processing routines currently include calibration (instrument-specific),
noise removal, and mean volume backscattering strength (MVBS) calculation
for narrowband echoes. EK80 calibration based on pulse compression output
in the form of average over frequency is implemented.

For more details, check out the [echopype documentation](https://echopype.readthedocs.io)
and watch the [echopype talk](https://www.youtube.com/watch?v=qboH7MyHrpU) 
at SciPy 2019 for background, discussions and a quick demo!


## Echopype doesn't run on your data?

Please report any bugs by [creating issues on GitHub](https://medium.com/nyc-planning-digital/writing-a-proper-github-issue-97427d62a20f).
[Pull requests](https://jarednielsen.com/learn-git-fork-pull-request/) are always welcome!


Contributors
------------

[Wu-Jung Lee](http://leewujung.github.io) (@leewujung) leads this project
and along with [Kavin Nguyen](https://github.com/ngkavin) (@ngkavin)
are primary developers of this package.
[Valentina Staneva](https://escience.washington.edu/people/valentina-staneva/) (@valentina-s)
and [Emilio Mayorga](https://www.apl.washington.edu/people/profile.php?last_name=Mayorga&first_name=Emilio) (@emiliom)
provide consultation and also contribute to the development.
Other contributors are listed in [echopype documentation](https://echopype.readthedocs.io).

We thank Dave Billenness of ASL Environmental Sciences for
providing the AZFP Matlab Toolbox as reference for our
development of AZFP support in echopype.
We also thank [Rick Towler](https://github.com/rhtowler)
of the Alaska Fisheries Science Center
for providing low-level file parsing routines for
Simrad EK60 and EK80 echosounders.


License
-------

Echopype is licensed under the open source Apache 2.0 license.


---------------

Copyright (c) 2018--, echopype Developers.
